/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.mservice.upgrade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import org.apache.commons.collections4.CollectionUtils;

public class OutPurApplyBillUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(OutPurApplyBillUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        ThreadPools.executeOnceIncludeRequestContext((String)"OutApplyBillUpgradeServiceImpl", (Runnable)ThreadLifeCycleManager.wrapRunnable(() -> this.doUpgrade(scmRoute, result)));
        return result;
    }

    private void doUpgrade(DBRoute scmRoute, UpgradeResult result) {
        String switchSql = "SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = ? ";
        try (DataSet countSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)switchSql, (Object[])new String[]{"t_pm_purapplybill"});){
            if (!countSet.hasNext()) {
                String logstr = "OutPurApplyBillUpgradeServiceImpl upgrade t_pm_purapplybill ,t_pm_purapplybill has not exists.";
                logger.error(logstr);
                result.setLog(logstr);
                result.setSuccess(true);
                return;
            }
        }
        countSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)switchSql, (Object[])new String[]{"t_mrp_planorder"});
        var5_5 = null;
        try {
            if (!countSet.hasNext()) {
                String logstr = "OutPurApplyBillUpgradeServiceImpl upgrade t_pm_purapplybill ,t_mrp_planorder has not exists.";
                logger.error(logstr);
                result.setLog(logstr);
                result.setSuccess(true);
                return;
            }
        }
        catch (Throwable logstr) {
            var5_5 = logstr;
            throw logstr;
        }
        finally {
            if (countSet != null) {
                if (var5_5 != null) {
                    try {
                        countSet.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    countSet.close();
                }
            }
        }
        StringBuilder sql = new StringBuilder(300);
        sql.append("select b.fentryid,a.fcreatetime from t_pm_purapplybill a \n");
        sql.append("inner join t_pm_purapplybillentry b on b.fid = a.fid \n");
        sql.append("where a.fbiztypeid in (1002795213917594624,966651870204521472) \n");
        sql.append("and b.fbomtime is null \n");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
        try {
            Object updateSql;
            List partition;
            Object partition2;
            try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql.toString());){
                for (Row row : dataSet) {
                    paramsList.add(new Object[]{row.get("fcreatetime"), row.get("fentryid")});
                }
            }
            if (CollectionUtils.isNotEmpty(paramsList)) {
                String updateSql2 = "update t_pm_purapplybillentry set fbomtime = ? where fentryid = ?";
                partition2 = Lists.partition(paramsList, (int)1000);
                Iterator iterator = partition2.iterator();
                while (iterator.hasNext()) {
                    List objects = (List)iterator.next();
                    this.batchExcuteUpdate(DBRoute.of((String)"scm"), updateSql2, objects);
                }
            }
            sql.delete(0, sql.length());
            sql.append("select b.fentryid,c.fmaterialspread from t_pm_purapplybill a \n");
            sql.append("inner join t_pm_purapplybillentry b on b.fid = a.fid \n");
            sql.append("inner join t_pm_purapplybillentry_r r on r.fid = a.fid \n");
            sql.append("inner join t_mrp_planorder c on c.fid = r.fsrcbillid \n");
            sql.append("where a.fbiztypeid in (1002795213917594624,966651870204521472)\n");
            sql.append("and b.fisredordermate <> c.fmaterialspread \n");
            sql.append("and c.fmaterialspread is not null ");
            paramsList = new ArrayList(10);
            dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql.toString());
            partition2 = null;
            try {
                for (Row row : dataSet) {
                    paramsList.add(new Object[]{row.get("fmaterialspread"), row.get("fentryid")});
                }
            }
            catch (Throwable throwable) {
                partition2 = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (partition2 != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)partition2).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            result.setLog(String.format("OutPurApplyBillUpgradeServiceImpl query update fmaterialspread param size\uff1a%s", paramsList.size()));
            if (CollectionUtils.isNotEmpty(paramsList)) {
                partition = Lists.partition(paramsList, (int)1000);
                updateSql = "update t_pm_purapplybillentry set fisredordermate = ? where fentryid = ?";
                for (List objects : partition) {
                    this.batchExcuteUpdate(DBRoute.of((String)"scm"), (String)updateSql, objects);
                }
            }
            sql.delete(0, sql.length());
            sql.append("select b.fentryid from t_pm_purapplybill a \n");
            sql.append("inner join t_pm_purapplybillentry b on b.fid = a.fid \n");
            sql.append("inner join t_pm_purapplybillentry_r r on r.fid = a.fid \n");
            sql.append("left join t_mrp_planorder c on c.fid = r.fsrcbillid \n");
            sql.append("where a.fbiztypeid in (1002795213917594624,966651870204521472)\n");
            sql.append("and c.fid is null \n");
            sql.append("and b.fisredordermate <> '1' \n");
            paramsList = new ArrayList(10);
            dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql.toString());
            updateSql = null;
            try {
                for (Row row : dataSet) {
                    paramsList.add(new Object[]{row.get("fentryid")});
                }
            }
            catch (Throwable throwable) {
                updateSql = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (updateSql != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)updateSql).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(paramsList)) {
                partition = Lists.partition(paramsList, (int)1000);
                updateSql = "update t_pm_purapplybillentry set fisredordermate = '1' where fentryid = ?";
                for (List objects : partition) {
                    this.batchExcuteUpdate(DBRoute.of((String)"scm"), (String)updateSql, objects);
                }
            }
            result.setLog("Excute OutPurApplyBillUpgradeServiceImpl for update t_pm_purapplybillentry fisredordermate no planorder");
            result.setSuccess(true);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            result.setLog(e.toString());
            result.setSuccess(false);
        }
    }

    private void batchExcuteUpdate(DBRoute dbKey, String updateSql, List<Object[]> objects) {
        DB.executeBatch((DBRoute)dbKey, (String)updateSql, objects);
    }
}

