/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.mservice.upgrade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.mmc.om.mservice.upgrade.entity.SubinStorageEntity;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class StockSourceTypeUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(StockSourceTypeUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        String sql = "select distinct fisbomextend,FDetailId,fsourcetype from t_om_mftstockentry where fsourcetype = null or fsourcetype = ' '";
        try (DataSet srcEntryId = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);){
            String sql2;
            HashSet<SubinStorageEntity> set = new HashSet<SubinStorageEntity>(16);
            HashSet<Long> mftorderEntryIds = new HashSet<Long>(16);
            while (srcEntryId.hasNext()) {
                Row row = srcEntryId.next();
                long orderentryid = row.getLong("FDetailId");
                String isbomextend = row.getString("fisbomextend");
                if ("1".equals(isbomextend)) {
                    SubinStorageEntity subinStorageEntity = new SubinStorageEntity();
                    subinStorageEntity.setManufactureEntryId(orderentryid);
                    subinStorageEntity.setStr("A");
                    set.add(subinStorageEntity);
                    continue;
                }
                mftorderEntryIds.add(orderentryid);
            }
            if (!CollectionUtils.isEmpty(mftorderEntryIds)) {
                sql2 = "select distinct fentrychangetype,fstockentryid from t_om_xmftstockentry_A where fentrychangetype = 'A'";
                DataSet srcEntryId2 = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql2);
                HashSet mftorderEntryIds2 = new HashSet(16);
                while (srcEntryId2.hasNext()) {
                    Row row = srcEntryId2.next();
                    String orderentryidStr = row.getString("fstockentryid");
                    if (!StringUtils.isNotBlank((CharSequence)orderentryidStr)) continue;
                    long orderentryid = Long.parseLong(orderentryidStr);
                    mftorderEntryIds2.add(orderentryid);
                }
                for (Long mftorderEntryId : mftorderEntryIds) {
                    SubinStorageEntity subinStorageEntity;
                    if (mftorderEntryIds2.contains(mftorderEntryId)) {
                        subinStorageEntity = new SubinStorageEntity();
                        subinStorageEntity.setManufactureEntryId(mftorderEntryId);
                        subinStorageEntity.setStr("C");
                        set.add(subinStorageEntity);
                        continue;
                    }
                    subinStorageEntity = new SubinStorageEntity();
                    subinStorageEntity.setManufactureEntryId(mftorderEntryId);
                    subinStorageEntity.setStr("B");
                    set.add(subinStorageEntity);
                }
            }
            if (CollectionUtils.isEmpty(set)) {
                logger.info("StockSourceTypeUpgradeServiceImpl data is empty");
                sql2 = null;
                return sql2;
            }
            String updateInvTypeSql = "update t_om_mftstockentry set fsourcetype  = ? where FDetailId = ?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
            for (SubinStorageEntity entry : set) {
                paramsList.add(new Object[]{entry.getStr(), entry.getManufactureEntryId()});
            }
            if (CollectionUtils.isNotEmpty(paramsList)) {
                List partition = Lists.partition(paramsList, (int)1000);
                for (List objects : partition) {
                    this.batchUpdate(scmRoute, objects, updateInvTypeSql);
                }
            }
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private void batchUpdate(DBRoute scmRoute, List<Object[]> objects, String updateInvTypeSql) {
        ThreadPools.executeOnceIncludeRequestContext((String)"StockSourceTypeUpgradeServiceImpl", (Runnable)ThreadLifeCycleManager.wrapRunnable(() -> DB.executeBatch((DBRoute)scmRoute, (String)updateInvTypeSql, (List)objects)));
    }
}

