/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.basedata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.pdm.business.init.InitDataUtils;

public class PdmInitDataListFormPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(PdmInitDataListFormPlugin.class);

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ArrayList<Object> orgPks = new ArrayList<Object>(16);
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn columnFilter = (CommonFilterColumn)filterColumn;
            if (!columnFilter.getFieldName().startsWith("org")) continue;
            columnFilter.getComboItems().clear();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
            Set orgIds = InitDataUtils.getOrgIdSet();
            Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)orgIds)});
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bos_org");
            DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)mainEntityType, null);
            if (orgMap != null) {
                orgColl.addAll(orgMap.values());
            }
            for (DynamicObject org2 : orgColl) {
                Object orgPk = org2.getPkValue();
                orgPks.add(orgPk);
                comboItems.add(new ComboItem(new LocaleString(org2.getLocaleString("name").getLocaleValue()), orgPk.toString()));
            }
            columnFilter.setComboItems(comboItems);
            ArrayList<String> defaultOrg = new ArrayList<String>(16);
            long currentOrgId = RequestContext.get().getOrgId();
            boolean match = orgPks.stream().map(org -> Long.valueOf(org.toString())).anyMatch(org -> org.equals(currentOrgId));
            if (!match && !ObjectUtils.isEmpty((Object)orgColl)) {
                defaultOrg.add(String.valueOf(((DynamicObject)orgColl.get(0)).getPkValue()));
            } else {
                defaultOrg.add(String.valueOf(currentOrgId));
            }
            columnFilter.setDefaultValues(defaultOrg);
            break;
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (field != null && field.contains("org")) {
            Set orgIds = InitDataUtils.getOrgIdSet();
            QFilter orgFilter = new QFilter("id", "in", (Object)orgIds);
            List qFilters = args.getQfilters();
            qFilters.clear();
            qFilters.add(orgFilter);
            args.setQfilters(qFilters);
        }
    }

    private boolean checkUseOrg(List<Long> selectedMainOrgIds, BeforeDoOperationEventArgs args) {
        if (selectedMainOrgIds.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"PdmInitDataListFormPlugin_01", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        Long useOrgId = selectedMainOrgIds.get(0);
        long userId = RequestContext.get().getCurrUserId();
        if (PermissionServiceHelper.checkPermission((Long)userId, (Long)useOrgId, (String)"pdm", (String)"pdm_initdata", (String)"40ANFWHX7BDE") != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u672c\u751f\u4ea7\u7ec4\u7ec7\u521d\u59cb\u5316\u6570\u636e\u7684\u6743\u9650\u3002", (String)"PdmInitDataListFormPlugin_05", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long useOrgId;
        String msg;
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String key = op.getOperateKey();
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        if ((StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"getinititemdata") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"initdata")) && !this.checkUseOrg(selectedMainOrgIds, args)) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"initdata") && !kd.bos.util.StringUtils.isEmpty((String)(msg = InitDataUtils.getTipMsg((Long)(useOrgId = (Long)selectedMainOrgIds.get(0)), this.getPkValues())))) {
            String tipMsg = String.format(ResManager.loadKDString((String)"%1$s \r\n\u60a8\u786e\u5b9a\u8981\u7ee7\u7eed\u6267\u884c\u521d\u59cb\u5316\u64cd\u4f5c\u5417\uff1f", (String)"PdmInitDataListFormPlugin_03", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), msg);
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(key, (IFormPlugin)this);
            confirmCallBack.setView(this.getView());
            this.getView().showConfirm(tipMsg, MessageBoxOptions.YesNo, confirmCallBack);
            args.setCancel(true);
        }
    }

    private List<Long> getPkValues() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        ArrayList<Long> ids = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            Long id = (Long)row.getPrimaryKeyValue();
            ids.add(id);
        }
        return ids;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && "initdata".equals(e.getCallBackId())) {
            this.invokeInitOp();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"getinititemdata") && e.getOperationResult().isSuccess()) {
            this.invokeInitConfigOp();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"initdata") && e.getOperationResult().isSuccess()) {
            this.invokeInitOp();
        }
    }

    private void invokeInitConfigOp() {
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        if (selectedMainOrgIds.isEmpty()) {
            return;
        }
        InitDataUtils.getInitItemData((Long)((Long)selectedMainOrgIds.get(0)));
        this.getView().invokeOperation("refresh");
    }

    private void invokeInitOp() {
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        List<Long> ids = this.getPkValues();
        if (!selectedMainOrgIds.isEmpty()) {
            Long useOrgId = (Long)selectedMainOrgIds.get(0);
            boolean isSuccessful = InitDataUtils.execInitData((Long)useOrgId, ids);
            if (isSuccessful) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"PdmInitDataListFormPlugin_02", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5b58\u5728\u5931\u8d25\uff0c\u8bf7\u5728\u521d\u59cb\u5316\u7ed3\u679c\u4e2d\u67e5\u770b\u3002", (String)"PdmInitDataListFormPlugin_04", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            }
        }
        this.getView().invokeOperation("refresh");
    }
}

