/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.batchmftbom;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BatchMFTBomLogListPlugin
extends AbstractListPlugin {
    private static final String PDM_MFTBOM = "pdm_mftbom";
    private static final String PDM_BATCHMFTBOMLOG = "pdm_batchmftbomlog";
    private static final String BOM_NUMBER = "bomnum";
    private static final String SHOWCONTENT = "showcontent";
    private static final String PDM_BATCHLOGDERAIL = "pdm_batchlogdetail";
    private static final String PKID = "pkId";
    private static final String BILLLISTID = "billlistap";

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object batchbomlogs = customParams.get("batchbomlogs");
        Set<Object> collect = new HashSet(8);
        if (batchbomlogs instanceof JSONArray) {
            collect = ((JSONArray)batchbomlogs).stream().collect(Collectors.toSet());
        }
        if (!collect.isEmpty()) {
            BillList billList = (BillList)this.getControl(BILLLISTID);
            billList.setFilter(new QFilter("id", "in", collect));
            billList.refresh();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList bom_number = (BillList)this.getControl(BILLLISTID);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
        if (currentRow == null) {
            return;
        }
        Object primaryKeyValue = currentRow.getPrimaryKeyValue();
        Object entryPrimaryKeyValue = currentRow.getEntryPrimaryKeyValue();
        Long pkId = -1L;
        Long entryPkId = -1L;
        if (primaryKeyValue instanceof Long) {
            pkId = (Long)primaryKeyValue;
        }
        if (entryPrimaryKeyValue instanceof Long) {
            entryPkId = (Long)entryPrimaryKeyValue;
        }
        String eventName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        args.setCancel(true);
        boolean flag = true;
        switch (eventName) {
            case "bomnum": {
                QFilter qfFilter = new QFilter("logdetailentry.id", "=", (Object)entryPkId);
                DynamicObject queryOne = QueryServiceHelper.queryOne((String)PDM_BATCHMFTBOMLOG, (String)"logdetailentry.bomnum,logdetailentry.bomid", (QFilter[])new QFilter[]{qfFilter});
                Object bomPKObj = queryOne.get("logdetailentry.bomid");
                Long bomId = -1L;
                if (bomPKObj instanceof Long) {
                    bomId = (Long)bomPKObj;
                }
                this.linkBom(rowIndex, bomId);
                break;
            }
            case "showcontent": {
                flag = this.linkContent(pkId);
                if (flag) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684BOM\u4e0d\u5b58\u5728\u3002", (String)"BatchMFTBomLogListPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private boolean linkContent(Long pkId) {
        if (pkId < 0L) {
            return false;
        }
        return this.showForm(PDM_BATCHLOGDERAIL, pkId, ShowType.Modal, OperationStatus.VIEW);
    }

    private boolean showForm(String formId, Long pkId, ShowType showType, OperationStatus status) {
        if (StringUtils.isEmpty((CharSequence)formId) || pkId < 0L) {
            return false;
        }
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", formId);
        para.put(PKID, String.valueOf(pkId));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.setPageId(formId + String.valueOf(pkId));
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.setStatus(status);
        this.getView().showForm(showParameter);
        return true;
    }

    private boolean linkBom(int rowIndex, Long clickBomID) {
        DynamicObject bomDO;
        Object bomObj;
        if (rowIndex < 0 || clickBomID < 0L) {
            return false;
        }
        QFilter qFilterNo = new QFilter("id", "=", (Object)clickBomID);
        boolean exists = QueryServiceHelper.exists((String)PDM_MFTBOM, (QFilter[])new QFilter[]{qFilterNo});
        if (exists && (bomObj = (bomDO = QueryServiceHelper.queryOne((String)PDM_MFTBOM, (String)"id", (QFilter[])new QFilter[]{qFilterNo})).get("id")) instanceof Long) {
            return this.showForm(PDM_MFTBOM, clickBomID, ShowType.MainNewTabPage, OperationStatus.EDIT);
        }
        return false;
    }
}

