/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.chararule;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.pdm.common.util.chararul.CharaRuleUtils;

public class CharaRuleEdit
extends AbstractFormPlugin
implements CellClickListener {
    private static Log logger = LogFactory.getLog(CharaRuleEdit.class);
    private static final String CALLBACKACTIONID_FORMULAFORM = "formulaform";
    private static final String KEY_SELECTEDCHARAVAL = "selectedcharaval";
    private static final String PDM_FEATUREDEFINITION = "pdm_featuredefinition";
    private static final String PDM_FEATUREF7 = "pdm_featuref7";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"formulaalias", "entryval", "formula_test"});
        this.addClickListeners(new String[]{"value", "prevalue", "convalue", "formulavalue"});
        EntryGrid entryEntity = (EntryGrid)this.getView().getControl("entryentity");
        entryEntity.addCellClickListener((CellClickListener)this);
        EntryGrid preEntryEntity = (EntryGrid)this.getView().getControl("preentryentity");
        preEntryEntity.addCellClickListener((CellClickListener)this);
        EntryGrid conEntryEntity = (EntryGrid)this.getView().getControl("constrainentryentity");
        conEntryEntity.addCellClickListener((CellClickListener)this);
        EntryGrid valueEntryEntity = (EntryGrid)this.getView().getControl("valueentryentity");
        valueEntryEntity.addCellClickListener((CellClickListener)this);
    }

    public void initialize() {
        super.initialize();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "formulaalias": {
                break;
            }
            case "formula_test": {
                break;
            }
            case "entryval": {
                this.showBillList(source.getKey());
                break;
            }
            case "value": {
                this.clickValue("entryentity", "valuetype");
                break;
            }
            case "prevalue": {
                break;
            }
            case "convalue": {
                break;
            }
            case "formulavalue": {
                break;
            }
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey;
        switch (fieldKey = cellClickEvent.getFieldKey()) {
            case "value": {
                this.clickFeatureValue("entryentity", "valuetype", "featureid");
                break;
            }
            case "prevalue": {
                this.clickFeatureValue("preentryentity", "prevaluetype", "prefeatureid");
                break;
            }
            case "convalue": {
                this.clickFeatureValue("constrainentryentity", "convaluetype", "confeatureid");
                break;
            }
            case "formulavalue": {
                this.clickValue("valueentryentity", "formulavaluetype");
                break;
            }
        }
    }

    private void clickFeatureValue(String entryentity, String valueType, String featureField) {
        EntryGrid entryGrid;
        int[] selectRows;
        int selectRow;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object valueTypeStr = model.getValue(valueType, selectRow = (selectRows = (entryGrid = (EntryGrid)view.getControl(entryentity)).getSelectRows())[0]);
        if (valueTypeStr instanceof String && StringUtils.equals((CharSequence)"1", (CharSequence)valueTypeStr.toString())) {
            this.setFeatureValueShowParam(entryentity, valueType, featureField, selectRow);
        }
    }

    private void setFeatureValueShowParam(String entryentity, String valueType, String featureField, int row) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object featureid = this.getModel().getValue(featureField, row);
        DynamicObject featureDO = null;
        String featureType = "";
        int len = -1;
        long featurePKValue = 0L;
        boolean isAllowMulValue = false;
        boolean isAllowNegative = false;
        if (featureid instanceof DynamicObject) {
            featureDO = (DynamicObject)featureid;
            featureType = featureDO.getString("featuretype");
            featurePKValue = featureDO.getLong("id");
            isAllowNegative = featureDO.getBoolean("isallownegative");
            if (StringUtils.equals((CharSequence)featureType, (CharSequence)"A")) {
                len = featureDO.getInt("length");
            } else if (StringUtils.equals((CharSequence)featureType, (CharSequence)"B")) {
                len = featureDO.getInt("precision");
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7279\u5f81\u3002", (String)"CharaRuleEdit_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection featureListDOC = model.getEntryEntity(entryentity);
        List<Map<String, Object>> selectParamData = this.getFeatureDOList(entryentity, featureListDOC, row);
        ArrayList<Map<String, Object>> valueData = new ArrayList(4);
        boolean isEdit = false;
        DynamicObjectCollection treeEntryEntity = null;
        if (featureDO != null) {
            treeEntryEntity = featureDO.getDynamicObjectCollection("treeentryentity");
        }
        if (treeEntryEntity != null && !treeEntryEntity.isEmpty()) {
            for (DynamicObject entryDO : treeEntryEntity) {
                if (entryDO == null) continue;
                HashMap<String, Object> entryMap = new HashMap<String, Object>(4);
                String entryValue = entryDO.getString("entryvalue");
                String entryvalueName = entryDO.getString("entryvaluename");
                long entryPK = entryDO.getLong("id");
                String featureValue = entryDO.getString("featurevalueid");
                long featureValueId = 0L;
                if (StringUtils.isNotBlank((CharSequence)featureValue) && Pattern.matches("^[0-9]*$", featureValue)) {
                    featureValueId = Long.parseLong(featureValue);
                }
                entryMap.put("entryvalue", entryValue);
                entryMap.put("entryvaluename", entryvalueName);
                entryMap.put("entryid", entryPK);
                entryMap.put("entryauxvalueid", featureValueId);
                valueData.add(entryMap);
            }
        } else {
            isEdit = true;
            List<Map<String, Object>> cacheManualDataList = this.queryFeatureValueCacheManualData(view, model, row);
            valueData = cacheManualDataList;
        }
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("isallownegative", isAllowNegative);
        param.put("len", len);
        param.put("featuretype", featureType);
        this.showWorkScopeForm(param, valueData, selectParamData, isAllowMulValue, valueType, isEdit);
    }

    private void showWorkScopeForm(Map<String, Object> paramData, List<Map<String, Object>> valueData, List<Map<String, Object>> selectParamData, boolean isAllowMulValue, String callBack, boolean isEdit) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("list", valueData);
        params.put("selectData", selectParamData);
        params.put("isedit", isEdit);
        params.put("isallowmulvalue", isAllowMulValue);
        params.put("formId", "mpdm_featurevalselector");
        if (paramData != null) {
            params.putAll(paramData);
        }
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(params);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBack));
        this.getView().showForm(showParameter);
    }

    private List<Map<String, Object>> getFeatureDOList(String entryentity, DynamicObjectCollection featureListDOC, int row) {
        if (featureListDOC == null) {
            return null;
        }
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(1);
        IDataModel model = this.getModel();
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        Object valueId = model.getValue(CharaRuleUtils.getEntryValueIDField((String)entryentity), row);
        Object value = model.getValue(CharaRuleUtils.getEntryValueField((String)entryentity), row);
        if (StringUtils.isNotBlank((Object)value)) {
            param.put("entryid", valueId);
            param.put("entryvalue", value);
            paramList.add(param);
        }
        return paramList;
    }

    private List<Map<String, Object>> queryFeatureValueCacheManualData(IFormView view, IDataModel model, int row) {
        String cacheManualDataJSON;
        DynamicObject featureDO;
        List<Map<String, Object>> cacheManualDataList = new ArrayList<Map<String, Object>>(2);
        if (view == null || model == null) {
            return cacheManualDataList;
        }
        Object featureObj = model.getValue("featureid", row);
        String featurePkStr = "";
        if (featureObj instanceof DynamicObject && (featureDO = (DynamicObject)featureObj).getPkValue() != null) {
            featurePkStr = String.valueOf(featureDO.getPkValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)(cacheManualDataJSON = view.getPageCache().get(featurePkStr)))) {
            cacheManualDataList = (List)JSONObject.parseObject((String)cacheManualDataJSON, List.class);
        }
        return cacheManualDataList;
    }

    private void clickValue(String entryentity, String valueType) {
        EntryGrid entryGrid;
        int[] selectRows;
        int selectRow;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object valueTypeStr = model.getValue(valueType, selectRow = (selectRows = (entryGrid = (EntryGrid)view.getControl(entryentity)).getSelectRows())[0]);
        if (valueTypeStr instanceof String && StringUtils.equals((CharSequence)"1", (CharSequence)valueTypeStr.toString())) {
            this.setValueShowParam(entryentity, valueType, selectRow);
        }
    }

    private void setValueShowParam(String entryentity, String valueType, int selectRow) {
        RequestContext requestContext = RequestContext.get();
        long orgId = requestContext.getOrgId();
        QFilter featureDefBaseQfilter = BaseDataServiceHelper.getBaseDataFilter((String)PDM_FEATUREDEFINITION, (Long)orgId);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{featureDefBaseQfilter, statusFilter, enableFilter};
        DynamicObjectCollection featureDOC = QueryServiceHelper.query((String)PDM_FEATUREDEFINITION, (String)this.getSelectFiled(), (QFilter[])qFilters);
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(16);
        if (featureDOC != null) {
            for (int i = 0; i < featureDOC.size(); ++i) {
                DynamicObject featureDO = (DynamicObject)featureDOC.get(i);
                if (featureDO == null) continue;
                HashMap<String, Object> featureMap = new HashMap<String, Object>(8);
                long featurePK = featureDO.getLong("id");
                String number = featureDO.getString("number");
                String name = featureDO.getString("name");
                String group = featureDO.getString("group.number");
                String status = featureDO.getString("status");
                String enable = featureDO.getString("enable");
                String featuretype = featureDO.getString("featuretype");
                featureMap.put("id", featurePK);
                featureMap.put("number", number);
                featureMap.put("name", name);
                featureMap.put("group.number", group);
                featureMap.put("status", status);
                featureMap.put("enable", enable);
                featureMap.put("featuretype", featuretype);
                paramList.add(featureMap);
            }
        }
        this.showWorkScopeForm(paramList, null, valueType);
    }

    private String getSelectFiled() {
        StringBuilder fieldBuild = new StringBuilder();
        fieldBuild.append("id,");
        fieldBuild.append("number,");
        fieldBuild.append("name,");
        fieldBuild.append("group.number,");
        fieldBuild.append("group.name,");
        fieldBuild.append("status,");
        fieldBuild.append("enable,");
        fieldBuild.append("featuretype");
        return fieldBuild.toString();
    }

    private void showWorkScopeForm(List<Map<String, Object>> valueData, List<Map<String, Object>> selectParamData, String callBackField) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("list", valueData);
        params.put("selectData", selectParamData);
        params.put("formId", PDM_FEATUREF7);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(params);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackField));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (StringUtils.isBlank((Object)evt)) {
            return;
        }
        String action = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (action) {
            case "entryval": {
                this.setEntryVal(evt);
                break;
            }
            case "formulaform": {
                break;
            }
            case "valuetype": {
                this.callBackItemSelector(returnData, "entryentity", "value", "valfeaturedef");
                break;
            }
            case "prevaluetype": {
                this.callBackItemSelector(returnData, "preentryentity", "prevalue", "prevalfeaturedef");
                break;
            }
            case "convaluetype": {
                this.callBackItemSelector(returnData, "constrainentryentity", "convalue", "convalfeaturedef");
                break;
            }
            case "formulavaluetype": {
                this.setValueFeature(returnData, "valueentryentity", "formulavalue", "formvalfeaturedef");
                break;
            }
        }
    }

    private void callBackItemSelector(Object returnData, String entryEntity, String value, String valFeatureDef) {
        Object datas;
        if (returnData == null) {
            return;
        }
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Map callBackDataMap = null;
        List<Map<String, Object>> dataList = new ArrayList(8);
        if (returnData instanceof Map && (datas = (callBackDataMap = (Map)returnData).get("datas")) instanceof List) {
            dataList = (List)datas;
        }
        if (callBackDataMap == null) {
            return;
        }
        EntryGrid subentryGrid = (EntryGrid)this.getControl(entryEntity);
        int[] subEntrySelects = subentryGrid.getSelectRows();
        int row = subEntrySelects[0];
        Object cacheManualData = callBackDataMap.get("cachemanualdata");
        this.recordCacheManualData(view, model, cacheManualData, row);
        model.setValue(CharaRuleUtils.getEntryValueField((String)entryEntity), null, row);
        model.setValue(CharaRuleUtils.getEntryValueIDField((String)entryEntity), (Object)0L, row);
        if (dataList != null && !dataList.isEmpty()) {
            this.callBackWriteFeatureValue(view, model, dataList, entryEntity, row);
        }
        view.updateView(entryEntity);
    }

    private void callBackWriteFeatureValue(IFormView view, IDataModel model, List<Map<String, Object>> dataList, String entryEntity, int row) {
        if (view == null || model == null || dataList == null) {
            return;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> dataMap = dataList.get(i);
            Object entryValue = dataMap.get("entryvalue");
            Object entryIDObj = dataMap.get("entryid");
            Long entryid = 0L;
            if (entryIDObj != null && StringUtils.isNotEmpty((CharSequence)entryIDObj.toString()) && Pattern.matches("^[0-9]*$", String.valueOf(entryIDObj))) {
                entryid = Long.parseLong(entryIDObj.toString());
            }
            model.setValue(CharaRuleUtils.getEntryValueIDField((String)entryEntity), (Object)entryid, row);
            model.setValue(CharaRuleUtils.getEntryValueField((String)entryEntity), entryValue, row);
        }
    }

    private void recordCacheManualData(IFormView view, IDataModel model, Object cacheManualData, int row) {
        DynamicObject featureDO;
        if (view == null || model == null || cacheManualData == null) {
            return;
        }
        List cacheManualDataList = new ArrayList(8);
        Object featureObj = model.getValue("featureid", row);
        String featurePkStr = "";
        if (featureObj instanceof DynamicObject && (featureDO = (DynamicObject)featureObj).getPkValue() != null) {
            featurePkStr = String.valueOf(featureDO.getPkValue());
        }
        if (cacheManualData instanceof List) {
            cacheManualDataList = (List)cacheManualData;
            String cacheManualDataJson = JSONObject.toJSONString(cacheManualDataList);
            view.getPageCache().put(featurePkStr, cacheManualDataJson);
        }
    }

    private void setValueFeature(Object returnData, String entryEntity, String value, String valFeatureDef) {
        EntryGrid subentryGrid;
        int[] subEntrySelects;
        Object datas;
        Map returnDataMap = null;
        ArrayList<Map<String, Object>> dataList = new ArrayList(8);
        if (returnData instanceof Map && (datas = (returnDataMap = (Map)returnData).get("datas")) instanceof List) {
            dataList = (List)datas;
        }
        if ((subEntrySelects = (subentryGrid = (EntryGrid)this.getControl(entryEntity)).getSelectRows()) != null && subEntrySelects.length > 0) {
            int row = subEntrySelects[0];
            this.writeDataEntry(dataList, entryEntity, value, valFeatureDef, row);
        }
        if ("valueentryentity".equals(entryEntity)) {
            this.setEnableCompare("valueentryentity");
        }
        this.getView().updateView(entryEntity);
    }

    private void setEnableCompare(String entryEntity) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection entryEntityDOC = model.getEntryEntity(entryEntity);
        ArrayList<Long> featurePkList = new ArrayList<Long>(4);
        for (int i = 0; i < entryEntityDOC.size(); ++i) {
            DynamicObject entryEntityDO = (DynamicObject)entryEntityDOC.get(i);
            long featureDefPk = entryEntityDO.getLong("formvalfeaturedef");
            if (featureDefPk <= 0L) continue;
            featurePkList.add(featureDefPk);
        }
        Map featureMap = BusinessDataServiceHelper.loadFromCache((Object[])featurePkList.toArray(new Long[featurePkList.size()]), (String)PDM_FEATUREDEFINITION);
        for (int i = 0; i < entryEntityDOC.size(); ++i) {
            DynamicObject entryEntityDO = (DynamicObject)entryEntityDOC.get(i);
            long featureDefPk = entryEntityDO.getLong("formvalfeaturedef");
            String formulavaluetype = entryEntityDO.getString("formulavaluetype");
            String formulaValue = entryEntityDO.getString("formulavalue");
            if (featureMap == null || !featureMap.containsKey(featureDefPk)) continue;
            DynamicObject featureDO = (DynamicObject)featureMap.get(featureDefPk);
            if (featureDO != null) {
                String number = featureDO.getString("number");
                String featureType = featureDO.getString("featuretype");
                if ("1".equals(formulavaluetype) && "A".equals(featureType) && StringUtils.equals((CharSequence)formulaValue, (CharSequence)number)) {
                    model.setValue("formulacompare", (Object)"+", i);
                    view.setEnable(Boolean.valueOf(false), i, new String[]{"formulacompare"});
                    continue;
                }
                view.setEnable(Boolean.valueOf(true), i, new String[]{"formulacompare"});
                continue;
            }
            view.setEnable(Boolean.valueOf(true), i, new String[]{"formulacompare"});
        }
    }

    private void writeDataEntry(List<Map<String, Object>> dataList, String entryEntity, String value, String valFeatureDef, int row) {
        if (dataList == null || dataList.size() == 0) {
            return;
        }
        Map<String, Object> dataMap = dataList.get(0);
        Object pkValueObj = dataMap.get("pkvalue");
        Object number = dataMap.get("number");
        Long pkValue = 0L;
        if (pkValueObj instanceof Long) {
            pkValue = (Long)pkValueObj;
        }
        IDataModel model = this.getModel();
        model.setValue(value, number, row);
        model.setValue(valFeatureDef, (Object)pkValue, row);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        ChangeData[] changeSet = evt.getChangeSet();
        String propName = evt.getProperty().getName();
        for (int i = 0; i < changeSet.length; ++i) {
            this.propertyChanged(changeSet[i], propName);
        }
    }

    private void propertyChanged(ChangeData changeData, String propName) {
        int rowIndex = changeData.getRowIndex();
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        switch (propName) {
            case "type": {
                this.setFormulaEnable(newValue);
                this.refreshFormula(oldValue, newValue);
                break;
            }
            case "formula": {
                this.getModel().setValue("formulaalias", newValue);
                this.getView().updateView("formulaalias");
                break;
            }
            case "formulavaluetype": {
                this.getModel().setValue("formulavalue", (Object)"", rowIndex);
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"formulacompare"});
                break;
            }
            case "formulavalue": {
                break;
            }
        }
    }

    private void setFormulaEnable(Object newValue) {
        String type;
        String string = type = newValue == null ? "" : newValue.toString();
        if (type == null || "".equals(type)) {
            type = (String)this.getModel().getValue("type");
        }
        if ("1".equals(type) || "2".equals(type)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"formula"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"formula"});
        }
    }

    private void refreshFormula(Object oldValue, Object newValue) {
        String newVal;
        String oldVal = oldValue == null ? "" : oldValue.toString();
        String string = newVal = newValue == null ? "" : newValue.toString();
        if (!oldVal.equals(newVal)) {
            this.getModel().setValue("formula", null);
            this.getModel().setValue("formulaalias", null);
            this.getView().updateView("formula");
            this.getView().updateView("formulaalias");
            this.removeEntrys("entryentity");
            this.removeEntrys("preentryentity");
            this.removeEntrys("constrainentryentity");
        }
    }

    private void removeEntrys(String entryentity) {
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity(entryentity);
        if (entryCol != null && !entryCol.isEmpty()) {
            int[] rows = new int[entryCol.size()];
            for (int i = 0; i < entryCol.size(); ++i) {
                rows[i] = i;
            }
            this.getModel().deleteEntryRows(entryentity, rows);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFormulaEnable("");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String oprKey;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        switch (oprKey = op.getOperateKey()) {
            case "save": {
                this.generateExpression();
                this.validFormulaScript(e);
                break;
            }
            case "submit": {
                this.validFormulaScript(e);
                break;
            }
        }
    }

    private void generateExpression() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object typeObj = model.getValue("type");
        String type = "";
        if (typeObj instanceof String) {
            type = String.valueOf(typeObj);
        }
        switch (type) {
            case "1": 
            case "2": {
                DynamicObjectCollection entryEntityDOC = model.getEntryEntity("entryentity");
                boolean illegal = this.checkBracket(entryEntityDOC, "entryentity", "leftbracket", "rightbracket");
                if (!illegal) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u4e2d\u62ec\u53f7\u4e0d\u5408\u6cd5\uff0c\u8bf7\u5f55\u5165\u6210\u5bf9\u7684\u62ec\u53f7\u3002", (String)"CharaRuleEdit_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.assembleExpression(entryEntityDOC, "entryentity");
                break;
            }
            case "3": {
                break;
            }
        }
    }

    private void assembleExpression(DynamicObjectCollection entryEntityDOC, String entryentity) {
    }

    private boolean checkBracket(DynamicObjectCollection entryEntityDOC, String entryentity, String leftBracket, String rightBracket) {
        if (entryEntityDOC == null) {
            return true;
        }
        Stack<String> stack = new Stack<String>();
        boolean illegal = true;
        for (int i = 0; i < entryEntityDOC.size(); ++i) {
            String pop;
            DynamicObject entryDO = (DynamicObject)entryEntityDOC.get(i);
            if (entryDO == null) continue;
            String leftBracketStr = entryDO.getString(leftBracket);
            String rightBracketStr = entryDO.getString(rightBracket);
            if (StringUtils.equals((CharSequence)"((", (CharSequence)leftBracket)) {
                stack.push("(");
                stack.push("(");
            } else if (StringUtils.equals((CharSequence)"(", (CharSequence)leftBracket)) {
                stack.push(leftBracket);
            }
            if (StringUtils.equals((CharSequence)"))", (CharSequence)rightBracket)) {
                if (stack.size() >= 2) {
                    pop = (String)stack.pop();
                    String pop1 = (String)stack.pop();
                    if (StringUtils.equals((CharSequence)"(", (CharSequence)pop) && StringUtils.equals((CharSequence)"(", (CharSequence)pop1)) continue;
                    illegal = false;
                    break;
                }
                illegal = false;
                continue;
            }
            if (!StringUtils.equals((CharSequence)")", (CharSequence)rightBracket) || StringUtils.equals((CharSequence)"(", (CharSequence)(pop = (String)stack.pop()))) continue;
            illegal = false;
            break;
        }
        return illegal;
    }

    private void validFormulaScript(BeforeDoOperationEventArgs e) {
        String formulaScript = (String)this.getModel().getValue("formula");
        if (formulaScript != null && !formulaScript.endsWith(";")) {
            formulaScript = formulaScript + ";";
            this.getModel().setValue("formula", (Object)formulaScript);
            this.getModel().setValue("formulaalias", (Object)formulaScript);
            this.getView().updateView("formula");
        }
    }

    private void setEntryVal(ClosedCallBackEvent evt) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
        if (rows != null && !rows.isEmpty()) {
            this.updateCharactVal(rows);
        }
    }

    private void updateCharactVal(ListSelectedRowCollection rows) {
        ArrayList<Object> headSet = new ArrayList<Object>(rows.size());
        HashSet<Object> set = new HashSet<Object>();
        List<Object> entryList = Arrays.asList(rows.getEntryPrimaryKeyValues());
        for (ListSelectedRow row : rows) {
            headSet.add(row.getPrimaryKeyValue());
        }
        QFilter qf1 = new QFilter("treeentryentity.id", "in", entryList);
        ArrayList<String> nameList = new ArrayList<String>(rows.getEntryPrimaryKeyValues().length);
        ArrayList<String> valueList = new ArrayList<String>(rows.getEntryPrimaryKeyValues().length);
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)PDM_FEATUREDEFINITION, (String)"id, treeentryentity.id, name,treeentryentity.entryvalue entryvalue,treeentryentity.entryvaluename entryvaluename", (QFilter[])new QFilter[]{qf1}, null);){
            entryList = new ArrayList<Object>();
            for (Row row : queryDataSet) {
                Object id = row.get("id");
                if (set.contains(id)) continue;
                set.add(id);
                entryList.add(row.get("treeentryentity.id"));
                headSet.add(id);
                nameList.add(row.getString("name"));
                valueList.add(row.getString("entryvalue") + "/" + row.getString("entryvaluename"));
            }
            this.getModel().setValue("entryval", (Object)((Object)valueList).toString());
            this.getModel().setValue("charactdefinit", (Object)((Object)nameList).toString());
        }
        this.getModel().setValue("entryvalid", (Object)entryList.toString());
        this.getModel().setValue("charactdefinitid", (Object)((Object)headSet).toString());
    }

    private void showBillList(String sourcekey) {
        DynamicObject objectType = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)sourcekey, (CharSequence)"entryval")) {
            QFilter filter = new QFilter("number", "in", (Object)new String[]{"pdm_featuredefval_f7"});
            objectType = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (String)"id,number,name", (QFilter[])new QFilter[]{filter});
        }
        if (objectType != null) {
            String entityNumber = (String)objectType.getPkValue();
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)true);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, sourcekey);
            showParameter.setCloseCallBack(closeCallBack);
            if (StringUtils.equalsIgnoreCase((CharSequence)sourcekey, (CharSequence)"entryval")) {
                QFilter auditFilter = new QFilter("status", "=", (Object)"C");
                QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(enableFilter, auditFilter));
            }
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

