/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.chararule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class CharaRuleSelectEditPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
RowClickEventListener {
    private static final String ENTRY_ENTITY = "entryentity";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_cancel", "btn_ok"});
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entry.addRowClickListener((RowClickEventListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object listObj = param.get("list");
        ArrayList<Map<String, Object>> valueData = new ArrayList(16);
        if (listObj instanceof List) {
            valueData = (List)listObj;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        this.bindValueData(view, model, valueData);
    }

    private void bindValueData(IFormView view, IDataModel model, List<Map<String, Object>> valueData) {
        if (valueData == null) {
            return;
        }
        DynamicObjectCollection entryEntityDOC = model.getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < valueData.size(); ++i) {
            Map<String, Object> valueMap = valueData.get(i);
            if (valueMap == null) continue;
            int newEntryRow = model.createNewEntryRow(ENTRY_ENTITY);
            Object pkValue = valueMap.get("id");
            String number = valueMap.get("number") == null ? "" : String.valueOf(valueMap.get("number"));
            String name = valueMap.get("name") == null ? "" : String.valueOf(valueMap.get("name"));
            String groupNumber = valueMap.get("group.number") == null ? "" : String.valueOf(valueMap.get("group.number"));
            String status = valueMap.get("status") == null ? "" : String.valueOf(valueMap.get("status"));
            String enable = valueMap.get("enable") == null ? "" : String.valueOf(valueMap.get("enable"));
            String featuretype = valueMap.get("featuretype") == null ? "" : String.valueOf(valueMap.get("featuretype"));
            model.setValue("pkvalue", pkValue, newEntryRow);
            model.setValue("number", (Object)number, newEntryRow);
            model.setValue("name", (Object)name, newEntryRow);
            model.setValue("group", (Object)groupNumber, newEntryRow);
            model.setValue("status", (Object)status, newEntryRow);
            model.setValue("enable", (Object)enable, newEntryRow);
            model.setValue("featuretype", (Object)featuretype, newEntryRow);
        }
        view.updateView(ENTRY_ENTITY);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("btn_ok".equals(fieldKey)) {
            this.clickOk(view, model);
        }
    }

    private void clickOk(IFormView view, IDataModel model) {
        if (view == null || model == null) {
            return;
        }
        EntryGrid entryEntity = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntity.getSelectRows();
        HashMap<String, Object> param = new HashMap<String, Object>();
        ArrayList numbers = new ArrayList(8);
        for (int i = 0; i < selectRows.length; ++i) {
            int selectRow = selectRows[i];
            HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
            Object pkvalue = model.getValue("pkvalue", selectRow);
            Object number = model.getValue("number", selectRow);
            paramMap.put("pkvalue", pkvalue);
            paramMap.put("number", number);
            numbers.add(paramMap);
        }
        param.put("datas", numbers.isEmpty() ? "" : numbers);
        this.getView().returnDataToParent(param);
        this.getView().close();
    }

    public void search(SearchEnterEvent event) {
        String searchText = event.getText();
        this.innerSearch(searchText);
    }

    private void innerSearch(String searchText) {
        this.getView().updateView(ENTRY_ENTITY);
        if (!StringUtils.isEmpty((CharSequence)searchText)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
            ArrayList<Integer> rows = new ArrayList<Integer>();
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject o = (DynamicObject)collection.get(i);
                if (!o.getString("number").contains(searchText) && !o.getString("name").contains(searchText)) continue;
                rows.add(i);
            }
            if (rows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"CharaRuleSelectEditPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            } else {
                int[] rowArrays = rows.stream().mapToInt(Integer::valueOf).toArray();
                entryGrid.setRowBackcolor("#eff3fd", rowArrays);
                entryGrid.focusCell(rowArrays[0], "number");
            }
        }
    }

    public List<String> getSearchList(SearchEnterEvent evt) {
        return null;
    }

    public List<Object> getComPlexSearchList(SearchEnterEvent evt) {
        return null;
    }
}

