/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.eco;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.common.util.ECNUtil;

public class ECNPlugin
extends AbstractFormPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opr = e.getOperateKey();
        OperationResult or = e.getOperationResult();
        if (opr.equalsIgnoreCase("audit")) {
            List pks = or.getSuccessPkIds();
            ORM orm = ORM.create();
            DynamicObject o = orm.newDynamicObject("pdm_eco");
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])pks.toArray(new Object[pks.size()]), (DynamicObjectType)o.getDynamicObjectType());
            StringBuilder errors = new StringBuilder();
            int success = 0;
            for (int i = 0; i < dynamicObjects.length; ++i) {
                DynamicObject data = dynamicObjects[i];
                try {
                    String error = ECNUtil.exeECNOp((DynamicObject)data, (boolean)true, (String)opr);
                    if (!error.isEmpty()) {
                        errors.append(error);
                        continue;
                    }
                    ++success;
                    continue;
                }
                catch (KDBizException exp) {
                    errors.append(exp.getMessage()).append("\r\n");
                }
            }
            if (errors.length() > 0) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f\uff1a%1$s\u6761\uff0c\u5931\u8d25\uff1a%2$s\u6761\u3002", (String)"ECNPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), success, dynamicObjects.length - success), errors.toString(), MessageTypes.Default);
            } else if (success != 0) {
                // empty if block
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            if (formShowParameter instanceof ListShowParameter) {
                this.getView().invokeOperation("refresh");
            } else {
                QFilter qFilter;
                String selectFields;
                DynamicObjectCollection newDatas;
                IDataModel dm = this.getModel();
                DynamicObject data = dm.getDataEntity();
                if (data != null && (newDatas = QueryServiceHelper.query((String)"pdm_eco", (String)(selectFields = "id,pentry.id entryid, pentry.pentryexecstatus pentryexecstatus, pentry.pentryexecdate pentryexecdate"), (QFilter[])new QFilter[]{qFilter = new QFilter("id", "=", data.getPkValue())})) != null && !newDatas.isEmpty()) {
                    DynamicObjectCollection pentrys = dm.getEntryEntity("pentry");
                    block3: for (int i = 0; i < pentrys.size(); ++i) {
                        DynamicObject pentry = (DynamicObject)pentrys.get(i);
                        String entryID = String.valueOf(pentry.getPkValue());
                        for (DynamicObject newData : newDatas) {
                            if (!entryID.equalsIgnoreCase(newData.getString("entryid"))) continue;
                            dm.setValue("pentryexecstatus", newData.get("pentryexecstatus"), i);
                            dm.setValue("pentryexecdate", newData.get("pentryexecdate"), i);
                            continue block3;
                        }
                    }
                }
            }
        }
    }
}

