/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.eco;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.EntryGrid;

public class PdmEcoLogPlugin
extends AbstractBillPlugIn {
    private static final String ENTRYENTITYSHOW = "entryentityshow";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initEntryEntity();
        this.getModel().setDataChanged(false);
    }

    private String[] getShowFields() {
        return new String[]{"updateobjshow", "entrymodeshow", "entrymaterialidshow", "baseunitshow", "tranqtyshow", "transtartdateshow", "acttimeshow", "ecotypeshow", "entrygroupnoshow", "entryrefnoshow", "estimatestatusshow", "groupkeyshow", "refkeyshow", "othersshow", "opparentshow", "operationnoshow", "operationshow"};
    }

    private void initEntryEntity() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.getModel().deleteEntryData(ENTRYENTITYSHOW);
        EntryGrid entryEntity = (EntryGrid)this.getControl(ENTRYENTITYSHOW);
        AbstractFormDataModel model = (AbstractFormDataModel)entryEntity.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(this.getShowFields());
        DynamicObjectCollection entryentitys = this.getModel().getEntryEntity("entryentity");
        Map<Long, List<DynamicObject>> map = entryentitys.stream().collect(Collectors.groupingBy(g -> g.getLong("ecobomentryid")));
        for (Map.Entry<Long, List<DynamicObject>> entry : map.entrySet()) {
            List<Object> values = entry.getValue();
            if ((values = values.stream().sorted(Comparator.comparing(c -> c.getString("changeflag"))).collect(Collectors.toList())).size() < 2) continue;
            DynamicObject dy0 = (DynamicObject)values.get(0);
            String updateobj = dy0.getString("updateobj");
            String entrymode = dy0.getString("entrymode");
            long entrymaterialid = dy0.getLong("entrymaterialid.id");
            long operationid = dy0.getLong("operation.id");
            String opparent = dy0.getString("opparent");
            String operationno = dy0.getString("operationno");
            DynamicObject baseunit = dy0.getDynamicObject("baseunit");
            long baseunitId = 0L;
            String precisionaccount = "";
            int precision = 0;
            if (baseunit != null) {
                baseunitId = baseunit.getLong("id");
                precisionaccount = baseunit.getString("precisionaccount");
                precision = baseunit.getInt("precision");
            }
            RoundingMode roundingMode = RoundingMode.HALF_UP;
            if ("2".equals(precisionaccount)) {
                roundingMode = RoundingMode.DOWN;
            } else if ("3".equals(precisionaccount)) {
                roundingMode = RoundingMode.UP;
            }
            BigDecimal tranqtyshow0 = dy0.getBigDecimal("tranqty");
            Date transtartdateshow0 = dy0.getDate("transtartdate");
            Date acttimeshow0 = dy0.getDate("acttime");
            String ecotypeshow0 = dy0.getString("ecotype.number");
            String estimatestatus0 = dy0.getString("estimatestatus");
            String others0 = dy0.getString("others");
            boolean groupkey0 = dy0.getBoolean("groupkey");
            boolean refkey0 = dy0.getBoolean("refkey");
            String entrygroupno0 = dy0.getString("entrygroupno");
            String entryrefno0 = dy0.getString("entryrefno");
            DynamicObject dy1 = (DynamicObject)values.get(1);
            BigDecimal tranqtyshow1 = dy1.getBigDecimal("tranqty");
            Date transtartdateshow1 = dy1.getDate("transtartdate");
            Date acttimeshow1 = dy1.getDate("acttime");
            String ecotypeshow1 = dy1.getString("ecotype.number");
            String estimatestatus1 = dy1.getString("estimatestatus");
            String others1 = dy1.getString("others");
            boolean groupkey1 = dy1.getBoolean("groupkey");
            boolean refkey1 = dy1.getBoolean("refkey");
            String entrygroupno1 = dy1.getString("entrygroupno");
            String entryrefno1 = dy1.getString("entryrefno");
            String tranqtyshow = "";
            if (tranqtyshow0 != null && tranqtyshow1 != null) {
                if (BigDecimal.ZERO.compareTo(tranqtyshow0) == 0) {
                    tranqtyshow0 = BigDecimal.ZERO;
                }
                if (BigDecimal.ZERO.compareTo(tranqtyshow1) == 0) {
                    tranqtyshow1 = BigDecimal.ZERO;
                }
                tranqtyshow = !tranqtyshow0.equals(tranqtyshow1) ? String.valueOf(tranqtyshow0.setScale(precision, roundingMode)).concat(" -> ").concat(String.valueOf(tranqtyshow1.setScale(precision, roundingMode))) : "";
            }
            String transtartdate = "";
            if (transtartdateshow0 != null && transtartdateshow1 != null) {
                transtartdate = transtartdateshow0.compareTo(transtartdateshow1) != 0 ? sdf.format(transtartdateshow0).concat(" -> ").concat(sdf.format(transtartdateshow1)) : "";
            }
            String acttime = "";
            if (acttimeshow0 != null && acttimeshow1 != null) {
                acttime = acttimeshow0.compareTo(acttimeshow1) != 0 ? sdf.format(acttimeshow0).concat(" -> ").concat(sdf.format(acttimeshow1)) : "";
            }
            String ecotype = "";
            ecotype = !Objects.equals(ecotypeshow0, ecotypeshow1) ? String.valueOf(ecotypeshow0).concat(" -> ").concat(String.valueOf(ecotypeshow1)) : "";
            String estimatestatus = "";
            estimatestatus = !Objects.equals(estimatestatus0, estimatestatus1) ? this.getEnumName(estimatestatus0).concat(" -> ").concat(String.valueOf(this.getEnumName(estimatestatus1))) : "";
            String other = "";
            other = !Objects.equals(others0, others1) ? others0.concat(" -> ").concat(others1) : "";
            String groupkey = "";
            groupkey = !Objects.equals(groupkey0, groupkey1) ? String.valueOf(this.getBooleanName(groupkey0)).concat(" -> ").concat(String.valueOf(this.getBooleanName(groupkey1))) : "";
            String refkey = "";
            refkey = !Objects.equals(refkey0, refkey1) ? String.valueOf(this.getBooleanName(refkey0)).concat(" -> ").concat(String.valueOf(this.getBooleanName(refkey1))) : "";
            String entrygroupno = "";
            entrygroupno = !Objects.equals(entrygroupno0, entrygroupno1) ? String.valueOf(entrygroupno0).concat(" -> ").concat(String.valueOf(entrygroupno1)) : "";
            String entryrefno = "";
            entryrefno = !Objects.equals(entryrefno0, entryrefno1) ? String.valueOf(entryrefno0).concat(" -> ").concat(String.valueOf(entryrefno1)) : "";
            vs.addRow(new Object[]{updateobj, entrymode, entrymaterialid, baseunitId, tranqtyshow, transtartdate, acttime, ecotype, entrygroupno, entryrefno, estimatestatus, groupkey, refkey, other, opparent, operationno, operationid});
        }
        model.batchCreateNewEntryRow(ENTRYENTITYSHOW, vs);
        model.endInit();
        this.getView().updateView(ENTRYENTITYSHOW);
    }

    private String getBooleanName(boolean obj) {
        if (obj) {
            return ResManager.loadKDString((String)"\u662f", (String)"PdmEcoLogPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5426", (String)"PdmEcoLogPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private String getEnumName(String value) {
        if ("B".equals(value)) {
            return ResManager.loadKDString((String)"\u8bc4\u4f30\u4e2d", (String)"PdmEcoLogPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        }
        if ("C".equals(value)) {
            return ResManager.loadKDString((String)"\u8bc4\u4f30\u5b8c\u6210", (String)"PdmEcoLogPlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u672a\u8bc4\u4f30", (String)"PdmEcoLogPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }
}

