/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.ecoplatform;

import com.alibaba.fastjson.JSONArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class EcoEffectRangeDataExportProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public static final String EXPROGRESSBAR = "exprogressbar";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ProgressBar exportBar = (ProgressBar)this.getControl(EXPROGRESSBAR);
        this.getPageCache().put("percent", "0");
        exportBar.setPercent(0, ResManager.loadKDString((String)"\u5bfc\u51fa\u4e2d\uff0c\u8bf7\u52ff\u5173\u95ed\u754c\u9762\u3002", (String)"EcoEffectRangeDataExportProgressPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        exportBar.start();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar exportBar = (ProgressBar)this.getControl(EXPROGRESSBAR);
        exportBar.addProgressListener((ProgresssListener)this);
    }

    public void onProgress(ProgressEvent progressEvent) {
        int percent = Integer.parseInt(this.getPageCache().get("percent"));
        if (percent == 0) {
            progressEvent.setProgress(10);
            this.exportData(progressEvent);
        } else if (percent > 0 && percent < 100) {
            progressEvent.setProgress(percent);
        } else {
            this.getPageCache().put("percent", "100");
            progressEvent.setText(ResManager.loadKDString((String)"\u5bfc\u51fa\u5b8c\u6210", (String)"EcoEffectRangeDataExportProgressPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            progressEvent.setProgress(100);
            this.getView().invokeOperation("close", OperateOption.create());
        }
    }

    public Map<String, String> initColumnData() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(32);
        map.put("billno", ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7", (String)"EcoEffectRangeDataExportProgressPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("planprogram.name", ResManager.loadKDString((String)"\u8bc4\u4f30\u65b9\u6848\u540d\u79f0", (String)"EcoEffectRangeDataExportProgressPlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("material.number", ResManager.loadKDString((String)"\u9700\u6c42\u7269\u6599\u7f16\u7801", (String)"EcoEffectRangeDataExportProgressPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("material.name", ResManager.loadKDString((String)"\u9700\u6c42\u7269\u6599\u540d\u79f0", (String)"EcoEffectRangeDataExportProgressPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("material.modelnum", ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"EcoEffectRangeDataExportProgressPlugin_6", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("baseunit.name", ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"EcoEffectRangeDataExportProgressPlugin_7", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("materialattr", ResManager.loadKDString((String)"\u7269\u6599\u5c5e\u6027", (String)"EcoEffectRangeDataExportProgressPlugin_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("supplyorg.name", ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7", (String)"EcoEffectRangeDataExportProgressPlugin_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("supplyqty", ResManager.loadKDString((String)"\u9700\u6c42\u6570\u91cf", (String)"EcoEffectRangeDataExportProgressPlugin_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("supplydate", ResManager.loadKDString((String)"\u9700\u6c42\u65f6\u95f4", (String)"EcoEffectRangeDataExportProgressPlugin_11", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("supplybillno", ResManager.loadKDString((String)"\u9700\u6c42\u5355\u636e\u53f7", (String)"EcoEffectRangeDataExportProgressPlugin_12", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("entrymode", ResManager.loadKDString((String)"\u884c\u6807\u8bc6", (String)"EcoEffectRangeDataExportProgressPlugin_13", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("ecotype.name", ResManager.loadKDString((String)"\u53d8\u66f4\u7c7b\u578b", (String)"EcoEffectRangeDataExportProgressPlugin_14", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("entryentity.sortseq", ResManager.loadKDString((String)"\u5206\u5f55\u5e8f\u53f7", (String)"EcoEffectRangeDataExportProgressPlugin_15", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("entryentity.requirebillno", ResManager.loadKDString((String)"\u4f9b\u5e94\u5355\u636e\u53f7", (String)"EcoEffectRangeDataExportProgressPlugin_16", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("entryentity.requirematerial.number", ResManager.loadKDString((String)"\u4f9b\u5e94\u7269\u6599\u7f16\u7801", (String)"EcoEffectRangeDataExportProgressPlugin_17", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("entryentity.requirematerial.name", ResManager.loadKDString((String)"\u4f9b\u5e94\u7269\u6599\u540d\u79f0", (String)"EcoEffectRangeDataExportProgressPlugin_18", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("entryentity.requirebillentryseq", ResManager.loadKDString((String)"\u4f9b\u5e94\u5355\u636e\u5206\u5f55\u5e8f\u53f7\u3002", (String)"EcoEffectRangeDataExportProgressPlugin_19", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("entryentity.requireqty", ResManager.loadKDString((String)"\u4f9b\u5e94\u6570\u91cf", (String)"EcoEffectRangeDataExportProgressPlugin_20", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("entryentity.requiredate", ResManager.loadKDString((String)"\u4f9b\u5e94\u65f6\u95f4", (String)"EcoEffectRangeDataExportProgressPlugin_21", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("entryentity.requirebilltype.name", ResManager.loadKDString((String)"\u4f9b\u5e94\u5355\u636e\u7c7b\u578b", (String)"EcoEffectRangeDataExportProgressPlugin_22", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("entryentity.warehouse.name", ResManager.loadKDString((String)"\u4ed3\u5e93", (String)"EcoEffectRangeDataExportProgressPlugin_23", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("entryentity.location.number", ResManager.loadKDString((String)"\u4ed3\u4f4d", (String)"EcoEffectRangeDataExportProgressPlugin_24", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("entryentity.invstatus.name", ResManager.loadKDString((String)"\u5e93\u5b58\u72b6\u6001", (String)"EcoEffectRangeDataExportProgressPlugin_25", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("entryentity.invtype.name", ResManager.loadKDString((String)"\u5e93\u5b58\u7c7b\u578b", (String)"EcoEffectRangeDataExportProgressPlugin_26", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("entryentity.project.name", ResManager.loadKDString((String)"\u9879\u76ee\t", (String)"EcoEffectRangeDataExportProgressPlugin_27", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("entryentity.tracknumber.number", ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7", (String)"EcoEffectRangeDataExportProgressPlugin_28", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        map.put("entryentity.requirebillstatus", ResManager.loadKDString((String)"\u4f9b\u5e94\u5355\u636e\u72b6\u6001", (String)"EcoEffectRangeDataExportProgressPlugin_29", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        return map;
    }

    private String getSelectProperties(Map<String, String> columnMap) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> columns : columnMap.entrySet()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(columns.getKey());
            ++i;
        }
        return sb.toString();
    }

    private DynamicObjectCollection getAllData(Set<Long> allPkids, Map<String, String> columnMap) {
        String selectFields = this.getSelectProperties(columnMap);
        QFilter filter = new QFilter("id", "in", allPkids);
        return QueryServiceHelper.query((String)"pdm_ecoestimate_result", (String)selectFields, (QFilter[])new QFilter[]{filter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportData(ProgressEvent progressEvent) {
        this.getPageCache().put("percent", "5");
        progressEvent.setProgress(5);
        Set allPkids = PlatformUtils.jsonArrayToSet((JSONArray)((JSONArray)this.getView().getFormShowParameter().getCustomParam("pkids")));
        Map<String, String> columnMap = this.initColumnData();
        DynamicObjectCollection datas = this.getAllData(allPkids, columnMap);
        this.getPageCache().put("percent", "15");
        progressEvent.setProgress(15);
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        try {
            SXSSFSheet sheet = workbook.createSheet();
            SXSSFRow firstrow = sheet.createRow(0);
            int columnSeq = 0;
            SXSSFCell cell0 = firstrow.createCell(columnSeq++);
            cell0.setCellValue(ResManager.loadKDString((String)"\u884c\u53f7", (String)"EcoEffectRangeDataExportProgressPlugin_30", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            for (Map.Entry<String, String> fields : columnMap.entrySet()) {
                String columnName = fields.getValue();
                SXSSFCell cell = firstrow.createCell(columnSeq++);
                cell.setCellValue(columnName);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (datas != null && !datas.isEmpty()) {
                int i = 1;
                for (DynamicObject data : datas) {
                    SXSSFRow row = sheet.createRow(i++);
                    int currentIndex = 0;
                    row.createCell(currentIndex++).setCellValue((double)(i - 1));
                    for (Map.Entry<String, String> fields : columnMap.entrySet()) {
                        String columnNumber = fields.getKey();
                        Object value = data.get(columnNumber);
                        if (value == null) {
                            row.createCell(currentIndex++).setCellValue("");
                            continue;
                        }
                        if (value instanceof Integer) {
                            row.createCell(currentIndex++).setCellValue((double)((Integer)value).intValue());
                            continue;
                        }
                        if (value instanceof Long) {
                            row.createCell(currentIndex++).setCellValue((double)((Long)value).longValue());
                            continue;
                        }
                        if (value instanceof BigDecimal) {
                            row.createCell(currentIndex++).setCellValue(((BigDecimal)value).stripTrailingZeros().toPlainString());
                            continue;
                        }
                        if (value instanceof Boolean) {
                            row.createCell(currentIndex++).setCellValue(((Boolean)value).booleanValue());
                            continue;
                        }
                        if (value instanceof Date) {
                            row.createCell(currentIndex++).setCellValue(sdf.format((Date)value));
                            continue;
                        }
                        if (value instanceof String) {
                            row.createCell(currentIndex++).setCellValue(PlatformUtils.excelCSVChar((String)this.getStringValue(columnNumber, (String)value)));
                            continue;
                        }
                        row.createCell(currentIndex++).setCellValue(PlatformUtils.excelCSVChar((String)String.valueOf(value)));
                    }
                    int progress = 20 + i;
                    if (progress >= 100) {
                        progress = 99;
                    }
                    this.getPageCache().put("percent", String.valueOf(progress));
                    progressEvent.setProgress(progress);
                }
            }
            ByteArrayOutputStream outStream = null;
            ByteArrayInputStream inStream = null;
            try {
                outStream = new ByteArrayOutputStream();
                workbook.write((OutputStream)outStream);
                inStream = new ByteArrayInputStream(outStream.toByteArray());
                TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                int timeout = 7200;
                String tempUrl = cache.saveAsUrl(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8303\u56f4\u7ed3\u679c\u5bfc\u51fa.xlsx", (String)"EcoEffectRangeDataExportProgressPlugin_31", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), (InputStream)inStream, timeout);
                this.addFilePermission(tempUrl, this.getView().getFormShowParameter().getServiceAppId(), "pdm_ecoplatform_order", "4730fc9f000004ae");
                this.getView().openUrl(tempUrl);
                outStream.close();
                inStream.close();
                this.getPageCache().put("percent", "100");
            }
            catch (IOException e) {
                this.getPageCache().put("percent", "100");
                throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"EcoEffectRangeDataExportProgressPlugin_32", (String)"mmc-pdm-formplugin", (Object[])new Object[0])), new Object[]{e});
            }
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                this.getPageCache().put("percent", "100");
                this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"EcoEffectRangeDataExportProgressPlugin_32", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), e.getMessage(), MessageTypes.Default);
            }
        }
    }

    public void addFilePermission(String url, String appid, String entity, String permissionid) {
        String tempFileId = UrlUtil.getParam((String)url, (String)"id");
        HashMap<String, String> refEntitiyMap = new HashMap<String, String>(2);
        refEntitiyMap.put("entityNum", entity);
        refEntitiyMap.put("appId", appid);
        refEntitiyMap.put("permissionItemId", permissionid);
        DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", true);
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
    }

    public String getStringValue(String fieldNumber, String value) {
        if ("materialattr".equalsIgnoreCase(fieldNumber) || "entryentity.requirebillstatus".equalsIgnoreCase(fieldNumber) || "entrymode".equalsIgnoreCase(fieldNumber)) {
            return this.getCombValueName(fieldNumber, value);
        }
        return value;
    }

    public String getCombValueName(String fieldNumber, String value) {
        if ("materialattr".equalsIgnoreCase(fieldNumber)) {
            String attr = "";
            switch (value) {
                case "10030": {
                    attr = ResManager.loadKDString((String)"\u81ea\u5236\u4ef6", (String)"EcoEffectRangeDataExportProgressPlugin_33", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "10040": {
                    attr = ResManager.loadKDString((String)"\u5916\u8d2d\u4ef6", (String)"EcoEffectRangeDataExportProgressPlugin_34", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "10050": {
                    attr = ResManager.loadKDString((String)"\u59d4\u5916\u4ef6", (String)"EcoEffectRangeDataExportProgressPlugin_35", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "10020": {
                    attr = ResManager.loadKDString((String)"\u865a\u62df\u4ef6", (String)"EcoEffectRangeDataExportProgressPlugin_36", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "10060": {
                    attr = ResManager.loadKDString((String)"\u5185\u534f\u4ef6", (String)"EcoEffectRangeDataExportProgressPlugin_37", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                default: {
                    attr = value;
                }
            }
            return attr;
        }
        if ("entryentity.requirebillstatus".equalsIgnoreCase(fieldNumber)) {
            String status = "";
            switch (value) {
                case "A": {
                    status = ResManager.loadKDString((String)"\u6682\u5b58", (String)"EcoEffectRangeDataExportProgressPlugin_38", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "B": {
                    status = ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"EcoEffectRangeDataExportProgressPlugin_39", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "C": {
                    status = ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"EcoEffectRangeDataExportProgressPlugin_40", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "D": {
                    status = ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"EcoEffectRangeDataExportProgressPlugin_41", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                default: {
                    status = value;
                }
            }
            return status;
        }
        if ("entrymode".equalsIgnoreCase(fieldNumber)) {
            String entrymodename = "";
            switch (value) {
                case "A": {
                    entrymodename = ResManager.loadKDString((String)"\u65b0\u589e", (String)"EcoEffectRangeDataExportProgressPlugin_42", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "B": {
                    entrymodename = ResManager.loadKDString((String)"\u53d8\u66f4\u524d", (String)"EcoEffectRangeDataExportProgressPlugin_43", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "C": {
                    entrymodename = ResManager.loadKDString((String)"\u53d8\u66f4\u540e", (String)"EcoEffectRangeDataExportProgressPlugin_44", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "E": {
                    entrymodename = ResManager.loadKDString((String)"\u5931\u6548", (String)"EcoEffectRangeDataExportProgressPlugin_45", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                default: {
                    entrymodename = value;
                }
            }
            return entrymodename;
        }
        return "";
    }
}

