/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.ecoplatform;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.QtyEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.formplugin.ecoplatform.IEcoPlatFormQueryExt;
import kd.mmc.pdm.formplugin.ecoplatform.PlatFormQueryDataHelper;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class EcoPlatFormExportAllProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public static final String EXPROGRESSBAR = "exprogressbar";
    private static final ThreadLocal<Map<String, DynamicObject>> baseDataThreadLocal = new ThreadLocal();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ProgressBar exportBar = (ProgressBar)this.getControl(EXPROGRESSBAR);
        this.getPageCache().put("percent", "0");
        exportBar.setPercent(0, ResManager.loadKDString((String)"\u5bfc\u51fa\u4e2d\uff0c\u8bf7\u52ff\u5173\u95ed\u754c\u9762\u3002", (String)"EcoPlatFormExportAllProgressPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        exportBar.start();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar exportBar = (ProgressBar)this.getControl(EXPROGRESSBAR);
        exportBar.addProgressListener((ProgresssListener)this);
    }

    public void onProgress(ProgressEvent progressEvent) {
        int percent = Integer.parseInt(this.getPageCache().get("percent"));
        if (percent == 0) {
            progressEvent.setProgress(10);
            this.exportData(progressEvent);
        } else if (percent > 0 && percent < 100) {
            progressEvent.setProgress(percent);
        } else {
            this.getPageCache().put("percent", "100");
            progressEvent.setText(ResManager.loadKDString((String)"\u5bfc\u51fa\u5b8c\u6210", (String)"EcoPlatFormExportAllProgressPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            progressEvent.setProgress(100);
            this.getView().invokeOperation("close", OperateOption.create());
        }
    }

    private String getFieldName(Map<String, String> fieldNameMap, String fieldNumber) {
        String fieldName = fieldNameMap.get(fieldNumber);
        return StringUtils.isEmpty((String)fieldName) ? fieldNumber : fieldName;
    }

    private String getDataSetFieldNumber(String fieldNumber, Object oldExtPlugin, PluginProxy<IEcoPlatFormQueryExt> newExtPlugin) {
        return PlatFormQueryDataHelper.getDataSetFieldNumberByGrid(fieldNumber, oldExtPlugin, newExtPlugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportData(ProgressEvent progressEvent) {
        this.getPageCache().put("percent", "5");
        progressEvent.setProgress(5);
        String cacheId = (String)this.getView().getFormShowParameter().getCustomParam("cacheId");
        EntryGrid grid = (EntryGrid)this.getView().getParentView().getControl("entryentitys");
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
        int count = cacheDataSet.getRowCount();
        List pageRows = cacheDataSet.getList(0, count);
        HashMap<String, String> fieldNameMap = new HashMap<String, String>(16);
        HashMap<String, Control> fieldPropMap = new HashMap<String, Control>(16);
        List<String> fieldList = this.initColumnData(cacheId, grid, fieldNameMap, fieldPropMap);
        this.getPageCache().put("percent", "15");
        progressEvent.setProgress(15);
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        try {
            SXSSFSheet sheet = workbook.createSheet();
            SXSSFRow firstrow = sheet.createRow(0);
            int columnSeq = 0;
            SXSSFCell cell0 = firstrow.createCell(columnSeq++);
            cell0.setCellValue(ResManager.loadKDString((String)"\u884c\u53f7", (String)"EcoPlatFormExportAllProgressPlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            for (int colSize = 0; colSize < fieldList.size(); ++colSize) {
                String fieldNumber = fieldList.get(colSize);
                String columnName = this.getFieldName(fieldNameMap, fieldNumber);
                SXSSFCell cell = firstrow.createCell(columnSeq++);
                cell.setCellValue(columnName);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (!PlatformUtils.isNullList((List)pageRows)) {
                int i = 1;
                Object oldExtPlugin = PlatFormQueryDataHelper.getExtPlugin();
                PluginProxy<IEcoPlatFormQueryExt> newExtPlugin = PlatFormQueryDataHelper.genExtPluginxy();
                Set<String> dataSetFieldSet = PlatFormQueryDataHelper.getCacheDataSetAllFields(cacheDataSet);
                for (Row dyn : pageRows) {
                    SXSSFRow row = sheet.createRow(i++);
                    int currentIndex = 0;
                    row.createCell(currentIndex++).setCellValue((double)(i - 1));
                    for (int colSize = 0; colSize < fieldList.size(); ++colSize) {
                        String fieldNumber = fieldList.get(colSize);
                        String dsFieldNumber = this.getDataSetFieldNumber(fieldNumber, oldExtPlugin, newExtPlugin);
                        Object value = this.getValue(dsFieldNumber, dyn, (Control)fieldPropMap.get(fieldNumber), dataSetFieldSet, oldExtPlugin, newExtPlugin);
                        if (value == null) {
                            row.createCell(currentIndex++).setCellValue("");
                            continue;
                        }
                        if (value instanceof Integer) {
                            row.createCell(currentIndex++).setCellValue((double)((Integer)value).intValue());
                            continue;
                        }
                        if (value instanceof Long) {
                            row.createCell(currentIndex++).setCellValue((double)((Long)value).longValue());
                            continue;
                        }
                        if (value instanceof BigDecimal) {
                            row.createCell(currentIndex++).setCellValue(((BigDecimal)value).stripTrailingZeros().toPlainString());
                            continue;
                        }
                        if (value instanceof Boolean) {
                            row.createCell(currentIndex++).setCellValue(this.getBooleanValue((Boolean)value));
                            continue;
                        }
                        if (value instanceof Date) {
                            row.createCell(currentIndex++).setCellValue(sdf.format((Date)value));
                            continue;
                        }
                        if (value instanceof String) {
                            row.createCell(currentIndex++).setCellValue(PlatformUtils.excelCSVChar((String)((String)value)));
                            continue;
                        }
                        row.createCell(currentIndex++).setCellValue(PlatformUtils.excelCSVChar((String)String.valueOf(value)));
                    }
                    int progress = 20 + i;
                    if (progress >= 100) {
                        progress = 99;
                    }
                    this.getPageCache().put("percent", String.valueOf(progress));
                    progressEvent.setProgress(progress);
                }
            }
            ByteArrayOutputStream outStream = null;
            ByteArrayInputStream inStream = null;
            try {
                outStream = new ByteArrayOutputStream();
                workbook.write((OutputStream)outStream);
                inStream = new ByteArrayInputStream(outStream.toByteArray());
                TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                int timeout = 7200;
                String tempUrl = cache.saveAsUrl(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_\u5de5\u7a0b\u53d8\u66f4\u63a7\u5236\u5e73\u53f0.xlsx", (String)"EcoPlatFormExportAllProgressPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), (InputStream)inStream, timeout);
                this.addFilePermission(tempUrl, this.getView().getFormShowParameter().getServiceAppId(), "pdm_eco_changeplatform", "4730fc9f000004ae");
                this.getView().openUrl(tempUrl);
                outStream.close();
                inStream.close();
                this.getPageCache().put("percent", "100");
            }
            catch (IOException e) {
                this.getPageCache().put("percent", "100");
                throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"EcoPlatFormExportAllProgressPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0])), new Object[]{e});
            }
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                this.getPageCache().put("percent", "100");
                this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"EcoPlatFormExportAllProgressPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), e.getMessage(), MessageTypes.Default);
            }
        }
    }

    public void addFilePermission(String url, String appid, String entity, String permissionid) {
        String tempFileId = UrlUtil.getParam((String)url, (String)"id");
        HashMap<String, String> refEntitiyMap = new HashMap<String, String>(2);
        refEntitiyMap.put("entityNum", entity);
        refEntitiyMap.put("appId", appid);
        refEntitiyMap.put("permissionItemId", permissionid);
        DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", true);
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
    }

    public List<String> initColumnData(String cacheId, EntryGrid grid, Map<String, String> fieldNameMap, Map<String, Control> fieldPropMap) {
        ArrayList<String> sortList = new ArrayList<String>(64);
        List gridItems = grid.getControls();
        for (int i = 0; i < gridItems.size(); ++i) {
            Control gridItem = (Control)gridItems.get(i);
            String fieldNumber = gridItem.getKey();
            String fieldName = "";
            if (gridItem instanceof DecimalEdit) {
                fieldName = ((DecimalEdit)gridItem).getDisplayName().getLocaleValue();
            } else if (gridItem instanceof ComboEdit) {
                fieldName = ((ComboEdit)gridItem).getDisplayName().getLocaleValue();
            } else if (gridItem instanceof OrgEdit) {
                fieldName = ((OrgEdit)gridItem).getDisplayName().getLocaleValue();
            } else if (gridItem instanceof BasedataEdit) {
                fieldName = ((BasedataEdit)gridItem).getDisplayName().getLocaleValue();
            } else if (gridItem instanceof BasedataPropEdit) {
                fieldName = ((BasedataPropEdit)gridItem).getDisplayName().getLocaleValue();
            } else if (gridItem instanceof DateTimeEdit) {
                fieldName = ((DateTimeEdit)gridItem).getDisplayName().getLocaleValue();
            } else if (gridItem instanceof FieldEdit) {
                fieldName = ((FieldEdit)gridItem).getDisplayName().getLocaleValue();
            } else if (gridItem instanceof TextEdit) {
                fieldName = ((TextEdit)gridItem).getDisplayName().getLocaleValue();
            } else if (gridItem instanceof DateEdit) {
                fieldName = ((DateEdit)gridItem).getDisplayName().getLocaleValue();
            } else if (gridItem instanceof FlexEdit) {
                fieldName = ((FlexEdit)gridItem).getDisplayName().getLocaleValue();
            } else {
                if (!(gridItem instanceof QtyEdit)) continue;
                fieldName = ((QtyEdit)gridItem).getDisplayName().getLocaleValue();
            }
            if (gridItem.getVisibleIntegerVal() <= 0) continue;
            fieldNameMap.put(fieldNumber, fieldName);
            sortList.add(fieldNumber);
            fieldPropMap.put(fieldNumber, gridItem);
        }
        return sortList;
    }

    private Object getValueByCombo(Object value, ComboProp prop) {
        if (prop == null || value == null) {
            return value;
        }
        List listValue = prop.getComboItems();
        for (ValueMapItem vi : listValue) {
            if (!Objects.equals(value, vi.getValue())) continue;
            return vi.getName();
        }
        return value;
    }

    private DynamicObject getBaseData(Object value, String baseEntityNumber, String displayNameField) {
        if (StringUtils.isEmpty((String)baseEntityNumber)) {
            return null;
        }
        String selectProperties = "id,number,name";
        if (!StringUtils.isEmpty((String)displayNameField) && !selectProperties.contains(displayNameField)) {
            selectProperties = selectProperties + "," + displayNameField;
        }
        if (value != null && !"0".equals(value.toString())) {
            String keyString = baseEntityNumber + "_" + value;
            Map<String, DynamicObject> threadCacheMap = baseDataThreadLocal.get();
            if (threadCacheMap == null) {
                threadCacheMap = new HashMap<String, DynamicObject>(16);
                baseDataThreadLocal.set(threadCacheMap);
            }
            if (threadCacheMap.containsKey(keyString)) {
                return threadCacheMap.get(keyString);
            }
            DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)baseEntityNumber, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "=", value)});
            threadCacheMap.put(keyString, dy);
            return dy;
        }
        return null;
    }

    private Object getValueByBaseData(Object value, String baseEntityNumber, String displayNameField) {
        DynamicObject dy = this.getBaseData(value, baseEntityNumber, displayNameField);
        if (dy != null) {
            return dy.get(displayNameField);
        }
        return value == null || "0".equals(value.toString()) ? "" : value;
    }

    private Object getValueByDateTime(Object value, DateTimeEdit gridItem) {
        if (value == null) {
            return value;
        }
        String format = gridItem.getFormatString();
        if (StringUtils.isEmpty((String)format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(value);
    }

    private String getBooleanValue(Boolean value) {
        if (value.booleanValue()) {
            return ResManager.loadKDString((String)"\u662f", (String)"EcoPlatFormExportAllProgressPlugin_6", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5426", (String)"EcoPlatFormExportAllProgressPlugin_7", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private Object getDataSetValue(String dataSetFieldNumber, Row dyn, Set<String> dataSetFieldSet) {
        boolean hasDsKey = dataSetFieldSet.contains(dataSetFieldNumber);
        return hasDsKey ? dyn.get(dataSetFieldNumber) : null;
    }

    private Object getValue(String dataSetFieldNumber, Row dyn, Control gridItem, Set<String> dataSetFieldSet, Object oldExtPlugin, PluginProxy<IEcoPlatFormQueryExt> newExtPlugin) {
        if (gridItem == null) {
            return null;
        }
        Object value = this.getDataSetValue(dataSetFieldNumber, dyn, dataSetFieldSet);
        if (gridItem instanceof DecimalEdit) {
            return value;
        }
        if (gridItem instanceof ComboEdit) {
            ComboProp prop = (ComboProp)((ComboEdit)gridItem).getProperty();
            return this.getValueByCombo(value, prop);
        }
        if (gridItem instanceof OrgEdit) {
            String baseEntityNumber = "bos_org";
            String displayNameField = ((OrgEdit)gridItem).getDisplayProp();
            return this.getValueByBaseData(value, baseEntityNumber, displayNameField);
        }
        if (gridItem instanceof BasedataEdit) {
            BasedataProp prop = (BasedataProp)((BasedataEdit)gridItem).getProperty();
            String baseEntityNumber = prop.getBaseEntityId();
            String displayNameField = ((BasedataEdit)gridItem).getDisplayProp();
            return this.getValueByBaseData(value, baseEntityNumber, displayNameField);
        }
        if (gridItem instanceof BasedataPropEdit) {
            String displayNameField = ((BasedataPropEdit)gridItem).getRefDisplayProp();
            String refBaseDataProp = ((BasedataPropEdit)gridItem).getRefBasedataProp();
            String refDataSetField = this.getDataSetFieldNumber(refBaseDataProp, oldExtPlugin, newExtPlugin);
            Object refValue = this.getDataSetValue(refDataSetField, dyn, dataSetFieldSet);
            String baseEntityNumber = ((BasedataProp)((BasedataPropEdit)gridItem).getProperty()).getBaseEntityId();
            return this.getValueByBaseData(refValue, baseEntityNumber, displayNameField);
        }
        if (gridItem instanceof DateTimeEdit) {
            return this.getValueByDateTime(value, (DateTimeEdit)gridItem);
        }
        return value;
    }
}

