/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.ecoplatform;

import java.util.HashMap;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.StringUtils;

public class EcoPlatFormExportPlugin
extends AbstractReportFormPlugin {
    private static final Log log = LogFactory.getLog(EcoPlatFormExportPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("exportall".equalsIgnoreCase(operateKey)) {
            String cacheId = this.getView().getPageCache().get("dataset_cache");
            if (StringUtils.isEmpty((String)cacheId)) {
                String msgString = ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u67e5\u8be2\u540e\u518d\u6267\u884c\u5168\u90e8\u5bfc\u51fa\u64cd\u4f5c\u3002", (String)"EcoPlatFormExportPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msgString);
                e.setCancel(true);
                return;
            }
            int count = 0;
            try {
                CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
                count = cacheDataSet.getRowCount();
            }
            catch (Exception e1) {
                String msgString = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u6216\u5237\u65b0\u540e\u518d\u8bd5\u3002", (String)"EcoPlatFormExportPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msgString);
                e.setCancel(true);
                return;
            }
            if (count <= 0) {
                String msgString = ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"EcoPlatFormExportPlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msgString);
                e.setCancel(true);
                return;
            }
            String msgInfo = String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u5bfc\u51fa\u201c%s\u201d\u6761\u6570\u636e\uff1f", (String)"EcoPlatFormExportPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), count);
            this.getView().showConfirm(msgInfo, MessageBoxOptions.YesNo, new ConfirmCallBackListener("exportall"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        if ("exportall".equalsIgnoreCase(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.export();
        }
    }

    private void export() {
        String cacheId = this.getView().getPageCache().get("dataset_cache");
        HashMap<String, String> para = new HashMap<String, String>(16);
        para.put("formId", "pdm_effectrange_export");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        Plugin plugin = new Plugin();
        plugin.setClassName("kd.mmc.pdm.formplugin.ecoplatform.EcoPlatFormExportAllProgressPlugin");
        plugin.setEnabled(true);
        showParameter.setCustomParam("cacheId", (Object)cacheId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u8fdb\u5ea6", (String)"EcoPlatFormExportPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        showParameter.getFormConfig().getPlugins().add(plugin);
        this.getView().showForm(showParameter);
    }
}

