/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.ecoplatform;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.query.helper.OrgQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.MessageTypes;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.ActTimeBean;
import kd.mmc.pdm.business.ecoplatform.ActTimeCopBean;
import kd.mmc.pdm.business.ecoplatform.ActTimeRouteBean;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.formplugin.ecoplatform.EcoBomPlatFormQueryPlugin;
import kd.mmc.pdm.formplugin.ecoplatform.PlatFormQueryDataHelper;

public class EcoPlatFormQueryBasePlugin
extends AbstractReportFormPlugin {
    private static final Log log = LogFactory.getLog(EcoPlatFormQueryBasePlugin.class);
    public static final String EDIT = "modify";
    public static final int MAX_UPDATE_ROW = 100;
    public static final String ECOTYPE_CHANGE_CHAR = "ecotypechange";
    public static final String AUTOADJUSTACTTIME = "autoAdjustActTime";
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    protected static final String UPDATESQLA = " update t_fmm_ecobomentry set fgroupkey = '0' where fentryid = ?  ";
    protected static final String UPDATESQLB = " update t_fmm_ecobomentry set frefkey = '0' where fentryid = ? ";
    protected static final String[] fieldArray = new String[]{"billstatus", "auditdate", "ecotype"};
    protected static final List<String> values = Arrays.asList("B", "E");
    public static final String NULLVALUE = "NULL";

    public boolean verifyOrgisNull() {
        DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org_filter");
        return org == null || org.isEmpty();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (this.verifyOrgisNull()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u53d8\u66f4\u7ec4\u7ec7\u3002", (String)"EcoPlatFormQueryBasePlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        String changeTypes = (String)this.getModel().getValue("changetype_filter");
        if (StringUtils.isEmpty((String)changeTypes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u53d8\u66f4\u5bf9\u8c61\u3002", (String)"EcoPlatFormQueryBasePlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public Long getFirstId(DynamicObjectCollection coll) {
        if (!PlatformUtils.isNullCollection((DynamicObjectCollection)coll)) {
            return ((DynamicObject)coll.get(0)).getLong("fbasedataid.id");
        }
        return 0L;
    }

    public void initOrg() {
        DynamicObjectCollection coll = PlatFormQueryDataHelper.getCurrentDefaultOrg();
        if (coll != null && !coll.isEmpty()) {
            this.getModel().setValue("org_filter", (Object)coll);
        }
    }

    public boolean isSubmitStatus(DynamicObject dy, int rowIndex) {
        if (dy != null) {
            return "B".equalsIgnoreCase(dy.getString("billstatus"));
        }
        String billStatus = this.getStringValue("billstatus", rowIndex);
        return "B".equals(billStatus);
    }

    public boolean isAddStatus(DynamicObject dy, int rowIndex) {
        if (dy != null) {
            return "A".equalsIgnoreCase(dy.getString("billStatus"));
        }
        String billStatus = this.getStringValue("billstatus", rowIndex);
        return "A".equals(billStatus);
    }

    public boolean isAuditStatus(DynamicObject dy, int rowIndex) {
        if (dy != null) {
            return "C".equalsIgnoreCase(dy.getString("billstatus"));
        }
        String billStatus = this.getStringValue("billstatus", rowIndex);
        return "C".equals(billStatus);
    }

    public Set<Long> getIdSet(int[] selectRows, String fieldNumber) {
        HashSet<Long> idSet = new HashSet<Long>(selectRows.length);
        for (int row = 0; row < selectRows.length; ++row) {
            int rowIndex = selectRows[row];
            Long id = this.getLongValue(fieldNumber, rowIndex);
            if (id.equals(0L)) continue;
            idSet.add(id);
        }
        return idSet;
    }

    public Set<Long> getIdSetByProductType(int[] selectRows, String fieldNumber, Set<String> pSet) {
        HashSet<Long> idSet = new HashSet<Long>(selectRows.length);
        for (int row = 0; row < selectRows.length; ++row) {
            Long id;
            int rowIndex = selectRows[row];
            String productType = this.getStringValue("producttype", rowIndex);
            if (StringUtils.isEmpty((String)productType)) {
                productType = NULLVALUE;
            }
            if (!pSet.contains(productType) || (id = this.getLongValue(fieldNumber, rowIndex)).equals(0L)) continue;
            idSet.add(id);
        }
        return idSet;
    }

    public Set<String> genBomCopEntryProductType() {
        HashSet<String> set = new HashSet<String>(16);
        set.add("10720");
        set.add("10730");
        return set;
    }

    public Set<String> genBomEntryProductType() {
        HashSet<String> set = new HashSet<String>(16);
        set.add("10000");
        set.add(NULLVALUE);
        return set;
    }

    public Set<Long> genEcoBomEntryIdSet(int[] selectRows, Set<String> productTypeSet) {
        HashSet<Long> entrys = new HashSet<Long>(selectRows.length);
        Set<Long> entrys1 = this.getIdSetByProductType(selectRows, "ecoentryid", productTypeSet);
        Set<Long> entrys2 = this.getIdSetByProductType(selectRows, "ecoentryafterid", productTypeSet);
        if (!PlatformUtils.isNullSet(entrys1)) {
            entrys.addAll(entrys1);
        }
        if (!PlatformUtils.isNullSet(entrys2)) {
            entrys.addAll(entrys2);
        }
        return entrys;
    }

    public boolean getSubmitAndAudit() {
        DynamicObject billParameter = ParameterReader.getBillParameter((String)"pdm_bom_eco");
        return billParameter.getBoolean("submitandaudit");
    }

    public Long getOrgId(int rowIndex) {
        DynamicObject org = this.getDynamicObjectValue("org", rowIndex);
        return org == null ? 0L : org.getLong("id");
    }

    public Set<Long> getOrgIdSet(int[] selectRows) {
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            orgIdSet.add(this.getOrgId(rowIndex));
        }
        return orgIdSet;
    }

    public String checkHasPermItem(Set<Long> orgIdSet, String permissionId) {
        HasPermOrgResult hasPermOrgResult = this.getPermissionOrgs(permissionId);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            List perOrgIdList = hasPermOrgResult.getHasPermOrgs();
            HashSet<Long> unOrgIdSet = new HashSet<Long>(16);
            for (Long orgId : orgIdSet) {
                if (perOrgIdList.contains(orgId)) continue;
                unOrgIdSet.add(orgId);
            }
            if (!unOrgIdSet.isEmpty()) {
                StringBuilder orgNames = new StringBuilder();
                Map orgMaps = OrgQueryHelper.getDataCacheBySet(unOrgIdSet);
                for (Map.Entry orgs : orgMaps.entrySet()) {
                    orgNames.append(((DynamicObject)orgs.getValue()).getString("name")).append(" ");
                }
                DynamicObject permItem = BusinessDataServiceHelper.loadSingleFromCache((Object)permissionId, (String)"perm_permitem", (String)"name");
                return String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ec4\u7ec7\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\u3002", (String)"EcoPlatFormQueryBasePlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), orgNames, permItem.getString("name"));
            }
        }
        return "";
    }

    public HasPermOrgResult getPermissionOrgs(String permissionId) {
        RequestContext requestContext = RequestContext.get();
        long userID = requestContext.getCurrUserId();
        return PermissionServiceHelper.getAllPermOrgs((long)userID, (String)"04", (String)BizAppServiceHelp.getAppIdByAppNumber((String)"pdm"), (String)"pdm_eco_changeplatform", (String)permissionId);
    }

    public String getPermissionByOpKey(String opKey) {
        String permItemId = "";
        switch (opKey) {
            case "save": {
                permItemId = "3=V9KNWHJ11F";
                break;
            }
            case "submit": {
                permItemId = "3=V9M8Z=HHQR";
                break;
            }
            case "delete": {
                permItemId = "3=V9GNR6=7IS";
                break;
            }
            case "audit": {
                permItemId = "3=V9NJY30D=V";
                break;
            }
            case "updatebom": {
                permItemId = "3=V9Q+0Z+5+0";
                break;
            }
            case "unsubmit": {
                permItemId = "4CVMR4G793WW";
                break;
            }
            case "handestimateend": {
                permItemId = "3=V9TLKP5HE5";
                break;
            }
            case "updateorder": {
                permItemId = "3=V9RY0X7608";
                break;
            }
        }
        return permItemId;
    }

    public boolean verifyPermissionData(String opKey, int[] selectRows) {
        String permItemId = this.getPermissionByOpKey(opKey);
        if (StringUtils.isEmpty((String)permItemId)) {
            return true;
        }
        Set<Long> orgIdSet = this.getOrgIdSet(selectRows);
        String msg = this.checkHasPermItem(orgIdSet, permItemId);
        if (!StringUtils.isEmpty((String)msg)) {
            this.getView().showTipNotification(msg);
            return false;
        }
        return true;
    }

    public Long getMaterialId(int rowIndex) {
        DynamicObject material = this.getDynamicObjectValue("aftermaterial", rowIndex);
        if (material == null) {
            material = this.getDynamicObjectValue("beforematerial", rowIndex);
        }
        return material == null ? 0L : material.getLong("id");
    }

    public Long getFeatureTypeId(int rowIndex) {
        DynamicObject featureType = this.getDynamicObjectValue("afterfeaturetype", rowIndex);
        if (featureType == null) {
            featureType = this.getDynamicObjectValue("beforefeaturetype", rowIndex);
        }
        return featureType == null ? 0L : featureType.getLong("id");
    }

    public void refreshFiledValue(Set<Integer> updateRowSet, String[] fieldArray) {
        for (int i : updateRowSet) {
            for (String field : fieldArray) {
                this.getView().updateView(field, i, 0);
            }
        }
    }

    public Object getValue(String filed, int rowIndex) {
        return this.getModel().getValue(filed, rowIndex);
    }

    public String getStringValue(String filed, int rowIndex) {
        Object obj = this.getValue(filed, rowIndex);
        return obj == null ? "" : (obj instanceof String ? (String)obj : obj.toString());
    }

    public Long getLongValue(String filed, int rowIndex) {
        Object obj = this.getValue(filed, rowIndex);
        return obj == null ? 0L : (obj instanceof Long ? (Long)obj : Long.parseLong(obj.toString()));
    }

    public BigDecimal getBigDecimalValue(String filed, int rowIndex) {
        Object obj = this.getValue(filed, rowIndex);
        return obj == null ? BigDecimal.ZERO : (BigDecimal)obj;
    }

    public DynamicObject getDynamicObjectValue(String filed, int rowIndex) {
        Object obj = this.getValue(filed, rowIndex);
        return obj == null ? null : (DynamicObject)obj;
    }

    public Date getDateValue(String filed, int rowIndex) {
        Object obj = this.getValue(filed, rowIndex);
        return obj == null ? null : (Date)obj;
    }

    public boolean getBooleanValue(String filed, int rowIndex) {
        Object obj = this.getValue(filed, rowIndex);
        return obj == null ? Boolean.FALSE : (Boolean)obj;
    }

    public void setValue(String filed, Object value, int rowIndex) {
        this.getModel().setValue(filed, value, rowIndex);
    }

    public void execSql(String sqls) {
        DB.execute((DBRoute)scmDBRoute, (String)sqls);
    }

    public int returnAndShowMessage(int returnCode, String message) {
        if (!StringUtils.isEmpty((String)message)) {
            if (returnCode == -1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u53d1\u751f\u9519\u8bef", (String)"EcoPlatFormQueryBasePlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), message, MessageTypes.Default);
            } else {
                this.getView().showTipNotification(message);
            }
        }
        return returnCode;
    }

    public DynamicObject getEcoBillEntryDynamicObject(DynamicObject ecoBill, Long entryId) {
        int size = ecoBill.getDynamicObjectCollection("pentry").size();
        for (int i = 0; i < size; ++i) {
            DynamicObject pentry = (DynamicObject)ecoBill.getDynamicObjectCollection("pentry").get(i);
            if (!entryId.equals(pentry.getLong("id"))) continue;
            return pentry;
        }
        return null;
    }

    public String batchRequire(Map<Long, String> map, Set<Long> successIds) {
        StringBuilder lockMsg = new StringBuilder();
        for (Map.Entry<Long, String> entry : map.entrySet()) {
            Long key = entry.getKey();
            String value = entry.getValue();
            boolean mutex = MutexHelper.require((String)"pdm_bom_eco", (Object)key, (String)EDIT, (boolean)true, (StringBuilder)lockMsg);
            if (mutex) {
                successIds.add(key);
                continue;
            }
            for (Long successId : successIds) {
                MutexHelper.release((String)"pdm_bom_eco", (String)EDIT, (String)String.valueOf(successId));
            }
            successIds.clear();
            return String.join((CharSequence)"\uff1a", value, lockMsg.toString());
        }
        return lockMsg.toString();
    }

    public void releaseLock(Set<Long> ids) {
        if (ids.isEmpty()) {
            return;
        }
        for (Long id : ids) {
            MutexHelper.release((String)"pdm_bom_eco", (String)EDIT, (String)String.valueOf(id));
        }
    }

    public String genUpdateExtDbSql(JSONObject jsonObject, String pkFieldNumber, Long pkValue, String tableName) {
        if (jsonObject == null) {
            return null;
        }
        Set extFieldSet = jsonObject.keySet();
        if (PlatformUtils.isNullSet((Set)extFieldSet)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" update ").append(tableName).append(" set ");
        int isize = 0;
        for (String field : extFieldSet) {
            if (StringUtils.isEmpty((String)field)) continue;
            Object value = jsonObject.get((Object)field);
            if (++isize > 1) {
                sb.append(", ");
            }
            sb.append(field).append(" = ").append(value);
        }
        sb.append(" where ").append(pkFieldNumber).append(" = ").append(pkValue);
        String sql = sb.toString();
        log.info("---genUpdateExtDbSql---" + sql);
        return sql;
    }

    public JSONObject parseExtJson(String extchangejson) {
        if (!StringUtils.isEmpty((String)extchangejson)) {
            try {
                return JSON.parseObject((String)extchangejson);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                log.info(extchangejson);
                String errorMessage = String.format(ResManager.loadKDString((String)"\u4e8c\u5f00\u4fee\u6539\u6570\u636e\u8fdb\u884cJsonObject\u89e3\u6790\u65f6\u53d1\u751f\u9519\u8bef\uff1a%1$s\u3002", (String)"EcoPlatFormQueryBasePlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), e.getMessage());
                this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u53d1\u751f\u9519\u8bef", (String)"EcoPlatFormQueryBasePlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), errorMessage, MessageTypes.Default);
            }
        }
        return new JSONObject(16);
    }

    public JSONObject getExtEntryJsonObject(JSONObject extChangeJsonObject, String entryName) {
        if (PlatformUtils.isNullJsonObject((JSONObject)extChangeJsonObject)) {
            return new JSONObject(16);
        }
        if (extChangeJsonObject.containsKey((Object)entryName)) {
            return extChangeJsonObject.getJSONObject(entryName);
        }
        return new JSONObject(16);
    }

    private Set<String> getUpdateExtTableSet() {
        HashSet<String> set = new HashSet<String>(10);
        set.add("t_pdm_bomecopentry");
        set.add("t_fmm_ecobomcopentry");
        set.add("t_fmm_ecobomentry");
        set.add("t_pdm_ecorouteoperation_e");
        set.add("t_pdm_ecorouteoperation");
        return set;
    }

    public String genExtUpdateSqlPkField(String extTable, String pentryPkField, String ecoBomEntryPkField, Long pentryPk, Long ecoBomEntryPk) {
        if ("t_pdm_bomecopentry".equals(extTable)) {
            return pentryPkField;
        }
        return ecoBomEntryPkField;
    }

    public Long genExtUpdateSqlPkValue(String extTable, String pentryPkField, String ecoBomEntryPkField, Long pentryPk, Long ecoBomEntryPk) {
        if ("t_pdm_bomecopentry".equals(extTable)) {
            return pentryPk;
        }
        return ecoBomEntryPk;
    }

    public boolean isCopChange(String productType) {
        return "10720".equals(productType) || "10730".equals(productType);
    }

    public boolean isCopChange(int rowIndex) {
        String productType = this.getStringValue("producttype", rowIndex);
        return this.isCopChange(productType);
    }

    public void addToSet(Set<Long> set, Long idA, Long idB) {
        set.add(idA);
        if (!idB.equals(0L)) {
            set.add(idB);
        }
    }

    public DynamicObject getEntryFromMap(Map<Long, DynamicObject> ecoBomEntryDataMap, Map<Long, DynamicObject> ecoBomCopEntryDataMap, Long ecoBomEntryId, boolean isCopChange) {
        if (!isCopChange) {
            return ecoBomEntryDataMap.get(ecoBomEntryId);
        }
        return ecoBomCopEntryDataMap.get(ecoBomEntryId);
    }

    public boolean isMatchExtTable(String extTable, String changeType, String productType) {
        if ("t_pdm_bomecopentry".equals(extTable)) {
            return true;
        }
        if (StringUtils.isNull((String)changeType) || "A".equals(changeType)) {
            if ("t_fmm_ecobomentry".equals(extTable) && !this.isCopChange(productType)) {
                return true;
            }
            if ("t_fmm_ecobomcopentry".equals(extTable) && !this.isCopChange(productType)) {
                return true;
            }
        } else if ("B".equals(changeType) && ("t_pdm_ecorouteoperation_e".equals(extTable) || "t_pdm_ecorouteoperation".equals(extTable))) {
            return true;
        }
        return false;
    }

    public void genExtUpdateSql(String extchangejson, String pentryPkField, String ecoBomEntryPkField, Long pentryPk, Long ecoBomEntryPk, List<String> updateExtDBList, String changeType, String productType) {
        if (StringUtils.isEmpty((String)extchangejson)) {
            return;
        }
        JSONObject extChangeJsonObject = this.parseExtJson(extchangejson);
        if (extChangeJsonObject == null) {
            return;
        }
        Set<String> extSet = this.getUpdateExtTableSet();
        for (String extTable : extSet) {
            Long updatePkValue;
            String updateField;
            String execSql;
            JSONObject extJsonObject = this.getExtEntryJsonObject(extChangeJsonObject, extTable);
            if (PlatformUtils.isNullJsonObject((JSONObject)extJsonObject) || !this.isMatchExtTable(extTable, changeType, productType) || StringUtils.isEmpty((String)(execSql = this.genUpdateExtDbSql(extJsonObject, updateField = this.genExtUpdateSqlPkField(extTable, pentryPkField, ecoBomEntryPkField, pentryPk, ecoBomEntryPk), updatePkValue = this.genExtUpdateSqlPkValue(extTable, pentryPkField, ecoBomEntryPkField, pentryPk, ecoBomEntryPk), extTable)))) continue;
            updateExtDBList.add(execSql);
        }
    }

    public boolean isUnEstimateStatus(int rowIndex) {
        String estimateStatus = this.getStringValue("estimatestatus", rowIndex);
        return !"C".equals(estimateStatus);
    }

    public boolean isEstimateStatusB(int rowIndex) {
        String estimateStatus = this.getStringValue("estimatestatus", rowIndex);
        return "B".equals(estimateStatus);
    }

    public boolean isEstimateStatusA(int rowIndex) {
        String estimateStatus = this.getStringValue("estimatestatus", rowIndex);
        return "A".equals(estimateStatus);
    }

    public boolean isEstimateStatusC(int rowIndex) {
        String estimateStatus = this.getStringValue("estimatestatus", rowIndex);
        return "C".equals(estimateStatus);
    }

    public Set<Long> getAllEcoBomEntryIdSet(Map<Long, DynamicObject> ecoBomEntryDataMap, Map<Long, DynamicObject> ecoBomCopEntryDataMap, Map<Long, DynamicObject> ecoRouteEntryDataMap, Long ecoBomId, int rowIndex) {
        HashSet<Long> allIdSet = new HashSet<Long>(16);
        if (this.isBomChange(rowIndex)) {
            DynamicObject entry;
            for (Map.Entry<Long, DynamicObject> entrys : ecoBomEntryDataMap.entrySet()) {
                entry = entrys.getValue();
                if (!ecoBomId.equals(entry.getLong("ecobomid"))) continue;
                allIdSet.add(entrys.getKey());
            }
            for (Map.Entry<Long, DynamicObject> entrys : ecoBomCopEntryDataMap.entrySet()) {
                entry = entrys.getValue();
                if (!ecoBomId.equals(entry.getLong("ecobomid"))) continue;
                allIdSet.add(entrys.getKey());
            }
        } else {
            for (Map.Entry<Long, DynamicObject> entrys : ecoRouteEntryDataMap.entrySet()) {
                DynamicObject entry = entrys.getValue();
                if (!ecoBomId.equals(entry.getLong("ecorouteid"))) continue;
                allIdSet.add(entrys.getKey());
            }
        }
        return allIdSet;
    }

    public DynamicObject getEcoBomEntryFromMap(Map<Long, DynamicObject> ecoBomEntryDataMap, Long ecoBomEntryId) {
        for (Map.Entry<Long, DynamicObject> entrys : ecoBomEntryDataMap.entrySet()) {
            DynamicObject entry = entrys.getValue();
            if (!ecoBomEntryId.equals(entry.getLong("entryid"))) continue;
            return entry;
        }
        return null;
    }

    public Set<Long> getSameReplaceGroupIdSet(Map<Long, DynamicObject> ecoBomEntryDataMap, String entryReplaceGroup) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (Map.Entry<Long, DynamicObject> entrys : ecoBomEntryDataMap.entrySet()) {
            DynamicObject entry = entrys.getValue();
            if (!entryReplaceGroup.equals(entry.getString("entryreplacegroup"))) continue;
            idSet.add(entry.getLong("entryid"));
        }
        return idSet;
    }

    public boolean isEditGroupKey(int rowIndex) {
        DynamicObject ecoType = this.getDynamicObjectValue("ecotype", rowIndex);
        if (ecoType == null) {
            return false;
        }
        return EcoUtils.isEditMode((DynamicObject)ecoType, (String)"groupkeytype");
    }

    public boolean isEditRefKey(int rowIndex) {
        DynamicObject ecoType = this.getDynamicObjectValue("ecotype", rowIndex);
        if (ecoType == null) {
            return false;
        }
        return EcoUtils.isEditMode((DynamicObject)ecoType, (String)"refkeytype");
    }

    public Long getFirstLongValueFromMap(Map<Long, Long> dataMap) {
        return PlatformUtils.getFirstLongValueFromMap(dataMap);
    }

    public boolean isBomChange(int rowIndex) {
        String changeType = this.getStringValue("changetype", rowIndex);
        return StringUtils.isNull((String)changeType) || "A".equals(changeType);
    }

    public boolean isRouteChange(int rowIndex) {
        String changeType = this.getStringValue("changetype", rowIndex);
        return "B".equals(changeType);
    }

    public String getChangeType(int rowIndex) {
        return this.getStringValue("changetype", rowIndex);
    }

    protected String getFilterToFilterName(String fromName) {
        if ("materialinfofrom_filter".equals(fromName)) {
            return "materialinfoto_filter";
        }
        if ("materialfrom_filter".equals(fromName)) {
            return "materialto_filter";
        }
        if ("featurefrom_filter".equals(fromName)) {
            return "featureto_filter";
        }
        return "";
    }

    protected String getEntityName(String fromName) {
        if ("featurefrom_filter".equals(fromName)) {
            return "mpdm_featuretype";
        }
        return "bd_material";
    }

    public boolean updateEcoBomEntryByPvalidDate(Date pentryInvalidDate, Long ecoBillId, Long ecopentryid, Long ecoBomId, DynamicObject ecoType) {
        DynamicObject ecoBill = this.updateEcnBillByPvalidDate(pentryInvalidDate, ecoBillId, ecopentryid, ecoType);
        String selectProperties = "id,entry.entrymode,entry.acttime,entry.entryvaliddate,entry.entryinvaliddate,entry.id,entry.estimatestatus,copentry.copentrymode,copentry.copacttime,copentry.copentryvaliddate,copentry.copentryinvaliddate,copentry.id,copentry.copestimatestatus";
        DynamicObject ecobom = BusinessDataServiceHelper.loadSingle((String)"pdm_ecobom", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ecoBomId)});
        DynamicObjectCollection coll = ecobom.getDynamicObjectCollection("entry");
        DynamicObjectCollection copcoll = ecobom.getDynamicObjectCollection("copentry");
        this.updateEntryCollActtime(coll, pentryInvalidDate, false);
        this.updateEntryCollActtime(copcoll, pentryInvalidDate, true);
        this.saveDataByPentryVakidDate(ecoBill, ecobom);
        return true;
    }

    private DynamicObject updateEcnBillByPvalidDate(Date pentryInvalidDate, Long ecoBillId, Long ecopentryid, DynamicObject ecoType) {
        String selectProperties = "id,pentry.pentryvaliddate,pentry.ecotype,pentry.id";
        DynamicObject ecoBill = BusinessDataServiceHelper.loadSingle((String)"pdm_bom_eco", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ecoBillId)});
        DynamicObjectCollection ecoBillColl = ecoBill.getDynamicObjectCollection("pentry");
        for (int i = 0; i < ecoBillColl.size(); ++i) {
            DynamicObject pentry = (DynamicObject)ecoBillColl.get(i);
            if (!((Long)pentry.getPkValue()).equals(ecopentryid)) continue;
            pentry.set("ecotype", (Object)ecoType);
            pentry.set("pentryvaliddate", (Object)pentryInvalidDate);
            break;
        }
        return ecoBill;
    }

    public boolean updateEcoRouteEntryByPvalidDate(Date pentryInvalidDate, Long ecoBillId, Long ecopentryid, Long ecoRouteId, DynamicObject ecoType) {
        DynamicObject ecoBill = this.updateEcnBillByPvalidDate(pentryInvalidDate, ecoBillId, ecopentryid, ecoType);
        String selectProperties = "id,processentry.entrymode,processentry.acttime,processentry.entryvaliddate,processentry.entryinvaliddate,processentry.id,processentry.estimatestatus";
        DynamicObject ecoRoute = BusinessDataServiceHelper.loadSingle((String)"pdm_ecoroute", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ecoRouteId)});
        DynamicObjectCollection coll = ecoRoute.getDynamicObjectCollection("processentry");
        this.updateEntryCollActtime(coll, pentryInvalidDate, false);
        this.saveDataByPentryVakidDate(ecoBill, ecoRoute);
        return true;
    }

    private void updateEntryCollActtime(DynamicObjectCollection coll, Date pentryInvalidDate, boolean isCopChange) {
        ArrayList<DynamicObject> deleteRowList = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject entry = (DynamicObject)coll.get(i);
            String entrymode = entry.getString(isCopChange ? "copentrymode" : "entrymode");
            if (!"A".equals(entrymode)) {
                deleteRowList.add(entry);
                continue;
            }
            entry.set(isCopChange ? "copacttime" : "acttime", (Object)pentryInvalidDate);
            if (values.contains(entrymode)) continue;
            entry.set(isCopChange ? "copentryvaliddate" : "entryvaliddate", (Object)pentryInvalidDate);
        }
        if (!deleteRowList.isEmpty()) {
            for (DynamicObject entry : deleteRowList) {
                coll.remove((Object)entry);
            }
        }
    }

    private void saveDataByPentryVakidDate(DynamicObject ecoBill, DynamicObject ecobom) {
        try (TXHandle required = TX.required();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ecoBill}, (OperateOption)OperateOption.create());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ecobom}, (OperateOption)OperateOption.create());
        }
    }

    public String getChangeType(DynamicObject ecoBill) {
        return ecoBill.getString("changetype");
    }

    public boolean isEcoBomEntryDiff(DynamicObject ecoBomEntry, int rowIndex) {
        DynamicObject ecoType = this.getDynamicObjectValue("ecotype", rowIndex);
        Date transtartdate = this.getDateValue("transtartdate", rowIndex);
        Date acttime = this.getDateValue("acttime", rowIndex);
        BigDecimal tranQty = this.getBigDecimalValue("tranqty", rowIndex);
        String entryGroupno = this.getStringValue("entrygroupno", rowIndex);
        String entryRefno = this.getStringValue("entryrefno", rowIndex);
        boolean isRefKey = this.getBooleanValue("refkey", rowIndex);
        boolean isGroupKey = this.getBooleanValue("groupkey", rowIndex);
        String estimateStatus = this.getStringValue("estimatestatus", rowIndex);
        Date transtartdateOld = ecoBomEntry.getDate("transtartdate");
        Date acttimeOld = ecoBomEntry.getDate("acttime");
        BigDecimal tranQtyOld = ecoBomEntry.getBigDecimal("tranqty");
        String entryGroupnoOld = ecoBomEntry.get("entrygroupno") == null ? "" : ecoBomEntry.getString("entrygroupno");
        String entryRefNoOld = ecoBomEntry.get("entryrefno") == null ? "" : ecoBomEntry.getString("entryrefno");
        boolean isRefKeyOld = ecoBomEntry.getBoolean("refkey");
        boolean isGroupKeyOld = ecoBomEntry.getBoolean("groupkey");
        String estimateStatusNew = EcoUtils.getEstimateStatusByEcoType((DynamicObject)ecoType, (String)estimateStatus);
        return PlatformUtils.isDiffDate((Date)transtartdate, (Date)transtartdateOld) || PlatformUtils.isDiffDate((Date)acttime, (Date)acttimeOld) || tranQty.compareTo(tranQtyOld) != 0 || !entryGroupno.equals(entryGroupnoOld) || !entryRefno.equals(entryRefNoOld) || PlatformUtils.isDiffBoolean((boolean)isRefKey, (boolean)isRefKeyOld) || PlatformUtils.isDiffBoolean((boolean)isGroupKey, (boolean)isGroupKeyOld) || !estimateStatusNew.equals(estimateStatus);
    }

    public boolean isEcoBomEntryReSetKeyDiff(DynamicObject ecoBomEntry, int rowIndex) {
        BigDecimal tranQty = this.getBigDecimalValue("tranqty", rowIndex);
        String entryGroupno = this.getStringValue("entrygroupno", rowIndex);
        String entryRefno = this.getStringValue("entryrefno", rowIndex);
        boolean isRefKey = this.getBooleanValue("refkey", rowIndex);
        boolean isGroupKey = this.getBooleanValue("groupkey", rowIndex);
        BigDecimal tranQtyOld = ecoBomEntry.getBigDecimal("tranqty");
        String entryGroupnoOld = ecoBomEntry.get("entrygroupno") == null ? "" : ecoBomEntry.getString("entrygroupno");
        String entryRefNoOld = ecoBomEntry.get("entryrefno") == null ? "" : ecoBomEntry.getString("entryrefno");
        boolean isRefKeyOld = ecoBomEntry.getBoolean("refkey");
        boolean isGroupKeyOld = ecoBomEntry.getBoolean("groupkey");
        return tranQty.compareTo(tranQtyOld) != 0 || !entryGroupno.equals(entryGroupnoOld) || !entryRefno.equals(entryRefNoOld) || PlatformUtils.isDiffBoolean((boolean)isRefKey, (boolean)isRefKeyOld) || PlatformUtils.isDiffBoolean((boolean)isGroupKey, (boolean)isGroupKeyOld);
    }

    public boolean isEcnPentryDiff(DynamicObject ecoBillPEntry, int rowIndex) {
        DynamicObject ecoType = this.getDynamicObjectValue("ecotype", rowIndex);
        Date pentryValidDate = this.getDateValue("pentryvaliddate", rowIndex);
        boolean isEcoTypeDiff = PlatformUtils.isDiffDynamicObject((DynamicObject)ecoBillPEntry.getDynamicObject("ecotype"), (DynamicObject)ecoType);
        boolean isPEntryInvalidDateDiff = PlatformUtils.isDiffDate((Date)ecoBillPEntry.getDate("pentryvaliddate"), (Date)pentryValidDate);
        return isEcoTypeDiff || isPEntryInvalidDateDiff;
    }

    public boolean isEcoRouteEntryDiff(DynamicObject ecoRouteEntry, int rowIndex) {
        DynamicObject ecoType = this.getDynamicObjectValue("ecotype", rowIndex);
        Date acttimeOld = ecoRouteEntry.getDate("acttime");
        String estimateStatus = this.getStringValue("estimatestatus", rowIndex);
        String estimateStatusNew = EcoUtils.getEstimateStatusByEcoType((DynamicObject)ecoType, (String)estimateStatus);
        Date acttime = this.getDateValue("acttime", rowIndex);
        return PlatformUtils.isDiffDate((Date)acttime, (Date)acttimeOld) || !estimateStatusNew.equals(estimateStatus);
    }

    public boolean isEcoBomCopEntryDiff(DynamicObject ecoBomCopEntry, int rowIndex) {
        DynamicObject ecoType = this.getDynamicObjectValue("ecotype", rowIndex);
        Date acttimeOld = ecoBomCopEntry.getDate("copacttime");
        String estimateStatus = this.getStringValue("estimatestatus", rowIndex);
        String estimateStatusNew = EcoUtils.getEstimateStatusByEcoType((DynamicObject)ecoType, (String)estimateStatus);
        Date acttime = this.getDateValue("acttime", rowIndex);
        return PlatformUtils.isDiffDate((Date)acttime, (Date)acttimeOld) || !estimateStatusNew.equals(estimateStatus);
    }

    public String getEntryModeField(boolean isCopChange) {
        return isCopChange ? "copentrymode" : "entrymode";
    }

    public String getActtimeField(boolean isCopChange) {
        return isCopChange ? "copacttime" : "acttime";
    }

    public String getEstimateStatusField(boolean isCopChange) {
        return "estimatestatus";
    }

    public String getMaterialIdField(boolean isCopChange) {
        return isCopChange ? "copentrymaterialid" : "entrymaterial";
    }

    public String getUnitField(boolean isCopChange) {
        return isCopChange ? "copentryunit" : "entryunit";
    }

    public void initEcoBomRefNoMap(DynamicObject ecoBomEntry, int rowIndex, Map<Long, Set<String>> ecoBomRefNoMap) {
        String entryRefno = this.getStringValue("entryrefno", rowIndex);
        if (!entryRefno.equals(ecoBomEntry.getString("entryrefno"))) {
            Set<String> clearRefnoSet = ecoBomRefNoMap.get(ecoBomEntry.getLong("ecobomid"));
            if (clearRefnoSet == null) {
                clearRefnoSet = new HashSet<String>(16);
            }
            if (!PlatformUtils.isNullString((String)entryRefno)) {
                clearRefnoSet.add(entryRefno);
            }
            if (!PlatformUtils.isNullString((String)ecoBomEntry.getString("entryrefno"))) {
                clearRefnoSet.add(ecoBomEntry.getString("entryrefno"));
            }
            ecoBomRefNoMap.put(ecoBomEntry.getLong("ecobomid"), clearRefnoSet);
        }
    }

    public ActTimeBean genActtimeBean(int rowIndex) {
        Long materialId;
        Date actTime = (Date)this.getValue("acttime", rowIndex);
        Date entryValidDate = (Date)this.getValue("entryvaliddate", rowIndex);
        Date entryInValidDate = (Date)this.getValue("entryinvaliddate", rowIndex);
        Long ecoBillId = this.getLongValue("ecoid", rowIndex);
        String ecoBillNumber = this.getStringValue("billno", rowIndex);
        String entrymode = this.getStringValue("entrymode", rowIndex);
        String billStatus = this.getStringValue("billstatus", rowIndex);
        Long mftBomEntryId = this.getLongValue("bomentryid", rowIndex);
        Long mftBomEntryAfterId = 0L;
        if ("B".equals(entrymode)) {
            mftBomEntryAfterId = this.getLongValue("afterbomentryid", rowIndex);
        }
        if ((materialId = this.getMaterialId(rowIndex)) == null || materialId.equals(0L)) {
            materialId = this.getFeatureTypeId(rowIndex);
        }
        return new ActTimeBean(actTime, entryValidDate, entryInValidDate, mftBomEntryId, mftBomEntryAfterId, ecoBillId, ecoBillNumber, entrymode, billStatus, materialId);
    }

    public ActTimeCopBean genActtimeBomCopBean(int rowIndex) {
        Long materialId;
        Date actTime = (Date)this.getValue("acttime", rowIndex);
        Date entryValidDate = (Date)this.getValue("entryvaliddate", rowIndex);
        Date entryInValidDate = (Date)this.getValue("entryinvaliddate", rowIndex);
        Long ecoBillId = this.getLongValue("ecoid", rowIndex);
        String ecoBillNumber = this.getStringValue("billno", rowIndex);
        String entrymode = this.getStringValue("entrymode", rowIndex);
        String billStatus = this.getStringValue("billstatus", rowIndex);
        Long mftBomEntryId = this.getLongValue("bomentryid", rowIndex);
        Long mftBomEntryAfterId = 0L;
        if ("B".equals(entrymode)) {
            mftBomEntryAfterId = this.getLongValue("afterbomentryid", rowIndex);
        }
        if ((materialId = this.getMaterialId(rowIndex)) == null || materialId.equals(0L)) {
            materialId = this.getFeatureTypeId(rowIndex);
        }
        return new ActTimeCopBean(actTime, entryValidDate, entryInValidDate, mftBomEntryId, mftBomEntryAfterId, ecoBillId, ecoBillNumber, entrymode, billStatus, materialId);
    }

    public ActTimeRouteBean genActtimeRouteBean(int rowIndex) {
        Date actTime = (Date)this.getValue("acttime", rowIndex);
        Date entryValidDate = (Date)this.getValue("entryvaliddate", rowIndex);
        Date entryInValidDate = (Date)this.getValue("entryinvaliddate", rowIndex);
        Long ecoBillId = this.getLongValue("ecoid", rowIndex);
        String ecoBillNumber = this.getStringValue("billno", rowIndex);
        String entrymode = this.getStringValue("entrymode", rowIndex);
        String billStatus = this.getStringValue("billstatus", rowIndex);
        Long routeEntryId = this.getLongValue("bomentryid", rowIndex);
        Long routeEntryAfterId = 0L;
        if ("B".equals(entrymode)) {
            routeEntryAfterId = this.getLongValue("afterbomentryid", rowIndex);
        }
        String operationNo = this.getStringValue("operationno", rowIndex);
        String processSeq = this.getStringValue("processseq", rowIndex);
        return new ActTimeRouteBean(actTime, entryValidDate, entryInValidDate, routeEntryId, routeEntryAfterId, ecoBillId, ecoBillNumber, entrymode, billStatus, operationNo, processSeq);
    }

    public boolean isDisableGroupNo() {
        String value = this.getPageCache().get("isDisableGroupNo");
        if (StringUtils.isEmpty((String)value)) {
            boolean isDisableGroupNo = PlatformUtils.isDisableGroupNo();
            value = isDisableGroupNo ? "true" : "false";
            this.getPageCache().put("isDisableGroupNo", value);
        }
        return "true".equalsIgnoreCase(value);
    }

    public Map<Long, String> getSelectDataMap(int[] selectRows) {
        HashMap<Long, String> dataMap = new HashMap<Long, String>(selectRows.length);
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            Long billId = this.getLongValue("ecoid", rowIndex);
            if (dataMap.containsKey(billId)) continue;
            dataMap.put(billId, this.getStringValue("billno", rowIndex));
        }
        return dataMap;
    }

    public Map<String, Object> genNewValueMap(DynamicObject keyDy, Long ecoBomEntryId, boolean isReComputeKey, DynamicObject oldEcoBomEntry) {
        Long entryId;
        if (isReComputeKey) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("groupkey", oldEcoBomEntry.getBoolean("groupkey"));
            map.put("refkey", oldEcoBomEntry.getBoolean("refkey"));
            return map;
        }
        if (keyDy != null && (entryId = Long.valueOf(keyDy.getLong("entryid"))).equals(ecoBomEntryId)) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("groupkey", keyDy.getBoolean("groupkey"));
            map.put("refkey", keyDy.getBoolean("refkey"));
            return map;
        }
        return null;
    }

    public void genUpdateGroupKeyEcoBomEntrys(Long ecoBomId, String entryGroupno, Long ecoBomEntryId, List<DynamicObject> updateUnGroupKeyList) {
        String querySql = "select fentryid from t_fmm_ecobomentry where fid = ? and fentrygroupnos = ? and fentryid  <> ?  and fgroupkey = '1' ";
        HashSet<Long> ecoBomentryIdSet = new HashSet<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)(EcoBomPlatFormQueryPlugin.class.getName() + "_getUpdateGroupKeyEcoBomEntrys"), (DBRoute)scmDBRoute, (String)querySql, (Object[])new Object[]{ecoBomId, entryGroupno, ecoBomEntryId});){
            while (ds.hasNext()) {
                ecoBomentryIdSet.add(ds.next().getLong("fentryid"));
            }
        }
        this.queryResultToList(ecoBomentryIdSet, updateUnGroupKeyList);
    }

    public void genUpdateRefKeyEcoBomEntrys(String entryRefno, Long ecoBomEntryId, List<DynamicObject> updateUnRefKeyList) {
        String querySql = "select fentryid from t_fmm_ecobomentry where fentryrefnos = ? and fentryid  <> ?  and festimatestatus <> 'C'  and frefkey = '1' ";
        HashSet<Long> ecoBomentryIdSet = new HashSet<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)(EcoBomPlatFormQueryPlugin.class.getName() + "_getUpdateRefKeyEcoBomEntrys"), (DBRoute)scmDBRoute, (String)querySql, (Object[])new Object[]{entryRefno, ecoBomEntryId});){
            while (ds.hasNext()) {
                ecoBomentryIdSet.add(ds.next().getLong("fentryid"));
            }
        }
        this.queryResultToList(ecoBomentryIdSet, updateUnRefKeyList);
    }

    private void queryResultToList(Set<Long> ecoBomentryIdSet, List<DynamicObject> updateUnGroupKeyList) {
        Map<Long, DynamicObject> maps;
        if (!ecoBomentryIdSet.isEmpty() && (maps = PlatFormQueryDataHelper.getEcoBomData(ecoBomentryIdSet)) != null && !maps.isEmpty()) {
            for (Map.Entry<Long, DynamicObject> entrys : maps.entrySet()) {
                PlatformUtils.addList(updateUnGroupKeyList, (DynamicObject)entrys.getValue());
            }
        }
    }
}

