/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.ecoplatform;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.GetEcoEffectManuftechBusiness;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;

public class MyTaskGetManftechDiffData
implements Runnable {
    private static Log logger = LogFactory.getLog(MyTaskGetManftechDiffData.class);
    private RequestContext rc;
    private String pageId;
    private String parentPageId;
    private Set<Long> ecoRouteEntryIdSet;

    public MyTaskGetManftechDiffData(RequestContext rc, String pageId, String parentpageId, Set<Long> ecoRouteEntryIdset) {
        this.rc = rc;
        this.pageId = pageId;
        this.parentPageId = parentpageId;
        this.ecoRouteEntryIdSet = ecoRouteEntryIdset;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        this.doTask();
    }

    private List<Map<String, Object>> doTask() {
        List<Map<String, Object>> gridList = new ArrayList<Map<String, Object>>(16);
        try {
            GetEcoEffectManuftechBusiness impl = GetEcoEffectManuftechBusiness.getInstance();
            Map allData = impl.getEffectAllData(this.ecoRouteEntryIdSet, false, true);
            Set allEcoBillIdSet = (Set)allData.get("ecoBillIdSet");
            Set allRouteIdSet = (Set)allData.get("routeIdSet");
            Set allEcoRouteEntryIdSet = (Set)allData.get("allEcoRouteEntryIdSet");
            gridList = impl.genDiffManuftechData(allRouteIdSet, allEcoBillIdSet, allEcoRouteEntryIdSet, this.pageId);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            PageCache pageCache = new PageCache(this.pageId);
            pageCache.put("opProgressPro", "100");
            pageCache.put("opexception", PlatformUtils.getExceptionString((Exception)e));
            return gridList;
        }
        PageCache pageCache = new PageCache(this.pageId);
        pageCache.put("opProgressPro", "100");
        if (!StringUtils.isEmpty((String)this.parentPageId)) {
            pageCache = new PageCache(this.parentPageId);
            if (PlatformUtils.isNullList(gridList)) {
                pageCache.put("pc_gridlistjsonstring", "");
            } else {
                String jsonString = JSONArray.toJSONString(gridList);
                pageCache.put("pc_gridlistjsonstring", jsonString);
            }
        }
        return gridList;
    }
}

