/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.ecoplatform;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.GetEcoEffectOrderBusiness;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;

public class MyTaskGetStockDiffData
implements Runnable {
    private static Log logger = LogFactory.getLog(MyTaskGetStockDiffData.class);
    private RequestContext rc;
    private String pageId;
    private String parentPageId;
    private Set<Long> ecoBomEntryIdSet;

    public MyTaskGetStockDiffData(RequestContext rc, String pageId, String parentpageId, Set<Long> ecoBomEntryIdSet) {
        this.rc = rc;
        this.pageId = pageId;
        this.parentPageId = parentpageId;
        this.ecoBomEntryIdSet = ecoBomEntryIdSet;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        this.doTask();
    }

    private List<Map<String, Object>> doTask() {
        List<Map<String, Object>> gridList = new ArrayList<Map<String, Object>>(16);
        try {
            GetEcoEffectOrderBusiness impl = GetEcoEffectOrderBusiness.getInstance();
            Map allData = impl.getEffectAllData(this.ecoBomEntryIdSet, false, true);
            Set allEcoBillIdSet = (Set)allData.get("ecoBillIdSet");
            Set allChildBomIdSet = (Set)allData.get("childBomIdSet");
            Set allEcoBomEntryIdSet = (Set)allData.get("allEcoBomEntryIdSet");
            gridList = impl.genDiffStockData(allChildBomIdSet, allEcoBillIdSet, allEcoBomEntryIdSet, this.pageId);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            PageCache pageCache = new PageCache(this.pageId);
            pageCache.put("opProgressPro", "100");
            pageCache.put("opexception", PlatformUtils.getExceptionString((Exception)e));
            return gridList;
        }
        PageCache pageCache = new PageCache(this.pageId);
        pageCache.put("opProgressPro", "100");
        if (!StringUtils.isEmpty((String)this.parentPageId)) {
            pageCache = new PageCache(this.parentPageId);
            if (PlatformUtils.isNullList(gridList)) {
                pageCache.put("pc_gridlistjsonstring", "");
            } else {
                String jsonString = JSONArray.toJSONString(gridList);
                pageCache.put("pc_gridlistjsonstring", jsonString);
            }
        }
        return gridList;
    }
}

