/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.ecoplatform;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.LongType;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;
import kd.mmc.pdm.formplugin.ecoplatform.AbstractEcoBomPlatFormQueryFilterExtPlugin;
import kd.mmc.pdm.formplugin.ecoplatform.EcoPlatFormQueryExtPlugin;
import kd.mmc.pdm.formplugin.ecoplatform.IEcoPlatFormQueryExt;

public class PlatFormQueryDataHelper {
    private static final DBRoute scmDBRoute = new DBRoute("scm");
    private static final Log logger = LogFactory.getLog(PlatFormQueryDataHelper.class);
    private static final String AFTER_CHAR = "after";
    private static Map<String, String> MAP_LONG = new HashMap<String, String>(32);
    private static Map<String, String> MAP_DATE = new HashMap<String, String>(16);
    private static Map<String, String> MAP_STRING = new HashMap<String, String>(32);
    private static Map<String, String> MAP_BIGDECIMAL = new HashMap<String, String>(16);
    private static Map<String, String> MAP_BOOLEAN = new HashMap<String, String>(16);
    public static final String[] GRID_LOKC_FIELD_ARRAY;

    private static QFilter getEcoBillFilters(IFormView view, AbstractFormDataModel model, Object oldExtPlugin, PluginProxy<IEcoPlatFormQueryExt> newExtPlugin) {
        DynamicObjectCollection orgColl = (DynamicObjectCollection)model.getValue("org_filter");
        QFilter filter = PlatFormQueryDataHelper.getOrgQFilter(orgColl);
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getTypeFilter(view, model));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getChangeTypeFilter(view, model));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getEcoTypeFilter(view, model));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getBomEcoNumberFilter(view, model));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getMaterialInfoFilter(view, model));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getBillStatusFilter(view, model));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getCreateTimeFilter(view, model));
        QFilter extQFilter = PlatFormQueryDataHelper.getEcoBillExtFilter(view, model, "A", oldExtPlugin, newExtPlugin);
        if (extQFilter != null) {
            filter = PlatFormQueryDataHelper.addfilter(filter, extQFilter);
        }
        return filter;
    }

    private static QFilter getEcoBillExtFilter(IFormView view, AbstractFormDataModel model, String queryType, Object oldExtPlugin, PluginProxy<IEcoPlatFormQueryExt> newExtPlugin) {
        if (oldExtPlugin != null) {
            logger.info(" begin exec dealecoBillFilter oldExtPlugin:" + oldExtPlugin.getClass().getName() + ",queryType=" + queryType);
            long startTime = System.currentTimeMillis();
            QFilter qfilter = null;
            if ("A".equals(queryType)) {
                qfilter = ((AbstractEcoBomPlatFormQueryFilterExtPlugin)oldExtPlugin).dealecoBillFilter(view, model);
            } else if ("B".equals(queryType)) {
                qfilter = ((AbstractEcoBomPlatFormQueryFilterExtPlugin)oldExtPlugin).dealecoBomFilter(view, model);
            } else if ("C".equals(queryType)) {
                qfilter = ((AbstractEcoBomPlatFormQueryFilterExtPlugin)oldExtPlugin).dealecoRouteFilter(view, model);
            }
            long exextimelong = System.currentTimeMillis() - startTime;
            logger.info(" end exec dealecoBillFilter oldExtPlugin:" + oldExtPlugin.getClass().getName() + ",queryType=" + queryType + ",qfilter=" + qfilter + ",costs=" + exextimelong + "ms");
            return qfilter;
        }
        if (newExtPlugin != null) {
            logger.info(" begin exec dealecoBillFilter newExtPlugin,queryType=" + queryType);
            long startTime = System.currentTimeMillis();
            List listQfilter = null;
            if ("A".equals(queryType)) {
                listQfilter = newExtPlugin.callReplace(p -> p.dealecoBillFilter(view, model));
            } else if ("B".equals(queryType)) {
                listQfilter = newExtPlugin.callReplace(p -> p.dealecoBomFilter(view, model));
            } else if ("C".equals(queryType)) {
                listQfilter = newExtPlugin.callReplace(p -> p.dealecoRouteFilter(view, model));
            }
            QFilter qfilter = PlatFormQueryDataHelper.getFirstExtQFilter(listQfilter);
            long exextimelong = System.currentTimeMillis() - startTime;
            logger.info(" end exec dealecoBillFilter newExtPlugin,queryType=" + queryType + ",qfilter=" + qfilter + ",costs=" + exextimelong + "ms");
            return qfilter;
        }
        return null;
    }

    @Deprecated
    public static Object getExtPlugin() {
        String extClassPlugin = PdmParamSetHelper.getStringParamValue((String)"EcoBomPlatFormQueryFilterExtPlugin");
        if (!StringUtils.isEmpty((CharSequence)extClassPlugin)) {
            try {
                Object object = Class.forName(extClassPlugin).newInstance();
                if (AbstractEcoBomPlatFormQueryFilterExtPlugin.class.isInstance(object)) {
                    return object;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error((Throwable)e);
            }
        }
        return null;
    }

    public static PluginProxy<IEcoPlatFormQueryExt> genExtPluginxy() {
        EcoPlatFormQueryExtPlugin extPluginClass = new EcoPlatFormQueryExtPlugin();
        return PluginProxy.create((Object)extPluginClass, IEcoPlatFormQueryExt.class, (String)"PDM_ECOPLATFORMQUERY_EXT", null);
    }

    public static QFilter getOrgQFilter(DynamicObjectCollection orgColl) {
        if (orgColl == null || orgColl.isEmpty()) {
            return null;
        }
        Set<Long> orgIdSet = PlatFormQueryDataHelper.getCollectionIdset(orgColl);
        return new QFilter("org", "in", orgIdSet);
    }

    public static QFilter addfilter(QFilter afilter, QFilter bfilter) {
        if (bfilter == null) {
            return afilter;
        }
        afilter = afilter == null ? bfilter : afilter.and(bfilter);
        return afilter;
    }

    public static QFilter getEcoBomFilters(IFormView view, AbstractFormDataModel model, Set<Long> ecobomIdSet, Object oldExtPlugin, PluginProxy<IEcoPlatFormQueryExt> newExtPlugin) {
        QFilter filter = PlatFormQueryDataHelper.getEcoIdQFilter(ecobomIdSet);
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getMaterialFilter(view, model, "entry"));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getFeatureTypeFilter(view, model, "entry"));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getEntryModeFilter(view, model, "entry"));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getEstimateStatusFilter(view, model, "entry"));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getActTimeFilter(view, model, "entry"));
        QFilter extQFilter = PlatFormQueryDataHelper.getEcoBillExtFilter(view, model, "B", oldExtPlugin, newExtPlugin);
        if (extQFilter != null) {
            filter = PlatFormQueryDataHelper.addfilter(filter, extQFilter);
        }
        return filter;
    }

    public static QFilter getEcoBomCopFilters(IFormView view, AbstractFormDataModel model, Set<Long> ecobomIdSet, Object oldExtPlugin, PluginProxy<IEcoPlatFormQueryExt> newExtPlugin) {
        QFilter filter = PlatFormQueryDataHelper.getEcoIdQFilter(ecobomIdSet);
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getMaterialFilter(view, model, "copentry"));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getFeatureTypeFilter(view, model, "copentry"));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getEntryModeFilter(view, model, "copentry"));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getEstimateStatusFilter(view, model, "copentry"));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getActTimeFilter(view, model, "copentry"));
        QFilter extQFilter = PlatFormQueryDataHelper.getEcoBillExtFilter(view, model, "B", oldExtPlugin, newExtPlugin);
        if (extQFilter != null) {
            filter = PlatFormQueryDataHelper.addfilter(filter, extQFilter);
        }
        return filter;
    }

    public static QFilter getEcoRouteFilters(IFormView view, AbstractFormDataModel model, Set<Long> ecoRouteIdSet, Object oldExtPlugin, PluginProxy<IEcoPlatFormQueryExt> newExtPlugin) {
        QFilter filter = PlatFormQueryDataHelper.getEcoIdQFilter(ecoRouteIdSet);
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getMaterialFilter(view, model, "processentry"));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getFeatureTypeFilter(view, model, "processentry"));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getEntryModeFilter(view, model, "processentry"));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getEstimateStatusFilter(view, model, "processentry"));
        filter = PlatFormQueryDataHelper.addfilter(filter, PlatFormQueryDataHelper.getActTimeFilter(view, model, "processentry"));
        QFilter extQFilter = PlatFormQueryDataHelper.getEcoBillExtFilter(view, model, "C", oldExtPlugin, newExtPlugin);
        if (extQFilter != null) {
            filter = PlatFormQueryDataHelper.addfilter(filter, extQFilter);
        }
        return filter;
    }

    private static QFilter getEcoIdQFilter(Set<Long> ecoRouteIdSet) {
        QFilter filter = null;
        if (!ecoRouteIdSet.isEmpty()) {
            if (ecoRouteIdSet.size() < 1000) {
                filter = new QFilter("id", "in", ecoRouteIdSet);
            }
        } else {
            filter = new QFilter("id", "=", (Object)0L);
        }
        return filter;
    }

    public static QFilter getTypeFilter(IFormView view, AbstractFormDataModel model) {
        DynamicObjectCollection typeColl = (DynamicObjectCollection)model.getValue("type_filter");
        return PlatFormQueryDataHelper.getTypeQFilter(typeColl);
    }

    public static QFilter getTypeQFilter(DynamicObjectCollection typeColl) {
        if (typeColl == null || typeColl.isEmpty()) {
            return null;
        }
        Set<Long> bomTypeIdSet = PlatFormQueryDataHelper.getCollectionIdset(typeColl);
        return new QFilter("pentry.bomtype", "in", bomTypeIdSet);
    }

    public static QFilter getChangeTypeFilter(IFormView view, AbstractFormDataModel model) {
        if (PlatFormQueryDataHelper.isNullString(model.getValue("changetype_filter"))) {
            return null;
        }
        String changeTypes = model.getValue("changetype_filter").toString();
        return PlatFormQueryDataHelper.getChangeTypeQFilter(changeTypes);
    }

    public static QFilter getChangeTypeQFilter(String changeTypes) {
        Set types;
        if (changeTypes != null && !"".equals(changeTypes) && !(types = Arrays.stream(changeTypes.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet())).isEmpty()) {
            return new QFilter("changetype", "in", types);
        }
        return null;
    }

    public static QFilter getEcoTypeFilter(IFormView view, AbstractFormDataModel model) {
        DynamicObjectCollection ecoTypeColl = (DynamicObjectCollection)model.getValue("ecotype_filter");
        return PlatFormQueryDataHelper.getEcoTypeQFilter(ecoTypeColl);
    }

    public static QFilter getEcoTypeQFilter(DynamicObjectCollection ecoTypeColl) {
        if (ecoTypeColl == null || ecoTypeColl.isEmpty()) {
            return null;
        }
        Set<Long> ecoTypeIdSet = PlatFormQueryDataHelper.getCollectionIdset(ecoTypeColl);
        return new QFilter("pentry.ecotype", "in", ecoTypeIdSet);
    }

    public static QFilter getBomEcoNumberFilter(IFormView view, AbstractFormDataModel model) {
        DynamicObject bomecotoFilter;
        QFilter qFilter2;
        QFilter qFilter = null;
        if (!PlatFormQueryDataHelper.isNullString(model.getValue("bomecofrom_filter"))) {
            DynamicObjectCollection bomecofromFilter = (DynamicObjectCollection)model.getValue("bomecofrom_filter");
            qFilter = PlatFormQueryDataHelper.getBomEcoNumberFromQFilter(bomecofromFilter);
        }
        if (!PlatFormQueryDataHelper.isNullString(model.getValue("bomecoto_filter")) && (qFilter2 = PlatFormQueryDataHelper.getBomEcoNumberToQFilter(bomecotoFilter = (DynamicObject)model.getValue("bomecoto_filter"))) != null) {
            qFilter = qFilter == null ? qFilter2 : qFilter.and(qFilter2);
        }
        return qFilter;
    }

    public static QFilter getBomEcoNumberFromQFilter(DynamicObjectCollection bomecofrom_filter) {
        QFilter qFilter = null;
        if (bomecofrom_filter != null && !bomecofrom_filter.isEmpty()) {
            List<String> bomEcoNumber = PlatFormQueryDataHelper.getBomEcoNumber(bomecofrom_filter);
            qFilter = bomecofrom_filter.size() == 1 ? new QFilter("billno", ">=", (Object)bomEcoNumber.get(0)) : new QFilter("billno", "in", bomEcoNumber);
        }
        return qFilter;
    }

    public static List<String> getBomEcoNumber(DynamicObjectCollection bomecofrom_filter) {
        ArrayList<String> list = new ArrayList<String>(16);
        for (DynamicObject dynamicObject : bomecofrom_filter) {
            DynamicObject basedataid = dynamicObject.getDynamicObject("fbasedataid");
            list.add(basedataid.getString("number"));
        }
        return list;
    }

    public static QFilter getBomEcoNumberToQFilter(DynamicObject bomecoto_filter) {
        QFilter qFilter = null;
        if (bomecoto_filter != null) {
            return new QFilter("billno", "<=", (Object)bomecoto_filter.getString("number"));
        }
        return qFilter;
    }

    public static QFilter getMaterialInfoFilter(IFormView view, AbstractFormDataModel model) {
        DynamicObject material;
        QFilter qFilter2;
        QFilter qFilter = null;
        if (model.getValue("materialinfofrom_filter") != null) {
            DynamicObjectCollection materialColl = (DynamicObjectCollection)model.getValue("materialinfofrom_filter");
            qFilter = PlatFormQueryDataHelper.getMaterialInfoFromQFilter(materialColl);
        }
        if (model.getValue("materialinfoto_filter") != null && (qFilter2 = PlatFormQueryDataHelper.getMaterialInfoToQFilter(material = (DynamicObject)model.getValue("materialinfoto_filter"))) != null) {
            qFilter = qFilter == null ? qFilter2 : qFilter.and(qFilter2);
        }
        return qFilter;
    }

    public static QFilter getMaterialInfoFromQFilter(DynamicObjectCollection materialColl) {
        QFilter qFilter = null;
        if (materialColl != null && !materialColl.isEmpty()) {
            Set<Long> materialIdSet = PlatFormQueryDataHelper.getCollectionIdset(materialColl);
            if (materialIdSet.size() == 1) {
                DynamicObject material = (DynamicObject)materialColl.get(0);
                String materialNumber = "";
                materialNumber = material.containsProperty("number") ? material.getString("number") : material.getString("fbasedataid.number");
                qFilter = new QFilter("pentry.proentrymaterialid.number", ">=", (Object)materialNumber);
            } else {
                qFilter = new QFilter("pentry.proentrymaterialid", "in", materialIdSet);
            }
        }
        return qFilter;
    }

    public static QFilter getMaterialInfoToQFilter(DynamicObject material) {
        QFilter qFilter = null;
        if (material != null) {
            String materialNumber = material.getString("number");
            return new QFilter("pentry.proentrymaterialid.number", "<=", (Object)materialNumber);
        }
        return qFilter;
    }

    public static QFilter getMaterialFilter(IFormView view, AbstractFormDataModel model, String entryEntity) {
        DynamicObject material;
        QFilter qFilter2;
        QFilter qFilter = null;
        if (model.getValue("materialfrom_filter") != null) {
            DynamicObjectCollection materialColl = (DynamicObjectCollection)model.getValue("materialfrom_filter");
            qFilter = PlatFormQueryDataHelper.getMaterialFromQFilter(materialColl, entryEntity);
        }
        if (model.getValue("materialto_filter") != null && (qFilter2 = PlatFormQueryDataHelper.getMaterialToQFilter(material = (DynamicObject)model.getValue("materialto_filter"), entryEntity)) != null) {
            qFilter = qFilter == null ? qFilter2 : qFilter.and(qFilter2);
        }
        return qFilter;
    }

    public static QFilter getFeatureTypeFilter(IFormView view, AbstractFormDataModel model, String entryEntity) {
        DynamicObject featureType;
        QFilter qFilter2;
        QFilter qFilter = null;
        if (model.getValue("featurefrom_filter") != null) {
            DynamicObjectCollection featureTypeColl = (DynamicObjectCollection)model.getValue("featurefrom_filter");
            qFilter = PlatFormQueryDataHelper.getFeatureTypeFromQFilter(featureTypeColl, entryEntity);
        }
        if (model.getValue("featureto_filter") != null && (qFilter2 = PlatFormQueryDataHelper.getFeatureTypeToQFilter(featureType = (DynamicObject)model.getValue("featureto_filter"), entryEntity)) != null) {
            qFilter = qFilter == null ? qFilter2 : qFilter.and(qFilter2);
        }
        return qFilter;
    }

    public static QFilter getMaterialFromQFilter(DynamicObjectCollection materialColl, String entryEntity) {
        QFilter qFilter = null;
        if (materialColl != null && !materialColl.isEmpty()) {
            Set<Long> materialIdSet = PlatFormQueryDataHelper.getCollectionIdset(materialColl);
            if ("entry".equals(entryEntity)) {
                if (materialIdSet.size() == 1) {
                    DynamicObject material = (DynamicObject)materialColl.get(0);
                    String materialNumber = "";
                    materialNumber = material.containsProperty("number") ? material.getString("number") : material.getString("fbasedataid.number");
                    qFilter = new QFilter("entry.entrymaterialid.number", ">=", (Object)materialNumber);
                } else {
                    qFilter = new QFilter("entry.entrymaterialid", "in", materialIdSet);
                }
            } else {
                qFilter = new QFilter("id", "=", (Object)0L);
            }
        }
        return qFilter;
    }

    public static QFilter getMaterialToQFilter(DynamicObject material, String entryEntity) {
        if (material != null) {
            String materialNumber = material.getString("number");
            if ("entry".equals(entryEntity)) {
                return new QFilter("entry.entrymaterialid.number", "<=", (Object)materialNumber);
            }
            return new QFilter("id", "=", (Object)0L);
        }
        return null;
    }

    public static QFilter getFeatureTypeFromQFilter(DynamicObjectCollection featureTypeColl, String entryEntity) {
        QFilter qFilter = null;
        if (featureTypeColl != null && !featureTypeColl.isEmpty()) {
            Set<Long> featureTypeIdSet = PlatFormQueryDataHelper.getCollectionIdset(featureTypeColl);
            if ("entry".equals(entryEntity)) {
                if (featureTypeIdSet.size() == 1) {
                    DynamicObject featureType = (DynamicObject)featureTypeColl.get(0);
                    String featureTypeNumber = "";
                    featureTypeNumber = featureType.containsProperty("number") ? featureType.getString("number") : featureType.getString("fbasedataid.number");
                    qFilter = new QFilter("entry.featuretype.number", ">=", (Object)featureTypeNumber);
                } else {
                    qFilter = new QFilter("entry.featuretype", "in", featureTypeIdSet);
                }
            } else {
                return new QFilter("id", "=", (Object)0L);
            }
        }
        return qFilter;
    }

    public static QFilter getFeatureTypeToQFilter(DynamicObject featureType, String entryEntity) {
        if (featureType != null) {
            String featureTypeNumber = featureType.getString("number");
            if ("entry".equals(entryEntity)) {
                return new QFilter("entry.featuretype.number", "<=", (Object)featureTypeNumber);
            }
            return new QFilter("id", "=", (Object)0L);
        }
        return null;
    }

    public static QFilter getEntryModeFilter(IFormView view, AbstractFormDataModel model, String entryEntity) {
        if (PlatFormQueryDataHelper.isNullString(model.getValue("entrymode_filter"))) {
            return null;
        }
        String entrymodes = model.getValue("entrymode_filter").toString();
        return PlatFormQueryDataHelper.getEntryModeQFilter(entrymodes, entryEntity);
    }

    public static QFilter getEstimateStatusFilter(IFormView view, AbstractFormDataModel model, String entryEntity) {
        if (PlatFormQueryDataHelper.isNullString(model.getValue("estimatestatus_filter"))) {
            return null;
        }
        String estimatestatus = model.getValue("estimatestatus_filter").toString();
        return PlatFormQueryDataHelper.getEstimateStatusQFilter(estimatestatus, entryEntity);
    }

    public static QFilter getEntryModeQFilter(String entrymodes, String entryEntity) {
        Set entrymodeSet;
        if (entrymodes != null && !"".equals(entrymodes) && !(entrymodeSet = Arrays.stream(entrymodes.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet())).isEmpty()) {
            return new QFilter(entryEntity + "." + PlatFormQueryDataHelper.getEntryModeField(entryEntity), "in", entrymodeSet);
        }
        return null;
    }

    private static String getEntryModeField(String entryEntity) {
        return PlatFormQueryDataHelper.isCopEntry(entryEntity) ? "copentrymode" : "entrymode";
    }

    private static boolean isCopEntry(String entryEntity) {
        return "copentry".equals(entryEntity);
    }

    public static QFilter getEstimateStatusQFilter(String estimateStatus, String entryEntity) {
        Set status;
        if (estimateStatus != null && !"".equals(estimateStatus) && !(status = Arrays.stream(estimateStatus.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet())).isEmpty()) {
            return new QFilter(entryEntity + "." + PlatFormQueryDataHelper.getEstimateStatusField(entryEntity), "in", status);
        }
        return null;
    }

    private static String getEstimateStatusField(String entryEntity) {
        return PlatFormQueryDataHelper.isCopEntry(entryEntity) ? "copestimatestatus" : "estimatestatus";
    }

    public static QFilter getBillStatusFilter(IFormView view, AbstractFormDataModel model) {
        if (PlatFormQueryDataHelper.isNullString(model.getValue("billstatus_filter"))) {
            return null;
        }
        String billStatus = model.getValue("billstatus_filter").toString();
        return PlatFormQueryDataHelper.getBillStatusQFilter(billStatus);
    }

    public static QFilter getBillStatusQFilter(String billStatus) {
        Set status;
        if (billStatus != null && !"".equals(billStatus) && !(status = Arrays.stream(billStatus.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet())).isEmpty()) {
            return new QFilter("billstatus", "in", status);
        }
        return null;
    }

    public static Date getBeginDate(String createTimeSelect) {
        Date today = new Date();
        if ("A".equals(createTimeSelect)) {
            return today;
        }
        if ("B".equals(createTimeSelect)) {
            int year = DateUtils.getYear((Date)today);
            int month = DateUtils.getMonth((Date)today);
            return DateUtils.getFirstDayOfMonth((int)year, (int)month);
        }
        if ("C".equals(createTimeSelect)) {
            return DateUtils.addDay((Date)today, (int)-90);
        }
        if ("E".equals(createTimeSelect)) {
            return DateUtils.getWeekStart();
        }
        return null;
    }

    public static Date getEndDate(String createTimeSelect) {
        Date today = new Date();
        if ("A".equals(createTimeSelect)) {
            return today;
        }
        if ("B".equals(createTimeSelect)) {
            int year = DateUtils.getYear((Date)today);
            int month = DateUtils.getMonth((Date)today);
            return DateUtils.getLastDayOfMonth((int)year, (int)month);
        }
        if ("C".equals(createTimeSelect)) {
            return today;
        }
        if ("E".equals(createTimeSelect)) {
            return DateUtils.getWeekEnd();
        }
        return null;
    }

    public static QFilter getCreateTimeFilter(IFormView view, AbstractFormDataModel model) {
        if (PlatFormQueryDataHelper.isNullString(model.getValue("createtimeselect"))) {
            return null;
        }
        String createTimeSelect = model.getValue("createtimeselect").toString();
        Date startDate = null;
        Date endDate = null;
        if ("D".equals(createTimeSelect)) {
            DateRangeEdit createRangeEdit = (DateRangeEdit)view.getControl("createtime_filter");
            String keyCreatedatestart = createRangeEdit.getStartDateFieldKey();
            String keyCreatedateend = createRangeEdit.getEndDateFieldKey();
            if (model.getValue(keyCreatedatestart) != null) {
                startDate = (Date)model.getValue(keyCreatedatestart);
            }
            if (model.getValue(keyCreatedateend) != null) {
                endDate = (Date)model.getValue(keyCreatedateend);
            }
        } else {
            startDate = PlatFormQueryDataHelper.getBeginDate(createTimeSelect);
            endDate = PlatFormQueryDataHelper.getEndDate(createTimeSelect);
        }
        return PlatFormQueryDataHelper.getCreateTimeQFilter(startDate, endDate);
    }

    public static QFilter getCreateTimeQFilter(Date startDate, Date endDate) {
        QFilter qFilter = null;
        SimpleDateFormat sdfDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdfSec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (startDate != null) {
            try {
                startDate = sdfSec.parse(sdfDay.format(startDate) + " 00:00:00");
                qFilter = new QFilter("createtime", ">=", (Object)startDate);
            }
            catch (ParseException e) {
                logger.info("parseException1:" + e.getMessage());
            }
        }
        if (endDate != null) {
            try {
                endDate = sdfSec.parse(sdfDay.format(endDate) + " 23:59:59");
                qFilter = qFilter == null ? new QFilter("createtime", "<=", (Object)endDate) : qFilter.and(new QFilter("createtime", "<=", (Object)endDate));
            }
            catch (ParseException e) {
                logger.info("parseException2:" + e.getMessage());
            }
        }
        return qFilter;
    }

    private static Set<Long> getCollectionIdset(DynamicObjectCollection coll) {
        if (coll != null) {
            return coll.stream().map(m -> m.getLong("fbasedataid.id")).collect(Collectors.toSet());
        }
        return new HashSet<Long>(16);
    }

    public static QFilter getActTimeFilter(IFormView view, AbstractFormDataModel model, String entryEntity) {
        if (PlatFormQueryDataHelper.isNullString(model.getValue("acttimeselect"))) {
            return null;
        }
        String actTimeSelect = model.getValue("acttimeselect").toString();
        Date startDate = null;
        Date endDate = null;
        if ("D".equals(actTimeSelect)) {
            DateRangeEdit actRangeEdit = (DateRangeEdit)view.getControl("acttime_filter");
            String keyActtimestart = actRangeEdit.getStartDateFieldKey();
            String keyActtimeend = actRangeEdit.getEndDateFieldKey();
            if (model.getValue(keyActtimestart) != null) {
                startDate = (Date)model.getValue(keyActtimestart);
            }
            if (model.getValue(keyActtimeend) != null) {
                endDate = (Date)model.getValue(keyActtimeend);
            }
        } else {
            startDate = PlatFormQueryDataHelper.getBeginDate(actTimeSelect);
            endDate = PlatFormQueryDataHelper.getEndDate(actTimeSelect);
        }
        return PlatFormQueryDataHelper.getActTimeQFilter(startDate, endDate, entryEntity);
    }

    private static String getActtimeField(String entryEntity) {
        return PlatFormQueryDataHelper.isCopEntry(entryEntity) ? "copacttime" : "acttime";
    }

    public static QFilter getActTimeQFilter(Date startDate, Date endDate, String entryEntity) {
        QFilter qFilter = null;
        SimpleDateFormat sdfDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdfSec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String acttimeField = PlatFormQueryDataHelper.getActtimeField(entryEntity);
        if (startDate != null) {
            try {
                startDate = sdfSec.parse(sdfDay.format(startDate) + " 00:00:00");
                qFilter = new QFilter(entryEntity + "." + acttimeField, ">=", (Object)startDate);
            }
            catch (ParseException e) {
                logger.info("parseException1:" + e.getMessage());
            }
        }
        if (endDate != null) {
            try {
                endDate = sdfSec.parse(sdfDay.format(endDate) + " 23:59:59");
                qFilter = qFilter == null ? new QFilter(entryEntity + "." + acttimeField, "<=", (Object)endDate) : qFilter.and(new QFilter(entryEntity + "." + acttimeField, "<=", (Object)endDate));
            }
            catch (ParseException e) {
                logger.info("parseException2:" + e.getMessage());
            }
        }
        return qFilter;
    }

    public static void colseDataSetCache(String dataSetCacheId) {
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)dataSetCacheId);
        cacheDataSet.close();
    }

    public static String getECOBillSelectFields(boolean iscount) {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",pentry.ecobomid as ecobomid");
        sb.append(",pentry.ecorouteid as ecorouteid");
        if (!iscount) {
            sb.append(",org");
            sb.append(",billno");
            sb.append(",type");
            sb.append(",billstatus");
            sb.append(",createtime");
            sb.append(",auditdate");
            sb.append(",changetype");
            sb.append(",pentry");
            sb.append(",pentry.pentrybom as pentrybom");
            sb.append(",pentry.pentryroute as pentryroute");
            sb.append(",pentry.proentrymaterial as proentrymaterial");
            sb.append(",pentry.proentrymaterialid as proentrymaterialid");
            sb.append(",pentry.ecotype as ecotype");
            sb.append(",pentry.pentryvaliddate as pentryvaliddate");
        }
        return sb.toString();
    }

    public static String[] getECOBillSelectStr() {
        return new String[]{"id", "org", "billno", "type", "billstatus", "createtime", "auditdate", "changetype", "pentry", "pentrybom", "pentryroute", "proentrymaterial", "proentrymaterialid", "ecotype", "pentryvaliddate"};
    }

    public static String getECOBomSelectFields(boolean iscount) {
        StringBuilder sb = new StringBuilder();
        sb.append("id as ").append("ecobom");
        sb.append(",").append("entry").append(" as ").append("ecobomentryid");
        sb.append(",").append("entry").append(".entrymode as entrymode");
        if (!iscount) {
            sb.append(",").append("entry").append(".entrymaterialid as entrymaterialid");
            sb.append(",").append("entry").append(".entrymaterialid.number as entrymaterialnumber");
            sb.append(",").append("entry").append(".entrymaterialid.name as entrymaterialname");
            sb.append(",").append("entry").append(".featuretype as featuretype");
            sb.append(",").append("entry").append(".featuretype.number as featuretypenumber");
            sb.append(",").append("entry").append(".featuretype.name as featuretypename");
            sb.append(",").append("entry").append(".entrytype as entrytype");
            sb.append(",").append("entry").append(".entryunit as baseunit");
            sb.append(",").append("entry").append(".tranqty as tranqty");
            sb.append(",").append("entry").append(".transtartdate as transtartdate");
            sb.append(",").append("entry").append(".acttime as acttime");
            sb.append(",").append("entry").append(".entryvaliddate as entryvaliddate");
            sb.append(",").append("entry").append(".entryinvaliddate as entryinvaliddate");
            sb.append(",").append("entry").append(".entrybomentryid as ").append("entrybomentryid");
            sb.append(",").append("entry").append(".bomentry as ").append("bomentryid");
            sb.append(",").append("entry").append(".entryqtynumerator as entryqtynumerator");
            sb.append(",").append("entry").append(".entryqtydenominator as entryqtydenominator");
            sb.append(",").append("entry").append(".entrygroupno as entrygroupno");
            sb.append(",").append("entry").append(".entryrefno as entryrefno");
            sb.append(",").append("entry").append(".refkey as refkey");
            sb.append(",").append("entry").append(".groupkey as groupkey");
            sb.append(",").append("entry").append(".estimatestatus as estimatestatus");
            sb.append(",").append("entry").append(".usedqty as useqty");
            sb.append(",").append("entry").append(".iscanestimate as iscanestimate");
            sb.append(",").append("entry").append(".continuouspoint as continuouspoint");
            sb.append(",").append("entry").append(".seq as entryseq");
            sb.append(",").append("entry").append(".entryreplaceplan as entryreplaceplan");
            sb.append(",").append("entry").append(".entryreplacegroup as entryreplacegroup");
        }
        return sb.toString();
    }

    public static String[] getECOBomSelectArray(String afterChar) {
        return new String[]{afterChar + "ecobom", afterChar + "ecobomentryid", afterChar + "entrymode", afterChar + "entrymaterialid", afterChar + "entrymaterialnumber", afterChar + "entrymaterialname", afterChar + "featuretype", afterChar + "featuretypenumber", afterChar + "featuretypename", afterChar + "entrytype", afterChar + "baseunit", afterChar + "tranqty", afterChar + "transtartdate", afterChar + "acttime", afterChar + "entryvaliddate", afterChar + "entryinvaliddate", afterChar + "entrybomentryid", afterChar + "bomentryid", afterChar + "entryqtynumerator", afterChar + "entryqtydenominator", afterChar + "entrygroupno", afterChar + "entryrefno", afterChar + "groupkey", afterChar + "refkey", afterChar + "estimatestatus", afterChar + "useqty", afterChar + "continuouspoint", afterChar + "iscanestimate", afterChar + "entryseq", afterChar + "entryreplaceplan", afterChar + "entryreplacegroup"};
    }

    public static String[] getRenameAfterECOSelectArray(String afterChar, String type) {
        String[] beforeArray = PlatFormQueryDataHelper.getECOBomSelectArray("");
        if ("B".equals(type)) {
            beforeArray = PlatFormQueryDataHelper.getECORouteSelectArray("");
        } else if ("C".equals(type)) {
            beforeArray = PlatFormQueryDataHelper.getECOBomCopSelectArray("");
        }
        String[] afterArray = new String[beforeArray.length];
        for (int i = 0; i < beforeArray.length; ++i) {
            afterArray[i] = beforeArray[i] + " as " + afterChar + beforeArray[i];
        }
        return afterArray;
    }

    public static String[] getECOBomReturnSelectArray(String afterChar) {
        return new String[]{"ecobom", "ecobomentryid", "entrytype", afterChar + "ecobomentryid", "entrymode", "case when entrymode ='A' then 0 else entrymaterialid end as entrymaterialid", "case when entrymode ='A' then 0 else baseunit end as baseunit", "case when entrymode ='A' then 0 else featuretype end as beforefeaturetype", "newmaterialid", "afterfeaturetype", "newbaseunit", "tranqty", "transtartdate", "acttime", "entryvaliddate", "entryinvaliddate", "entrybomentryid", "case when bomentryid = 0 then entrybomentryid else bomentryid end as bomentryid", afterChar + "bomentryid", "case when entrymode ='B' then " + afterChar + "entryqtynumerator else entryqtynumerator end as entryqtynumerator", "case when entrymode ='B' then " + afterChar + "entryqtydenominator else entryqtydenominator end as entryqtydenominator", "entrygroupno", "entryrefno", "groupkey", "refkey", "estimatestatus", "useqty", "continuouspoint", "iscanestimate", "beforematerialnumber", "beforematerialname", "aftermaterialnumber", "aftermaterialname", "entryseq", "entryreplaceplan", "entryreplacegroup"};
    }

    public static String[] getECOBomSelectStr(String afterChar) {
        return new String[]{"ecobom", "ecobomentryid", afterChar + "ecobomentryid", "entrymode", "entrytype", "entrymaterialid", "beforefeaturetype", "afterfeaturetype", "baseunit", "newmaterialid", "newbaseunit", "tranqty", "transtartdate", "acttime", "entryvaliddate", "entryinvaliddate", "entrybomentryid", "bomentryid", afterChar + "bomentryid", "entryqtynumerator", "entryqtydenominator", "entrygroupno", "entryrefno", "groupkey", "refkey", "estimatestatus", "useqty", "continuouspoint", "iscanestimate", "beforematerialnumber", "beforematerialname", "aftermaterialnumber", "aftermaterialname", "entryseq", "entryreplaceplan", "entryreplacegroup"};
    }

    public static String getECOBomCopSelectFields(boolean iscount) {
        StringBuilder sb = new StringBuilder();
        sb.append("id as ").append("ecobom");
        sb.append(",").append("copentry").append(" as ").append("ecobomentryid");
        sb.append(",").append("copentry").append(".copentrymode as entrymode");
        if (!iscount) {
            sb.append(",").append("copentry").append(".copentrymaterialid as entrymaterialid");
            sb.append(",").append("copentry").append(".copentrymaterialid.number as entrymaterialnumber");
            sb.append(",").append("copentry").append(".copentrymaterialid.name as entrymaterialname");
            sb.append(",").append("copentry").append(".copentrytype as producttype");
            sb.append(",").append("copentry").append(".copentryunit as baseunit");
            sb.append(",").append("copentry").append(".copacttime as acttime");
            sb.append(",").append("copentry").append(".copentryvaliddate as entryvaliddate");
            sb.append(",").append("copentry").append(".copentryinvaliddate as entryinvaliddate");
            sb.append(",").append("copentry").append(".oldcopentryid as ").append("entrybomentryid");
            sb.append(",").append("copentry").append(".newcopentryid as ").append("bomentryid");
            sb.append(",").append("copentry").append(".copentryqty as entryqtynumerator");
            sb.append(",1 as entryqtydenominator");
            sb.append(",").append("copentry").append(".copestimatestatus as estimatestatus");
            sb.append(",").append("copentry").append(".seq as entryseq");
        }
        return sb.toString();
    }

    public static String[] getECOBomCopSelectArray(String afterChar) {
        return new String[]{afterChar + "ecobom", afterChar + "ecobomentryid", afterChar + "entrymode", afterChar + "entrymaterialid", afterChar + "entrymaterialnumber", afterChar + "entrymaterialname", afterChar + "producttype", afterChar + "baseunit", afterChar + "acttime", afterChar + "entryvaliddate", afterChar + "entryinvaliddate", afterChar + "entrybomentryid", afterChar + "bomentryid", afterChar + "entryqtynumerator", afterChar + "entryqtydenominator", afterChar + "estimatestatus", afterChar + "entryseq"};
    }

    public static String[] getECOBomCopReturnSelectArray(String afterChar) {
        return new String[]{"ecobom", "ecobomentryid", "producttype", afterChar + "ecobomentryid", "entrymode", "case when entrymode ='A' then 0 else entrymaterialid end as entrymaterialid", "case when entrymode ='A' then 0 else baseunit end as baseunit", "newmaterialid", "newbaseunit", "acttime", "entryvaliddate", "entryinvaliddate", "entrybomentryid", "case when bomentryid = 0 then entrybomentryid else bomentryid end as bomentryid", afterChar + "bomentryid", "case when entrymode ='B' then " + afterChar + "entryqtynumerator else entryqtynumerator end as entryqtynumerator", "case when entrymode ='B' then " + afterChar + "entryqtydenominator else entryqtydenominator end as entryqtydenominator", "estimatestatus", "beforematerialnumber", "beforematerialname", "aftermaterialnumber", "aftermaterialname", "entryseq"};
    }

    public static String[] getECOBomCopSelectStr(String afterChar) {
        return new String[]{"ecobom", "ecobomentryid", afterChar + "ecobomentryid", "entrymode", "producttype", "entrymaterialid", "baseunit", "newmaterialid", "newbaseunit", "acttime", "entryvaliddate", "entryinvaliddate", "entrybomentryid", "bomentryid", afterChar + "bomentryid", "entryqtynumerator", "entryqtydenominator", "estimatestatus", "beforematerialnumber", "beforematerialname", "aftermaterialnumber", "aftermaterialname", "entryseq"};
    }

    public static String getECORouteSelectFields(boolean iscount) {
        StringBuilder sb = new StringBuilder();
        sb.append("id as ").append("ecobom");
        sb.append(",").append("processentry").append(" as ").append("ecobomentryid");
        sb.append(",").append("processentry").append(".entrymode as entrymode");
        if (!iscount) {
            sb.append(",").append("processentry").append(".acttime as acttime");
            sb.append(",").append("processentry").append(".entryvaliddate as entryvaliddate");
            sb.append(",").append("processentry").append(".entryinvaliddate as entryinvaliddate");
            sb.append(",").append("processentry").append(".oldprocessentryid as ").append("entrybomentryid");
            sb.append(",").append("processentry").append(".newprocessentryid as ").append("bomentryid");
            sb.append(",").append("processentry").append(".estimatestatus as estimatestatus");
            sb.append(",").append("processentry").append(".operation as operation");
            sb.append(",").append("processentry").append(".parent as processseq");
            sb.append(",").append("processentry").append(".operationno as operationno");
            sb.append(",").append("processentry").append(".operationdesc as operdesc");
            sb.append(",").append("processentry").append(".seq as entryseq");
        }
        return sb.toString();
    }

    public static String[] getECORouteSelectArray(String afterChar) {
        return new String[]{afterChar + "ecobom", afterChar + "ecobomentryid", afterChar + "entrymode", afterChar + "acttime", afterChar + "entryvaliddate", afterChar + "entryinvaliddate", afterChar + "entrybomentryid", afterChar + "bomentryid", afterChar + "estimatestatus", afterChar + "operation", afterChar + "processseq", afterChar + "operationno", afterChar + "operdesc", afterChar + "entryseq"};
    }

    public static String[] getECORouteReturnSelectArray(String afterChar) {
        return new String[]{"ecobom", "ecobomentryid", afterChar + "ecobomentryid", "entrymode", "acttime", "entryvaliddate", "entryinvaliddate", "entrybomentryid", "case when bomentryid = 0 then entrybomentryid else bomentryid end as bomentryid", afterChar + "bomentryid", "estimatestatus", "operation", "processseq", "operationno", "operdesc", "entryseq"};
    }

    public static String[] getECORouteSelectStr(String afterChar) {
        return new String[]{"ecobom", "ecobomentryid", afterChar + "ecobomentryid", "entrymode", "acttime", "entryvaliddate", "entryinvaliddate", "entrybomentryid", "bomentryid", afterChar + "bomentryid", "estimatestatus", "operation", "processseq", "operationno", "operdesc", "entryseq"};
    }

    public static String bulidDataSetCache(QFilter ecoChangeBillfilterInfo, IFormView view, AbstractFormDataModel model, Object oldExtPlugin, PluginProxy<IEcoPlatFormQueryExt> newExtPlugin) {
        long startTime = System.currentTimeMillis();
        String algoKey = PlatFormQueryDataHelper.class.getName() + "_bulidDataSetCache";
        QFilter[] qFilters = new QFilter[]{ecoChangeBillfilterInfo};
        try (DataSet bomEcoDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pdm_bom_eco", (String)PlatFormQueryDataHelper.getECOBillSelectFields(false), (QFilter[])qFilters, (String)"id");){
            HashSet<Long> ecoBomIdSet = new HashSet<Long>(128);
            HashSet<Long> ecoRouteIdSet = new HashSet<Long>(128);
            Algo algo = Algo.create((String)PlatFormQueryDataHelper.class.getName());
            RowMeta rowMeta = bomEcoDs.getRowMeta();
            DataSetBuilder builderBom = algo.createDataSetBuilder(rowMeta);
            DataSetBuilder builderRoute = algo.createDataSetBuilder(rowMeta);
            while (bomEcoDs.hasNext()) {
                Row arow = bomEcoDs.next();
                Long ecoBomId = arow.getLong("ecobomid");
                Long ecoRouteId = arow.getLong("ecorouteid");
                if (!PlatformUtils.isNullLong((Long)ecoBomId)) {
                    ecoBomIdSet.add(ecoBomId);
                    builderBom.append(arow);
                }
                if (PlatformUtils.isNullLong((Long)ecoRouteId)) continue;
                ecoRouteIdSet.add(ecoRouteId);
                builderRoute.append(arow);
            }
            DataSet ecnBillBom = builderBom.build();
            DataSet ecnBillRoute = builderRoute.build();
            DataSet dataSetBom = null;
            DataSet dataSetBomCop = null;
            DataSet dataSetRoute = null;
            if (!ecoBomIdSet.isEmpty()) {
                QFilter ecoBomfilterInfo = PlatFormQueryDataHelper.getEcoBomFilters(view, model, ecoBomIdSet, oldExtPlugin, newExtPlugin);
                dataSetBom = PlatFormQueryDataHelper.bulidEcoBomDataSetCache(ecoBomfilterInfo, ecnBillBom);
                QFilter ecoBomCopfilterInfo = PlatFormQueryDataHelper.getEcoBomCopFilters(view, model, ecoBomIdSet, oldExtPlugin, newExtPlugin);
                dataSetBomCop = PlatFormQueryDataHelper.bulidEcoBomCopDataSetCache(ecoBomCopfilterInfo, ecnBillBom);
            }
            if (!ecoRouteIdSet.isEmpty()) {
                QFilter ecoRoutefilterInfo = PlatFormQueryDataHelper.getEcoRouteFilters(view, model, ecoRouteIdSet, oldExtPlugin, newExtPlugin);
                dataSetRoute = PlatFormQueryDataHelper.bulidEcoRouteDataSetCache(ecoRoutefilterInfo, ecnBillRoute);
            }
            DataSet dataSet = PlatFormQueryDataHelper.mergeDataSet(dataSetBom, dataSetBomCop);
            dataSet = PlatFormQueryDataHelper.mergeDataSet(dataSet, dataSetRoute);
            dataSet = PlatFormQueryDataHelper.extDataSetResultDeal(dataSet, oldExtPlugin, newExtPlugin);
            List<String> orderFieldList = Arrays.asList("createtime desc", "id desc", "pentry asc");
            if (PlatFormQueryDataHelper.isExistsField(dataSet, "entryseq")) {
                orderFieldList = Arrays.asList("createtime desc", "id desc", "pentry asc", "entryseq asc");
            }
            dataSet = dataSet.orderBy(orderFieldList.toArray(new String[orderFieldList.size()]));
            CacheHint hint = new CacheHint();
            hint.setTimeout(3600000L);
            CachedDataSet cache = dataSet.cache(hint);
            dataSet.close();
            ecnBillRoute.close();
            ecnBillBom.close();
            long endTime = System.currentTimeMillis();
            logger.info("\u5de5\u7a0b\u53d8\u66f4\u63a7\u5236\u53f0\u6570\u636e\u67e5\u8be2dataset\u8017\u65f6:" + (endTime - startTime) + "ms");
            String string = cache.getCacheId();
            return string;
        }
    }

    private static boolean isExistsField(DataSet ds, String field) {
        Set<String> fieldSet = PlatFormQueryDataHelper.getAllFields(ds);
        return fieldSet.contains(field);
    }

    private static DataSet bulidEcoBomDataSetCache(QFilter ecoBomfilterInfo, DataSet ecnBillDataSet) {
        String algoKey = PlatFormQueryDataHelper.class.getName() + "_bulidEcoBomDataSetCache";
        DataSet pdmEcoDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pdm_ecobom", (String)PlatFormQueryDataHelper.getECOBomSelectFields(false), (QFilter[])new QFilter[]{ecoBomfilterInfo}, (String)"id");
        DataSet changeBefore = pdmEcoDataSet.filter("entrymode in ('A','B','E') ").select(PlatFormQueryDataHelper.getECOBomSelectArray(""));
        DataSet changeAfter = pdmEcoDataSet.filter("entrymode = 'C' ").select(PlatFormQueryDataHelper.getRenameAfterECOSelectArray(AFTER_CHAR, "A"));
        JoinDataSet pdmEcoJoinDataSet = changeBefore.leftJoin(changeAfter).on("ecobom", "afterecobom").on("entrybomentryid", "afterentrybomentryid");
        pdmEcoDataSet = pdmEcoJoinDataSet.select(PlatFormQueryDataHelper.getECOBomSelectArray(""), PlatFormQueryDataHelper.getECOBomSelectArray(AFTER_CHAR)).finish();
        pdmEcoDataSet = pdmEcoDataSet.addField("case when entrymode ='A' then entrymaterialid when entrymode ='B' then afterentrymaterialid else 0 end", "newmaterialid");
        pdmEcoDataSet = pdmEcoDataSet.addField("case when entrymode ='A' then baseunit when entrymode ='B' then afterbaseunit else 0 end", "newbaseunit");
        pdmEcoDataSet = pdmEcoDataSet.addField("case when entrymode ='A' then featuretype when entrymode ='B' then afterfeaturetype else 0 end", "afterfeaturetype");
        pdmEcoDataSet = pdmEcoDataSet.addField("(case when entrytype = 'A' then (case when entrymode ='A' then ''  else entrymaterialnumber end) else (case when entrymode ='A' then ''  else featuretypenumber end) end )", "beforematerialnumber");
        pdmEcoDataSet = pdmEcoDataSet.addField("(case when entrytype = 'A' then (case when entrymode ='A' then ''  else entrymaterialname end) else (case when entrymode ='A' then ''  else featuretypename end) end )", "beforematerialname");
        pdmEcoDataSet = pdmEcoDataSet.addField("(case when entrytype = 'A' then (case when entrymode ='A' then entrymaterialnumber when entrymode ='B' then afterentrymaterialnumber else '' end) else (case when entrymode ='A' then featuretypenumber when entrymode ='B' then afterfeaturetypenumber else '' end) end )", "aftermaterialnumber");
        pdmEcoDataSet = pdmEcoDataSet.addField("(case when entrytype = 'A' then (case when entrymode ='A' then entrymaterialname when entrymode ='B' then afterentrymaterialname else '' end) else (case when entrymode ='A' then featuretypename when entrymode ='B' then afterfeaturetypename else '' end) end )", "aftermaterialname");
        pdmEcoDataSet = pdmEcoDataSet.select(PlatFormQueryDataHelper.getECOBomReturnSelectArray(AFTER_CHAR));
        JoinDataSet joinDataSet = ecnBillDataSet.join(pdmEcoDataSet, JoinType.INNER).on("ecobomid", "ecobom");
        DataSet dataSet = joinDataSet.select(PlatFormQueryDataHelper.getECOBillSelectStr(), PlatFormQueryDataHelper.getECOBomSelectStr(AFTER_CHAR)).finish();
        dataSet = dataSet.addField("(tranqty -  useqty)", "remainderqty");
        dataSet = dataSet.addField("(case when tranqty = 0 then 0 else useqty / tranqty end ) * 100", "progress");
        dataSet = dataSet.addField(PlatFormQueryDataHelper.getChangeDetails(), "changedetails");
        dataSet = dataSet.addField("(case when newbaseunit = 0 then baseunit else newbaseunit end )", "allunit");
        dataSet = dataSet.addField("'10000'", "producttype");
        return dataSet;
    }

    private static DataSet bulidEcoBomCopDataSetCache(QFilter ecoBomCopfilterInfo, DataSet ecnBillDataSet) {
        String algoKey = PlatFormQueryDataHelper.class.getName() + "_bulidEcoBomCopDataSetCache";
        DataSet pdmEcoDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pdm_ecobom", (String)PlatFormQueryDataHelper.getECOBomCopSelectFields(false), (QFilter[])new QFilter[]{ecoBomCopfilterInfo}, (String)"id");
        DataSet changeBefore = pdmEcoDataSet.filter("entrymode in ('A','B','E') ").select(PlatFormQueryDataHelper.getECOBomCopSelectArray(""));
        DataSet changeAfter = pdmEcoDataSet.filter("entrymode = 'C' ").select(PlatFormQueryDataHelper.getRenameAfterECOSelectArray(AFTER_CHAR, "C"));
        JoinDataSet pdmEcoJoinDataSet = changeBefore.leftJoin(changeAfter).on("ecobom", "afterecobom").on("entrybomentryid", "afterentrybomentryid");
        pdmEcoDataSet = pdmEcoJoinDataSet.select(PlatFormQueryDataHelper.getECOBomCopSelectArray(""), PlatFormQueryDataHelper.getECOBomCopSelectArray(AFTER_CHAR)).finish();
        pdmEcoDataSet = pdmEcoDataSet.addField("case when entrymode ='A' then entrymaterialid when entrymode ='B' then afterentrymaterialid else 0 end", "newmaterialid");
        pdmEcoDataSet = pdmEcoDataSet.addField("case when entrymode ='A' then baseunit when entrymode ='B' then afterbaseunit else 0 end", "newbaseunit");
        pdmEcoDataSet = pdmEcoDataSet.addField("(case when entrymode ='A' then ''  else entrymaterialnumber end)", "beforematerialnumber");
        pdmEcoDataSet = pdmEcoDataSet.addField("(case when entrymode ='A' then ''  else entrymaterialname end)", "beforematerialname");
        pdmEcoDataSet = pdmEcoDataSet.addField("(case when entrymode ='A' then entrymaterialnumber when entrymode ='B' then afterentrymaterialnumber else '' end)", "aftermaterialnumber");
        pdmEcoDataSet = pdmEcoDataSet.addField("(case when entrymode ='A' then entrymaterialname when entrymode ='B' then afterentrymaterialname else '' end)", "aftermaterialname");
        pdmEcoDataSet = pdmEcoDataSet.select(PlatFormQueryDataHelper.getECOBomCopReturnSelectArray(AFTER_CHAR));
        JoinDataSet joinDataSet = ecnBillDataSet.join(pdmEcoDataSet, JoinType.INNER).on("ecobomid", "ecobom");
        DataSet dataSet = joinDataSet.select(PlatFormQueryDataHelper.getECOBillSelectStr(), PlatFormQueryDataHelper.getECOBomCopSelectStr(AFTER_CHAR)).finish();
        dataSet = dataSet.addField(PlatFormQueryDataHelper.getChangeDetails(), "changedetails");
        dataSet = dataSet.addField("(case when newbaseunit = 0 then baseunit else newbaseunit end )", "allunit");
        return dataSet;
    }

    private static DataSet bulidEcoRouteDataSetCache(QFilter ecoRoutefilterInfo, DataSet ecnBillDataSet) {
        String algoKey = PlatFormQueryDataHelper.class.getName() + "_bulidEcoRouteDataSetCache";
        DataSet pdmEcoDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pdm_ecoroute", (String)PlatFormQueryDataHelper.getECORouteSelectFields(false), (QFilter[])new QFilter[]{ecoRoutefilterInfo}, (String)"id");
        DataSet changeBefore = pdmEcoDataSet.filter("entrymode in ('A','B','E') ").select(PlatFormQueryDataHelper.getECORouteSelectArray(""));
        DataSet changeAfter = pdmEcoDataSet.filter("entrymode = 'C' ").select(PlatFormQueryDataHelper.getRenameAfterECOSelectArray(AFTER_CHAR, "B"));
        JoinDataSet pdmEcoJoinDataSet = changeBefore.leftJoin(changeAfter).on("ecobom", "afterecobom").on("entrybomentryid", "afterentrybomentryid");
        pdmEcoDataSet = pdmEcoJoinDataSet.select(PlatFormQueryDataHelper.getECORouteSelectArray(""), PlatFormQueryDataHelper.getECORouteSelectArray(AFTER_CHAR)).finish();
        pdmEcoDataSet = pdmEcoDataSet.select(PlatFormQueryDataHelper.getECORouteReturnSelectArray(AFTER_CHAR));
        JoinDataSet joinDataSet = ecnBillDataSet.join(pdmEcoDataSet, JoinType.INNER).on("ecorouteid", "ecobom");
        DataSet dataSet = joinDataSet.select(PlatFormQueryDataHelper.getECOBillSelectStr(), PlatFormQueryDataHelper.getECORouteSelectStr(AFTER_CHAR)).finish();
        dataSet = dataSet.addField(PlatFormQueryDataHelper.getChangeDetails(), "changedetails");
        return dataSet;
    }

    private static String getChangeDetails() {
        return ResManager.loadKDString((String)"'\u4fee\u6539\u8be6\u60c5'", (String)"PlatFormQueryDataHelper_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    public static Set<String> getCacheDataSetAllFields(CachedDataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        HashSet<String> allFieldName = new HashSet<String>(fields.length);
        for (Field field : fields) {
            allFieldName.add(field.getName());
        }
        return allFieldName;
    }

    public static int loadDataByCache(String cacheId, TableValueSetter vs, int rowNumber, int pageNum, int pageSize, Object oldExtPlugin, PluginProxy<IEcoPlatFormQueryExt> newExtPlugin) {
        int count = 0;
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
        count = cacheDataSet.getRowCount();
        if (count == 0 || pageNum == 0) {
            return 0;
        }
        if (PlatFormQueryDataHelper.isAllPage(pageSize)) {
            pageSize = count;
        }
        int fromIndex = (pageNum - 1) * pageSize;
        List pageRows = cacheDataSet.getList(fromIndex, pageSize);
        Set<String> allFieldSet = PlatFormQueryDataHelper.getCacheDataSetAllFields(cacheDataSet);
        Map<String, String> extFieldMap = PlatFormQueryDataHelper.extLoadDataFiedlMapDeal(oldExtPlugin, newExtPlugin);
        for (Row dyn : pageRows) {
            String dataSetField;
            String gridField;
            for (Map.Entry<String, String> maps : MAP_LONG.entrySet()) {
                gridField = maps.getKey();
                dataSetField = maps.getValue();
                if (allFieldSet.contains(dataSetField)) {
                    vs.set(gridField, (Object)dyn.getLong(dataSetField), rowNumber);
                    continue;
                }
                vs.set(gridField, (Object)0L, rowNumber);
            }
            for (Map.Entry<String, String> maps : MAP_STRING.entrySet()) {
                gridField = maps.getKey();
                dataSetField = maps.getValue();
                if (allFieldSet.contains(dataSetField)) {
                    vs.set(gridField, (Object)dyn.getString(dataSetField), rowNumber);
                    continue;
                }
                vs.set(gridField, (Object)"", rowNumber);
            }
            for (Map.Entry<String, String> maps : MAP_DATE.entrySet()) {
                gridField = maps.getKey();
                dataSetField = maps.getValue();
                if (allFieldSet.contains(dataSetField)) {
                    vs.set(gridField, (Object)dyn.getDate(dataSetField), rowNumber);
                    continue;
                }
                vs.set(gridField, null, rowNumber);
            }
            for (Map.Entry<String, String> maps : MAP_BIGDECIMAL.entrySet()) {
                gridField = maps.getKey();
                dataSetField = maps.getValue();
                if (allFieldSet.contains(dataSetField)) {
                    vs.set(gridField, (Object)dyn.getBigDecimal(dataSetField), rowNumber);
                    continue;
                }
                vs.set(gridField, (Object)BigDecimal.ZERO, rowNumber);
            }
            for (Map.Entry<String, String> maps : MAP_BOOLEAN.entrySet()) {
                gridField = maps.getKey();
                dataSetField = maps.getValue();
                if (allFieldSet.contains(dataSetField)) {
                    vs.set(gridField, (Object)dyn.getBoolean(dataSetField), rowNumber);
                    continue;
                }
                vs.set(gridField, (Object)Boolean.FALSE, rowNumber);
            }
            if (extFieldMap != null) {
                for (Map.Entry<String, String> maps : extFieldMap.entrySet()) {
                    gridField = maps.getKey();
                    dataSetField = maps.getValue();
                    if (allFieldSet.contains(dataSetField)) {
                        vs.set(gridField, dyn.get(dataSetField), rowNumber);
                        continue;
                    }
                    vs.set(gridField, null, rowNumber);
                }
            }
            ++rowNumber;
        }
        return count;
    }

    public static void fillDatas(IFormView view, AbstractFormDataModel model) {
        model.deleteEntryData("entryentitys");
        Object oldExtPlugin = PlatFormQueryDataHelper.getExtPlugin();
        PluginProxy<IEcoPlatFormQueryExt> newExtPlugin = PlatFormQueryDataHelper.genExtPluginxy();
        QFilter filter = PlatFormQueryDataHelper.getEcoBillFilters(view, model, oldExtPlugin, newExtPlugin);
        if (filter == null) {
            logger.info("----filter is null no query data");
            return;
        }
        String cacheId = view.getPageCache().get("dataset_cache");
        if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
            try {
                PlatFormQueryDataHelper.colseDataSetCache(cacheId);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        cacheId = PlatFormQueryDataHelper.bulidDataSetCache(filter, view, model, oldExtPlugin, newExtPlugin);
        view.getPageCache().put("dataset_cache", cacheId);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        model.beginInit();
        int pagesize = 20;
        if (model.getValue("pagesize") != null) {
            String pageSize = (String)model.getValue("pagesize");
            pagesize = Integer.parseInt(pageSize);
        }
        Long startTime = System.currentTimeMillis();
        int count = PlatFormQueryDataHelper.loadDataByCache(cacheId, vs, 0, 1, pagesize, oldExtPlugin, newExtPlugin);
        view.getPageCache().put("count_cache", String.valueOf(count));
        Label sumLab = (Label)view.getControl("sumlabelap");
        int pageCount = 0;
        pageCount = count % pagesize == 0 ? count / pagesize : count / pagesize + 1;
        sumLab.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u9875", (String)"PlatFormQueryDataHelper_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), pageCount));
        model.batchCreateNewEntryRow("entryentitys", vs);
        model.endInit();
        view.updateView("entryentitys");
        model.setValue("pageindex", (Object)1);
        Long endTime = System.currentTimeMillis();
        logger.info("\u53d8\u66f4\u63a7\u5236\u53f0\u6570\u636e\u52a0\u8f7d\u82b1\u8d39" + (endTime - startTime) + "ms");
    }

    public static void atFirst(IDataModel model) {
        model.setValue("pageindex", (Object)1);
    }

    public static void toFront(IDataModel model) {
        int pageIndex;
        int frontIndex;
        if (model.getValue("pageindex") != null && (frontIndex = (pageIndex = ((Integer)model.getValue("pageindex")).intValue()) - 1) >= 1) {
            model.setValue("pageindex", (Object)frontIndex);
        }
    }

    public static void toBack(IDataModel model, int count) {
        int pageIndex;
        int backIndex;
        int pagesize = 20;
        if (model.getValue("pagesize") != null) {
            String pageSize = (String)model.getValue("pagesize");
            pagesize = Integer.parseInt(pageSize);
        }
        int pageCount = 0;
        pageCount = count % pagesize == 0 ? count / pagesize : count / pagesize + 1;
        if (model.getValue("pageindex") != null && (backIndex = (pageIndex = ((Integer)model.getValue("pageindex")).intValue()) + 1) >= 1 && backIndex <= pageCount) {
            model.setValue("pageindex", (Object)backIndex);
        }
    }

    public static void toLast(IDataModel model, int count) {
        int pagesize = 20;
        if (model.getValue("pagesize") != null) {
            String pageSize = (String)model.getValue("pagesize");
            pagesize = Integer.parseInt(pageSize);
        }
        int pageCount = 0;
        pageCount = count % pagesize == 0 ? count / pagesize : count / pagesize + 1;
        model.setValue("pageindex", (Object)pageCount);
    }

    public static void toPageIndex(IFormView view, AbstractFormDataModel model, int pageIndex) {
        String countStr = view.getPageCache().get("count_cache");
        int count = 0;
        if (StringUtils.isNotEmpty((CharSequence)countStr)) {
            count = Integer.parseInt(countStr);
        }
        Label sumLab = (Label)view.getControl("sumlabelap");
        Integer pageCount = 0;
        int pagesize = 20;
        if (model.getValue("pagesize") != null) {
            String pageSize = String.valueOf(model.getValue("pagesize"));
            pagesize = Integer.parseInt(pageSize);
        }
        pageCount = count % pagesize == 0 ? Integer.valueOf(count / pagesize) : Integer.valueOf(count / pagesize + 1);
        sumLab.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u9875", (String)"PlatFormQueryDataHelper_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), pageCount));
        if (pageIndex > pageCount) {
            pageIndex = pageCount;
            model.beginInit();
            model.setValue("pageindex", (Object)pageIndex);
            model.endInit();
            return;
        }
        model.deleteEntryData("entryentitys");
        Object oldExtPlugin = PlatFormQueryDataHelper.getExtPlugin();
        PluginProxy<IEcoPlatFormQueryExt> newExtPlugin = PlatFormQueryDataHelper.genExtPluginxy();
        model.beginInit();
        String cacheId = view.getPageCache().get("dataset_cache");
        if (StringUtils.isEmpty((CharSequence)cacheId)) {
            QFilter filterInfo = PlatFormQueryDataHelper.getEcoBillFilters(view, model, oldExtPlugin, newExtPlugin);
            cacheId = PlatFormQueryDataHelper.bulidDataSetCache(filterInfo, view, model, oldExtPlugin, newExtPlugin);
            view.getPageCache().put("dataset_cache", cacheId);
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        count = PlatFormQueryDataHelper.loadDataByCache(cacheId, vs, 0, pageIndex, pagesize, oldExtPlugin, newExtPlugin);
        view.getPageCache().put("count_cache", String.valueOf(count));
        model.batchCreateNewEntryRow("entryentitys", vs);
        model.endInit();
        view.updateView("entryentitys");
    }

    private static boolean isAllPage(int pagesize) {
        return pagesize == 99999;
    }

    public static void toPageSize(IFormView view, AbstractFormDataModel model, int pagesize) {
        Integer pageCount = 0;
        String countStr = view.getPageCache().get("count_cache");
        int count = 0;
        if (StringUtils.isNotEmpty((CharSequence)countStr)) {
            count = Integer.parseInt(countStr);
        }
        pageCount = PlatFormQueryDataHelper.isAllPage(pagesize) ? Integer.valueOf(1) : (count % pagesize == 0 ? Integer.valueOf(count / pagesize) : Integer.valueOf(count / pagesize + 1));
        Label sumLab = (Label)view.getControl("sumlabelap");
        sumLab.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u9875", (String)"PlatFormQueryDataHelper_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), pageCount));
        model.deleteEntryData("entryentitys");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        String cacheId = view.getPageCache().get("dataset_cache");
        if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
            model.beginInit();
            Object oldExtPlugin = PlatFormQueryDataHelper.getExtPlugin();
            PluginProxy<IEcoPlatFormQueryExt> newExtPlugin = PlatFormQueryDataHelper.genExtPluginxy();
            count = PlatFormQueryDataHelper.loadDataByCache(cacheId, vs, 0, 1, pagesize, oldExtPlugin, newExtPlugin);
            model.setValue("pageindex", (Object)1);
            view.getPageCache().put("count_cache", String.valueOf(count));
            model.batchCreateNewEntryRow("entryentitys", vs);
            model.endInit();
            view.updateView("entryentitys");
            view.updateView("pageindex");
        }
    }

    public static boolean isNullString(Object obj) {
        return obj == null || kd.bos.util.StringUtils.isEmpty((String)obj.toString());
    }

    public static boolean isNullLong(Long obj) {
        return obj == null || obj.equals(0L);
    }

    public static Map<Long, Map<String, Object>> getBomEntryData(Set<Long> bomentryIdSet) {
        if (bomentryIdSet.isEmpty()) {
            return Collections.emptyMap();
        }
        String algoKey = PlatFormQueryDataHelper.class.getName() + "getBomEntryData";
        HashMap<Long, Map<String, Object>> dataMap = new HashMap<Long, Map<String, Object>>(bomentryIdSet.size());
        QFilter filter = new QFilter("entry.id", "in", bomentryIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = "entry.id as entryid,entry.entryvaliddate entryvaliddate ,entry.entryinvaliddate entryinvaliddate";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pdm_mftbom", (String)selectProperties, (QFilter[])qFilters, (String)"id");){
            while (ds.hasNext()) {
                Row arow = ds.next();
                Long entryId = arow.getLong("entryid");
                HashMap<String, Date> bomMap = new HashMap<String, Date>(16);
                bomMap.put("entryvaliddate", arow.getDate("entryvaliddate"));
                bomMap.put("entryinvaliddate", arow.getDate("entryinvaliddate"));
                dataMap.put(entryId, bomMap);
            }
        }
        return dataMap;
    }

    private static String getEcoBillDataSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",org");
        sb.append(",billno");
        sb.append(",name");
        sb.append(",billno");
        sb.append(",billstatus");
        sb.append(",changetype");
        sb.append(",pentry");
        sb.append(",pentry.pentrybom");
        sb.append(",pentry.pentryroute");
        sb.append(",pentry.pentryvaliddate");
        sb.append(",pentry.proentrymaterial");
        sb.append(",pentry.proentrymaterialid");
        sb.append(",pentry.ecotype");
        sb.append(",pentry.ecobomid ");
        sb.append(",pentry.ecorouteid ");
        return sb.toString();
    }

    public static Map<Long, DynamicObject> getEcoBillData(Set<Long> ecoIdSet) {
        DynamicObject[] coll;
        if (ecoIdSet.isEmpty()) {
            return new HashMap<Long, DynamicObject>(16);
        }
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(ecoIdSet.size());
        QFilter filter = new QFilter("id", "in", ecoIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = PlatFormQueryDataHelper.getEcoBillDataSelectProperties();
        for (DynamicObject dy : coll = BusinessDataServiceHelper.load((String)"pdm_bom_eco", (String)selectProperties, (QFilter[])qFilters)) {
            dataMap.put(dy.getLong("id"), dy);
        }
        return dataMap;
    }

    private static String getEcoBomDataSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append(" entryid ");
        sb.append(",entrymode ");
        sb.append(",entrymaterial ");
        sb.append(",featuretype ");
        sb.append(",entryunit ");
        sb.append(",tranqty ");
        sb.append(",transtartdate ");
        sb.append(",acttime ");
        sb.append(",minacttime ");
        sb.append(",entryvaliddate ");
        sb.append(",entryinvaliddate ");
        sb.append(",entryqtynumerator ");
        sb.append(",entryqtydenominator ");
        sb.append(",entryfixscrap ");
        sb.append(",entryscraprate ");
        sb.append(",entryconfiguredcode ");
        sb.append(",entryqtytype ");
        sb.append(",entryauxproperty ");
        sb.append(",bomentry ");
        sb.append(",entrybomentryid ");
        sb.append(",ecobomid ");
        sb.append(",entrygroupno ");
        sb.append(",entryrefno ");
        sb.append(",estimatestatus ");
        sb.append(",groupkey ");
        sb.append(",refkey ");
        sb.append(",entryseq ");
        sb.append(",iscanestimate ");
        sb.append(",continuouspoint ");
        sb.append(",entryreplaceplan ");
        sb.append(",entryreplacegroup ");
        return sb.toString();
    }

    private static String getEcoBomCopDataSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append(" entryid ");
        sb.append(",copentrymode ");
        sb.append(",copentrytype ");
        sb.append(",copentrymaterial ");
        sb.append(",copentrymaterialid ");
        sb.append(",copentryversion ");
        sb.append(",copentryqty ");
        sb.append(",copacttime ");
        sb.append(",copentryvaliddate ");
        sb.append(",copentryinvaliddate ");
        sb.append(",entryseq ");
        sb.append(",newcopentryid ");
        sb.append(",oldcopentryid ");
        sb.append(",ecobomid ");
        sb.append(",copentryunit ");
        sb.append(",estimatestatus ");
        sb.append(",esremark ");
        return sb.toString();
    }

    private static String getEcoRouteDataSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append(" entryid ");
        sb.append(",entrymode ");
        sb.append(",parent ");
        sb.append(",operationno ");
        sb.append(",machiningtype ");
        sb.append(",productionorg ");
        sb.append(",workcenter ");
        sb.append(",operation ");
        sb.append(",operationdesc ");
        sb.append(",oprctrlstrategy ");
        sb.append(",entryvaliddate ");
        sb.append(",entryinvaliddate ");
        sb.append(",ecorouteid ");
        sb.append(",acttime ");
        sb.append(",oldprocessentryid ");
        sb.append(",newprocessentryid ");
        sb.append(",esremark ");
        sb.append(",entryseq ");
        sb.append(",minacttime ");
        sb.append(",estimatestatus ");
        return sb.toString();
    }

    public static Map<Long, DynamicObject> getEcoBomData(Set<Long> ecoBomEntryIdSet) {
        if (ecoBomEntryIdSet.isEmpty()) {
            return new HashMap<Long, DynamicObject>(16);
        }
        QFilter filter = new QFilter("entryid", "in", ecoBomEntryIdSet);
        return PlatFormQueryDataHelper.getEcoBomData(filter);
    }

    public static Map<Long, DynamicObject> getEcoBomCopData(Set<Long> ecoBomCopEntryIdSet) {
        if (ecoBomCopEntryIdSet.isEmpty()) {
            return new HashMap<Long, DynamicObject>(16);
        }
        QFilter filter = new QFilter("entryid", "in", ecoBomCopEntryIdSet);
        return PlatFormQueryDataHelper.getEcoBomCopData(filter);
    }

    public static Map<Long, DynamicObject> getEcoRouteData(Set<Long> ecoRouteEntryIdSet) {
        if (ecoRouteEntryIdSet.isEmpty()) {
            return new HashMap<Long, DynamicObject>(16);
        }
        QFilter filter = new QFilter("entryid", "in", ecoRouteEntryIdSet);
        return PlatFormQueryDataHelper.getEcoRouteData(filter);
    }

    public static Map<Long, DynamicObject> getEcoBomData(Long ecoBomId) {
        if (ecoBomId == null || ecoBomId.equals(0L)) {
            return new HashMap<Long, DynamicObject>(16);
        }
        QFilter filter = new QFilter("ecobomid", "=", (Object)ecoBomId);
        return PlatFormQueryDataHelper.getEcoBomData(filter);
    }

    public static Map<Long, DynamicObject> getEcoBomData(QFilter filter) {
        DynamicObject[] coll;
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(16);
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = PlatFormQueryDataHelper.getEcoBomDataSelectProperties();
        for (DynamicObject dy : coll = BusinessDataServiceHelper.load((String)"pdm_ecobom_entryf7", (String)selectProperties, (QFilter[])qFilters)) {
            dataMap.put(dy.getLong("entryid"), dy);
        }
        return dataMap;
    }

    public static Map<Long, DynamicObject> getEcoBomCopData(QFilter filter) {
        DynamicObject[] coll;
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(16);
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = PlatFormQueryDataHelper.getEcoBomCopDataSelectProperties();
        for (DynamicObject dy : coll = BusinessDataServiceHelper.load((String)"pdm_ecobomcopentry_f7", (String)selectProperties, (QFilter[])qFilters)) {
            dataMap.put(dy.getLong("entryid"), dy);
        }
        return dataMap;
    }

    public static Map<Long, DynamicObject> getEcoRouteData(QFilter filter) {
        DynamicObject[] coll;
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(16);
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = PlatFormQueryDataHelper.getEcoRouteDataSelectProperties();
        for (DynamicObject dy : coll = BusinessDataServiceHelper.load((String)"pdm_ecoroute_entryf7", (String)selectProperties, (QFilter[])qFilters)) {
            dataMap.put(dy.getLong("entryid"), dy);
        }
        return dataMap;
    }

    public static Map<Long, DynamicObject> getMftBomEntryData(Set<Long> mftBomEntryIdSet) {
        return EcoUtils.getMftBomEntryData(mftBomEntryIdSet);
    }

    private static String getErrorMsg(OperationResult operationResult) {
        return PlatformUtils.getErrorMsg((OperationResult)operationResult);
    }

    public static Map<String, Object> executeOperation(Set<Long> ecoBillIdSet, String operatekey) {
        if (!ecoBillIdSet.isEmpty()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ignorewarn", String.valueOf(true));
            operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
            operateOption.setVariableValue("strictvalidation", String.valueOf(true));
            operateOption.setVariableValue("needlog", String.valueOf(true));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)operatekey, (String)"pdm_bom_eco", (Object[])ecoBillIdSet.toArray(), (OperateOption)operateOption);
            String errorMsg = PlatFormQueryDataHelper.getErrorMsg(operationResult);
            HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
            returnMap.put("msg", errorMsg == null ? "" : errorMsg);
            returnMap.put("successpkids", operationResult.getSuccessPkIds());
            return returnMap;
        }
        return null;
    }

    public static Map<Long, Map<String, Object>> getEcoBillEntryNewData(List<Object> ecoIdSet) {
        if (ecoIdSet.isEmpty()) {
            return Collections.emptyMap();
        }
        String algoKey = PlatFormQueryDataHelper.class.getName() + "getEcoBillHeadData";
        HashMap<Long, Map<String, Object>> dataMap = new HashMap<Long, Map<String, Object>>(ecoIdSet.size());
        QFilter filter = new QFilter("id", "in", ecoIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = "id,billstatus,auditdate,pentry as pentryid,pentry.ecotype as ecotype";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pdm_bom_eco", (String)selectProperties, (QFilter[])qFilters, (String)"id");){
            while (ds.hasNext()) {
                Row arow = ds.next();
                Long entryId = arow.getLong("pentryid");
                HashMap<String, Object> bomMap = new HashMap<String, Object>(16);
                bomMap.put("billstatus", arow.getString("billstatus"));
                bomMap.put("auditdate", arow.getDate("auditdate"));
                bomMap.put("ecotype", arow.getLong("ecotype"));
                dataMap.put(entryId, bomMap);
            }
        }
        return dataMap;
    }

    private static Long getfirstOrgId(List<Long> orgIdList, Long defOrgId) {
        Long firstOrgId = 0L;
        if (!orgIdList.isEmpty()) {
            firstOrgId = orgIdList.contains(defOrgId) ? defOrgId : orgIdList.get(0);
        }
        return firstOrgId;
    }

    public static DynamicObjectCollection getCurrentDefaultOrg() {
        Long firstOrgId;
        Long currentOrgId = RequestContext.get().getOrgId();
        Long userId = RequestContext.get().getCurrUserId();
        String appId = "pdm";
        String permItemId = "47150e89000000ac";
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"04", (String)appId, (String)"pdm_eco_changeplatform", (String)permItemId);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            List orgIdList = hasPermOrgResult.getHasPermOrgs();
            firstOrgId = PlatFormQueryDataHelper.getfirstOrgId(orgIdList, currentOrgId);
        } else {
            DynamicObjectCollection orgCol = PlatFormQueryDataHelper.queryOrgDatas(4L, null);
            List<Long> productOrgIdList = orgCol.stream().map(p -> p.getLong("orgid")).collect(Collectors.toList());
            firstOrgId = PlatFormQueryDataHelper.getfirstOrgId(productOrgIdList, currentOrgId);
        }
        if (firstOrgId != null && !firstOrgId.equals(0L)) {
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)firstOrgId, (String)"bos_org");
            DynamicObjectCollection coll = new DynamicObjectCollection();
            coll.add((Object)org);
            return coll;
        }
        return null;
    }

    private static String getEntryEntity(String entityName, boolean isCopChange) {
        if ("pdm_ecobom".equals(entityName)) {
            if (isCopChange) {
                return "copentry";
            }
            return "entry";
        }
        if ("pdm_ecoroute".equals(entityName)) {
            return "processentry";
        }
        return "";
    }

    public static QFilter getEcoBillFiltersFromCard(DynamicObject scheme) {
        DataEntityPropertyCollection entryProperties = scheme.getDynamicObjectType().getProperties();
        QFilter filter = null;
        for (IDataEntityProperty pro : entryProperties) {
            QFilter filterTemp;
            String propName = pro.getName();
            Object value = scheme.get(propName);
            if ("org_filter".equals(propName)) {
                filterTemp = PlatFormQueryDataHelper.getOrgQFilter(value == null ? null : (DynamicObjectCollection)value);
                filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp);
            }
            if ("type_filter".equals(propName)) {
                filterTemp = PlatFormQueryDataHelper.getTypeQFilter(value == null ? null : (DynamicObjectCollection)value);
                filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp);
            }
            if ("changetype_filter".equals(propName)) {
                filterTemp = PlatFormQueryDataHelper.getChangeTypeQFilter(value == null ? null : (String)value);
                filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp);
            }
            if ("ecotype_filter".equals(propName)) {
                filterTemp = PlatFormQueryDataHelper.getEcoTypeQFilter(value == null ? null : (DynamicObjectCollection)value);
                filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp);
            }
            if ("bomecofrom_filter".equals(propName)) {
                filterTemp = PlatFormQueryDataHelper.getBomEcoNumberFromQFilter(value == null ? null : (DynamicObjectCollection)value);
                filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp);
            }
            if ("bomecoto_filter".equals(propName)) {
                filterTemp = PlatFormQueryDataHelper.getBomEcoNumberToQFilter(value == null ? null : (DynamicObject)value);
                filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp);
            }
            if ("materialinfofrom_filter".equals(propName)) {
                filterTemp = PlatFormQueryDataHelper.getMaterialInfoFromQFilter(value == null ? null : (DynamicObjectCollection)value);
                filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp);
            }
            if ("materialinfoto_filter".equals(propName)) {
                filterTemp = PlatFormQueryDataHelper.getMaterialInfoToQFilter(value == null ? null : (DynamicObject)value);
                filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp);
            }
            if ("billstatus_filter".equals(propName)) {
                filterTemp = PlatFormQueryDataHelper.getBillStatusQFilter(value == null ? null : (String)value);
                filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp);
            }
            if (value == null || !"createtimeselect".equals(propName)) continue;
            Date startDate = null;
            Date endDate = null;
            String createTimeSelect = value.toString();
            if ("D".equals(createTimeSelect)) {
                startDate = scheme.getDate("createtime_filter_start");
                endDate = scheme.getDate("createtime_filter_end");
            } else {
                startDate = PlatFormQueryDataHelper.getBeginDate(createTimeSelect);
                endDate = PlatFormQueryDataHelper.getEndDate(createTimeSelect);
            }
            QFilter filterTemp2 = PlatFormQueryDataHelper.getCreateTimeQFilter(startDate, endDate);
            filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp2);
        }
        logger.info("cardfilter1=" + (filter == null ? "" : filter.toString()));
        return filter;
    }

    public static QFilter getEcoBomFiltersByCard(DynamicObject scheme, Set<Long> ecobomIdSet, String entryEntity) {
        QFilter filter = null;
        filter = !ecobomIdSet.isEmpty() ? new QFilter("id", "in", ecobomIdSet) : new QFilter("id", "=", (Object)0L);
        DataEntityPropertyCollection entryProperties = scheme.getDynamicObjectType().getProperties();
        for (IDataEntityProperty pro : entryProperties) {
            QFilter filterTemp;
            String propName = pro.getName();
            Object value = scheme.get(propName);
            if ("materialfrom_filter".equals(propName)) {
                filterTemp = PlatFormQueryDataHelper.getMaterialFromQFilter(value == null ? null : (DynamicObjectCollection)value, entryEntity);
                filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp);
            }
            if ("materialto_filter".equals(propName)) {
                filterTemp = PlatFormQueryDataHelper.getMaterialToQFilter(value == null ? null : (DynamicObject)value, entryEntity);
                filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp);
            }
            if ("featurefrom_filter".equals(propName)) {
                filterTemp = PlatFormQueryDataHelper.getFeatureTypeFromQFilter(value == null ? null : (DynamicObjectCollection)value, entryEntity);
                filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp);
            }
            if ("featureto_filter".equals(propName)) {
                filterTemp = PlatFormQueryDataHelper.getFeatureTypeToQFilter(value == null ? null : (DynamicObject)value, entryEntity);
                filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp);
            }
            if ("entrymode_filter".equals(propName)) {
                filterTemp = PlatFormQueryDataHelper.getEntryModeQFilter(value == null ? null : (String)value, entryEntity);
                filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp);
            }
            if ("estimatestatus_filter".equals(propName)) {
                filterTemp = PlatFormQueryDataHelper.getEstimateStatusQFilter(value == null ? null : (String)value, entryEntity);
                filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp);
            }
            if (value == null || !"acttimeselect".equals(propName)) continue;
            Date startDate = null;
            Date endDate = null;
            String actTimeSelect = value.toString();
            if ("D".equals(actTimeSelect)) {
                startDate = scheme.getDate("acttime_filter_start");
                endDate = scheme.getDate("acttime_filter_end");
            } else {
                startDate = PlatFormQueryDataHelper.getBeginDate(actTimeSelect);
                endDate = PlatFormQueryDataHelper.getEndDate(actTimeSelect);
            }
            QFilter filterTemp2 = PlatFormQueryDataHelper.getActTimeQFilter(startDate, endDate, entryEntity);
            filter = PlatFormQueryDataHelper.addfilter(filter, filterTemp2);
        }
        logger.info("cardfilter2=" + (filter == null ? "" : filter.toString()));
        return filter;
    }

    public static int getBillCountFromCard(DynamicObject scheme) {
        int count = 0;
        try {
            String algoKey = PlatFormQueryDataHelper.class.getName() + "getBillCountFromCard";
            QFilter ecoChangeBillfilterInfo = PlatFormQueryDataHelper.getEcoBillFiltersFromCard(scheme);
            if (ecoChangeBillfilterInfo == null) {
                return count;
            }
            QFilter[] qFilters = new QFilter[]{ecoChangeBillfilterInfo};
            try (DataSet bomEcoDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pdm_bom_eco", (String)PlatFormQueryDataHelper.getECOBillSelectFields(true), (QFilter[])qFilters, (String)"id");){
                HashSet<Long> ecoBomIdSet = new HashSet<Long>(128);
                HashSet<Long> ecoRouteIdSet = new HashSet<Long>(128);
                while (bomEcoDs.hasNext()) {
                    Row arow = bomEcoDs.next();
                    Long ecoBomId = arow.getLong("ecobomid");
                    Long ecoRouteId = arow.getLong("ecorouteid");
                    if (!PlatformUtils.isNullLong((Long)ecoBomId)) {
                        ecoBomIdSet.add(ecoBomId);
                    }
                    if (PlatformUtils.isNullLong((Long)ecoRouteId)) continue;
                    ecoRouteIdSet.add(ecoRouteId);
                }
                count += PlatFormQueryDataHelper.getCountFromEcoEntry(scheme, ecoBomIdSet, "pdm_ecobom", false);
                count += PlatFormQueryDataHelper.getCountFromEcoEntry(scheme, ecoBomIdSet, "pdm_ecobom", true);
                count += PlatFormQueryDataHelper.getCountFromEcoEntry(scheme, ecoRouteIdSet, "pdm_ecoroute", false);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return count;
    }

    public static Set<Long> getEcoBomEntryAllGroupNoData(Long ecoBomId, String groupNo, String entryMode) {
        String algoKey = PlatFormQueryDataHelper.class.getName() + "getEcoBomEntryAllGroupNoData";
        QFilter filter = new QFilter("ecobomid", "=", (Object)ecoBomId);
        filter.and(new QFilter("entrygroupno", "=", (Object)groupNo));
        HashSet<String> entrymodeSet = new HashSet<String>(16);
        if (kd.bos.util.StringUtils.isEmpty((String)entryMode)) {
            entrymodeSet.add("A");
            entrymodeSet.add("E");
        } else {
            entrymodeSet.add(entryMode);
        }
        filter.and(new QFilter("entrymode", "in", entrymodeSet));
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = PlatFormQueryDataHelper.getEcoBomEntryDataSelectProperties();
        HashSet<Long> allIdSet = new HashSet<Long>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pdm_ecobom_entryf7", (String)selectProperties, (QFilter[])qFilters, (String)"id");){
            while (ds.hasNext()) {
                Row arow = ds.next();
                allIdSet.add(arow.getLong("entryid"));
            }
        }
        return allIdSet;
    }

    private static int getCountFromEcoEntry(DynamicObject scheme, Set<Long> ecoBomIdSet, String ecoEntity, boolean isCopChange) {
        int count = 0;
        if (!ecoBomIdSet.isEmpty()) {
            String algoKey = PlatFormQueryDataHelper.class.getName() + "_getCountFromEcoEntry";
            String entryEntity = PlatFormQueryDataHelper.getEntryEntity(ecoEntity, isCopChange);
            QFilter ecoEntryFilterInfo = PlatFormQueryDataHelper.getEcoBomFiltersByCard(scheme, ecoBomIdSet, entryEntity);
            String selectProperties = "";
            if ("pdm_ecoroute".equals(ecoEntity)) {
                selectProperties = PlatFormQueryDataHelper.getECORouteSelectFields(true);
            } else if ("pdm_ecobom".equals(ecoEntity)) {
                selectProperties = isCopChange ? PlatFormQueryDataHelper.getECOBomSelectFields(true) : PlatFormQueryDataHelper.getECOBomCopSelectFields(true);
            }
            DataSet pdmEcoDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)ecoEntity, (String)selectProperties, (QFilter[])new QFilter[]{ecoEntryFilterInfo}, (String)"");
            DataSet changeBefore = pdmEcoDataSet.filter("entrymode in ('A','B','E') ").select(new String[]{"ecobomentryid"});
            count = changeBefore.count("ecobomentryid", true);
            changeBefore.close();
        }
        return count;
    }

    public static Set<Long> getEcoBomEntryAllGroupNoData(Set<Long> ecoBomEntryIdSet) {
        String algoKey = PlatFormQueryDataHelper.class.getName() + "_getEcoBomEntryAllGroupNoData";
        HashSet<Long> allIdSet = new HashSet<Long>(16);
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select b.fentryid  ", new Object[0]);
        sb.append(" from t_fmm_ecobomentry a  ", new Object[0]);
        sb.append(" inner join t_fmm_ecobomentry b on a.fid  = b.fid and a.fentrygroupnos  = b.fentrygroupnos   ", new Object[0]);
        sb.append(" where ", new Object[0]);
        sb.appendIn("a.fentryid", ecoBomEntryIdSet.toArray());
        sb.append(" and a.fentrygroupnos <> ' ' ", new Object[0]);
        sb.append(" and b.fentrymode in('A','E') ", new Object[0]);
        sb.append(" and a.fentrymode in('A','E') ", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            while (ds.hasNext()) {
                Row arow = ds.next();
                allIdSet.add(arow.getLong("fentryid"));
            }
        }
        return allIdSet;
    }

    public static String getEcoBomEntryDataSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append(" entryid ");
        sb.append(",entrymode ");
        sb.append(",entrygroupno ");
        return sb.toString();
    }

    public static String genExtDBUpdateJson(String changeTable, String changeField, Object changeValue, String oldDatas) {
        if (!("t_pdm_bomecopentry".equalsIgnoreCase(changeTable) || "t_fmm_ecobomentry".equalsIgnoreCase(changeTable) || "t_fmm_ecobomcopentry".equalsIgnoreCase(changeTable) || "t_pdm_ecorouteoperation".equalsIgnoreCase(changeTable) || "t_pdm_ecorouteoperation_e".equalsIgnoreCase(changeTable))) {
            return oldDatas;
        }
        JSONObject datas = null;
        datas = kd.bos.util.StringUtils.isEmpty((String)oldDatas) ? new JSONObject() : JSON.parseObject((String)oldDatas);
        JSONObject js = datas.getJSONObject(changeTable);
        if (js == null) {
            js = new JSONObject();
        }
        js.put(changeField, changeValue);
        datas.put(changeTable, (Object)js);
        return datas.toJSONString();
    }

    private static Set<String> getAllFields(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        HashSet<String> allFieldName = new HashSet<String>(fields.length);
        for (Field field : fields) {
            allFieldName.add(field.getName());
        }
        return allFieldName;
    }

    private static Set<String> getMapValue(Map<String, String> map) {
        HashSet<String> fieldSet = new HashSet<String>(32);
        for (Map.Entry<String, String> maps : map.entrySet()) {
            String dataSetField = maps.getValue();
            fieldSet.add(dataSetField);
        }
        return fieldSet;
    }

    private static DataSet addFields(DataSet ds, Set<String> fields, DataType dataType) {
        ds = ds.addNullField(fields.toArray(new String[fields.size()]));
        for (String field : fields) {
            ds.getRowMeta().getField(field).setDataType(dataType);
        }
        return ds;
    }

    private static DataSet addFields(DataSet ds) {
        if (ds != null) {
            Set<String> fieldSetA = PlatFormQueryDataHelper.getAllFields(ds);
            Set<String> fieldSetB = PlatFormQueryDataHelper.getMapValue(MAP_LONG);
            fieldSetB.removeAll(fieldSetA);
            if (!fieldSetB.isEmpty()) {
                ds = PlatFormQueryDataHelper.addFields(ds, fieldSetB, (DataType)DataType.LongType);
            }
            fieldSetB = PlatFormQueryDataHelper.getMapValue(MAP_STRING);
            fieldSetB.removeAll(fieldSetA);
            if (!fieldSetB.isEmpty()) {
                ds = PlatFormQueryDataHelper.addFields(ds, fieldSetB, (DataType)DataType.StringType);
            }
            fieldSetB = PlatFormQueryDataHelper.getMapValue(MAP_DATE);
            fieldSetB.removeAll(fieldSetA);
            if (!fieldSetB.isEmpty()) {
                ds = PlatFormQueryDataHelper.addFields(ds, fieldSetB, (DataType)DataType.DateType);
            }
            fieldSetB = PlatFormQueryDataHelper.getMapValue(MAP_BOOLEAN);
            fieldSetB.removeAll(fieldSetA);
            if (!fieldSetB.isEmpty()) {
                ds = PlatFormQueryDataHelper.addFields(ds, fieldSetB, (DataType)DataType.BooleanType);
            }
            fieldSetB = PlatFormQueryDataHelper.getMapValue(MAP_BIGDECIMAL);
            fieldSetB.removeAll(fieldSetA);
            if (!fieldSetB.isEmpty()) {
                ds = PlatFormQueryDataHelper.addFields(ds, fieldSetB, (DataType)DataType.BigDecimalType);
            }
        }
        return ds;
    }

    private static DataSet buildNullDataSet() {
        Algo algo = Algo.create((String)PlatFormQueryDataHelper.class.getName());
        ArrayList<String> fieldList = new ArrayList<String>(32);
        ArrayList<LongType> dataTypeList = new ArrayList<LongType>(32);
        for (Map.Entry<String, String> maps : MAP_LONG.entrySet()) {
            fieldList.add(maps.getValue());
            dataTypeList.add(DataType.LongType);
        }
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(new RowMeta(fieldList.toArray(new String[fieldList.size()]), dataTypeList.toArray(new DataType[dataTypeList.size()])));
        DataSet ds = dsBuilder.build();
        Set<String> fieldSetB = PlatFormQueryDataHelper.getMapValue(MAP_STRING);
        ds = PlatFormQueryDataHelper.addFields(ds, fieldSetB, (DataType)DataType.StringType);
        fieldSetB = PlatFormQueryDataHelper.getMapValue(MAP_DATE);
        ds = PlatFormQueryDataHelper.addFields(ds, fieldSetB, (DataType)DataType.DateType);
        fieldSetB = PlatFormQueryDataHelper.getMapValue(MAP_BOOLEAN);
        ds = PlatFormQueryDataHelper.addFields(ds, fieldSetB, (DataType)DataType.BooleanType);
        fieldSetB = PlatFormQueryDataHelper.getMapValue(MAP_BIGDECIMAL);
        ds = PlatFormQueryDataHelper.addFields(ds, fieldSetB, (DataType)DataType.BigDecimalType);
        return ds;
    }

    private static DataSet mergeDataSet(DataSet dsBom, DataSet dsRoute) {
        dsBom = PlatFormQueryDataHelper.addFields(dsBom);
        dsRoute = PlatFormQueryDataHelper.addFields(dsRoute);
        if (dsBom == null && dsRoute == null) {
            return PlatFormQueryDataHelper.buildNullDataSet();
        }
        if (dsBom == null) {
            return dsRoute;
        }
        if (dsRoute == null) {
            return dsBom;
        }
        Set<String> fieldSet = PlatFormQueryDataHelper.getAllFields(dsBom);
        String[] allFieldArray = fieldSet.toArray(new String[fieldSet.size()]);
        dsBom = dsBom.select(allFieldArray);
        dsRoute = dsRoute.select(allFieldArray);
        return dsBom.union(dsRoute);
    }

    private static DataSet extDataSetResultDeal(DataSet dataSet, Object oldExtPlugin, PluginProxy<IEcoPlatFormQueryExt> newExtPlugin) {
        DataSet ds = null;
        if (oldExtPlugin != null) {
            ds = ((AbstractEcoBomPlatFormQueryFilterExtPlugin)oldExtPlugin).dealDataSetResult(dataSet);
        } else if (newExtPlugin != null) {
            List listData = newExtPlugin.callReplace(p -> p.dealDataSetResult(dataSet));
            ds = PlatFormQueryDataHelper.getFirstExtDataSet(listData);
        }
        if (ds != null) {
            return ds;
        }
        return dataSet;
    }

    private static Map<String, String> extLoadDataFiedlMapDeal(Object oldExtPlugin, PluginProxy<IEcoPlatFormQueryExt> newExtPlugin) {
        if (oldExtPlugin != null) {
            return ((AbstractEcoBomPlatFormQueryFilterExtPlugin)oldExtPlugin).dealLoadDataExtFieldMap();
        }
        if (newExtPlugin != null) {
            List listData = newExtPlugin.callReplace(p -> p.dealLoadDataExtFieldMap());
            return PlatFormQueryDataHelper.getFirstExtMap(listData);
        }
        return new HashMap<String, String>(16);
    }

    public static String getDataSetFieldNumberByGrid(String gridFieldNumber, Object oldExtPlugin, PluginProxy<IEcoPlatFormQueryExt> newExtPlugin) {
        Map<String, String> extFieldMap;
        String value = MAP_BIGDECIMAL.get(gridFieldNumber);
        if (kd.bos.util.StringUtils.isEmpty((String)value)) {
            value = MAP_BOOLEAN.get(gridFieldNumber);
        }
        if (kd.bos.util.StringUtils.isEmpty((String)value)) {
            value = MAP_DATE.get(gridFieldNumber);
        }
        if (kd.bos.util.StringUtils.isEmpty((String)value)) {
            value = MAP_LONG.get(gridFieldNumber);
        }
        if (kd.bos.util.StringUtils.isEmpty((String)value)) {
            value = MAP_STRING.get(gridFieldNumber);
        }
        if (kd.bos.util.StringUtils.isEmpty((String)value) && (extFieldMap = PlatFormQueryDataHelper.extLoadDataFiedlMapDeal(oldExtPlugin, newExtPlugin)) != null) {
            value = extFieldMap.get(gridFieldNumber);
        }
        if (kd.bos.util.StringUtils.isEmpty((String)value)) {
            value = gridFieldNumber;
        }
        return value;
    }

    private static QFilter getFirstExtQFilter(List<QFilter> listData) {
        return listData == null || listData.isEmpty() ? null : listData.get(0);
    }

    private static Map<String, String> getFirstExtMap(List<Map<String, String>> listData) {
        return listData == null || listData.isEmpty() ? null : listData.get(0);
    }

    private static DataSet getFirstExtDataSet(List<DataSet> listData) {
        return listData == null || listData.isEmpty() ? null : listData.get(0);
    }

    private static DynamicObjectCollection queryOrgDatas(Long viewId, QFilter qfilter) {
        QFilter filterTreetype = new QFilter("view", "=", (Object)viewId);
        if (qfilter != null) {
            filterTreetype = filterTreetype.and(qfilter);
        }
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter = freezeFilter.or(freezeFilter1);
        return QueryServiceHelper.query((String)"bos_org_structure", (String)"org.id orgid", (QFilter[])new QFilter[]{filterTreetype, freezeFilter}, (String)"");
    }

    static {
        MAP_LONG.put("ecoid", "id");
        MAP_LONG.put("ecoentryid", "ecobomentryid");
        MAP_LONG.put("ecoentryafterid", "afterecobomentryid");
        MAP_LONG.put("org", "org");
        MAP_LONG.put("parentmaterial", "proentrymaterialid");
        MAP_LONG.put("ecotype", "ecotype");
        MAP_LONG.put("beforematerial", "entrymaterialid");
        MAP_LONG.put("beforefeaturetype", "beforefeaturetype");
        MAP_LONG.put("afterfeaturetype", "afterfeaturetype");
        MAP_LONG.put("beforeunit", "baseunit");
        MAP_LONG.put("aftermaterial", "newmaterialid");
        MAP_LONG.put("afterunit", "newbaseunit");
        MAP_LONG.put("allunit", "allunit");
        MAP_LONG.put("bomentryid", "bomentryid");
        MAP_LONG.put("afterbomentryid", "afterbomentryid");
        MAP_LONG.put("ecopentryid", "pentry");
        MAP_LONG.put("pentrybom", "pentrybom");
        MAP_LONG.put("ecobomid", "ecobom");
        MAP_LONG.put("pentryroute", "pentryroute");
        MAP_LONG.put("operation", "operation");
        MAP_LONG.put("entryreplaceplan", "entryreplaceplan");
        MAP_STRING.put("billstatus", "billstatus");
        MAP_STRING.put("billno", "billno");
        MAP_STRING.put("entrymode", "entrymode");
        MAP_STRING.put("changedetails", "changedetails");
        MAP_STRING.put("estimatestatus", "estimatestatus");
        MAP_STRING.put("entrygroupno", "entrygroupno");
        MAP_STRING.put("entryrefno", "entryrefno");
        MAP_STRING.put("continuouspoint", "continuouspoint");
        MAP_STRING.put("entrytype", "entrytype");
        MAP_STRING.put("beforematerialnumber", "beforematerialnumber");
        MAP_STRING.put("beforematerialname", "beforematerialname");
        MAP_STRING.put("aftermaterialnumber", "aftermaterialnumber");
        MAP_STRING.put("aftermaterialname", "aftermaterialname");
        MAP_STRING.put("changetype", "changetype");
        MAP_STRING.put("processseq", "processseq");
        MAP_STRING.put("operationno", "operationno");
        MAP_STRING.put("operdesc", "operdesc");
        MAP_STRING.put("producttype", "producttype");
        MAP_STRING.put("entryreplacegroup", "entryreplacegroup");
        MAP_BIGDECIMAL.put("entryqtynumerator", "entryqtynumerator");
        MAP_BIGDECIMAL.put("entryqtydenominator", "entryqtydenominator");
        MAP_BIGDECIMAL.put("tranqty", "tranqty");
        MAP_BIGDECIMAL.put("useqty", "useqty");
        MAP_BIGDECIMAL.put("remainderqty", "remainderqty");
        MAP_BIGDECIMAL.put("progress", "progress");
        MAP_DATE.put("transtartdate", "transtartdate");
        MAP_DATE.put("acttime", "acttime");
        MAP_DATE.put("entryvaliddate", "entryvaliddate");
        MAP_DATE.put("entryinvaliddate", "entryinvaliddate");
        MAP_DATE.put("auditdate", "auditdate");
        MAP_DATE.put("createtime", "createtime");
        MAP_DATE.put("pentryvaliddate", "pentryvaliddate");
        MAP_BOOLEAN.put("groupkey", "groupkey");
        MAP_BOOLEAN.put("refkey", "refkey");
        MAP_BOOLEAN.put("iscanestimate", "iscanestimate");
        GRID_LOKC_FIELD_ARRAY = new String[0];
    }
}

