/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.ecoplatform.card;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IFilterModel;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.filter.FilterSchemeService;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.ReportShowParameter;
import kd.mmc.pdm.formplugin.ecoplatform.PlatFormQueryDataHelper;

public class EcoBomPlatFormCardHomePlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(EcoBomPlatFormCardHomePlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setValue("billcount");
    }

    protected void setValue(String type) {
        Label label = new Label();
        label = (Label)this.getView().getControl(type);
        int count = this.getBillCount();
        label.setText(Integer.toString(count));
    }

    protected int getBillCount() {
        DynamicObject scheme;
        FilterScheme defFilterScheme;
        DynamicObjectCollection coll = PlatFormQueryDataHelper.getCurrentDefaultOrg();
        if (coll != null && !coll.isEmpty() && (defFilterScheme = this.initFilterScheme()) != null && (scheme = this.toDynamicObject(defFilterScheme)) != null) {
            return PlatFormQueryDataHelper.getBillCountFromCard(scheme);
        }
        return 0;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billcount"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if ("billcount".equals(key)) {
            this.showEcoBomPlatFormRpt();
        }
    }

    protected void showEcoBomPlatFormRpt() {
        DynamicObjectCollection coll = PlatFormQueryDataHelper.getCurrentDefaultOrg();
        if (coll != null && !coll.isEmpty()) {
            ReportShowParameter para = new ReportShowParameter();
            para.setFormId("pdm_eco_changeplatform");
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)para);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u6743\u9650\u4e0d\u8db3\u3002", (String)"EcoBomPlatFormCardHomePlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject toDynamicObject(FilterScheme filterScheme) {
        String entityId = filterScheme.getFormId();
        String schemeJson = filterScheme.getScheme();
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)schemeJson, HashMap.class);
        String custfilters = (String)filterMap.get("custfilters");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityId);
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        DynamicObject scheme = (DynamicObject)jser.deserializeFromString(custfilters, null);
        BusinessDataReader.loadRefence((Object[])new DynamicObject[]{scheme}, (IDataEntityType)type);
        return scheme;
    }

    private FilterScheme initFilterScheme() {
        List<FilterScheme> schemeList = this.getSchemeList();
        FilterScheme filterScheme = FilterSchemeService.getDefaultSchemeFromAll(schemeList);
        return filterScheme;
    }

    private IFilterModel getFilterModel() {
        IFilterModel filterModel = (IFilterModel)TypesContainer.createInstance((String)"kd.bos.filter.FilterModel");
        filterModel.setFormId("pdm_eco_changeplatform");
        return filterModel;
    }

    protected List<FilterScheme> getSchemeList() {
        IFilterModel filterModel = this.getFilterModel();
        filterModel.setFormId("pdm_eco_changeplatform");
        return filterModel.getSchemeList();
    }
}

