/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.mftbom.bomsearch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.TreeSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.web.DispatchServiceHelper;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.ORGAndPermissionUtils;

public class BOMBackSearchPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
IDataModelChangeListener {
    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        String formId = this.getView().getFormShowParameter().getFormId();
        super.initDefaultQueryParam(queryParam);
        if ("pdm_bombacksearch".equals(formId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bomno"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"isshowlast"});
        RequestContext rc = RequestContext.get();
        long orgId = rc.getOrgId();
        long userId = rc.getCurrUserId();
        this.initOrg(orgId, userId);
        this.getModel().setValue("bomexpandconfig", (Object)1637711947497568256L);
    }

    public void initOrg(Long orgId, Long userId) {
        IReportView view = this.getView();
        IDataModel model = view.getModel();
        if (orgId == 0L) {
            model.setValue("org", (Object)0L);
            return;
        }
        String entityNum = model.getDataEntityType().getName();
        String appId = model.getDataEntityType().getAppId();
        Long orgByUserOrg = ORGAndPermissionUtils.getOrgByUserOrg((Long)userId, (Long)orgId, (String)entityNum, (String)appId, (String)"47150e89000000ac", (String)"04");
        model.setValue("org", (Object)orgByUserOrg);
    }

    public void registerListener(EventObject e) {
        String formId = this.getView().getFormShowParameter().getFormId();
        BasedataEdit bomVersionText = (BasedataEdit)this.getView().getControl("bomversion");
        BasedataEdit configCodeText = (BasedataEdit)this.getView().getControl("configcode");
        BasedataEdit materialnoText = (BasedataEdit)this.getView().getControl("materialno");
        BasedataEdit bomNoText = (BasedataEdit)this.getView().getControl("bomno");
        BasedataEdit orgText = (BasedataEdit)this.getView().getControl("org");
        bomVersionText.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        if (configCodeText != null) {
            configCodeText.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        materialnoText.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        orgText.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        if (!"pdm_bombacksearch".equals(formId)) {
            bomNoText.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject featureType;
        String formId = this.getView().getFormShowParameter().getFormId();
        FilterInfo filterInfo = queryParam.getFilter();
        Date searchDate = filterInfo.getDate("searchdate");
        DynamicObject materialObj = filterInfo.getDynamicObject("materialno");
        DynamicObject bomtypeObj = filterInfo.getDynamicObject("bomtype");
        DynamicObject org = filterInfo.getDynamicObject("org");
        DynamicObject configcode = filterInfo.getDynamicObject("configcode");
        DynamicObject bomexpandconfig = filterInfo.getDynamicObject("bomexpandconfig");
        BigDecimal demandcount = filterInfo.getBigDecimal("demandcount");
        String showtype = filterInfo.getString("showtype");
        if (showtype == null || "".equals(showtype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c55\u5f00\u65b9\u5f0f\u3002", (String)"BOMBackSearchPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (searchDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u67e5\u8be2\u65f6\u95f4\u3002", (String)"BOMBackSearchPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (materialObj == null && !"pdm_bombacksearch".equals(formId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7269\u6599\u7f16\u7801\u3002", (String)"BOMBackSearchPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if ("pdm_bombacksearch".equals(formId) && (featureType = filterInfo.getDynamicObject("featuretypeid")) == null && materialObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7269\u6599\u7f16\u7801\u6216\u7279\u5f81\u7c7b\u3002", (String)"BOMBackSearchPlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (bomexpandconfig == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199BOM\u5c55\u5f00\u8bbe\u7f6e\u3002", (String)"BOMBackSearchPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4f7f\u7528\u7ec4\u7ec7\u3002", (String)"BOMBackSearchPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (BigDecimal.ZERO.compareTo(demandcount) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9700\u6c42\u6570\u91cf\u3002", (String)"BOMBackSearchPlugin_6", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (BigDecimal.ZERO.compareTo(demandcount) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u6c42\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"BOMBackSearchPlugin_7", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        int levelCount = filterInfo.getInt("levelcount");
        if (levelCount < 1 || levelCount > 30) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u663e\u793a\u5c42\u6570\u5fc5\u987b\u57281-30\u8303\u56f4\u5185\u3002", (String)"BOMBackSearchPlugin_11", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject materialInfoObj;
        DynamicObject orgObj;
        ListFilterParameter lfp;
        IDataEntityProperty srcDEP = e.getProperty();
        String srcDEPName = srcDEP == null ? null : srcDEP.getName();
        IReportView view = this.getView();
        IDataModel model = view.getModel();
        FormShowParameter fsp = e.getFormShowParameter();
        if (fsp == null) {
            return;
        }
        ListShowParameter lsp = fsp instanceof ListShowParameter ? (ListShowParameter)fsp : null;
        ListFilterParameter listFilterParameter = lfp = lsp == null ? null : lsp.getListFilterParameter();
        if (lsp == null) {
            return;
        }
        if (lfp == null) {
            return;
        }
        if ("materialno".equalsIgnoreCase(srcDEPName) && (orgObj = (DynamicObject)model.getValue("org")) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4f7f\u7528\u7ec4\u7ec7\u3002", (String)"BOMBackSearchPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if ("bomversion".equalsIgnoreCase(srcDEPName) && (materialInfoObj = (DynamicObject)model.getValue("materialno")) != null) {
            long materialId = materialInfoObj.getLong("masterid");
            qFilterList.add(new QFilter("material", "=", (Object)materialId));
        }
        if (!"configcode".equalsIgnoreCase(srcDEPName) && "org".equals(srcDEPName)) {
            RequestContext requestContext = RequestContext.get();
            long userID = Long.parseLong(requestContext.getUserId());
            String formId = this.getView().getFormShowParameter().getFormId();
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)BizAppServiceHelp.getAppIdByAppNumber((String)"pdm"), (String)formId, (String)"47150e89000000ac");
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                List orgIds = hasPermOrgResult.getHasPermOrgs();
                qFilterList.add(new QFilter("id", "in", (Object)orgIds));
            }
        }
        if (!MMCUtils.isEmptyList(qFilterList)) {
            lfp.setQFilters(qFilterList);
            lsp.setListFilterParameter(lfp);
            e.setFormShowParameter((FormShowParameter)lsp);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IReportView view = this.getView();
        IDataModel model = view.getModel();
        String propertyName = e.getProperty().getName();
        if ("bomtype".equals(propertyName)) {
            DynamicObject dynamicObject = (DynamicObject)model.getValue("bomtype");
        } else if ("materialno".equals(propertyName)) {
            BasedataEdit configCodeText = (BasedataEdit)this.getView().getControl("configcode");
            model.setValue("bomversion", null);
            if (configCodeText != null) {
                model.setValue("configcode", null);
            }
            model.setValue("insteadnum", null);
            DynamicObject materialObj = (DynamicObject)model.getValue("materialno");
            if (materialObj == null) {
                return;
            }
            DynamicObject baseUnit = (DynamicObject)materialObj.get("baseunit");
            if (baseUnit == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7269\u6599\u5bf9\u5e94\u7684\u57fa\u672c\u5355\u4f4d\u4e3a\u7a7a\u3002", (String)"BOMBackSearchPlugin_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            }
            model.setValue("matunit", (Object)baseUnit);
            view.updateView();
        } else if ("showtype".equals(propertyName)) {
            String showType = (String)model.getValue("showtype");
            if ("A".equals(showType)) {
                view.setVisible(Boolean.FALSE, new String[]{"isshowlast"});
                view.updateView();
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"isshowlast"});
                view.updateView();
            }
        } else if ("org".equals(propertyName)) {
            this.initSelectBomNo((IFormView)view);
        } else if ("showtree".equals(propertyName)) {
            Object showTree = e.getChangeSet()[0].getNewValue();
            boolean isShowTree = (Boolean)showTree;
            this.setTreeDisplay(isShowTree);
            if (isShowTree) {
                ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
                rptFilter.search();
            }
        } else if ("defaultconfigcode".equals(propertyName)) {
            DynamicObject material = (DynamicObject)this.getModel().getValue("materialno");
            Object defaultConfigCode = e.getChangeSet()[0].getNewValue();
            boolean isDefaultConfigCode = (Boolean)defaultConfigCode;
            if (isDefaultConfigCode) {
                DynamicObject configCode = this.getDefaultConfigCode(material);
                this.getModel().setValue("configcode", (Object)configCode);
            } else {
                this.getModel().setValue("configcode", null);
            }
            this.getView().updateView("configcode");
        }
    }

    private DynamicObject getDefaultConfigCode(DynamicObject material) {
        if (material == null) {
            return null;
        }
        long matId = material.getLong("id");
        QFilter matfilter = new QFilter("material", "=", (Object)matId);
        QFilter isDefault = new QFilter("isdefault", "=", (Object)"1");
        DynamicObject configcodeObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_configuredcode", (QFilter[])new QFilter[]{matfilter, isDefault});
        return configcodeObj;
    }

    private void setTreeDisplay(boolean isShowTree) {
        SplitContainer splitc = (SplitContainer)this.getControl("splitcontainerap");
        if (!isShowTree) {
            splitc.hidePanel(SplitDirection.left, true);
            splitc.setSubContainerMinWidth(0);
            splitc.setSubContainerMinHeight(0);
        } else {
            splitc.hidePanel(SplitDirection.left, false);
            splitc.setSubContainerMinWidth(300);
            splitc.setSubContainerMinHeight(300);
        }
    }

    public DynamicObject getBomType(DynamicObject bomtypeObj) {
        long id = bomtypeObj.getLong("id");
        return BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_bomtype", (String)"id,status,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String entityId = this.getView().getEntityId();
        if ("pdm_bomforwardsearch".equals(entityId)) {
            IReportView view = this.getView();
            IDataModel model = view.getModel();
            boolean isShowTree = (Boolean)model.getValue("showtree");
            this.setTreeDisplay(isShowTree);
        }
    }

    public void initSelectBomNo(IFormView view) {
        String clickParams = "[{\"key\":\"bomno\",\"methodName\":\"click\",\"args\":[],\"postData\":[{},[]]}]";
        String result = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)"pdm", (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{this.getView().getPageId(), clickParams});
        if (result.contains("showErrMsg")) {
            // empty if block
        }
        view.updateView();
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        TreeSet<String> set = new TreeSet<String>(Arrays.asList("materialattr", "materialid", "materialname", "entrymaterialid", "entrymaterialname", "featuretype", "featuretypename", "entrymaterialattr", "entryconfigcode", "entryqtytype", "bomlevel", "level", "wbs"));
        for (SortAndFilterEvent sort : allColumns) {
            if (!set.contains(sort.getColumnName())) continue;
            sort.setSort(true);
            sort.setFilter(true);
        }
    }

    public void setExcelName(List<String> list) {
        String entityId = this.getView().getEntityId();
        String name = "";
        if ("pdm_bomforwardsearch".equals(entityId)) {
            name = ResManager.loadKDString((String)"BOM\u6b63\u67e5_", (String)"BOMBackSearchPlugin_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
            name = name + this.getPageCache().get("materialno");
        } else if ("pdm_bombacksearch".equals(entityId)) {
            name = ResManager.loadKDString((String)"BOM\u53cd\u67e5_", (String)"BOMBackSearchPlugin_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
            String materialno = this.getPageCache().get("materialno");
            String featuretypeid = this.getPageCache().get("featuretypeid");
            if (!" ".equals(materialno) && !" ".equals(featuretypeid)) {
                name = name + materialno + "-" + featuretypeid;
            } else if (" ".equals(materialno)) {
                name = name + featuretypeid;
            } else if (" ".equals(featuretypeid)) {
                name = name + materialno;
            }
        }
        list.add(name);
        super.setExcelName(list);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        DynamicObject materialno;
        String showType = (String)this.getModel().getValue("showtype");
        if ("B".equals(showType)) {
            queryParam.setSortInfo(null);
        }
        if ((materialno = queryParam.getFilter().getDynamicObject("materialno")) != null) {
            this.getPageCache().put("materialno", materialno.getString("number"));
        } else {
            this.getPageCache().put("materialno", " ");
        }
        if ("pdm_bombacksearch".equals(this.getView().getEntityId())) {
            DynamicObject featuretypeid = queryParam.getFilter().getDynamicObject("featuretypeid");
            if (featuretypeid != null) {
                this.getPageCache().put("featuretypeid", featuretypeid.getString("number"));
            } else {
                this.getPageCache().put("featuretypeid", " ");
            }
        }
        super.beforeQuery(queryParam);
    }
}

