/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.mftbom.bomsearch;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.report.AbstractReportTreeDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMExpandConfigBusiness;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMVersionFilterBusiness;
import kd.mmc.pdm.business.mftbom.bomsearch.BomBackwardSearchBusiness;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.formplugin.mftbom.bomsearch.BomFowordSearchReportTreePlugin;

public class BOMBackwardSearchReportTreePlugin
extends AbstractReportTreeDataPlugin {
    private static final Log logger = LogFactory.getLog(BOMBackwardSearchReportTreePlugin.class);

    public List<TreeNode> query(ReportQueryParam queryParam, String paramString) throws Throwable {
        long versionId;
        FilterInfo filterInfo = queryParam.getFilter();
        Date searchDate = filterInfo.getDate("searchdate");
        DynamicObject materialObj = filterInfo.getDynamicObject("materialno");
        DynamicObject orgObj = filterInfo.getDynamicObject("org");
        DynamicObject bomVerObj = filterInfo.getDynamicObject("bomversion");
        DynamicObject bomExpandConfigObj = filterInfo.getDynamicObject("bomexpandconfig");
        DynamicObject insteadObj = filterInfo.getDynamicObject("insteadnum");
        Long insteadId = insteadObj == null ? 0L : insteadObj.getLong("id");
        DynamicObject wbsObj = filterInfo.getDynamicObject("bomwbs");
        Long wbsId = PlatformUtils.getDynamicObjectId((DynamicObject)wbsObj);
        String showtype = filterInfo.getString("showtype");
        boolean isshowlast = filterInfo.getBoolean("isshowlast");
        DynamicObject featureTypeObj = filterInfo.getDynamicObject("featuretypeid");
        BigDecimal demandCountTmp = filterInfo.getBigDecimal("demandcount");
        if (demandCountTmp == null || demandCountTmp.compareTo(BigDecimal.ZERO) <= 0) {
            demandCountTmp = BigDecimal.ONE;
        }
        int levelCount = filterInfo.getInt("levelcount");
        Map bomExpandMap = BOMExpandConfigBusiness.getBomExpandConfig((long)(bomExpandConfigObj == null ? -1L : bomExpandConfigObj.getLong("id")));
        String verConfig = BOMExpandConfigBusiness.getExpandVerConfig((Map)bomExpandMap);
        Set bomTypeSet = BOMExpandConfigBusiness.getBomType((Map)bomExpandMap);
        QFilter ids = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)orgObj.getLong("id"));
        QFilter bomType = new QFilter("type", "in", (Object)bomTypeSet);
        long l = versionId = bomVerObj == null ? 0L : bomVerObj.getLong("id");
        if (bomVerObj != null && !BOMVersionFilterBusiness.isVerEnable((long)versionId, (Date)searchDate, (String)"")) {
            versionId = -1L;
        }
        QFilter version = new QFilter("entry.entryversion", "=", (Object)versionId);
        QFilter effect = new QFilter("entry.entryvaliddate", "<=", (Object)searchDate);
        QFilter invalid = new QFilter("entry.entryinvaliddate", ">=", (Object)searchDate);
        QFilter insteadNum = new QFilter("replaceno", "=", (Object)insteadId);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        Object[] allDataFilter = new QFilter[]{};
        if (orgObj != null) {
            allDataFilter = new QFilter[]{status, enable, effect, invalid, bomType, ids};
        }
        ArrayList<TreeNode> retList = new ArrayList<TreeNode>(64);
        List<TreeNode> featureTreeList = null;
        List<TreeNode> matTreeList = null;
        if (featureTypeObj != null) {
            BomBackwardSearchBusiness featureBackwardSearchBusiness = new BomBackwardSearchBusiness("false", demandCountTmp, true, levelCount, bomExpandConfigObj);
            QFilter featureType = new QFilter("entry.featuretype", "=", (Object)featureTypeObj.getLong("id"));
            QFilter[] featureDataFilter = (QFilter[])ArrayUtils.add((Object[])allDataFilter, (Object)featureType);
            DataSet firstSet = featureBackwardSearchBusiness.getFirstLevelData(null, featureDataFilter);
            if ((firstSet = BOMExpandConfigBusiness.backFilterByExpandConfig((DataSet)firstSet, (Date)searchDate, (Long)insteadId, (Long)wbsId, (Map)bomExpandMap)) == null || firstSet.isEmpty()) {
                String ver = bomVerObj == null ? "0" : bomVerObj.getString("id");
                String rootId = this.getNodeAndPNodeId(featureTypeObj.getString("id"), ver, "0", "featureType", "0", demandCountTmp, showtype);
                String featureNum = String.valueOf(featureTypeObj.get("number"));
                String featureName = String.valueOf(featureTypeObj.get("number"));
                String nodeName = featureNum + "[" + featureName + "]";
                TreeNode rootNode = new TreeNode("root", rootId, nodeName);
                retList.add(rootNode);
            }
            Set featureTypeMat = featureBackwardSearchBusiness.getFeatureTypeByMat(featureTypeObj.getLong("id"));
            DataSet featureData = featureBackwardSearchBusiness.getDataSet((QFilter[])allDataFilter, null, featureDataFilter, showtype, isshowlast, searchDate, insteadObj, null, false, featureTypeMat, versionId, wbsId);
            featureTreeList = this.getTreeList(firstSet, featureData, featureTypeObj, bomVerObj, showtype, "featureType", demandCountTmp, verConfig);
        }
        if (materialObj != null) {
            QFilter material = new QFilter("entry.entrymaterialid", "=", (Object)materialObj.getLong("id"));
            Object[] matDataFilter = (QFilter[])ArrayUtils.add((Object[])allDataFilter, (Object)version);
            matDataFilter = (QFilter[])ArrayUtils.add((Object[])matDataFilter, (Object)material);
            BomBackwardSearchBusiness materialBackwardSearchBusiness = new BomBackwardSearchBusiness("false", demandCountTmp, true, levelCount, bomExpandConfigObj);
            HashSet<Long> matIdSet = new HashSet<Long>(16);
            matIdSet.add(materialObj.getLong("id"));
            Set featureTypeSet = materialBackwardSearchBusiness.getFeatureTypeByMat(matIdSet);
            Object[] featureDataFilter2 = null;
            if (!featureTypeSet.isEmpty()) {
                QFilter featureTypeOfMat = new QFilter("entry.featuretype", "in", (Object)featureTypeSet);
                featureDataFilter2 = (QFilter[])allDataFilter.clone();
                featureDataFilter2 = (QFilter[])ArrayUtils.add((Object[])featureDataFilter2, (Object)featureTypeOfMat);
            }
            DataSet firstMatSet = materialBackwardSearchBusiness.getFirstLevelData((QFilter[])matDataFilter, featureDataFilter2);
            List firstMatList = MMCUtils.parseToList((DataSet)firstMatSet);
            firstMatList = materialBackwardSearchBusiness.featureTypeToMat(firstMatList, matIdSet);
            firstMatSet = MMCUtils.parseToDataSet((Object)((Object)this), (List)firstMatList, (RowMeta)firstMatSet.getRowMeta());
            if ((firstMatSet = BOMExpandConfigBusiness.backFilterByExpandConfig((DataSet)firstMatSet, (Date)searchDate, (Long)insteadId, (Long)wbsId, (Map)bomExpandMap)) == null || firstMatSet.isEmpty()) {
                String ver = bomVerObj == null ? "0" : bomVerObj.getString("id");
                String rootId = this.getNodeAndPNodeId(materialObj.getString("id"), ver, "0", "material", "0", demandCountTmp, showtype);
                rootId = this.getNodeAndPNodeId(materialObj.getString("id"), ver, "0", "material", "0", demandCountTmp, showtype);
                String matNum = String.valueOf(materialObj.get("number"));
                String matName = String.valueOf(materialObj.get("number"));
                String nodeName = matNum + "[" + matName + "]";
                TreeNode rootNode = new TreeNode("root", rootId, nodeName);
                retList.add(rootNode);
            }
            DataSet matData = materialBackwardSearchBusiness.getDataSet((QFilter[])allDataFilter, (QFilter[])matDataFilter, (QFilter[])featureDataFilter2, showtype, isshowlast, searchDate, insteadObj, null, true, matIdSet, versionId, wbsId);
            matTreeList = this.getTreeList(firstMatSet, matData, materialObj, bomVerObj, showtype, "material", demandCountTmp, verConfig);
        }
        if (matTreeList != null && !matTreeList.isEmpty()) {
            retList.addAll((Collection<TreeNode>)matTreeList);
        }
        if (featureTreeList != null && !featureTreeList.isEmpty()) {
            retList.addAll((Collection<TreeNode>)featureTreeList);
        }
        return retList;
    }

    public List<TreeNode> getTreeList(DataSet firstSet, DataSet dataSet, DynamicObject rootObj, DynamicObject bomVerObj, String showtype, String headObjType, BigDecimal demandCountTmp, String verConfig) {
        ArrayList<TreeNode> retList = new ArrayList<TreeNode>(80);
        try {
            boolean isFeature = "featureType".equals(headObjType);
            if (firstSet == null) {
                ArrayList<TreeNode> arrayList = retList;
                return arrayList;
            }
            if (rootObj == null) {
                ArrayList<TreeNode> arrayList = retList;
                return arrayList;
            }
            List dataSetList = MMCUtils.parseToList((DataSet)dataSet);
            String versionId = "0";
            String entryauxproperty = "0";
            if (bomVerObj != null) {
                versionId = bomVerObj.getString("id");
            }
            Map<String, Map<String, String>> treeNodeMap = this.getMaterial(dataSetList);
            HashSet<String> rootIdSet = new HashSet<String>(64);
            HashSet<String> existRootSet = new HashSet<String>(64);
            while (firstSet.hasNext()) {
                Row row = firstSet.next();
                String featuretypeId = row.getString("featuretype");
                String entrymaterialId = row.getString("entrymaterialId");
                String entryversion = row.getString("entryversion");
                entryauxproperty = row.getString("entryauxproperty");
                String rootId = "";
                rootId = isFeature ? this.getNodeAndPNodeId(featuretypeId, entryversion, entryauxproperty, "featureType", "0", demandCountTmp, showtype) : this.getNodeAndPNodeId(entrymaterialId, entryversion, entryauxproperty, "material", "0", demandCountTmp, showtype);
                String number = rootObj.getString("number");
                String name = rootObj.getString("name");
                StringBuilder rootName = new StringBuilder();
                rootName.append(number);
                rootName.append("[");
                rootName.append(name);
                rootName.append("]");
                TreeNode rootNode = new TreeNode("root", rootId, rootName.toString());
                if (!rootIdSet.add(rootId)) continue;
                this.setFirstTreeNodeListExt(rootNode, showtype, row);
                retList.add(rootNode);
                versionId = entryversion;
                if (treeNodeMap == null) {
                    ArrayList<TreeNode> arrayList = retList;
                    return arrayList;
                }
                this.createTreeNode(retList, dataSetList, showtype, treeNodeMap, versionId, entryauxproperty, entrymaterialId, featuretypeId, headObjType, existRootSet, verConfig);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("find-fail", ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25", (String)"BOMBackwardSearchReportTreePlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        finally {
            if (firstSet != null) {
                firstSet.close();
            }
            dataSet.close();
        }
        return retList;
    }

    private void createTreeNode(List<TreeNode> retList, List<Map<String, Object>> dataSetList, String showtype, Map<String, Map<String, String>> treeNodeMap, String versionId, String auxpropertyId, String entryMatId, String featuretypeId, String headObjType, Set<String> existRootSet, String verConfig) {
        try {
            String entrymaterialId;
            String randomId;
            int i = 1;
            boolean isNewVersionMode = "B".equals(verConfig);
            if (isNewVersionMode && "A".equals(showtype)) {
                ArrayList<String> vList;
                HashMap parentVersionMap = new HashMap(16);
                for (Map<String, Object> dataMap : dataSetList) {
                    String keyString;
                    String parentNum = "";
                    randomId = "";
                    entrymaterialId = null;
                    String entryversion = "";
                    randomId = dataMap.get("randomId") == null ? "" : dataMap.get("randomId").toString();
                    entrymaterialId = dataMap.get("entrymaterialId") == null ? "" : dataMap.get("entrymaterialId").toString();
                    entryversion = dataMap.get("entryversion") == null ? "" : dataMap.get("entryversion").toString();
                    String[] num = randomId.split("-");
                    if (num.length == 1) {
                        parentNum = "0";
                        if ("featureType".equals(headObjType) && !"C".equals(showtype)) {
                            entrymaterialId = dataMap.get("featuretype") == null ? "" : dataMap.get("featuretype").toString();
                        }
                    } else {
                        parentNum = num[num.length - 2];
                    }
                    if ((vList = (ArrayList<String>)parentVersionMap.get(keyString = parentNum + "_" + entrymaterialId)) == null) {
                        vList = new ArrayList<String>(16);
                    }
                    if (vList.contains(entryversion)) continue;
                    vList.add(entryversion);
                    parentVersionMap.put(keyString, vList);
                }
                HashMap<Integer, Map<String, Object>> addDataSetMap = new HashMap<Integer, Map<String, Object>>(16);
                for (int dsize = 0; dsize < dataSetList.size(); ++dsize) {
                    String childNum;
                    Map<String, Object> dataMap = dataSetList.get(dsize);
                    String randomId2 = "";
                    if ("B".equals(showtype)) {
                        childNum = "0";
                        randomId2 = dataMap.get("randomId") == null ? "" : dataMap.get("randomId").toString();
                    } else if ("C".equals(showtype)) {
                        childNum = "0" + i;
                        ++i;
                    } else {
                        childNum = "";
                        randomId2 = dataMap.get("randomId") == null ? "" : dataMap.get("randomId").toString();
                    }
                    String[] num = randomId2.split("-");
                    if (num.length == 1) {
                        if (!"C".equals(showtype)) {
                            childNum = randomId2;
                        }
                    } else {
                        childNum = num[num.length - 1];
                    }
                    String materialId = dataMap.get("materialId") == null ? "" : dataMap.get("materialId").toString();
                    String parentKeys = childNum + "_" + materialId;
                    vList = (List)parentVersionMap.get(parentKeys);
                    int size = vList == null ? 0 : vList.size();
                    for (int loop = 0; loop < size; ++loop) {
                        if (loop == 0) {
                            dataMap.put("version", vList.get(loop));
                            continue;
                        }
                        dataMap = new HashMap<String, Object>(dataMap);
                        dataMap.put("version", vList.get(loop));
                        addDataSetMap.put(dsize + loop, dataMap);
                    }
                }
                if (!addDataSetMap.isEmpty()) {
                    for (Map.Entry entrys : addDataSetMap.entrySet()) {
                        dataSetList.add((Integer)entrys.getKey(), (Map<String, Object>)entrys.getValue());
                    }
                }
            }
            for (Map<String, Object> dataMap : dataSetList) {
                String parentNum;
                String childNum;
                randomId = "";
                entrymaterialId = null;
                String entryauxproperty = null;
                String nodeType = "material";
                String entryversion = versionId;
                if ("B".equals(showtype)) {
                    String parentNum2 = "0";
                    childNum = "0";
                    randomId = dataMap.get("randomId") == null ? "" : dataMap.get("randomId").toString();
                    entrymaterialId = dataMap.get("entrymaterialId") == null ? "" : dataMap.get("entrymaterialId").toString();
                    entryversion = dataMap.get("tmpver") == null ? "" : dataMap.get("tmpver").toString();
                    entryauxproperty = dataMap.get("entryauxproperty") == null ? "" : dataMap.get("entryauxproperty").toString();
                } else if ("C".equals(showtype)) {
                    String parentNum3 = "0";
                    childNum = "0" + i;
                    if ("featureType".equals(headObjType)) {
                        nodeType = "featureType";
                        entrymaterialId = String.valueOf(featuretypeId);
                    } else {
                        entrymaterialId = String.valueOf(entryMatId);
                    }
                    entryversion = versionId;
                    entryauxproperty = auxpropertyId;
                    ++i;
                } else {
                    childNum = "";
                    randomId = dataMap.get("randomId") == null ? "" : dataMap.get("randomId").toString();
                    entrymaterialId = dataMap.get("entrymaterialId") == null ? "" : dataMap.get("entrymaterialId").toString();
                    entryversion = dataMap.get("entryversion") == null ? "" : dataMap.get("entryversion").toString();
                    entryauxproperty = dataMap.get("entryauxproperty") == null ? "" : dataMap.get("entryauxproperty").toString();
                }
                String[] num = randomId.split("-");
                if (num.length == 1) {
                    parentNum = "0";
                    if (!"C".equals(showtype)) {
                        childNum = randomId;
                    }
                    if ("featureType".equals(headObjType) && !"C".equals(showtype)) {
                        nodeType = "featureType";
                        entrymaterialId = dataMap.get("featuretype") == null ? "" : dataMap.get("featuretype").toString();
                    }
                } else {
                    parentNum = num[num.length - 2];
                    childNum = num[num.length - 1];
                }
                String materialId = dataMap.get("materialId") == null ? "" : dataMap.get("materialId").toString();
                String version = dataMap.get("version") == null ? "" : dataMap.get("version").toString();
                String auxproperty = dataMap.get("auxproperty") == null ? "" : dataMap.get("auxproperty").toString();
                String entryversionStr = entryversion;
                Map<String, String> mateMap = treeNodeMap.get(materialId);
                if (mateMap == null) continue;
                String number = mateMap.get("number");
                String name = mateMap.get("name");
                BigDecimal commonused = null;
                BigDecimal pcommonused = null;
                if ("A".equals(showtype)) {
                    commonused = (BigDecimal)dataMap.get("commonused");
                    pcommonused = (BigDecimal)dataMap.get("pcommonused");
                }
                String pNodeId = this.getNodeAndPNodeId(entrymaterialId, entryversionStr, entryauxproperty, nodeType, parentNum, pcommonused, showtype);
                String nodeId = this.getNodeAndPNodeId(materialId, version, auxproperty, "material", childNum, commonused, showtype);
                String text = number + "[" + name + "]";
                if (!existRootSet.add(nodeId)) continue;
                TreeNode node = new TreeNode(pNodeId, nodeId, text);
                this.setTreeNodeListExt(node, showtype, dataMap);
                retList.add(node);
                existRootSet.add(nodeId);
            }
        }
        catch (Exception e) {
            Object[] stackTrace = e.getStackTrace();
            logger.info(Arrays.toString(stackTrace));
            logger.info(e.getMessage());
            throw new KDBizException((Throwable)e, new ErrorCode("find-fail", ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25", (String)"BOMBackwardSearchReportTreePlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
    }

    public void setTreeNodeListExt(TreeNode node, String showtype, Map<String, Object> dataMap) {
    }

    public void setFirstTreeNodeListExt(TreeNode node, String showtype, Row row) {
    }

    private String getNodeAndPNodeId(String materialId, String version, String auxproperty, String searchType, String childNum, BigDecimal useCount, String showType) {
        JSONObject pObj = new JSONObject(new LinkedHashMap(16));
        pObj.put("objectId", (Object)materialId);
        pObj.put("version", (Object)version);
        if ("A".equals(showType)) {
            useCount = useCount.stripTrailingZeros();
            String useCountStr = useCount.toPlainString();
            pObj.put("usesCount", (Object)useCountStr);
        }
        pObj.put("auxproperty", (Object)auxproperty);
        pObj.put("nodeType", (Object)searchType);
        pObj.put("childNum", (Object)childNum);
        return pObj.toJSONString();
    }

    private Map<String, Map<String, String>> getMaterial(List<Map<String, Object>> dataSetList) {
        Set mids = dataSetList.stream().map(p -> (Long)p.get("materialId")).collect(Collectors.toSet());
        if (mids.isEmpty()) {
            return Collections.emptyMap();
        }
        QFilter material = new QFilter("id", "in", mids);
        HashMap<String, Map<String, String>> treeNodeMap = new HashMap<String, Map<String, String>>(mids.size());
        try (DataSet materialMtfDataSet = QueryServiceHelper.queryDataSet((String)(BomFowordSearchReportTreePlugin.class.getName() + "_getMaterial"), (String)"bd_material", (String)"id,number,name,modelnum", (QFilter[])new QFilter[]{material}, null);){
            while (materialMtfDataSet.hasNext()) {
                Row mateRow = materialMtfDataSet.next();
                String id = mateRow.getString("id");
                String number = String.valueOf(mateRow.get("number"));
                String name = String.valueOf(mateRow.get("name"));
                String modelnum = String.valueOf(mateRow.get("modelnum"));
                HashMap<String, String> mateMap = new HashMap<String, String>(16);
                mateMap.put("number", number);
                mateMap.put("name", name);
                mateMap.put("modelnum", modelnum);
                treeNodeMap.put(id, mateMap);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("find-fail", ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25", (String)"BOMBackwardSearchReportTreePlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        return treeNodeMap;
    }
}

