/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.mftbom.bomsearch.batch;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BomBatchImportUtils {
    private static Log log = LogFactory.getLog(BomBatchImportUtils.class);

    public static Map<String, String> dealWorkbookDatas(InputStream inputStream, String oldExcelData, String queryType, String uid) throws IOException {
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        resultMap.put("errorString", "");
        resultMap.put("resultString", "");
        XSSFWorkbook wb = (XSSFWorkbook)WorkbookFactory.create((InputStream)inputStream);
        XSSFSheet sheet = wb.getSheetAt(0);
        wb.close();
        if (sheet == null) {
            resultMap.put("errorString", String.format(BomBatchImportUtils.getModelError(), "wb.getSheetAt(0) == null"));
            return resultMap;
        }
        XSSFRow firstRow = sheet.getRow(0);
        if (firstRow == null) {
            resultMap.put("errorString", String.format(BomBatchImportUtils.getModelError(), "sheet.getRow(0) == null"));
            return resultMap;
        }
        XSSFRow secondRow = sheet.getRow(1);
        if (secondRow == null) {
            resultMap.put("errorString", String.format(BomBatchImportUtils.getModelError(), ResManager.loadKDString((String)"Excel\u4e2d\u65e0\u6570\u636e\u3002", (String)"BomBatchImportUtils_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0])));
            return resultMap;
        }
        HashMap<String, Integer> dataTypeMap = new HashMap<String, Integer>(8);
        Set<String> leastAttr = BomBatchImportUtils.initColumnNames(queryType);
        for (int i = 0; i < firstRow.getLastCellNum(); ++i) {
            String columnName = firstRow.getCell(i).getStringCellValue();
            if (dataTypeMap.get(columnName) != null) {
                StringBuilder fields = new StringBuilder();
                fields.append(ResManager.loadKDString((String)"\u8868\u7ed3\u6784\u9519\u8bef\uff0c\u6570\u636e\u5217", (String)"BomBatchImportUtils_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0])).append(columnName).append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"BomBatchImportUtils_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                resultMap.put("errorString", fields.toString());
                return resultMap;
            }
            if (!leastAttr.contains(columnName)) continue;
            dataTypeMap.put(columnName, i);
        }
        String chkMsg = BomBatchImportUtils.checkColumnExists(dataTypeMap, leastAttr);
        if (!kd.bos.util.StringUtils.isEmpty((String)chkMsg)) {
            resultMap.put("errorString", chkMsg);
            return resultMap;
        }
        int sheetSize = sheet.getLastRowNum();
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>(sheetSize);
        HashSet<String> materialNumberSet = new HashSet<String>(16);
        HashSet<String> bomVersionNumberSet = new HashSet<String>(16);
        HashSet<String> wbsNumberSet = new HashSet<String>(16);
        HashSet<String> insteadNumberSet = new HashSet<String>(16);
        HashSet<String> configurecodeNumberSet = new HashSet<String>(16);
        HashSet<String> featureTypeNumberSet = new HashSet<String>(16);
        boolean isLastRow = false;
        for (int i = 1; i <= sheetSize; ++i) {
            XSSFRow dataRow = sheet.getRow(i);
            if (dataRow == null) continue;
            if (isLastRow) break;
            boolean isfindData = false;
            Integer rowNum = dataRow.getRowNum();
            HashMap<String, String> map = new HashMap<String, String>();
            for (String columnName : leastAttr) {
                XSSFCell cells = dataRow.getCell(((Integer)dataTypeMap.get(columnName)).intValue());
                String cellValue = BomBatchImportUtils.getCellString((Cell)cells);
                if (BomBatchImportUtils.isMaterialNumberColumn(columnName)) {
                    if (!StringUtils.isEmpty((CharSequence)cellValue)) {
                        if (BomBatchImportUtils.isTipsValue(cellValue)) {
                            isLastRow = true;
                            break;
                        }
                        materialNumberSet.add(cellValue);
                        isfindData = true;
                    }
                    map.put("querymaterial", cellValue);
                }
                if (BomBatchImportUtils.isBomVersionNumberColumn(columnName)) {
                    if (!StringUtils.isEmpty((CharSequence)cellValue)) {
                        bomVersionNumberSet.add(cellValue);
                        isfindData = true;
                    }
                    map.put("querybomversion", cellValue);
                }
                if (BomBatchImportUtils.isFeatureTypeNumberColumn(columnName)) {
                    if (!StringUtils.isEmpty((CharSequence)cellValue)) {
                        featureTypeNumberSet.add(cellValue);
                        isfindData = true;
                    }
                    map.put("queryfeaturetype", cellValue);
                }
                if (BomBatchImportUtils.isWbsNumberColumn(columnName)) {
                    if (!StringUtils.isEmpty((CharSequence)cellValue)) {
                        wbsNumberSet.add(cellValue);
                        isfindData = true;
                    }
                    map.put("querybomwbs", cellValue);
                }
                if (BomBatchImportUtils.isInsteadNumberColumn(columnName)) {
                    if (!StringUtils.isEmpty((CharSequence)cellValue)) {
                        insteadNumberSet.add(cellValue);
                        isfindData = true;
                    }
                    map.put("queryinsteadnum", cellValue);
                }
                if (BomBatchImportUtils.isConfigureCodeNumberColumn(columnName)) {
                    if (!StringUtils.isEmpty((CharSequence)cellValue)) {
                        configurecodeNumberSet.add(cellValue);
                        isfindData = true;
                    }
                    map.put("queryconfigurecode", cellValue);
                }
                if (!BomBatchImportUtils.isQtyColumn(columnName)) continue;
                map.put("queryqty", cellValue);
            }
            if (isLastRow) break;
            if (!isfindData) continue;
            dataList.add(map);
        }
        try {
            Map<String, DynamicObject> confiureDyMap = BomBatchImportUtils.checkExcelConfigureCodeDataValidity(configurecodeNumberSet);
            Map<String, DynamicObject> materialDyMap = BomBatchImportUtils.checkExcelMaterialDataValidity(materialNumberSet);
            Map<String, DynamicObject> bomversionDyMap = BomBatchImportUtils.checkExcelBomVersionDataValidity(bomVersionNumberSet);
            Map<String, DynamicObject> insteadnumDyMap = BomBatchImportUtils.checkExcelInsteadNumDataValidity(insteadNumberSet);
            Map<String, DynamicObject> wbsnumDyMap = BomBatchImportUtils.checkExcelWBSNumDataValidity(wbsNumberSet);
            Map<String, DynamicObject> featureTypeDyMap = BomBatchImportUtils.checkExcelFeatureTypeDataValidity(featureTypeNumberSet);
            String resultStr = BomBatchImportUtils.addToEntry(dataList, confiureDyMap, materialDyMap, bomversionDyMap, wbsnumDyMap, insteadnumDyMap, featureTypeDyMap, oldExcelData, uid);
            resultMap.put("resultString", resultStr);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            String errorMsg = PlatformUtils.getSimpleExceptionString((Exception)e);
            resultMap.put("errorString", errorMsg);
        }
        return resultMap;
    }

    private static boolean isTipsValue(String objectValue) {
        String tipsName = BomBatchImportUtils.getBackSearchExcelTips();
        return tipsName.equals(objectValue);
    }

    public static String getBackSearchExcelTips() {
        return ResManager.loadKDString((String)"\u63d0\u793a\uff1a\u7279\u5f81\u7c7b\u548c\u7269\u6599\u4e0d\u80fd\u540c\u65f6\u586b\u5199\u5728\u4e00\u884c\u4e2d\u3002", (String)"BomBatchImportUtils_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private static Set<String> initColumnNames(String queryType) {
        HashSet<String> leastAttr = new HashSet<String>();
        if ("bombatchforwardsearch".equalsIgnoreCase(queryType)) {
            leastAttr.add(BomBatchImportUtils.getQueryMaterialHeadName());
            leastAttr.add(BomBatchImportUtils.getQueryConfigureCodeHeadName());
            leastAttr.add(BomBatchImportUtils.getQueryBomVersionHeadName());
            leastAttr.add(BomBatchImportUtils.getQueryWBSNumHeadName());
            leastAttr.add(BomBatchImportUtils.getQueryInsteadNumHeadName());
            leastAttr.add(BomBatchImportUtils.getQueryQtyHeadName());
        } else if ("bombatchbacksearch".equalsIgnoreCase(queryType)) {
            leastAttr.add(BomBatchImportUtils.getQueryMaterialHeadName());
            leastAttr.add(BomBatchImportUtils.getQueryFeatureTypeHeadName());
            leastAttr.add(BomBatchImportUtils.getQueryBomVersionHeadName());
            leastAttr.add(BomBatchImportUtils.getQueryWBSNumHeadName());
            leastAttr.add(BomBatchImportUtils.getQueryInsteadNumHeadName());
            leastAttr.add(BomBatchImportUtils.getQueryQtyHeadName());
        }
        return leastAttr;
    }

    private static String getCellString(Cell xssfCell) {
        if (xssfCell == null) {
            return "";
        }
        if (xssfCell.getCellType() == CellType.NUMERIC) {
            NumberFormat n = NumberFormat.getInstance();
            double d = xssfCell.getNumericCellValue();
            return n.format(d).replace(",", "");
        }
        if (xssfCell.getCellType() == CellType.BOOLEAN) {
            return String.valueOf(xssfCell.getBooleanCellValue());
        }
        if (xssfCell.getCellType() == CellType.FORMULA) {
            String value = "";
            try {
                NumberFormat n = NumberFormat.getInstance();
                double d = xssfCell.getNumericCellValue();
                value = n.format(d).replace(",", "");
            }
            catch (IllegalStateException e) {
                value = String.valueOf(xssfCell.getRichStringCellValue());
            }
            return value;
        }
        return xssfCell.getStringCellValue();
    }

    private static Map<String, DynamicObject> checkExcelBomVersionDataValidity(Set<String> bomVersionNumberSet) {
        String selectProperties = "id,number,name";
        return BomBatchImportUtils.chkBaseDataValidity(bomVersionNumberSet, "bd_bomversion_new", selectProperties, BomBatchImportUtils.getQueryBomVersionHeadName());
    }

    private static Map<String, DynamicObject> checkExcelInsteadNumDataValidity(Set<String> insteadNumSet) {
        String selectProperties = "id,number,name";
        return BomBatchImportUtils.chkBaseDataValidity(insteadNumSet, "mpdm_replaceno", selectProperties, BomBatchImportUtils.getQueryInsteadNumHeadName());
    }

    private static Map<String, DynamicObject> checkExcelWBSNumDataValidity(Set<String> wbsNumSet) {
        String selectProperties = "id,number,name";
        return BomBatchImportUtils.chkBaseDataValidity(wbsNumSet, "bd_wbs", selectProperties, BomBatchImportUtils.getQueryWBSNumHeadName());
    }

    private static Map<String, DynamicObject> checkExcelFeatureTypeDataValidity(Set<String> featureTypeCodeSet) {
        String selectProperties = "id,number,name,basicunit";
        return BomBatchImportUtils.chkBaseDataValidity(featureTypeCodeSet, "mpdm_featuretype", selectProperties, BomBatchImportUtils.getQueryFeatureTypeHeadName());
    }

    private static Map<String, DynamicObject> checkExcelConfigureCodeDataValidity(Set<String> configureCodeSet) {
        String selectProperties = "id,number,name";
        return BomBatchImportUtils.chkBaseDataValidity(configureCodeSet, "bd_configuredcode", selectProperties, BomBatchImportUtils.getQueryConfigureCodeHeadName());
    }

    private static boolean isMaterialNumberColumn(String columnName) {
        return BomBatchImportUtils.isSameColumn(columnName, BomBatchImportUtils.getQueryMaterialHeadName());
    }

    private static boolean isConfigureCodeNumberColumn(String columnName) {
        return BomBatchImportUtils.isSameColumn(columnName, BomBatchImportUtils.getQueryConfigureCodeHeadName());
    }

    private static boolean isBomVersionNumberColumn(String columnName) {
        return BomBatchImportUtils.isSameColumn(columnName, BomBatchImportUtils.getQueryBomVersionHeadName());
    }

    private static boolean isWbsNumberColumn(String columnName) {
        return BomBatchImportUtils.isSameColumn(columnName, BomBatchImportUtils.getQueryWBSNumHeadName());
    }

    private static boolean isInsteadNumberColumn(String columnName) {
        return BomBatchImportUtils.isSameColumn(columnName, BomBatchImportUtils.getQueryInsteadNumHeadName());
    }

    private static boolean isFeatureTypeNumberColumn(String columnName) {
        return BomBatchImportUtils.isSameColumn(columnName, BomBatchImportUtils.getQueryFeatureTypeHeadName());
    }

    private static boolean isQtyColumn(String columnName) {
        return BomBatchImportUtils.isSameColumn(columnName, BomBatchImportUtils.getQueryQtyHeadName());
    }

    private static boolean isSameColumn(String columnName, String names) {
        return names.equalsIgnoreCase(columnName);
    }

    private static String getQueryMaterialHeadName() {
        return ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"BomBatchImportUtils_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private static String getQueryFeatureTypeHeadName() {
        return ResManager.loadKDString((String)"\u7279\u5f81\u7c7b.\u7f16\u7801", (String)"BomBatchImportUtils_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private static String getQueryBomVersionHeadName() {
        return ResManager.loadKDString((String)"BOM\u7248\u672c\u53f7.\u7f16\u7801", (String)"BomBatchImportUtils_6", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private static String getQueryInsteadNumHeadName() {
        return ResManager.loadKDString((String)"BOM\u66ff\u4ee3\u53f7", (String)"BomBatchImportUtils_7", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private static String getQueryWBSNumHeadName() {
        return ResManager.loadKDString((String)"WBS", (String)"BomBatchImportUtils_13", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private static String getQueryQtyHeadName() {
        return ResManager.loadKDString((String)"\u9700\u6c42\u57fa\u672c\u6570\u91cf", (String)"BomBatchImportUtils_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private static String getQueryConfigureCodeHeadName() {
        return ResManager.loadKDString((String)"\u914d\u7f6e\u53f7", (String)"BomBatchImportUtils_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private static String checkColumnExists(Map<String, Integer> dataTypeMap, Set<String> leastAttr) {
        StringBuilder error = new StringBuilder();
        for (String columnName : leastAttr) {
            if (dataTypeMap.get(columnName) != null) continue;
            error.append(ResManager.loadKDString((String)"\u8868\u7ed3\u6784\u9519\u8bef\uff0c\u6570\u636e\u5217", (String)"BomBatchImportUtils_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0])).append(columnName).append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u3002", (String)"BomBatchImportUtils_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0])).append("\r\n");
        }
        return error.toString();
    }

    private static String getModelError() {
        return ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528\u5bfc\u5165\u7684\u6a21\u677f\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%1$s\u3002", (String)"BomBatchImportUtils_11", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private static String addToEntry(List<Map<String, String>> dataList, Map<String, DynamicObject> confiureDyMap, Map<String, DynamicObject> materialDyMap, Map<String, DynamicObject> bomversionDyMap, Map<String, DynamicObject> wbsnumDyMap, Map<String, DynamicObject> insteadnumDyMap, Map<String, DynamicObject> featureTypeDyMap, String oldExcelData, String uid) {
        int size = dataList.size();
        JSONArray jsonDataArray = new JSONArray(size);
        for (int i = 0; i < size; ++i) {
            BigDecimal qty;
            Map<String, String> dataMap = dataList.get(i);
            String materialNumber = dataMap.get("querymaterial");
            Long materialId = StringUtils.isEmpty((CharSequence)materialNumber) || materialDyMap.get(materialNumber) == null ? 0L : materialDyMap.get(materialNumber).getLong("id");
            Long unitId = StringUtils.isEmpty((CharSequence)materialNumber) || materialDyMap.get(materialNumber) == null ? 0L : materialDyMap.get(materialNumber).getDynamicObject("baseunit").getLong("id");
            String bomVersionNumber = dataMap.get("querybomversion");
            Long bomVersionId = StringUtils.isEmpty((CharSequence)bomVersionNumber) || bomversionDyMap.get(bomVersionNumber) == null ? 0L : bomversionDyMap.get(bomVersionNumber).getLong("id");
            String configureCodeNumber = dataMap.get("queryconfigurecode");
            Long confiureCode = StringUtils.isEmpty((CharSequence)configureCodeNumber) || confiureDyMap.get(configureCodeNumber) == null ? 0L : confiureDyMap.get(configureCodeNumber).getLong("id");
            String wbsNumber = dataMap.get("querybomwbs");
            Long wbsId = StringUtils.isEmpty((CharSequence)wbsNumber) || wbsnumDyMap.get(wbsNumber) == null ? 0L : wbsnumDyMap.get(wbsNumber).getLong("id");
            String insteadNumber = dataMap.get("queryinsteadnum");
            Long insteadNumId = StringUtils.isEmpty((CharSequence)insteadNumber) || insteadnumDyMap.get(insteadNumber) == null ? 0L : insteadnumDyMap.get(insteadNumber).getLong("id");
            String featureTypeNumber = dataMap.get("queryfeaturetype");
            Long featureTypeId = StringUtils.isEmpty((CharSequence)featureTypeNumber) || featureTypeDyMap.get(featureTypeNumber) == null ? 0L : featureTypeDyMap.get(featureTypeNumber).getLong("id");
            String qtys = dataMap.get("queryqty");
            BigDecimal bigDecimal = qty = StringUtils.isEmpty((CharSequence)qtys) ? BigDecimal.ONE : new BigDecimal(qtys);
            if (qty.compareTo(BigDecimal.ZERO) <= 0) {
                qty = BigDecimal.ONE;
            }
            JSONObject jsonData = new JSONObject();
            jsonData.put("querymaterial", (Object)materialId);
            jsonData.put("querybomversion", (Object)bomVersionId);
            jsonData.put("queryconfigurecode", (Object)confiureCode);
            jsonData.put("queryfeaturetype", (Object)featureTypeId);
            jsonData.put("querybomwbs", (Object)wbsId);
            jsonData.put("queryinsteadnum", (Object)insteadNumId);
            jsonData.put("queryqty", (Object)qty);
            jsonData.put("queryunit", (Object)unitId);
            jsonData.put("uid", (Object)uid);
            jsonDataArray.add((Object)jsonData);
        }
        return BomBatchImportUtils.addExcelDataJsonObject(jsonDataArray, oldExcelData);
    }

    private static String addExcelDataJsonObject(JSONArray jsonData, String oldExcelData) {
        if (jsonData == null || jsonData.isEmpty()) {
            return "";
        }
        String newJsonData = jsonData.toJSONString();
        if (!StringUtils.isEmpty((CharSequence)oldExcelData)) {
            JSONArray oldData = JSON.parseArray((String)oldExcelData);
            oldData.addAll((Collection)jsonData);
            newJsonData = oldData.toJSONString();
        }
        return newJsonData;
    }

    private static Map<String, DynamicObject> checkExcelMaterialDataValidity(Set<String> materialNumberSet) {
        String selectProperties = "id,number,name,baseunit";
        return BomBatchImportUtils.chkBaseDataValidity(materialNumberSet, "bd_material", selectProperties, BomBatchImportUtils.getQueryMaterialHeadName());
    }

    private static Map<String, DynamicObject> chkBaseDataValidity(Set<String> numberSet, String entityName, String selectProperties, String baseName) {
        if (numberSet.isEmpty()) {
            return new HashMap<String, DynamicObject>(16);
        }
        QFilter qfilter = new QFilter("number", "in", numberSet);
        Map maps = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{qfilter});
        Map<String, DynamicObject> numberMap = BomBatchImportUtils.convertToNumberMap(maps);
        StringBuilder error = new StringBuilder();
        for (String number : numberSet) {
            if (numberMap.get(number) != null) continue;
            error.append(baseName).append(number).append(ResManager.loadKDString((String)"\u5728\u57fa\u7840\u8d44\u6599\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"BomBatchImportUtils_12", (String)"mmc-pdm-formplugin", (Object[])new Object[0])).append("\r\n");
        }
        if (error.length() > 0) {
            throw new KDBizException(error.toString());
        }
        return numberMap;
    }

    private static Map<String, DynamicObject> convertToNumberMap(Map<Object, DynamicObject> maps) {
        if (maps == null || maps.isEmpty()) {
            return new HashMap<String, DynamicObject>(16);
        }
        HashMap<String, DynamicObject> numberMap = new HashMap<String, DynamicObject>(16);
        for (Map.Entry<Object, DynamicObject> entrys : maps.entrySet()) {
            DynamicObject entry = entrys.getValue();
            numberMap.put(entry.getString("number"), entry);
        }
        return numberMap;
    }
}

