/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.mftbom.bomsearch.batch;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.ORGAndPermissionUtils;

public class BomBatchSearchFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
IDataModelChangeListener {
    private static Log log = LogFactory.getLog(BomBatchSearchFormPlugin.class);

    public Set<String> sortAndFilterFieldSet() {
        return new HashSet<String>(16);
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        RequestContext rc = RequestContext.get();
        long orgId = rc.getOrgId();
        long userId = rc.getCurrUserId();
        this.initOrg(orgId, userId);
    }

    public void initOrg(Long orgId, Long userId) {
        IReportView view = this.getView();
        IDataModel model = view.getModel();
        if (orgId.equals(0L)) {
            model.setValue("org", (Object)0L);
            return;
        }
        String entityNum = model.getDataEntityType().getName();
        String appId = model.getDataEntityType().getAppId();
        Long orgByUserOrg = ORGAndPermissionUtils.getOrgByUserOrg((Long)userId, (Long)orgId, (String)entityNum, (String)appId, (String)"47150e89000000ac", (String)"04");
        model.setValue("org", (Object)orgByUserOrg);
    }

    public void registerListener(EventObject e) {
        BasedataEdit orgText = (BasedataEdit)this.getView().getControl("org");
        orgText.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        ListFilterParameter lfp;
        IDataEntityProperty srcDEP = e.getProperty();
        String srcDEPName = srcDEP == null ? null : srcDEP.getName();
        FormShowParameter fsp = e.getFormShowParameter();
        if (fsp == null) {
            return;
        }
        ListShowParameter lsp = fsp instanceof ListShowParameter ? (ListShowParameter)fsp : null;
        ListFilterParameter listFilterParameter = lfp = lsp == null ? null : lsp.getListFilterParameter();
        if (lsp == null) {
            return;
        }
        if (lfp == null) {
            return;
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if ("org".equals(srcDEPName)) {
            RequestContext requestContext = RequestContext.get();
            long userID = Long.parseLong(requestContext.getUserId());
            String formId = this.getView().getFormShowParameter().getFormId();
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)BizAppServiceHelp.getAppIdByAppNumber((String)"pdm"), (String)formId, (String)"47150e89000000ac");
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                List orgIds = hasPermOrgResult.getHasPermOrgs();
                qFilterList.add(new QFilter("id", "in", (Object)orgIds));
            }
        }
        if (!MMCUtils.isEmptyList(qFilterList)) {
            lfp.setQFilters(qFilterList);
            lsp.setListFilterParameter(lfp);
            e.setFormShowParameter((FormShowParameter)lsp);
        }
    }

    public String getQueryMaterialHeadName() {
        return ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"BomBatchSearchFormPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    public String getQueryFeatureTypeHeadName() {
        return ResManager.loadKDString((String)"\u9009\u9879\u7c7b.\u7f16\u7801", (String)"BomBatchSearchFormPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    public String getQueryBomVersionHeadName() {
        return ResManager.loadKDString((String)"BOM\u7248\u672c\u53f7.\u7f16\u7801", (String)"BomBatchSearchFormPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    public String getQueryInsteadNumHeadName() {
        return ResManager.loadKDString((String)"BOM\u66ff\u4ee3\u53f7", (String)"BomBatchSearchFormPlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    public String getQueryQtyHeadName() {
        return ResManager.loadKDString((String)"\u9700\u6c42\u57fa\u672c\u6570\u91cf", (String)"BomBatchSearchFormPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    public String getQueryConfigureCodeHeadName() {
        return ResManager.loadKDString((String)"\u914d\u7f6e\u53f7", (String)"BomBatchSearchFormPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    public String getLevelName() {
        return ResManager.loadKDString((String)"\u5c42\u7ea7", (String)"BomBatchSearchFormPlugin_6", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    public String getQueryWBSName() {
        return ResManager.loadKDString((String)"WBS", (String)"BomBatchSearchFormPlugin_7", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        Set<String> sortFilterSet = this.sortAndFilterFieldSet();
        for (SortAndFilterEvent sort : allColumns) {
            if (!sortFilterSet.contains(sort.getColumnName())) continue;
            sort.setSort(true);
            sort.setFilter(true);
        }
    }

    public String getExcelName(Date searchDate, DynamicObject org) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String name = sdf.format(searchDate);
        if (org != null) {
            name = name + "_" + org.getString("name");
        }
        return name;
    }

    public void addToEntry(String excelData) {
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e == null) {
            return;
        }
        switch (e.getActionId()) {
            case "pdm_bomexcelimport": {
                Object returnData = e.getReturnData();
                if (returnData == null) {
                    return;
                }
                Map result = (Map)returnData;
                String excelData = (String)result.get("excelimportdata");
                this.addToEntry(excelData);
                break;
            }
        }
    }

    public String getFieldName(String fieldNumber) {
        if ("level".equalsIgnoreCase(fieldNumber)) {
            return this.getLevelName();
        }
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        if (reportList == null) {
            return fieldNumber;
        }
        List columnList = reportList.getColumns();
        for (AbstractReportColumn columns : columnList) {
            ReportColumn column = (ReportColumn)columns;
            if (!column.getFieldKey().equalsIgnoreCase(fieldNumber)) continue;
            return column.getCaption().getLocaleValue();
        }
        return fieldNumber;
    }
}

