/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.mftbom.bomsearch.batch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.pdm.formplugin.mftbom.bomsearch.batch.BomBatchImportUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BomBatchSearchImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String BTNDOWNLOAD = "btndownload";
    private static final String BTNOK = "imbtnok";
    private static final String FILEIMPORT = "fileimport";
    private static final String EXCELIMPORTDATA = "excelimportdata";
    private static Log log = LogFactory.getLog(BomBatchSearchImportPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK, BTNDOWNLOAD});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(FILEIMPORT);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    private String getExcelDataJsonObject() {
        return this.getView().getPageCache().get(EXCELIMPORTDATA);
    }

    private boolean isBatchForwardSearch() {
        String type = (String)this.getView().getFormShowParameter().getCustomParam("bombatchquerytype");
        return "bombatchforwardsearch".equalsIgnoreCase(type);
    }

    private boolean isBatchBackSearch() {
        String type = (String)this.getView().getFormShowParameter().getCustomParam("bombatchquerytype");
        return "bombatchbacksearch".equalsIgnoreCase(type);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        if (BTNOK.equals(key)) {
            String excelData = this.getExcelDataJsonObject();
            if (StringUtils.isEmpty((CharSequence)excelData)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230Excel\u6570\u636e,\u8bf7\u5148\u4e0a\u4f20Excle\u6587\u4ef6\u3002", (String)"BomBatchSearchImportPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                return;
            }
            IFormView view = this.getView();
            FormShowParameter showParam = view.getFormShowParameter();
            Map param = showParam.getCustomParams();
            param.put(EXCELIMPORTDATA, excelData);
            view.returnDataToParent((Object)param);
            view.close();
        } else if (BTNDOWNLOAD.equals(key)) {
            this.downExcelModel();
        }
    }

    private void downExcelModel() {
        String excelName = "";
        if (this.isBatchForwardSearch()) {
            excelName = ResManager.loadKDString((String)"BOM\u6279\u91cf\u6b63\u67e5\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx", (String)"BomBatchSearchImportPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        } else if (this.isBatchBackSearch()) {
            excelName = ResManager.loadKDString((String)"BOM\u6279\u91cf\u53cd\u67e5\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx", (String)"BomBatchSearchImportPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        }
        this.createExcel(excelName, this.getEntryHeadNames());
    }

    public void afterUpload(UploadEvent evt) {
        for (Object url : evt.getUrls()) {
            Map map = (Map)url;
            this.parsingFiles((String)map.get("type"), (String)map.get("url"), (String)map.get("uid"));
        }
    }

    public void afterRemove(UploadEvent evt) {
        super.afterRemove(evt);
        Object[] delUrls = evt.getUrls();
        String cachUrl = this.getExcelDataJsonObject();
        if (StringUtils.isNotEmpty((CharSequence)cachUrl)) {
            List cachUrlList = (List)SerializationUtils.fromJsonString((String)cachUrl, List.class);
            String delUrlUid = (String)((Map)delUrls[0]).get("uid");
            ArrayList<Map> delList = new ArrayList<Map>();
            for (int i = 0; i < cachUrlList.size(); ++i) {
                Map cachUrlMap = (Map)cachUrlList.get(i);
                String cachUrlUid = (String)cachUrlMap.get("uid");
                if (!StringUtils.equals((CharSequence)delUrlUid, (CharSequence)cachUrlUid)) continue;
                delList.add(cachUrlMap);
            }
            cachUrlList.removeAll(delList);
            this.getView().getPageCache().put(EXCELIMPORTDATA, SerializationUtils.toJsonString((Object)cachUrlList));
        }
    }

    private void parsingFiles(String type, String fileUrl, String uid) {
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inputStream = null;
        try {
            String errorString;
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>(1);
            int int_0 = 0;
            int int_1 = 1;
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[int_0], p[int_1]);
            }
            String queryType = (String)this.getView().getFormShowParameter().getCustomParam("bombatchquerytype");
            String oldExcelData = this.getExcelDataJsonObject();
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            if (content == null) {
                return;
            }
            inputStream = content.getInputStream();
            Map<String, String> resultMap = BomBatchImportUtils.dealWorkbookDatas(inputStream, oldExcelData, queryType, uid);
            String string = errorString = resultMap.get("errorString") == null ? "" : resultMap.get("errorString");
            if (!kd.bos.util.StringUtils.isEmpty((String)errorString)) {
                this.getView().showTipNotification(errorString);
                return;
            }
            this.getView().getPageCache().put(EXCELIMPORTDATA, resultMap.get("resultString") == null ? "" : resultMap.get("resultString"));
        }
        catch (Exception e) {
            throw new KDBizException(new ErrorCode(e.getMessage(), e.getMessage()), new Object[]{e});
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    private String[] getEntryHeadNames() {
        if (this.isBatchForwardSearch()) {
            return new String[]{this.getQueryMaterialHeadName(), this.getQueryConfigureCodeHeadName(), this.getQueryBomVersionHeadName(), this.getQueryWBSHeadName(), this.getQueryInsteadNumHeadName(), this.getQueryQtyHeadName()};
        }
        return new String[]{this.getQueryMaterialHeadName(), this.getQueryFeatureTypeHeadName(), this.getQueryBomVersionHeadName(), this.getQueryWBSHeadName(), this.getQueryInsteadNumHeadName(), this.getQueryQtyHeadName()};
    }

    private String getQueryMaterialHeadName() {
        return ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"BomBatchSearchImportPlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private String getQueryFeatureTypeHeadName() {
        return ResManager.loadKDString((String)"\u7279\u5f81\u7c7b.\u7f16\u7801", (String)"BomBatchSearchImportPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private String getQueryBomVersionHeadName() {
        return ResManager.loadKDString((String)"BOM\u7248\u672c\u53f7.\u7f16\u7801", (String)"BomBatchSearchImportPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private String getQueryInsteadNumHeadName() {
        return ResManager.loadKDString((String)"BOM\u66ff\u4ee3\u53f7", (String)"BomBatchSearchImportPlugin_6", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private String getQueryQtyHeadName() {
        return ResManager.loadKDString((String)"\u9700\u6c42\u57fa\u672c\u6570\u91cf", (String)"BomBatchSearchImportPlugin_7", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private String getQueryConfigureCodeHeadName() {
        return ResManager.loadKDString((String)"\u914d\u7f6e\u53f7", (String)"BomBatchSearchImportPlugin_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private String getQueryWBSHeadName() {
        return ResManager.loadKDString((String)"WBS", (String)"BomBatchSearchImportPlugin_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    private void createExcel(String excelName, String[] entryHeadNames) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFCellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setFillForegroundColor((short)13);
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            XSSFSheet sheet = workbook.createSheet(ResManager.loadKDString((String)"\u6279\u91cf\u5bfc\u5165\u6570\u636e", (String)"BomBatchSearchImportPlugin_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            XSSFRow row = sheet.createRow(0);
            for (int i = 0; i < entryHeadNames.length; ++i) {
                sheet.setColumnWidth(i, 7000);
                XSSFCell cell = row.createCell(i, CellType.STRING);
                cell.setCellValue(entryHeadNames[i]);
                cell.setCellStyle((CellStyle)cellStyle);
            }
            if (this.isBatchBackSearch()) {
                this.createSheetTips(sheet, row, workbook);
            }
            workbook.write((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String url = tempFileCache.saveAsUrl(excelName, (InputStream)byteArrayInputStream, 7200);
            this.getView().download(url);
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void createSheetTips(XSSFSheet sheet, XSSFRow row, XSSFWorkbook workbook) {
        XSSFRow tipRow = sheet.createRow(8);
        XSSFFont font = workbook.createFont();
        font.setColor(IndexedColors.RED.getIndex());
        XSSFCellStyle newStyle = workbook.createCellStyle();
        newStyle.setFont((Font)font);
        XSSFCell cell = tipRow.createCell(0);
        cell.setCellStyle((CellStyle)newStyle);
        cell.setCellValue(this.getBackSearchExcelTips());
    }

    private String getBackSearchExcelTips() {
        return BomBatchImportUtils.getBackSearchExcelTips();
    }
}

