/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.mftbom.report;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.bom.ReplacePlanBusiness;
import kd.bd.mpdm.common.bombasedata.ReplaceUpdateBomUtils;
import kd.bd.mpdm.formplugin.bombasedata.ReplacePlanUpdateBomRunner;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.operate.MutexHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class CopyCodeFromReplacePlanUtils {
    private IPageCache pageCache;
    private IFormView formView;

    public CopyCodeFromReplacePlanUtils(IPageCache pageCache, IFormView formView) {
        this.pageCache = pageCache;
        this.formView = formView;
    }

    public boolean checkSelectDataSize(Object[] pkIds) {
        if (pkIds == null || pkIds.length < 1 || pkIds[0] == null || pkIds[0].equals(0L)) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u7ec4\u4ef6\u66ff\u4ee3\u65b9\u6848\u6570\u636e\u3002", (String)"CopyCodeFromReplacePlanUtils_01", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (pkIds != null && pkIds.length > 1) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u884c\u7ec4\u4ef6\u66ff\u4ee3\u65b9\u6848\u6570\u636e\u3002", (String)"CopyCodeFromReplacePlanUtils_02", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public boolean checkReplacePlanData(Long id) {
        int i;
        DynamicObject replacePlan = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"mpdm_replaceplan", (String)this.getReplacePlanSelectProperties());
        if (!"1".equals(replacePlan.getString("enable"))) {
            this.formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848[%1$s]\u4e0d\u662f\u53ef\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"CopyCodeFromReplacePlanUtils_03", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number")));
            return false;
        }
        if (!"C".equals(replacePlan.getString("status"))) {
            this.formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848[%1$s]\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"CopyCodeFromReplacePlanUtils_04", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number")));
            return false;
        }
        DynamicObjectCollection coll1 = replacePlan.getDynamicObjectCollection("mainmaterentry");
        if (coll1 == null || coll1.isEmpty()) {
            this.formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848[%1$s]\u6ca1\u6709\u8bbe\u7f6e\u4e3b\u7269\u6599\u5206\u5f55\u6570\u636e\u3002", (String)"CopyCodeFromReplacePlanUtils_05", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number")));
            return false;
        }
        DynamicObjectCollection coll2 = replacePlan.getDynamicObjectCollection("repmaterentry");
        if (coll2 == null || coll2.isEmpty()) {
            this.formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848[%1$s]\u6ca1\u6709\u8bbe\u7f6e\u66ff\u4ee3\u7269\u6599\u5206\u5f55\u6570\u636e\u3002", (String)"CopyCodeFromReplacePlanUtils_06", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number")));
            return false;
        }
        boolean hasReplace = false;
        HashSet<Object> materialMftIdSet = new HashSet<Object>(16);
        for (i = 0; i < coll1.size(); ++i) {
            if (((DynamicObject)coll1.get(i)).getBoolean("isreplace")) {
                hasReplace = true;
            }
            materialMftIdSet.add(((DynamicObject)coll1.get(i)).getDynamicObject("material").getPkValue());
        }
        if (!hasReplace) {
            this.formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848[%1$s]\u7684\u4e3b\u7269\u6599\u5206\u5f55\u4e2d\u6ca1\u6709\u8bbe\u7f6e[\u66ff\u4ee3\u4e3b\u6599]\u52fe\u9009\u9879\u3002", (String)"CopyCodeFromReplacePlanUtils_07", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number")));
            return false;
        }
        hasReplace = false;
        for (i = 0; i < coll2.size(); ++i) {
            if (((DynamicObject)coll2.get(i)).getBoolean("isrep")) {
                hasReplace = true;
            }
            materialMftIdSet.add(((DynamicObject)coll2.get(i)).getDynamicObject("repmaterial").getPkValue());
        }
        if (!hasReplace) {
            this.formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848[%1$s]\u7684\u66ff\u4ee3\u7269\u6599\u5206\u5f55\u4e2d\u6ca1\u6709\u8bbe\u7f6e[\u66ff\u4ee3\u4e3b\u6599]\u52fe\u9009\u9879\u3002", (String)"CopyCodeFromReplacePlanUtils_08", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number")));
            return false;
        }
        return materialMftIdSet.isEmpty() || CopyCodeFromReplacePlanUtils.checkMaterialValidData(materialMftIdSet, replacePlan, this.formView);
    }

    private static boolean checkMaterialValidData(Set<Object> materialMftIdSet, DynamicObject replacePlan, IFormView formView) {
        String sp = "id,status,enable,masterid.number,masterid.status,masterid.enable";
        Map<Object, DynamicObject> mftMap = CopyCodeFromReplacePlanUtils.getDataBySelectProperties(materialMftIdSet, sp);
        for (Map.Entry<Object, DynamicObject> mfts : mftMap.entrySet()) {
            DynamicObject mft = mfts.getValue();
            DynamicObject material = mft.getDynamicObject("masterid");
            if (!"C".equals(mft.getString("status")) || !"1".equals(mft.getString("enable"))) {
                formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848[%1$s]\u7684\u7269\u6599[%2$s]\u5bf9\u5e94\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u4e0d\u5904\u4e8e\u53ef\u7528\u6216\u5ba1\u6838\u72b6\u6001\u3002", (String)"CopyCodeFromReplacePlanUtils_09", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number"), material.get("number")));
                return false;
            }
            if ("C".equals(material.getString("status")) && "1".equals(material.getString("enable"))) continue;
            formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848[%1$s]\u7684\u7269\u6599[%2$s]\u4e0d\u5904\u4e8e\u53ef\u7528\u6216\u5ba1\u6838\u72b6\u6001\u3002", (String)"CopyCodeFromReplacePlanUtils_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number"), material.get("number")));
            return false;
        }
        return true;
    }

    public static Map<Object, DynamicObject> getDataBySelectProperties(Set<Object> idSet, String sp) {
        if (idSet == null || idSet.isEmpty()) {
            return Collections.emptyMap();
        }
        QFilter qfilter = new QFilter("id", "in", idSet);
        return BusinessDataServiceHelper.loadFromCache((String)"bd_materialmftinfo", (String)sp, (QFilter[])new QFilter[]{qfilter});
    }

    private String getReplacePlanSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",").append("number");
        sb.append(",").append("enable");
        sb.append(",").append("status");
        sb.append(",").append("createorg");
        sb.append(",").append("mainmaterentry").append(".").append("material");
        sb.append(",").append("mainmaterentry").append(".").append("isreplace");
        sb.append(",").append("repmaterentry").append(".").append("repmaterial");
        sb.append(",").append("repmaterentry").append(".").append("repauxpty");
        sb.append(",").append("repmaterentry").append(".").append("isrep");
        return sb.toString();
    }

    public Set<Long> getPPBomDataEntryIdSet(Long replacePlanId, boolean isAdd, Long bizOrgId) {
        ReplacePlanBusiness impl = new ReplacePlanBusiness();
        Map maps = impl.getEffectBomEntryIdSet(bizOrgId, replacePlanId, isAdd);
        if (maps == null || maps.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> allBomEntryIdSet = new HashSet<Long>(64);
        this.setCacheBomEntryData(maps);
        for (Map.Entry groups : maps.entrySet()) {
            Set bomEntryIdSet = (Set)groups.getValue();
            if (bomEntryIdSet == null || bomEntryIdSet.isEmpty()) continue;
            allBomEntryIdSet.addAll(bomEntryIdSet);
        }
        return allBomEntryIdSet;
    }

    private void setCacheBomEntryData(Map<String, Set<Long>> maps) {
        String cacheJsonString = JSON.toJSONString(maps);
        this.pageCache.put("bomEntryIdMaps", cacheJsonString);
    }

    public String getOrgName(Long bizOrgId) {
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)bizOrgId, (String)"bos_org", (String)"name");
        return org.getString("name");
    }

    public String getBomF7Caption(String operateKey) {
        if ("addbomdata".equals(operateKey)) {
            return ResManager.loadKDString((String)"\u6279\u91cf\u65b0\u589e\u66ff\u4ee3", (String)"CopyCodeFromReplacePlanUtils_18", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        }
        if ("updatebomdata".equals(operateKey)) {
            return ResManager.loadKDString((String)"\u6279\u91cf\u66f4\u65b0\u66ff\u4ee3", (String)"CopyCodeFromReplacePlanUtils_19", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public boolean validBomData(Set<Long> bomentryIdSet, String opKey) {
        HashSet<Long> bomIdSet = new HashSet<Long>(16);
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> bomentryMap = new HashMap<Long, DynamicObject>(16);
        DynamicObjectCollection coll = ReplaceUpdateBomUtils.queryBomEntryById(bomentryIdSet);
        for (DynamicObject bomentry : coll) {
            Long bomentryId = bomentry.getLong("entryid");
            Long bomId = bomentry.getLong("bomid");
            bomIdSet.add(bomId);
            bomentryMap.put(bomentryId, bomentry);
            Long l = bomentry.getLong("entrymaterialid");
            materialIdSet.add(l);
        }
        HashMap<Long, String> bomNumberMap = new HashMap<Long, String>(16);
        StringBuilder errorSb = new StringBuilder();
        Map bomMap = BusinessDataServiceHelper.loadFromCache((String)"pdm_mftbom", (String)"number,enable,id", (QFilter[])new QFilter[]{new QFilter("id", "in", bomIdSet)});
        for (Map.Entry entry : bomMap.entrySet()) {
            DynamicObject bom = (DynamicObject)entry.getValue();
            bomNumberMap.put(bom.getLong("id"), bom.getString("number"));
            if ("1".equals(bom.getString("enable"))) continue;
            errorSb.append(String.format(ResManager.loadKDString((String)"BOM[%1$s]\u4e0d\u5904\u4e8e\u53ef\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u66ff\u4ee3\u64cd\u4f5c\u3002%2$s", (String)"CopyCodeFromReplacePlanUtils_21", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), bom.getString("number"), "\r\n"));
        }
        Date currentDate = new Date();
        Map<Long, String> map = this.getMaterialNumberMap(materialIdSet);
        for (Long bomentryId : bomentryIdSet) {
            DynamicObject bomentry = (DynamicObject)bomentryMap.get(bomentryId);
            if (bomentry == null) {
                errorSb.append(String.format(ResManager.loadKDString((String)"BOM\u5206\u5f55ID[%1$s]\u5df2\u7ecf\u4e0d\u5b58\u5728\u4e8e\u7cfb\u7edf\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u9000\u51fa\u91cd\u8bd5\u3002%2$s", (String)"CopyCodeFromReplacePlanUtils_22", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), bomentryId, "\r\n"));
                continue;
            }
            String bomNumber = (String)bomNumberMap.get(bomentry.getLong("bomid"));
            int seq = bomentry.getInt("entryseq");
            Date entryinvaliddate = bomentry.getDate("entryinvaliddate");
            boolean isJumpLevel = bomentry.getBoolean("entryisjumplevel");
            Long replacePlanId = bomentry.getLong("entryreplaceplan");
            Long materialId = bomentry.getLong("entrymaterialid");
            String materialNumber = map.get(materialId);
            if (isJumpLevel) {
                errorSb.append(String.format(ResManager.loadKDString((String)"BOM[%1$s]\u7684\u7b2c[%2$s]\u884c\u5206\u5f55\u7ec4\u4ef6[%3$s]\u4e3a\u8df3\u5c42\u4ef6\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u66ff\u4ee3\u64cd\u4f5c\u3002%4$s", (String)"CopyCodeFromReplacePlanUtils_23", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), bomNumber, seq, materialNumber, "\r\n"));
                continue;
            }
            if ("addbomdata".equalsIgnoreCase(opKey) && entryinvaliddate.compareTo(currentDate) < 0) {
                errorSb.append(String.format(ResManager.loadKDString((String)"BOM[%1$s]\u7684\u7b2c[%2$s]\u884c\u5206\u5f55\u7ec4\u4ef6[%3$s]\u5931\u6548\u65e5\u671f\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6279\u91cf\u65b0\u589e\u66ff\u4ee3\u64cd\u4f5c\u3002%4$s", (String)"CopyCodeFromReplacePlanUtils_24", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), bomNumber, seq, materialNumber, "\r\n"));
                continue;
            }
            if (replacePlanId == null || replacePlanId.equals(0L)) {
                if (!"updatebomdata".equalsIgnoreCase(opKey)) continue;
                errorSb.append(String.format(ResManager.loadKDString((String)"BOM[%1$s]\u7684\u7b2c[%2$s]\u884c\u5206\u5f55\u7ec4\u4ef6[%3$s]\u4e0d\u5b58\u5728\u66ff\u4ee3\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6279\u91cf\u66f4\u65b0\u66ff\u4ee3\u64cd\u4f5c\u3002%4$s", (String)"CopyCodeFromReplacePlanUtils_25", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), bomNumber, seq, materialNumber, "\r\n"));
                continue;
            }
            if (!"addbomdata".equalsIgnoreCase(opKey)) continue;
            errorSb.append(String.format(ResManager.loadKDString((String)"BOM[%1$s]\u7684\u7b2c[%2$s]\u884c\u5206\u5f55\u7ec4\u4ef6[%3$s]\u5df2\u5b58\u5728\u66ff\u4ee3\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6279\u91cf\u65b0\u589e\u66ff\u4ee3\u64cd\u4f5c\u3002%4$s", (String)"CopyCodeFromReplacePlanUtils_26", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), bomNumber, seq, materialNumber, "\r\n"));
        }
        if (errorSb.length() > 1) {
            this.formView.showTipNotification(errorSb.toString());
            return false;
        }
        return true;
    }

    private Map<Long, String> getMaterialNumberMap(Set<Long> materialIdSet) {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_material", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIdSet)});
        HashMap<Long, String> materialMap = new HashMap<Long, String>(16);
        for (DynamicObject bom : coll) {
            materialMap.put(bom.getLong("id"), bom.getString("number"));
        }
        return materialMap;
    }

    public boolean addDataMutex(Long pkId) {
        StringBuilder errMsg = new StringBuilder();
        if (!MutexHelper.require((String)"mpdm_replaceplan", (Object)pkId, (String)"releasemutex", (boolean)true, (StringBuilder)errMsg)) {
            this.formView.showErrorNotification(ResManager.loadKDString((String)"\u8be5\u66ff\u4ee3\u65b9\u6848\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u6570\u636e\uff0c\u8bf7\u7a0d\u5019\u518d\u6267\u884c\u3002", (String)"CopyCodeFromReplacePlanUtils_28", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public boolean execUpdataOp(Set<Long> bomEntryIdSelectSet, Long replacePlanId, Long orgId, String opKey) {
        if (bomEntryIdSelectSet == null || bomEntryIdSelectSet.isEmpty()) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u4efb\u4f55BOM\u5206\u5f55\u6570\u636e\u3002", (String)"CopyCodeFromReplacePlanUtils_12", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Map<String, Set<Long>> bomentryIdMap = this.getMapBySelectIdSet(bomEntryIdSelectSet, opKey);
        if (bomentryIdMap == null || bomentryIdMap.isEmpty()) {
            return false;
        }
        ReplacePlanBusiness impl = new ReplacePlanBusiness();
        Long logId = impl.insertExecLogByOne(replacePlanId, bomentryIdMap, orgId, opKey);
        if (logId == null || logId.equals(0L)) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u672a\u751f\u6210\u8fd0\u7b97\u65e5\u5fd7\u4fe1\u606f\u3002", (String)"CopyCodeFromReplacePlanUtils_13", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        ThreadPools.executeOnceIncludeRequestContext((String)("MMC-ReplacePlanUpdateBom-logId-" + logId), (Runnable)new ReplacePlanUpdateBomRunner(RequestContext.get(), logId));
        this.showLogForm(logId, replacePlanId);
        return true;
    }

    private void showLogForm(Long logId, Long replacePlanId) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("mpdm_replaceplan_log");
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setPkId((Object)logId);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("id", (Object)logId);
        this.formView.showForm((FormShowParameter)formShowParameter);
        ThreadPools.executeOnce((String)"MMC-ReplacePlanUpdateBom", () -> this.doRelease(logId, replacePlanId));
    }

    private void doRelease(Long logId, Long replacePlanId) {
        String status = this.getCalcStatus(logId);
        int i = 0;
        while ("B".equals(status)) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            status = this.getCalcStatus(logId);
            if (++i <= 10000) continue;
        }
        this.release(replacePlanId);
    }

    public void release(Long pkID) {
        MutexHelper.release((String)"mpdm_replaceplan", (String)"releasemutex", (String)String.valueOf(pkID));
    }

    private String getCalcStatus(Long id) {
        String status = "";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mpdm_replaceplan_log", (String)"runstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (dynamicObject != null) {
            status = dynamicObject.getString("runstatus");
        }
        return status;
    }

    private Map<String, Set<Long>> getMapBySelectIdSet(Set<Long> bomEntryIdSelectSet, String opKey) {
        Map<String, Set<Long>> cacheBomEntryIdMap = this.getCacheBomEntryData();
        if (cacheBomEntryIdMap.isEmpty()) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5339\u914d\u7684BOM\u5206\u5f55\u7f13\u5b58\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"CopyCodeFromReplacePlanUtils_14", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return Collections.emptyMap();
        }
        HashMap<String, Set<Long>> selectMap = new HashMap<String, Set<Long>>(16);
        for (Long bomentryId : bomEntryIdSelectSet) {
            boolean isFind = false;
            for (Map.Entry<String, Set<Long>> groups : cacheBomEntryIdMap.entrySet()) {
                Set<Long> unionBomEntryIdSet;
                String replaceGroupNo = groups.getKey();
                Set<Long> bomEntryIdsObject = groups.getValue();
                if (bomEntryIdsObject == null) continue;
                Set<Object> bomEntryIdSet = new HashSet(16);
                bomEntryIdSet = bomEntryIdsObject instanceof ArrayList ? new HashSet(groups.getValue()) : groups.getValue();
                if (!bomEntryIdSet.contains(bomentryId)) continue;
                isFind = true;
                if (selectMap.containsKey(replaceGroupNo)) break;
                if ("addbomdata".equalsIgnoreCase(opKey) && (unionBomEntryIdSet = this.getUnionSet(bomEntryIdSet, bomEntryIdSelectSet)).size() != bomEntryIdSet.size()) {
                    this.formView.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u6570\u636e\u65e0\u6cd5\u4e0e\u66ff\u4ee3\u65b9\u6848\u7684\u4e3b\u7269\u6599\u8fdb\u884c\u5339\u914d\uff08\u65b0\u589e\u66ff\u4ee3\u6a21\u5f0f\u4e0b\uff0cBOM\u5206\u5f55\u6240\u9009\u62e9\u7684\u7ec4\u4ef6\u4e0e\u66ff\u4ee3\u65b9\u6848\u7684\u4e3b\u7269\u6599\u5fc5\u987b\u5b8c\u5168\u4e00\u81f4\uff09\u3002", (String)"CopyCodeFromReplacePlanUtils_20", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                    return Collections.emptyMap();
                }
                selectMap.put(replaceGroupNo, bomEntryIdSet);
                break;
            }
            if (isFind) continue;
            this.formView.showTipNotification(String.format(ResManager.loadKDString((String)"BOM\u5206\u5f55ID[%1$s]\u65e0\u6cd5\u5728\u5339\u914d\u7f13\u5b58\u4e2d\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"CopyCodeFromReplacePlanUtils_15", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), bomentryId));
            return Collections.emptyMap();
        }
        return selectMap;
    }

    private Map<String, Set<Long>> getCacheBomEntryData() {
        String cacheJsonString = this.pageCache.get("bomEntryIdMaps");
        if (StringUtils.isEmpty((String)cacheJsonString)) {
            return Collections.emptyMap();
        }
        return (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class);
    }

    private Set<Long> getUnionSet(Set<Long> setA, Set<Long> setB) {
        HashSet<Long> resSet = new HashSet<Long>(16);
        resSet.addAll(setA);
        resSet.retainAll(setB);
        return resSet;
    }
}

