/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.mftbom.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.MergeColumnRule;
import kd.bos.report.events.ReportExportInitializeEvent;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.formplugin.mftbom.report.CopyCodeFromReplacePlanUtils;

public class ReplacePlanUserReportFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    public static final String BOM_REPLACE_FORM = "mpdm_replaceplan";
    private static final Log logger = LogFactory.getLog(ReplacePlanUserReportFormPlugin.class);
    private static String[] mergeHeadFiledls = new String[]{"createorg", "number", "name", "replacemethod", "replacestra", "status", "enable", "bomuser"};
    private static List<String> mergeHeadFileds = Arrays.stream(mergeHeadFiledls).collect(Collectors.toList());
    private static String[] mergeMasterFiledls = new String[]{"priority", "material", "maternumber", "matername", "modelnum", "auxpty", "bomversion", "isreplace", "unit", "mole", "deno", "useratio"};
    private static List<String> mergeMasterFileds = Arrays.stream(mergeMasterFiledls).collect(Collectors.toList());
    private static String[] mergeReplaceFiledls = new String[]{"reppriority", "repmaterial", "repmaternumber", "repmatername", "repmodelnum", "repauxpty", "repbomversion", "isrep", "repunit", "repqtytype", "repmole", "repdeno", "repeffectdate", "repinvaliddate", "repuseratio", "repfixscrap", "repscraprate"};
    private static List<String> mergeReplaceFileds = Arrays.stream(mergeReplaceFiledls).collect(Collectors.toList());
    private volatile LocalMemoryCache localcache = null;

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
    }

    public void afterCreateNewData(EventObject e) {
        RequestContext rc = RequestContext.get();
        long orgId = rc.getOrgId();
        long userId = rc.getCurrUserId();
        this.initOrg(orgId, userId);
        ReportFilter filter = (ReportFilter)this.getView().getControl("reportfilterap");
        filter.search();
    }

    public void initOrg(Long orgId, Long userId) {
        IReportView view = this.getView();
        IDataModel model = this.getModel();
        if (orgId.equals(0L)) {
            model.setValue("orgf", (Object)0L);
            return;
        }
        String entityNum = model.getDataEntityType().getName();
        String appId = model.getDataEntityType().getAppId();
        Long orgByUserOrg = ReplacePlanUserReportFormPlugin.getOrgByUserOrg(userId, orgId, entityNum, appId, "47150e89000000ac", "04");
        model.setValue("orgf", (Object)orgByUserOrg);
    }

    public static Long getOrgByUserOrg(Long userId, Long orgId, String entityNum, String appId, String permItemId, String orgViewType) {
        if (OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)orgViewType)) {
            return orgId;
        }
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)orgViewType, (String)appId, (String)entityNum, (String)permItemId);
        List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
        if (hasPermOrgs != null && hasPermOrgs.size() > 0) {
            return (Long)hasPermOrgs.get(0);
        }
        return 0L;
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent sort : allColumns) {
            if (!allColumns.contains(sort)) continue;
            sort.setSort(true);
            sort.setFilter(true);
        }
    }

    public void setMergeColums(List<String> columns) {
        if (columns != null) {
            columns.addAll(this.getMergeColums());
        }
        super.setMergeColums(columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalMemoryCache getLocalCache() {
        if (this.localcache == null) {
            ReplacePlanUserReportFormPlugin replacePlanUserReportFormPlugin = this;
            synchronized (replacePlanUserReportFormPlugin) {
                if (this.localcache == null) {
                    CacheConfigInfo localConfig = new CacheConfigInfo();
                    localConfig.setTimeout(28820);
                    localConfig.setMaxItemSize(16);
                    this.localcache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("replaceplan_region", "String", localConfig);
                }
            }
        }
        return this.localcache;
    }

    private String getLocalCacheV(String cacheKey) {
        Object cacheValue = this.getLocalCache().get(cacheKey);
        if (cacheValue != null) {
            return (String)cacheValue;
        }
        return "";
    }

    private void putLocalCache(String cacheKey, String cacheValue) {
        this.getLocalCache().put(cacheKey, (Object)cacheValue);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        String condition_prevalue;
        String currtColV;
        ReportColumn currtColumn = (ReportColumn)packageDataEvent.getSource();
        String currtFieldKey = currtColumn.getFieldKey();
        if ("id".equals(currtFieldKey)) {
            currtColV = packageDataEvent.getFormatValue().toString();
            condition_prevalue = this.getLocalCacheV("pre_id");
            if (condition_prevalue != null && !condition_prevalue.isEmpty() && !condition_prevalue.equals(currtColV)) {
                packageDataEvent.getNoMergeKey().addAll(mergeHeadFileds);
            }
            this.putLocalCache("pre_id", currtColV);
        }
        if ("mainmaterentryid".equals(currtFieldKey)) {
            currtColV = packageDataEvent.getFormatValue().toString();
            condition_prevalue = this.getLocalCacheV("pre_mainmaterentryid");
            if (condition_prevalue != null && !condition_prevalue.isEmpty() && !condition_prevalue.equals(currtColV)) {
                packageDataEvent.getNoMergeKey().addAll(mergeMasterFileds);
            }
            this.putLocalCache("pre_mainmaterentryid", currtColV);
        }
        if ("repmaterentryid".equals(currtFieldKey)) {
            currtColV = packageDataEvent.getFormatValue() != null ? packageDataEvent.getFormatValue().toString() : "";
            condition_prevalue = this.getLocalCacheV("pre_repmaterentryid");
            if (condition_prevalue != null && !condition_prevalue.isEmpty() && !condition_prevalue.equals(currtColV)) {
                packageDataEvent.getNoMergeKey().addAll(mergeReplaceFileds);
            }
            this.putLocalCache("pre_repmaterentryid", currtColV);
        }
        super.packageData(packageDataEvent);
    }

    private List<String> getMergeColums() {
        ArrayList<String> columns = new ArrayList<String>(8);
        columns.add("id");
        columns.add("createorg");
        columns.add("number");
        columns.add("name");
        columns.add("replacemethod");
        columns.add("replacestra");
        columns.add("status");
        columns.add("enable");
        columns.add("bomuser");
        columns.add("mainmaterentryid");
        columns.add("priority");
        columns.add("material");
        columns.add("maternumber");
        columns.add("matername");
        columns.add("modelnum");
        columns.add("auxpty");
        columns.add("bomversion");
        columns.add("isreplace");
        columns.add("unit");
        columns.add("mole");
        columns.add("deno");
        columns.add("useratio");
        columns.add("repmaterentryid");
        columns.add("reppriority");
        columns.add("repmaterial");
        columns.add("repmaternumber");
        columns.add("repmatername");
        columns.add("repmodelnum");
        columns.add("repauxpty");
        columns.add("repbomversion");
        columns.add("isrep");
        columns.add("repunit");
        columns.add("repqtytype");
        columns.add("repmole");
        columns.add("repdeno");
        columns.add("repeffectdate");
        columns.add("repinvaliddate");
        columns.add("repuseratio");
        columns.add("repfixscrap");
        columns.add("repscraprate");
        return columns;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener(this::hyperLinkClick);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        ReportList reportList = (ReportList)hyperLinkClickEvent.getSource();
        int[] selectedRows = reportList.getEntryState().getSelectedRows();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        this.hyperLink(selectedRows, rowIndex, reportList);
    }

    private void hyperLink(int[] selectedRows, int rowIndex, ReportList reportList) {
        Set<Long> pks = this.getSelectPKs(selectedRows, reportList);
        DynamicObject rowData = reportList.getReportModel().getRowData(rowIndex);
        if (pks.size() == 1) {
            long replacePk = rowData.getLong("id");
            this.showEditForm(replacePk);
        } else if (pks.size() > 1) {
            this.showBillListForm(pks, reportList);
        }
    }

    private Set<Long> getSelectPKs(int[] selectedRows, ReportList reportList) {
        HashSet<Long> replacePks = new HashSet<Long>(selectedRows.length);
        for (int i = 0; i < selectedRows.length; ++i) {
            int selectedRow = selectedRows[i];
            DynamicObject rowData = reportList.getReportModel().getRowData(selectedRow);
            long replaceID = rowData.getLong("id");
            replacePks.add(replaceID);
        }
        return replacePks;
    }

    private void showBillListForm(Set<Long> replacePks, ReportList reportList) {
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)BOM_REPLACE_FORM, (boolean)true, (int)0, (boolean)false);
        List qFilters = showListForm.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("id", "in", replacePks));
        this.getView().showForm((FormShowParameter)showListForm);
    }

    private void showEditForm(long replacePk) {
        HashMap<String, String> para = new HashMap<String, String>(4);
        para.put("formId", BOM_REPLACE_FORM);
        para.put("pkId", replacePk + "");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.setStatus(OperationStatus.VIEW);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        showParameter.setOpenStyle(openStyle);
        this.getView().showForm(showParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "new": {
                this.showReplacePlanNewForm("new", e);
                break;
            }
            case "copy": {
                this.showReplacePlanNewForm("copy", e);
                break;
            }
            case "submit": {
                this.doAfterExecOp("submit", e);
                break;
            }
            case "unsubmit": {
                this.doAfterExecOp("unsubmit", e);
                break;
            }
            case "audit": {
                this.doAfterExecOp("audit", e);
                break;
            }
            case "unaudit": {
                this.doAfterExecOp("unaudit", e);
                break;
            }
            case "disable": {
                this.doAfterExecOp("disable", e);
                break;
            }
            case "enable": {
                this.doAfterExecOp("enable", e);
                break;
            }
            case "addbomdata": {
                this.doAfterExecOp("addbomdata", e);
                break;
            }
            case "updatebomdata": {
                this.doAfterExecOp("updatebomdata", e);
                break;
            }
            case "repconfig": {
                this.doAfterExecOp("repconfig", e);
                break;
            }
            case "replaceupdatelog": {
                this.doAfterExecOp("replaceupdatelog", e);
            }
        }
    }

    private void showReplacePlanNewForm(String optypeNew, AfterDoOperationEventArgs e) {
        Object orgF = this.getModel().getValue("orgf");
        Long orgID = orgF instanceof DynamicObject ? ((DynamicObject)orgF).getLong("id") : 0L;
        Long dataID = 0L;
        BaseShowParameter fsp = new BaseShowParameter();
        fsp.setFormId(BOM_REPLACE_FORM);
        fsp.setUseOrgId(orgID.longValue());
        HashMap<String, Long> customs = new HashMap<String, Long>(2);
        customs.put("org", orgID);
        fsp.setCustomParams(customs);
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)fsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAfterExecOp(String optype, AfterDoOperationEventArgs e) {
        if (e.getOperationResult().isSuccess()) {
            ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
            int[] selectedRows = reportList.getEntryState().getSelectedRows();
            Set<Long> selectPKs = this.getSelectPKs(selectedRows, reportList);
            try {
                if ("submit".equals(optype) || "unsubmit".equals(optype) || "audit".equals(optype) || "unaudit".equals(optype) || "disable".equals(optype) || "enable".equals(optype)) {
                    DynamicObject[] replaceDatas = this.loadReplacePlan(selectPKs);
                    if (selectPKs.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReplacePlanUserReportFormPlugin_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.execOparation(replaceDatas, optype);
                } else {
                    this.doAfterBussinessOperation(selectPKs, optype);
                }
            }
            finally {
                this.releaseLocks(selectPKs);
            }
        }
    }

    private void doAfterBussinessOperation(Set<Long> selectPKs, String optype) {
        if ("repconfig".equals(optype)) {
            this.showConfigSetForm(1742916443785135104L);
        } else if ("addbomdata".equals(optype) || "updatebomdata".equals(optype)) {
            this.openBatchReplacePlan(selectPKs, optype);
        } else if ("replaceupdatelog".equals(optype)) {
            this.openReplacePlanLog(selectPKs);
        }
    }

    private void openBatchReplacePlan(Set<Long> selectPKs, String optype) {
        Long bizOrgId = this.getQFilterOrg();
        Object[] pkIds = selectPKs.toArray(new Object[0]);
        CopyCodeFromReplacePlanUtils replacePlanUtils = new CopyCodeFromReplacePlanUtils(this.getPageCache(), (IFormView)this.getView());
        if (!replacePlanUtils.checkSelectDataSize(pkIds)) {
            return;
        }
        Long pkId = (Long)pkIds[0];
        if (!replacePlanUtils.checkReplacePlanData(pkId)) {
            return;
        }
        Set<Long> bomEntryIdSet = replacePlanUtils.getPPBomDataEntryIdSet(pkId, "addbomdata".equals(optype), bizOrgId);
        if (bomEntryIdSet == null || bomEntryIdSet.isEmpty()) {
            DynamicObject replacePlan = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)BOM_REPLACE_FORM, (String)"id,number");
            String orgName = replacePlanUtils.getOrgName(bizOrgId);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848[%1$s]\u5728\u4e1a\u52a1\u7ec4\u7ec7[%2$s]\u4e0b\u672a\u627e\u5230\u9002\u914d\u7684BOM\u6570\u636e\u3002", (String)"ReplacePlanUserReportFormPlugin_11", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), replacePlan.getString("number"), orgName));
            return;
        }
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pdm_mftbomlist_f7", (boolean)true);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, optype));
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        filters.add(new QFilter("entry.id", "in", bomEntryIdSet));
        listShowParameter.setSelectedEntity("entry");
        listShowParameter.setCustomParam("ismergerows", (Object)false);
        listShowParameter.setCaption(replacePlanUtils.getBomF7Caption(optype));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event == null) {
            return;
        }
        CopyCodeFromReplacePlanUtils replacePlanUtils = new CopyCodeFromReplacePlanUtils(this.getPageCache(), (IFormView)this.getView());
        String actID = event.getActionId();
        Object returnDataObj = event.getReturnData();
        ListSelectedRowCollection returnLSRC = returnDataObj instanceof ListSelectedRowCollection ? (ListSelectedRowCollection)returnDataObj : null;
        int returnLSRCSize = returnLSRC == null || returnLSRC.isEmpty() ? 0 : returnLSRC.size();
        if (StringUtils.isEmpty((String)actID) || returnDataObj == null) {
            return;
        }
        if (("addbomdata".equalsIgnoreCase(actID) || "updatebomdata".equalsIgnoreCase(actID)) && returnLSRCSize > 0) {
            HashSet<Long> bomEntryIdSelectSet = new HashSet<Long>(16);
            for (int index = 0; index < returnLSRCSize; ++index) {
                ListSelectedRow returnLSR = returnLSRC.get(index);
                if (returnLSR == null) continue;
                Object returnPKObj = returnLSR.getEntryPrimaryKeyValue();
                if (returnPKObj == null) {
                    String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u9009\u62e9BOM\u5206\u5f55\u6570\u636e\uff0c\u8bf7\u5728\u5f39\u51fa\u7684BOM\u9009\u62e9F7\u754c\u9762\uff0c\u8868\u683c\u53f3\u4e0a\u89d2\u7684\u5de5\u5177\u680f\u70b9\u51fb[\u663e\u793a\u5168\u90e8]\u540e\u518d\u91cd\u8bd5\u3002", (String)"ReplacePlanUserReportFormPlugin_27", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(msg);
                    return;
                }
                Long returnPK = returnPKObj == null ? -1L : Long.parseLong(returnPKObj.toString());
                if (returnPK <= 0L) continue;
                bomEntryIdSelectSet.add(returnPK);
            }
            if (!replacePlanUtils.validBomData(bomEntryIdSelectSet, actID)) {
                return;
            }
            ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
            int[] selectedRows = reportList.getEntryState().getSelectedRows();
            Set<Long> selectPKs = this.getSelectPKs(selectedRows, reportList);
            Object[] pkIds = selectPKs.toArray(new Object[0]);
            Long pkId = (Long)pkIds[0];
            Long orgId = this.getQFilterOrg();
            if (!replacePlanUtils.addDataMutex(pkId)) {
                return;
            }
            try {
                boolean bl = replacePlanUtils.execUpdataOp(bomEntryIdSelectSet, pkId, orgId, actID);
            }
            catch (Exception exception) {
                logger.error((Throwable)exception);
                throw exception;
            }
            finally {
                replacePlanUtils.release(pkId);
            }
        }
    }

    private void openReplacePlanLog(Set<Long> selectPKs) {
        Object[] pkIds = selectPKs.toArray(new Object[0]);
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("mpdm_replaceplan_log");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListFilterParameter listFilter = new ListFilterParameter();
        QFilter qFilter = null;
        if (pkIds != null && pkIds.length > 0 && pkIds[0] != null && !pkIds[0].equals(0L)) {
            qFilter = new QFilter("entryentity.replaceplan", "in", (Object)pkIds);
        } else {
            Long bizOrgId = this.getQFilterOrg();
            qFilter = new QFilter("org", "=", (Object)bizOrgId);
        }
        listFilter.setFilter(qFilter);
        listFilter.setOrderBy("createtime desc , entryentity.replaceplan,entryentity.seq");
        listShowParameter.setListFilterParameter(listFilter);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private Long getQFilterOrg() {
        IDataModel model = this.getModel();
        Object orgFilter = model.getValue("orgf");
        Long orgPk = 0L;
        if (orgFilter instanceof DynamicObject) {
            orgPk = ((DynamicObject)orgFilter).getLong("id");
        }
        return orgPk;
    }

    private void showConfigSetForm(Object pkId) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("mpdm_bomrepconfig");
        baseShowParameter.setPkId(pkId);
        baseShowParameter.setCustomParam("view", (Object)Boolean.TRUE);
        baseShowParameter.setShowTitle(true);
        baseShowParameter.setCaption(ResManager.loadKDString((String)"\u66ff\u4ee3\u53c2\u6570\u8bbe\u7f6e", (String)"ReplacePlanUserReportFormPlugin_29", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        OperationStatus operationStatus = OperationStatus.EDIT;
        baseShowParameter.setStatus(operationStatus);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("1080px");
        css.setHeight("400px");
        baseShowParameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void releaseLocks(Set<Long> selectPKs) {
        if (selectPKs.isEmpty()) {
            return;
        }
        for (Long pk : selectPKs) {
            if (pk == null) continue;
            MutexHelper.release((String)BOM_REPLACE_FORM, (String)"modify", (String)pk.toString());
        }
    }

    private void execOparation(DynamicObject[] replaceDatas, String optype) {
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)optype, (String)BOM_REPLACE_FORM, (DynamicObject[])replaceDatas, (OperateOption)OperateOption.create());
        boolean success = executeOperate.isSuccess();
        String opTypeName = this.transOperationName(optype);
        if (!success) {
            this.getView().showOperationResult(executeOperate, opTypeName);
        } else {
            StringBuilder successMsg = new StringBuilder();
            successMsg.append(opTypeName).append(ResManager.loadKDString((String)"\u6210\u529f\u3002", (String)"ReplacePlanUserReportFormPlugin_7", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            this.getView().showSuccessNotification(successMsg.toString());
        }
    }

    private String transOperationName(String optype) {
        String opTypeName = "";
        switch (optype) {
            case "submit": {
                opTypeName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ReplacePlanUserReportFormPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "unsubmit": {
                opTypeName = ResManager.loadKDString((String)"\u64a4\u9500", (String)"ReplacePlanUserReportFormPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "audit": {
                opTypeName = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"ReplacePlanUserReportFormPlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "unaudit": {
                opTypeName = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"ReplacePlanUserReportFormPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "disable": {
                opTypeName = ResManager.loadKDString((String)"\u7981\u7528", (String)"ReplacePlanUserReportFormPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "enable": {
                opTypeName = ResManager.loadKDString((String)"\u542f\u7528", (String)"ReplacePlanUserReportFormPlugin_6", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
            }
        }
        return opTypeName;
    }

    private DynamicObject[] loadReplacePlan(Set<Long> selectPKs) {
        DynamicObject replacePlan = ORM.create().newDynamicObject(BOM_REPLACE_FORM);
        DynamicObject[] replaceDatas = BusinessDataServiceHelper.load((Object[])selectPKs.toArray(new Object[0]), (DynamicObjectType)replacePlan.getDynamicObjectType());
        return replaceDatas;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean verifyFlag = super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject orgFilter = filterInfo.getDynamicObject("orgf");
        if (!(orgFilter instanceof DynamicObject)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"ReplacePlanUserReportFormPlugin_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            verifyFlag = false;
        }
        return verifyFlag;
    }

    public void exportInitialize(ReportExportInitializeEvent event) {
        ArrayList<MergeColumnRule> rules = new ArrayList<MergeColumnRule>(10);
        ArrayList<String> headGroupColumns = new ArrayList<String>(1);
        headGroupColumns.add("number");
        List<String> headMergeColumns = this.getHeadMergeColums();
        rules.add(new MergeColumnRule(headGroupColumns, headMergeColumns));
        ArrayList<String> mainGroupColumns = new ArrayList<String>(1);
        mainGroupColumns.add("number");
        mainGroupColumns.add("maternumber");
        List<String> mainMergeColumns = this.getMainMergeColums();
        rules.add(new MergeColumnRule(mainGroupColumns, mainMergeColumns));
        ArrayList<String> repGroupColumns = new ArrayList<String>(1);
        repGroupColumns.add("number");
        repGroupColumns.add("repmaternumber");
        List<String> repMergeColumns = this.getRepMergeColums();
        rules.add(new MergeColumnRule(repGroupColumns, repMergeColumns));
        event.setMergeColumnRules(rules);
    }

    private List<String> getHeadMergeColums() {
        ArrayList<String> columns = new ArrayList<String>(16);
        columns.add("id");
        columns.add("createorg");
        columns.add("number");
        columns.add("name");
        columns.add("replacemethod");
        columns.add("replacestra");
        columns.add("status");
        columns.add("enable");
        columns.add("bomuser");
        return columns;
    }

    private List<String> getMainMergeColums() {
        ArrayList<String> columns = new ArrayList<String>(16);
        columns.add("mainmaterentryid");
        columns.add("priority");
        columns.add("material");
        columns.add("maternumber");
        columns.add("matername");
        columns.add("modelnum");
        columns.add("auxpty");
        columns.add("bomversion");
        columns.add("isreplace");
        columns.add("unit");
        columns.add("mole");
        columns.add("deno");
        columns.add("useratio");
        return columns;
    }

    private List<String> getRepMergeColums() {
        ArrayList<String> columns = new ArrayList<String>(32);
        columns.add("repmaterentryid");
        columns.add("reppriority");
        columns.add("repmaterial");
        columns.add("repmaternumber");
        columns.add("repmatername");
        columns.add("repmodelnum");
        columns.add("repauxpty");
        columns.add("repbomversion");
        columns.add("isrep");
        columns.add("repunit");
        columns.add("repqtytype");
        columns.add("repmole");
        columns.add("repdeno");
        columns.add("repeffectdate");
        columns.add("repinvaliddate");
        columns.add("repuseratio");
        columns.add("repfixscrap");
        columns.add("repscraprate");
        return columns;
    }
}

