/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.mftbom.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.replaceplan.ReplacePlanReportUtils;
import kd.mpscmm.msplan.reportext.ReportExtBaseQueryPlugin;

public class ReplacePlanUserReportQueryPlugin
extends ReportExtBaseQueryPlugin {
    private static final String MPDM_REPLACEPLAN = "mpdm_replaceplan";
    private static final String PDM_REPLACEPLANREP_SET = "pdm_replaceplanrep_set";
    private static final Log logger = LogFactory.getLog(ReplacePlanUserReportQueryPlugin.class);

    public DataSet doQuery(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        super.doQuery(reportQueryParam, o);
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List<QFilter> qFilters = this.buildQueryQFilter(filterInfo);
        String selectItems = this.getSelectItems();
        logger.info("ReplacePlanUserReport: start query dataset\u3002");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)MPDM_REPLACEPLAN, (String)selectItems, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"number,mainmaterentry.id,repmaterentry.id");
        logger.info("ReplacePlanUserReport: query dataset end\u3002");
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        try (DataSet dataSet = super.query(param, obj);){
            logger.info("ReplacePlanUserReport: start transform query dataset\u3002");
            DataSet resDataSet = this.transDataSet(dataSet);
            logger.info("ReplacePlanUserReport: transform query dataset end\u3002");
            DataSet dataSet2 = resDataSet;
            return dataSet2;
        }
    }

    private DataSet transDataSet(DataSet dataSet) {
        RowMeta rowMeta = dataSet.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        int fieldNameLength = fieldNames.length;
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(256);
        HashSet<String> pkDatas = new HashSet<String>(128);
        HashSet<Long> replacePks = new HashSet<Long>(128);
        HashSet<Long> uniqueMainmaterPks = new HashSet<Long>(128);
        List repMaterEntryFields = ReplacePlanReportUtils.getRepmaterentryFields();
        StringBuilder uniqueBuilder = new StringBuilder();
        while (dataSet.hasNext()) {
            Row rowData = dataSet.next();
            long replacePk = rowData.getLong("id");
            replacePks.add(replacePk);
            long mainmaterentryPk = rowData.getLong("mainmaterentryid");
            long repmaterentryPk = rowData.getLong("repmaterentryid");
            uniqueBuilder.setLength(0);
            uniqueBuilder.append(replacePk).append("-").append(repmaterentryPk);
            String unique = uniqueBuilder.toString();
            boolean uniqueFalg = pkDatas.add(unique);
            if (!uniqueMainmaterPks.add(mainmaterentryPk) && !uniqueFalg) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(fieldNames.length);
            for (int i = 0; i < fieldNameLength; ++i) {
                if (uniqueFalg || !repMaterEntryFields.contains(fieldNames[i])) {
                    data.put(fieldNames[i], rowData.get(fieldNames[i]));
                    continue;
                }
                if ("repmaterentryid".equals(fieldNames[i])) {
                    data.put(fieldNames[i], -1L);
                    continue;
                }
                data.put(fieldNames[i], null);
            }
            datas.add(data);
        }
        this.writeReplacePlanUserInBom(datas, replacePks);
        return MMCUtils.parseToDataSet((Object)((Object)this), datas, (RowMeta)rowMeta);
    }

    private void writeReplacePlanUserInBom(List<Map<String, Object>> datas, Set<Long> replacePks) {
        Set<Long> replaceUserFromBom = this.queryReplacePlanUserFromBom(replacePks);
        if (replaceUserFromBom == null || replaceUserFromBom.isEmpty()) {
            return;
        }
        for (int i = 0; i < datas.size(); ++i) {
            Map<String, Object> dataMap = datas.get(i);
            Object replacePlacPk = dataMap.get("id");
            if (replacePlacPk == null || !replaceUserFromBom.contains(replacePlacPk)) continue;
            dataMap.put("bomuser", "1");
        }
    }

    private Set<Long> queryReplacePlanUserFromBom(Set<Long> replacePks) {
        Set<Long> replacePlanUserMap = new HashSet<Long>();
        if (replacePks.isEmpty()) {
            return replacePlanUserMap;
        }
        QFilter qFilter = new QFilter("entryreplaceplan", "in", replacePks);
        replacePlanUserMap = QueryServiceHelper.query((String)"pdm_mftbomentry", (String)"entryreplaceplan", (QFilter[])new QFilter[]{qFilter}).stream().map(p -> p.getLong("entryreplaceplan")).collect(Collectors.toSet());
        return replacePlanUserMap;
    }

    public String getReportEntity(ReportQueryParam queryParam) {
        return PDM_REPLACEPLANREP_SET;
    }

    private String getSelectItems() {
        StringBuilder selectitems = new StringBuilder();
        selectitems.append("id,");
        selectitems.append("number,");
        selectitems.append("name,");
        selectitems.append("replacemethod,");
        selectitems.append("replacestra,");
        selectitems.append("createorg,");
        selectitems.append("status,");
        selectitems.append("enable,");
        selectitems.append("mainmaterentry.id as mainmaterentryid,");
        selectitems.append("mainmaterentry.seq as mainmaterentryseq,");
        selectitems.append("mainmaterentry.material as material,");
        selectitems.append("mainmaterentry.material.masterid.number as maternumber,");
        selectitems.append("mainmaterentry.material.masterid.name as matername,");
        selectitems.append("mainmaterentry.material.masterid.modelnum as modelnum,");
        selectitems.append("mainmaterentry.bomversion as bomversion,");
        selectitems.append("mainmaterentry.auxpty as auxpty,");
        selectitems.append("mainmaterentry.priority as priority,");
        selectitems.append("mainmaterentry.isreplace as isreplace,");
        selectitems.append("mainmaterentry.unit as unit,");
        selectitems.append("mainmaterentry.mole as mole,");
        selectitems.append("mainmaterentry.deno as deno,");
        selectitems.append("mainmaterentry.useratio as useratio,");
        selectitems.append("repmaterentry.id as repmaterentryid,");
        selectitems.append("repmaterentry.seq as repmaterentryseq,");
        selectitems.append("repmaterentry.reppriority as reppriority,");
        selectitems.append("repmaterentry.repmaterial as repmaterial,");
        selectitems.append("repmaterentry.repmaterial.masterid.number as repmaternumber,");
        selectitems.append("repmaterentry.repmaterial.masterid.name as repmatername,");
        selectitems.append("repmaterentry.repmaterial.masterid.modelnum as repmodelnum,");
        selectitems.append("repmaterentry.repauxpty as repauxpty,");
        selectitems.append("repmaterentry.repbomversion as repbomversion,");
        selectitems.append("repmaterentry.isrep as isrep,");
        selectitems.append("repmaterentry.repunit as repunit,");
        selectitems.append("repmaterentry.repqtytype as repqtytype,");
        selectitems.append("repmaterentry.repmole as repmole,");
        selectitems.append("repmaterentry.repdeno as repdeno,");
        selectitems.append("repmaterentry.repeffectdate as repeffectdate,");
        selectitems.append("repmaterentry.repinvaliddate as repinvaliddate,");
        selectitems.append("repmaterentry.repuseratio as repuseratio,");
        selectitems.append("repmaterentry.repfixscrap as repfixscrap,");
        selectitems.append("repmaterentry.repscraprate as repscraprate,");
        selectitems.append("0 as bomuser");
        return selectitems.toString();
    }

    private List<QFilter> buildQueryQFilter(FilterInfo filterInfo) {
        logger.info("ReplacePlanUserReport: start build QFilter\u3002");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        DynamicObject orgFilter = filterInfo.getDynamicObject("orgf");
        DynamicObjectCollection materialInfosFilter = filterInfo.getDynamicObjectCollection("materielinfof");
        String repalceNumberFilter = filterInfo.getString("replacenumberf");
        String repalceMethodFilter = filterInfo.getString("replacemethodf");
        String repalceStarFilter = filterInfo.getString("replacestraf");
        if (orgFilter != null) {
            long orgPK = orgFilter.getLong("id");
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)MPDM_REPLACEPLAN, (Long)orgPK);
            qFilters.add(baseDataFilter);
        }
        if (materialInfosFilter != null && !materialInfosFilter.isEmpty()) {
            Set<Long> replacePlanPks = this.getFindMaterialInfoPks(materialInfosFilter);
            qFilters.add(new QFilter("id", "in", replacePlanPks));
        }
        if (StringUtils.isNotBlank((CharSequence)repalceNumberFilter)) {
            String[] repalceNumbers = repalceNumberFilter.split(" ");
            QFilter numberQFilter = null;
            for (int i = 0; i < repalceNumbers.length; ++i) {
                String trim = repalceNumbers[i].trim();
                if (!StringUtils.isNotEmpty((CharSequence)trim)) continue;
                String repalceNumber = "%" + trim + "%";
                if (numberQFilter == null) {
                    numberQFilter = new QFilter("number", "like", (Object)repalceNumber);
                    continue;
                }
                numberQFilter.or("number", "like", (Object)repalceNumber);
            }
            if (numberQFilter != null) {
                qFilters.add(numberQFilter);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)repalceMethodFilter) && !"C".equals(repalceMethodFilter)) {
            qFilters.add(new QFilter("replacemethod", "=", (Object)repalceMethodFilter));
        }
        if (StringUtils.isNotBlank((CharSequence)repalceStarFilter) && !"A".equals(repalceStarFilter)) {
            qFilters.add(new QFilter("replacestra", "=", (Object)repalceStarFilter));
        }
        logger.info("ReplacePlanUserReport: build QFilter end\u3002");
        return qFilters;
    }

    private Set<Long> getFindMaterialInfoPks(DynamicObjectCollection materialInfosFilter) {
        HashSet<Long> materialInfoPks = new HashSet<Long>(8);
        HashSet<Long> replacePlanPks = new HashSet<Long>(32);
        for (int i = 0; i < materialInfosFilter.size(); ++i) {
            DynamicObject materialInfo = (DynamicObject)materialInfosFilter.get(i);
            long materialInfoPk = materialInfo.getLong("id");
            if (materialInfoPk <= 0L) continue;
            materialInfoPks.add(materialInfoPk);
        }
        if (!materialInfoPks.isEmpty()) {
            QFilter qFilter = new QFilter("mainmaterentry.material", "in", materialInfoPks).or("repmaterentry.repmaterial", "in", materialInfoPks);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)ReplacePlanUserReportQueryPlugin.class.getName(), (String)MPDM_REPLACEPLAN, (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"id");
            while (!dataSet.isEmpty() && dataSet.hasNext()) {
                Row row = dataSet.next();
                long replacePlanPk = row.getLong("id");
                if (replacePlanPk <= 0L) continue;
                replacePlanPks.add(replacePlanPk);
            }
        }
        return replacePlanPks;
    }
}

