/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.processroute;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.pdm.common.enums.DistributModeEnum;
import kd.mmc.pdm.common.enums.MaterialAttrEnum;
import kd.mmc.pdm.common.helper.PDMProMaterDTHelper;
import kd.mmc.pdm.common.objectbeen.StepEntryObj;
import kd.mmc.pdm.common.util.BOMQueryObject;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.PDMDateUtil;
import kd.mmc.pdm.common.util.ProMaterDTBUtil;

public class PDMProMaterDTBPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
BeforeF7SelectListener,
AfterF7SelectListener,
TabSelectListener,
SearchEnterListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(PDMProMaterDTBPlugin.class);
    private static final String PDM_DTBQTY = "pdm_dtbqty";
    private static final String PDM_DELDTBQTY = "pdm_delqty";
    private static final String BD_MATERIALMFTINFO = "bd_materialmftinfo";
    private static final String BD_MEASUREUNITS = "bd_measureunits";
    private static final String BD_AUXPROPERTY = "bd_auxproperty";
    private static final String WORKPROENTRY = "workprocedure";
    private static final String NOTALLOCATENTRY = "notallocatentry";
    private static final String STEPENTRY = "stepentry";
    private static final String SUBVIRTUALENTRY = "subvirtualentry";
    private static final String VIRTUALENTRY = "virtualentry";
    private static final String DTBMATERENTRY = "dtbmaterentry";
    private static final String DTBSTEPENTRY = "dtbstepentry";
    private static final String DTBVIRTUALENTRY = "dtbvirtualentry";
    private static final String DTBSUBVIRTUALENTRY = "dtbsubvirtualentry";
    private static final String ROOT = "root";
    private static final String CURNODEID = "curNodeId";
    private static final String QTYENTRY = "qtyentry";
    private static final String DTBQTYENTRY = "dtbqtyentry";
    private static final String BOM = "bom";
    private static final String PRODUCT = "product";
    private static final String PROCESSROUTE = "processroute";
    private static final String PDM_BOM = "pdm_mftbom";
    private static final String TREEVIEWAP = "treeviewap";
    private static final String NOT_VIRTUAL = "not_virtual";
    private static final String MAIN_PRODUCT = "material";
    private static final String ISINTEGRITY = "isintegrity";
    private static final String BOM_VERSION = "version";
    private static final String BOM_TYPE = "type";
    private static final String BOM_ENTRY = "entry";
    private static final String ENTRY_ATTR = "entrymaterialattr";
    private static final String ENTRY_BOMVERSION = "entryversion";
    private static final String ENTRY_MATERIAL = "entrymaterial";
    private static final String ENTRY_QTYTYPE = "entryqtytype";
    private static final List<BOMQueryObject> NOTALLOCATENTRYLIST = new ArrayList<BOMQueryObject>();
    private static final List<StepEntryObj> STEPENTRYLIST = new ArrayList<StepEntryObj>();
    private static final List<BOMQueryObject> VIRTUALENTRYLIST = new ArrayList<BOMQueryObject>();
    private static final List<BOMQueryObject> SUBVIRTUALENTRYLIST = new ArrayList<BOMQueryObject>();
    private static final List<BOMQueryObject> DISNOTALLOCATENTRYLIST = new ArrayList<BOMQueryObject>();
    private static final List<BOMQueryObject> DISSTEPENTRYLIST = new ArrayList<BOMQueryObject>();
    private static final String KEY_NOTALLOCATENTRYLIST = "NOTALLOCATENTRYLIST";
    private static final String KEY_STEPENTRYLIST = "STEPENTRYLIST";
    private static final String KEY_VIRTUALENTRYLIST = "VIRTUALENTRYLIST";
    private static final String KEY_SUBVIRTUALENTRYLIST = "SUBVIRTUALENTRYLIST";
    private static final String KEY_DISNOTALLOCATENTRYLIST = "DISNOTALLOCATENTRYLIST";
    private static final String KEY_DISSTEPENTRYLIST = "DISSTEPENTRYLIST";
    public static final String DISTRIBUT = "distribut";

    public void afterBindData(EventObject e) {
        DynamicObject newbom;
        this.getView().setEnable(Boolean.FALSE, new String[]{PRODUCT});
        TreeView materTree = (TreeView)this.getControl(TREEVIEWAP);
        if (materTree == null) {
            return;
        }
        materTree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"PDMProMaterDTBPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setId("0");
        root.setIsOpened(false);
        materTree.addNode(root);
        String rootStr = SerializationUtils.toJsonString((Object)root);
        this.getPageCache().put(ROOT, rootStr);
        this.getView().setEnable(Boolean.FALSE, new String[]{NOTALLOCATENTRY, STEPENTRY, VIRTUALENTRY, SUBVIRTUALENTRY, WORKPROENTRY, DTBMATERENTRY, DTBSTEPENTRY, DTBVIRTUALENTRY, DTBSUBVIRTUALENTRY, QTYENTRY, DTBQTYENTRY});
        DynamicObject bom = (DynamicObject)this.getModel().getValue(BOM);
        if (bom != null && bom.getPkValue() != null && (newbom = BusinessDataServiceHelper.loadSingleFromCache((Object)bom.getPkValue(), (String)PDM_BOM, (String)PDMProMaterDTHelper.getSelectBOMField())) != null) {
            this.initTree(newbom);
        }
        this.getPageCache().put("tabpageap", "tabpageap");
        this.getPageCache().put("tabpageapdtb", "tabpageap51");
        this.setRowColor();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        switch (key) {
            case "distribut": {
                Object oldValue;
                Object newValue = changeData.getNewValue();
                Object object = oldValue = changeData.getOldValue() == null ? DistributModeEnum.DISORDER.getCode() : changeData.getOldValue();
                if (!Objects.nonNull(newValue)) break;
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DTBMATERENTRY);
                if (!entryEntity.isEmpty()) {
                    this.getPageCache().put("distributoldValue", oldValue.toString());
                    String msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5206\u914d\u7684\u7ec4\u4ef6\uff0c\u201c\u5206\u914d\u65b9\u5f0f\u201d\u53d8\u5316\u5c06\u4f1a\u91cd\u7f6e\u5206\u914d\u7ed3\u679c\uff0c\u662f\u5426\u786e\u5b9a\u4fee\u6539\uff1f", (String)"PDMProMaterDTBPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(DISTRIBUT);
                    this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBackListener);
                    break;
                }
                this.changeDTBQuery(newValue.toString());
                break;
            }
            case "effectdate": 
            case "invaliddate": {
                break;
            }
            case "bom": {
                this.setEffectAndInvalidDate(this.getModel());
            }
        }
    }

    private void setEffectAndInvalidDate(IDataModel modle) {
        DynamicObject bom = (DynamicObject)modle.getValue(BOM);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2029, 1, 1, 0, 0, 0);
        Date defalutInvalidDate = calendar.getTime();
        if (bom == null) {
            modle.setValue("effectdate", (Object)new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
            modle.setValue("invaliddate", (Object)defalutInvalidDate);
            this.cleanData();
            return;
        }
        Long bomPkValue = (Long)bom.getPkValue();
        QFilter qfilter = new QFilter("id", "=", (Object)bomPkValue);
        DynamicObjectCollection bomConllection = QueryServiceHelper.query((String)PDM_BOM, (String)"version.effectdate,version.invaliddate", (QFilter[])new QFilter[]{qfilter});
        if (bomConllection != null && !bomConllection.isEmpty()) {
            DynamicObject bomDynamic = (DynamicObject)bomConllection.get(0);
            Date effectDate = (Date)bomDynamic.get("version.effectdate");
            Date invalidDate = (Date)bomDynamic.get("version.invaliddate");
            if (effectDate != null) {
                modle.setValue("effectdate", (Object)new SimpleDateFormat("yyyy-MM-dd").format(effectDate));
            }
            if (invalidDate != null) {
                modle.setValue("invaliddate", (Object)new SimpleDateFormat("yyyy-MM-dd").format(invalidDate));
            }
        } else {
            modle.setValue("effectdate", (Object)new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
            modle.setValue("invaliddate", (Object)defalutInvalidDate);
        }
    }

    private void changeProcess() {
        DynamicObject process = (DynamicObject)this.getModel().getValue(PROCESSROUTE);
        if (process == null) {
            return;
        }
        DynamicObjectCollection processEntry = process.getDynamicObjectCollection("processentry");
        if (this.getModel().getEntryEntity(WORKPROENTRY) != null && !this.getModel().getEntryEntity(WORKPROENTRY).isEmpty()) {
            this.getModel().deleteEntryData(WORKPROENTRY);
        }
        this.setWorkProcessEntryValue(processEntry);
        String mode = (String)this.getModel().getValue(DISTRIBUT);
        this.changeDTBQuery(mode);
    }

    private void changeBOM(IDataModel model, IFormView view) {
        DynamicObject bom = (DynamicObject)model.getValue(BOM);
        if (bom == null) {
            return;
        }
        DynamicObject newbom = PDMProMaterDTHelper.queryBOMData((Object)bom.getPkValue());
        if (newbom == null) {
            return;
        }
        PDMProMaterDTHelper.setOtherFieldValueByBOM((IDataModel)model, (IFormView)view, (DynamicObject)newbom);
        this.initTree(newbom);
        String dtbMode = (String)model.getValue(DISTRIBUT);
        this.changeDTBQuery(dtbMode);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("effectdate", (Object)PDMDateUtil.getDate((Date)new Date()));
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        BasedataEdit basedataEdit = (BasedataEdit)e.getSource();
        if (basedataEdit == null) {
            return;
        }
        String key = basedataEdit.getFieldKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)BOM)) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            this.changeBOM(model, view);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)PROCESSROUTE)) {
            this.changeProcess();
        }
    }

    private void initTree(DynamicObject bom) {
        if (bom == null) {
            return;
        }
        NOTALLOCATENTRYLIST.clear();
        STEPENTRYLIST.clear();
        VIRTUALENTRYLIST.clear();
        SUBVIRTUALENTRYLIST.clear();
        DISNOTALLOCATENTRYLIST.clear();
        DISSTEPENTRYLIST.clear();
        TreeView materTree = (TreeView)this.getControl(TREEVIEWAP);
        if (materTree == null) {
            return;
        }
        materTree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"PDMProMaterDTBPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setId("0");
        root.setIsOpened(false);
        materTree.addNode(root);
        DynamicObject mainProduct = bom.getDynamicObject(MAIN_PRODUCT);
        if (mainProduct == null) {
            return;
        }
        String id = mainProduct.getString("id");
        String name = mainProduct.getString("masterid.name") + "[" + mainProduct.getString("masterid.number") + "]";
        TreeNode mainM = new TreeNode("0", id, name);
        root.addChild(mainM);
        root.setIsOpened(true);
        DynamicObjectCollection materCol = bom.getDynamicObjectCollection(BOM_ENTRY);
        String dtbMode = (String)this.getModel().getValue(DISTRIBUT);
        if (dtbMode == null || dtbMode.trim().length() == 0) {
            dtbMode = DistributModeEnum.DISORDER.getCode();
            this.getModel().setValue(DISTRIBUT, (Object)DistributModeEnum.DISORDER.getCode());
        }
        this.getPageCache().put(DISTRIBUT, dtbMode);
        Object version = bom.get(BOM_VERSION);
        Date effectDate = null;
        Date invalidDate = null;
        if (!Objects.isNull(version)) {
            Object invalidDateObj;
            Object bomversion = (DynamicObject)version;
            Object effectDateObj = (bomversion = BusinessDataServiceHelper.loadSingle((Object)bomversion.getPkValue(), (String)"bd_bomversion_new")).get("effectdate");
            if (effectDateObj instanceof Date) {
                effectDate = PDMDateUtil.getDate((Date)((Date)effectDateObj));
            }
            if ((invalidDateObj = bomversion.get("invaliddate")) instanceof Date) {
                invalidDate = PDMDateUtil.getDate((Date)((Date)invalidDateObj));
            }
        }
        for (DynamicObject row : materCol) {
            DynamicObject entryMater;
            Date invalidDate_zj = row.getDate("entryinvaliddate");
            Date effectDate_zj = row.getDate("entryvaliddate");
            HashMap<String, Date> paraMap = new HashMap<String, Date>();
            if (effectDate != null && invalidDate != null && invalidDate_zj != null && effectDate_zj != null) {
                if (invalidDate_zj.before(effectDate) || effectDate_zj.after(invalidDate)) continue;
                Date subEffectDate = null;
                subEffectDate = !effectDate_zj.after(effectDate) ? effectDate : effectDate_zj;
                Date subInvalidDate = null;
                subInvalidDate = !invalidDate_zj.after(invalidDate) ? invalidDate_zj : invalidDate;
                paraMap.put("subEffectDate", subEffectDate);
                paraMap.put("subInvalidDate", subInvalidDate);
            }
            if (effectDate == null && invalidDate == null) {
                paraMap.put("subEffectDate", effectDate_zj);
                paraMap.put("subInvalidDate", invalidDate_zj);
            }
            if ((entryMater = row.getDynamicObject(ENTRY_MATERIAL)) == null) {
                ErrorCode ec = new ErrorCode(MAIN_PRODUCT, ResManager.loadKDString((String)"BOM\u5206\u5f55\u7269\u6599\u4e3a\u7a7a\u3002", (String)"PDMProMaterDTBPlugin_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                throw new KDBizException(ec, new Object[0]);
            }
            DynamicObject bomVersion = row.getDynamicObject(ENTRY_BOMVERSION);
            String mainProId = entryMater.getString("id");
            String nodeName = entryMater.getString("masterid.name") + "[" + entryMater.getString("masterid.number") + "]";
            Long entryId = ProMaterDTBUtil.getRandNum();
            BOMQueryObject dtbObject = ProMaterDTBUtil.geMaterDTBObject((DynamicObject)bom, (DynamicObject)row, (Long)0L, (Long)entryId, (BigDecimal)new BigDecimal("1"), (BigDecimal)new BigDecimal("1"));
            String qtyType = row.getString(ENTRY_QTYTYPE).trim();
            if ("C".equals(qtyType)) {
                dtbObject.setQtyentry(PDMProMaterDTHelper.queryStepEntry((DynamicObject)row, (BigDecimal)new BigDecimal("1"), (BigDecimal)new BigDecimal("1")));
            }
            NOTALLOCATENTRYLIST.add(dtbObject);
            DISNOTALLOCATENTRYLIST.add(dtbObject);
            String longId = row.getString("id");
            TreeNode node = new TreeNode(id, longId, nodeName);
            Boolean isJumpLevel = row.getBoolean("entryisjumplevel");
            if (isJumpLevel.booleanValue()) {
                node.setColor("blue");
                DynamicObject bomType = bom.getDynamicObject(BOM_TYPE);
                String bomVersionPk = bomVersion != null ? bomVersion.getPkValue().toString() : "0";
                String bomTypePk = bomType != null ? bomType.getPkValue().toString() : "0";
                BigDecimal qtymole = dtbObject.getQtymole();
                BigDecimal fixScrap = dtbObject.getFixscrap();
                DynamicObject bomReplace = bom.getDynamicObject("replaceno");
                String bomReplacePK = bomReplace != null ? bomReplace.getPkValue().toString() : "0";
                DynamicObject entryauxproperty = row.getDynamicObject("entryauxproperty");
                String entryauxpropertyId = entryauxproperty != null ? entryauxproperty.getPkValue().toString() : "0";
                HashMap<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>(2);
                dataMap.put("mole", qtymole);
                dataMap.put("fixScrap", fixScrap);
                node.setData(dataMap);
                List<TreeNode> childes = this.loadChildNodes(paraMap, bomReplacePK, entryauxpropertyId, mainProId, bomVersionPk, entryId, qtymole, dtbObject.getQtydeno(), bomTypePk, longId);
                if (childes != null && childes.size() > 0) {
                    node.addChildren(childes);
                }
            }
            mainM.addChild(node);
        }
        String rootString = SerializationUtils.toJsonString((Object)root);
        this.getPageCache().put(ROOT, rootString);
        this.setDTBPageCache();
    }

    private void setDTBPageCache() {
        String str = SerializationUtils.toJsonString(NOTALLOCATENTRYLIST);
        this.getPageCache().put(KEY_NOTALLOCATENTRYLIST, str);
        str = SerializationUtils.toJsonString(STEPENTRYLIST);
        this.getPageCache().put(KEY_STEPENTRYLIST, str);
        str = SerializationUtils.toJsonString(VIRTUALENTRYLIST);
        this.getPageCache().put(KEY_VIRTUALENTRYLIST, str);
        str = SerializationUtils.toJsonString(SUBVIRTUALENTRYLIST);
        this.getPageCache().put(KEY_SUBVIRTUALENTRYLIST, str);
        str = SerializationUtils.toJsonString(DISNOTALLOCATENTRYLIST);
        this.getPageCache().put(KEY_DISNOTALLOCATENTRYLIST, str);
        str = SerializationUtils.toJsonString(DISSTEPENTRYLIST);
        this.getPageCache().put(KEY_DISSTEPENTRYLIST, str);
    }

    private void getDTBPageCache() {
        List disnotallocatlist;
        List subvirtuallist;
        List virtuallist;
        String str = this.getPageCache().get(KEY_NOTALLOCATENTRYLIST);
        if (Objects.isNull(str)) {
            NOTALLOCATENTRYLIST.clear();
            DISNOTALLOCATENTRYLIST.clear();
            return;
        }
        List notallocatlist = SerializationUtils.fromJsonStringToList((String)str, BOMQueryObject.class);
        if (!MMCUtils.isEmptyList((List)notallocatlist) && notallocatlist.get(0) instanceof BOMQueryObject) {
            NOTALLOCATENTRYLIST.clear();
            NOTALLOCATENTRYLIST.addAll(notallocatlist);
        }
        if (!MMCUtils.isEmptyList((List)(virtuallist = SerializationUtils.fromJsonStringToList((String)(str = this.getPageCache().get(KEY_VIRTUALENTRYLIST)), BOMQueryObject.class))) && virtuallist.get(0) instanceof BOMQueryObject) {
            VIRTUALENTRYLIST.clear();
            VIRTUALENTRYLIST.addAll(virtuallist);
        }
        if (!MMCUtils.isEmptyList((List)(subvirtuallist = SerializationUtils.fromJsonStringToList((String)(str = this.getPageCache().get(KEY_SUBVIRTUALENTRYLIST)), BOMQueryObject.class))) && subvirtuallist.get(0) instanceof BOMQueryObject) {
            SUBVIRTUALENTRYLIST.clear();
            SUBVIRTUALENTRYLIST.addAll(subvirtuallist);
        }
        if (!MMCUtils.isEmptyList((List)(disnotallocatlist = SerializationUtils.fromJsonStringToList((String)(str = this.getPageCache().get(KEY_DISNOTALLOCATENTRYLIST)), BOMQueryObject.class))) && disnotallocatlist.get(0) instanceof BOMQueryObject) {
            DISNOTALLOCATENTRYLIST.clear();
            DISNOTALLOCATENTRYLIST.addAll(disnotallocatlist);
        }
    }

    private List<TreeNode> loadChildNodes(Map<String, Date> paraMap, String bomReplacePK, String entryauxpropertyId, String mainProId, String BOMVersionId, Long parentEntryId, BigDecimal mole, BigDecimal deno, String bomTypeId, String longId) {
        if (StringUtils.isEmpty((CharSequence)mainProId)) {
            return null;
        }
        List<Map<String, String>> nodeList = this.queryBOMEntry(paraMap, bomReplacePK, entryauxpropertyId, mainProId, BOMVersionId, parentEntryId, mole, deno, bomTypeId, longId);
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(nodeList.size());
        for (Map<String, String> map : nodeList) {
            TreeNode node = this.changeMapToTreeNode(map);
            if (node == null) continue;
            String isJumpLevel = map.get("isJumpLevel");
            if (Boolean.parseBoolean(isJumpLevel)) {
                String id = map.get("id");
                String bomversion = map.get("bomversion");
                String entryauxpropertyPK = map.get("entryauxpropertyPK");
                String entryId = map.get("entryId");
                String invalidTime = map.get("invalidTime");
                String effectTime = map.get("effectTime");
                Date subEffectDate = PDMDateUtil.parseDateTime((String)effectTime, (String)"yyyy-MM-dd");
                Date subInvalidDate = PDMDateUtil.parseDateTime((String)invalidTime, (String)"yyyy-MM-dd");
                mole = new BigDecimal(map.get("mole"));
                HashMap<String, Date> paraDate = new HashMap<String, Date>();
                paraDate.put("subEffectDate", subEffectDate);
                paraDate.put("subInvalidDate", subInvalidDate);
                BigDecimal fixScrap = new BigDecimal(map.get("fixScrap"));
                HashMap<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>(2);
                dataMap.put("mole", mole);
                dataMap.put("fixScrap", fixScrap);
                node.setData(dataMap);
                deno = new BigDecimal(map.get("deno"));
                List<TreeNode> childNodes = this.loadChildNodes(paraDate, bomReplacePK, entryauxpropertyPK, id, bomversion, Long.parseLong(entryId), mole, deno, bomTypeId, map.get("longid"));
                if (childNodes != null && !childNodes.isEmpty() && node != null) {
                    node.addChildren(childNodes);
                }
            }
            nodes.add(node);
        }
        return nodes;
    }

    private String getQueryBOMItems() {
        String string = "id,number,type,group,createorg,status,enable,version,replaceno,material,material.materialattr  materialattr,entry.id entryid,entry.entryisjumplevel entryisjumplevel,entry.entrymaterial entrymaterial,entry.entryvaliddate entryvaliddate,entry.entryinvaliddate entryinvaliddate,entry.entrymaterialattr entrymaterialattr,entry.entryunit entryunit,entry.entryversion entryversion,entry.entryqtytype entryqtytype,entry.entryqtynumerator entryqtynumerator,entry.entryqtydenominator entryqtydenominator,entry.entryqty entryqty,entry.entryfixscrap entryfixscrap,entry.entryscraprate entryscraprate,entry.entryremark entryremark,entry.entryauxproperty entryauxproperty,entry.qtyentry.qtyentrybatchstartqty qtyentrybatchstartqty,entry.qtyentry.qtyentrybatchendqty qtyentrybatchendqty,entry.qtyentry.qtyentryqtynumerator qtyentryqtynumerator,entry.qtyentry.qtyentryqtydenominator qtyentryqtydenominator,entry.qtyentry.qtyentryfixscrap qtyentryfixscrap,entry.qtyentry.qtyentryscraprate qtyentryscraprate";
        return string;
    }

    private List<Map<String, String>> queryBOMEntry(Map<String, Date> paraMap, String bomReplacePK, String entryauxpropertyId, String mainProId, String BOMVersionId, Long parentEntryId, BigDecimal mole, BigDecimal deno, String bomTypeId, String longId) {
        DynamicObject newbom;
        DynamicObjectCollection materCol;
        ArrayList<Map<String, String>> nodeList = new ArrayList<Map<String, String>>();
        DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)PDM_BOM, (Long)createorg.getLong("id"));
        QFilter qFilterReplace = new QFilter("replaceno", "=", (Object)Long.parseLong(bomReplacePK));
        QFilter qFilterBOMVersion = new QFilter(BOM_VERSION, "=", (Object)Long.valueOf(BOMVersionId));
        QFilter qFilterMater = new QFilter(MAIN_PRODUCT, "=", (Object)Long.valueOf(mainProId));
        QFilter qFilterAuxpro = new QFilter("auxproperty", "=", (Object)Long.valueOf(entryauxpropertyId));
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterType = new QFilter(BOM_TYPE, "=", (Object)Long.valueOf(bomTypeId));
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(qFilterMater);
        filters.add(qFilterStatus);
        filters.add(qFilterEnable);
        filters.add(qFilterType);
        filters.add(qFilterOrg);
        filters.add(qFilterBOMVersion);
        filters.add(qFilterReplace);
        filters.add(qFilterAuxpro);
        DynamicObject bom = QueryServiceHelper.queryOne((String)PDM_BOM, (String)"id", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        if (Objects.isNull(bom)) {
            filters.remove(qFilterReplace);
            QFilter qFilterNoReplace = new QFilter("replaceno", "=", (Object)Long.parseLong("0"));
            filters.add(qFilterNoReplace);
            bom = QueryServiceHelper.queryOne((String)PDM_BOM, (String)"id", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        }
        if (Objects.nonNull(bom) && (materCol = (newbom = BusinessDataServiceHelper.loadSingleFromCache((Object)bom.get("id"), (String)PDM_BOM, (String)PDMProMaterDTHelper.getSelectBOMField())).getDynamicObjectCollection(BOM_ENTRY)) != null && materCol.size() > 0) {
            Date effectDateObj = paraMap.get("subEffectDate");
            Date effectDate = null;
            effectDate = PDMDateUtil.getDate((Date)effectDateObj);
            Date invalidDateObj = paraMap.get("subInvalidDate");
            Date invalidDate = null;
            invalidDate = PDMDateUtil.getDate((Date)invalidDateObj);
            Object version = newbom.get(BOM_VERSION);
            if (!Objects.isNull(version)) {
                DynamicObject bomversion = (DynamicObject)version;
                bomversion = BusinessDataServiceHelper.loadSingle((Object)bomversion.getPkValue(), (String)"bd_bomversion_new");
                Object veffectDateObj = bomversion.get("effectdate");
                Date versionEffect = null;
                if (veffectDateObj instanceof Date) {
                    versionEffect = PDMDateUtil.getDate((Date)((Date)veffectDateObj));
                }
                Object vinvalidDateObj = bomversion.get("invaliddate");
                Date versionIvalidDate = null;
                if (vinvalidDateObj instanceof Date) {
                    versionIvalidDate = PDMDateUtil.getDate((Date)((Date)vinvalidDateObj));
                }
                if (null != versionIvalidDate && null != versionEffect) {
                    if (versionIvalidDate.before(effectDate) || versionEffect.after(invalidDate)) {
                        return nodeList;
                    }
                    if (!effectDate.after(versionEffect)) {
                        effectDate = versionEffect;
                    }
                    if (!invalidDate.before(versionIvalidDate)) {
                        invalidDate = versionIvalidDate;
                    }
                }
            }
            for (DynamicObject row : materCol) {
                if (StringUtils.isBlank((CharSequence)row.getString(ENTRY_MATERIAL))) continue;
                String newLongId = longId + "-" + row.getString("id");
                Date invalidDate_zj = row.getDate("entryinvaliddate");
                Date effectDate_zj = row.getDate("entryvaliddate");
                String effectTime = null;
                String invalidTime = null;
                if (effectDate != null && invalidDate != null && invalidDate_zj != null && effectDate_zj != null) {
                    if (invalidDate_zj.before(effectDate) || effectDate_zj.after(invalidDate)) continue;
                    Date subEffectDate = null;
                    subEffectDate = !effectDate_zj.after(effectDate) ? effectDate : effectDate_zj;
                    Date subInvalidDate = null;
                    subInvalidDate = !invalidDate_zj.after(invalidDate) ? invalidDate_zj : invalidDate;
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    effectTime = sdf.format(subEffectDate);
                    invalidTime = sdf.format(subInvalidDate);
                }
                DynamicObject entryMater = row.getDynamicObject(ENTRY_MATERIAL);
                DynamicObject entryauxproperty = row.getDynamicObject("entryauxproperty");
                String entryauxpropertyPK = entryauxproperty != null ? entryauxproperty.getPkValue().toString() : "0";
                Long bomVersion = row.getLong("entryversion.id");
                String entryMaterId = entryMater.getString("id");
                String nodeName = entryMater.getString("name") + "[" + entryMater.getString("number") + "]";
                Boolean entryIsJumpLevel = row.getBoolean("entryisjumplevel");
                Long entryId = ProMaterDTBUtil.getRandNum();
                String qtyType = row.getString(ENTRY_QTYTYPE).trim();
                BOMQueryObject dtbObject = null;
                dtbObject = "B".equals(qtyType) ? ProMaterDTBUtil.geBOMQueryObject((DynamicObject)row, (String)newLongId, (Long)parentEntryId, (Long)entryId, (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ONE) : ProMaterDTBUtil.geBOMQueryObject((DynamicObject)row, (String)newLongId, (Long)parentEntryId, (Long)entryId, (BigDecimal)mole, (BigDecimal)deno);
                if (dtbObject == null) continue;
                if ("C".equals(qtyType)) {
                    dtbObject.setQtyentry(PDMProMaterDTHelper.queryStepEntry((DynamicObject)row, (BigDecimal)mole, (BigDecimal)deno));
                }
                NOTALLOCATENTRYLIST.add(dtbObject);
                DISNOTALLOCATENTRYLIST.add(dtbObject);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", entryMaterId);
                map.put("name", nodeName);
                map.put("entryauxpropertyPK", entryauxpropertyPK);
                map.put("parentid", parentEntryId.toString());
                map.put("entryId", entryId.toString());
                map.put("mole", dtbObject.getQtymole().toString());
                map.put("deno", dtbObject.getQtydeno().toString());
                map.put("bomversion", bomVersion == null ? "0" : bomVersion.toString());
                map.put("isJumpLevel", entryIsJumpLevel.toString());
                map.put("longid", newLongId);
                map.put("fixScrap", dtbObject.getFixscrap().toString());
                map.put("effectTime", effectTime);
                map.put("invalidTime", invalidTime);
                nodeList.add(map);
            }
        }
        return nodeList;
    }

    private TreeNode changeMapToTreeNode(Map<String, String> map) {
        if (map.isEmpty()) {
            return null;
        }
        TreeNode node = new TreeNode();
        String name = map.get("name");
        node.setId(map.get("longid"));
        node.setText(name);
        node.setParentid(map.get("parentid"));
        node.setType(map.get("bomversion"));
        String isJumpLevel = map.get("isJumpLevel");
        if (Boolean.parseBoolean(isJumpLevel)) {
            node.setColor("blue");
        }
        return node;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = (String)e.getNodeId();
        this.getPageCache().put(CURNODEID, nodeId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        String mode = (String)this.getModel().getValue(DISTRIBUT);
        String status = (String)this.getModel().getValue("status");
        if (!"A".equals(status)) {
            return;
        }
        String selectPag = this.getPageCache().get("tabpageap");
        String selectPagDtb = this.getPageCache().get("tabpageapdtb");
        switch (key) {
            case "query": {
                DynamicObject bom = this.getModel().getDataEntity().getDynamicObject(BOM);
                if (bom == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9BOM\u7f16\u7801\u3002", (String)"PDMProMaterDTBPlugin_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String dtbMode = this.getPageCache().get(DISTRIBUT);
                if (StringUtils.equals((CharSequence)dtbMode, (CharSequence)mode)) {
                    return;
                }
                this.getPageCache().put(DISTRIBUT, mode);
                this.changeDTBQuery(mode);
                break;
            }
            case "adistribut": {
                if ("tabpageap".equals(selectPag)) {
                    this.adistribut();
                } else if ("tabpageap1".equals(selectPag)) {
                    this.bdistribut();
                }
                this.setRowColor();
                break;
            }
            case "adeldistribut": {
                if ("tabpageap51".equals(selectPagDtb)) {
                    this.adeldistribut();
                } else if ("tabpageap4".equals(selectPagDtb)) {
                    this.bdeldistribut();
                }
                this.setRowColor();
                break;
            }
            case "alldistribut": {
                if ("tabpageap".equals(selectPag)) {
                    this.alldistribut();
                } else if ("tabpageap1".equals(selectPag)) {
                    this.balldistribut();
                }
                this.setRowColor();
                break;
            }
            case "alldeldistribut": {
                if ("tabpageap51".equals(selectPagDtb)) {
                    this.alldeldistribut();
                } else if ("tabpageap4".equals(selectPagDtb)) {
                    this.balldeldistribut();
                }
                this.setRowColor();
                break;
            }
        }
    }

    private void changeDTBQuery(String mode) {
        if (this.getModel().getEntryEntity(NOTALLOCATENTRY) != null) {
            this.getModel().deleteEntryData(NOTALLOCATENTRY);
        }
        if (this.getModel().getEntryEntity(STEPENTRY) != null) {
            this.getModel().deleteEntryData(STEPENTRY);
        }
        if (this.getModel().getEntryEntity(QTYENTRY) != null) {
            this.getModel().deleteEntryData(QTYENTRY);
        }
        if (this.getModel().getEntryEntity(DTBMATERENTRY) != null) {
            this.getModel().deleteEntryData(DTBMATERENTRY);
        }
        if (this.getModel().getEntryEntity(DTBSTEPENTRY) != null) {
            this.getModel().deleteEntryData(DTBSTEPENTRY);
        }
        if (this.getModel().getEntryEntity(DTBVIRTUALENTRY) != null) {
            this.getModel().deleteEntryData(DTBVIRTUALENTRY);
        }
        this.getView().updateView(NOTALLOCATENTRY);
        this.getView().updateView(STEPENTRY);
        this.getView().updateView(DTBMATERENTRY);
        this.getView().updateView(DTBSTEPENTRY);
        this.getView().updateView(DTBVIRTUALENTRY);
        this.getView().updateView(QTYENTRY);
        this.getView().updateView(DTBQTYENTRY);
        this.getDTBPageCache();
        if (StringUtils.equals((CharSequence)DistributModeEnum.ORDER.getCode(), (CharSequence)mode)) {
            this.setNotAllocatEntryValue(NOTALLOCATENTRYLIST);
        } else {
            this.setDisNotAllocatEntryValue(DISNOTALLOCATENTRYLIST);
        }
        this.setRowColor();
    }

    private void bdistribut() {
        StringBuilder error = ProMaterDTBUtil.checkDTBAddRigth((IDataModel)this.getModel(), (IFormView)this.getView(), (String)QTYENTRY, (String)ResManager.loadKDString((String)"\u9636\u68af\u7528\u91cf\u6e05\u5355", (String)"PDMProMaterDTBPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), (Boolean)Boolean.FALSE);
        if (error.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u63d0\u793a\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PDMProMaterDTBPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(NOTALLOCATENTRY);
        EntryGrid qtyEntryGrid = (EntryGrid)this.getControl(QTYENTRY);
        int[] indexs = entryGrid.getSelectRows();
        int[] qtyIndexs = qtyEntryGrid.getSelectRows();
        int qtyIndex = qtyIndexs[0];
        DynamicObject qtyMaterEntry = this.getModel().getEntryRowEntity(QTYENTRY, qtyIndex);
        if (indexs == null || indexs.length == 0) {
            DynamicObject parent = (DynamicObject)qtyMaterEntry.getParent();
            int pIndex = parent.getInt("seq") - 1;
            indexs = new int[]{pIndex};
        }
        int j = indexs[0];
        DynamicObject materEntry = this.getModel().getEntryRowEntity(NOTALLOCATENTRY, j);
        BigDecimal zero = new BigDecimal("0");
        if (zero.compareTo(qtyMaterEntry.getBigDecimal("substepqtymole")) == 0) {
            error.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u6240\u9009\u9636\u68af\u7528\u91cf\u53ef\u5206\u914d\u6570\u91cf\u4e3a\u96f6\u3002", (String)"PDMProMaterDTBPlugin_29", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), materEntry.get("nallocatmater.masterid.number"))).append("\r\n");
            this.getView().showMessage(error.toString());
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("formId", PDM_DTBQTY);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(param);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("qty", qtyMaterEntry.get("substepqtymole"));
        parameter.setCustomParam("unit", (Object)materEntry.getString("nallocatunit.id"));
        parameter.setCustomParam("usagetype", (Object)"D");
        parameter.setCustomParam("fixscrap", qtyMaterEntry.get("substepfixscrap"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addStepQty"));
        this.getView().showForm(parameter);
    }

    private void balldistribut() {
        StringBuilder error = ProMaterDTBUtil.checkDTBAddRigth((IDataModel)this.getModel(), (IFormView)this.getView(), (String)QTYENTRY, (String)ResManager.loadKDString((String)"\u9636\u68af\u7528\u91cf\u6e05\u5355", (String)"PDMProMaterDTBPlugin_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), (Boolean)Boolean.TRUE);
        if (error.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u63d0\u793a\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PDMProMaterDTBPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(NOTALLOCATENTRY);
        EntryGrid qtyEntryGrid = (EntryGrid)this.getControl(QTYENTRY);
        EntryGrid workEntryGrid = (EntryGrid)this.getControl(WORKPROENTRY);
        int[] indexs = entryGrid.getSelectRows();
        int[] qtyIndexs = qtyEntryGrid.getSelectRows();
        int[] workIndexs = workEntryGrid.getSelectRows();
        int k = qtyIndexs[0];
        DynamicObject qtyMaterEntry = this.getModel().getEntryRowEntity(QTYENTRY, k);
        if (indexs == null || indexs.length == 0) {
            DynamicObject parent = (DynamicObject)qtyMaterEntry.getParent();
            int pIndex = parent.getInt("seq") - 1;
            indexs = new int[]{pIndex};
        }
        int j = indexs[0];
        int i = workIndexs[0];
        DynamicObject processWork = this.getModel().getEntryRowEntity(WORKPROENTRY, i);
        DynamicObject materEntry = this.getModel().getEntryRowEntity(NOTALLOCATENTRY, j);
        DynamicObjectCollection dtbmater = this.getModel().getEntryEntity(DTBMATERENTRY);
        ArrayList<DynamicObject> qtyEntryObjLs = new ArrayList<DynamicObject>();
        int success = 0;
        for (int qtyIndex : qtyIndexs) {
            qtyMaterEntry = this.getModel().getEntryRowEntity(QTYENTRY, qtyIndex);
            BigDecimal qty = qtyMaterEntry.getBigDecimal("substepqtymole");
            BigDecimal substepfixscrap = qtyMaterEntry.getBigDecimal("substepfixscrap");
            long qtyEntryId = qtyMaterEntry.getLong("id");
            if (BigDecimal.ZERO.compareTo(qty) == 0) {
                error.append(ResManager.loadKDString((String)"\u7b2c%s\u6761\u5206\u5f55\uff1a\u53ef\u5206\u914d\u6570\u91cf\u4e3a\u96f6\u3002", (String)"PDMProMaterDTBPlugin_7", (String)"mmc-pdm-formplugin", (Object[])new Object[]{qtyIndex + 1}));
                continue;
            }
            boolean isDeal = false;
            if (dtbmater != null && dtbmater.size() > 0) {
                for (DynamicObject dtbmaterEntry : dtbmater) {
                    DynamicObjectCollection dtbQtyEntrys;
                    String dtballocatlongid = dtbmaterEntry.getString("dtballocatlongid");
                    String nallocatlongid = materEntry.getString("nallocatlongid");
                    String dtballocatoprentryid = dtbmaterEntry.getString("dtballocatoprentryid");
                    String oprentryid = processWork.getString("oprentryid");
                    if (!StringUtils.equals((CharSequence)dtballocatlongid, (CharSequence)nallocatlongid) || !StringUtils.equals((CharSequence)dtballocatoprentryid, (CharSequence)oprentryid) || (dtbQtyEntrys = dtbmaterEntry.getDynamicObjectCollection(DTBQTYENTRY)) == null) continue;
                    boolean isExist = false;
                    for (DynamicObject dtbQtyEntry : dtbQtyEntrys) {
                        long dtbsubstepqtyentryid = dtbQtyEntry.getLong("dtbsubstepqtyentryid");
                        if (qtyEntryId == 0L || qtyEntryId != dtbsubstepqtyentryid) continue;
                        isExist = true;
                        isDeal = true;
                        BigDecimal dtbsubstepqtymole = dtbQtyEntry.getBigDecimal("dtbsubstepqtymole");
                        dtbQtyEntry.set("dtbsubstepqtymole", (Object)dtbsubstepqtymole.add(qty));
                        BigDecimal oldQty = qtyMaterEntry.getBigDecimal("substepqtymole");
                        qtyMaterEntry.set("substepqtymole", (Object)oldQty.subtract(qty));
                        BigDecimal dtbsubstepfixscrap = dtbQtyEntry.getBigDecimal("dtbsubstepfixscrap");
                        dtbQtyEntry.set("dtbsubstepfixscrap", (Object)dtbsubstepfixscrap.add(substepfixscrap));
                        BigDecimal oldfixscrap = qtyMaterEntry.getBigDecimal("substepfixscrap");
                        qtyMaterEntry.set("substepfixscrap", (Object)oldfixscrap.subtract(substepfixscrap));
                        break;
                    }
                    if (isExist) continue;
                    DynamicObject dObject = new DynamicObject(dtbQtyEntrys.getDynamicObjectType(), true);
                    dObject.set("dtbsubstepbatchstartqty", qtyMaterEntry.get("substepbatchstartqty"));
                    dObject.set("dtbsubstepbatchendqty", qtyMaterEntry.get("substepbatchendqty"));
                    dObject.set("dtbsubstepisstepfix", qtyMaterEntry.get("substepisstepfix"));
                    dObject.set("dtbsubstepqtymole", (Object)qty);
                    qtyMaterEntry.set("substepqtymole", (Object)BigDecimal.ZERO);
                    dObject.set("dtbsubstepqtydeno", qtyMaterEntry.get("substepqtydeno"));
                    dObject.set("dtbsubstepmole", qtyMaterEntry.get("substepmole"));
                    dObject.set("dtbsubstepdeno", qtyMaterEntry.get("substepdeno"));
                    dObject.set("dtbsubstepfixscrap", (Object)substepfixscrap);
                    qtyMaterEntry.set("substepfixscrap", (Object)BigDecimal.ZERO);
                    dObject.set("dtbsubstepscraprate", qtyMaterEntry.get("substepscraprate"));
                    dObject.set("dtbsubstepqtyentryid", qtyMaterEntry.get("id"));
                    dtbQtyEntrys.add((Object)dObject);
                    isDeal = true;
                    break;
                }
            }
            if (!isDeal) {
                qtyEntryObjLs.add(qtyMaterEntry);
            }
            ++success;
        }
        this.setStepEntryValue(processWork, materEntry, qtyEntryObjLs, null, null);
        this.getView().updateView(DTBMATERENTRY);
        this.getView().updateView(DTBQTYENTRY);
        this.getView().updateView(QTYENTRY);
        if (error.length() > 0) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff1a%1$s\u6761;\u5931\u8d25\uff1a%2$s\u6761\u3002", (String)"PDMProMaterDTBPlugin_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), success, qtyIndexs.length - success), error.toString(), MessageTypes.Default);
        } else if (success != 0) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff1a%s\u6761\u3002", (String)"PDMProMaterDTBPlugin_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), success));
        }
    }

    private void bdeldistribut() {
        StringBuilder error = ProMaterDTBUtil.checkDTBRemoveRight((IDataModel)this.getModel(), (IFormView)this.getView(), (String)DTBQTYENTRY, (String)ResManager.loadKDString((String)"\u9636\u68af\u7528\u91cf\u5206\u914d\u6e05\u5355", (String)"PDMProMaterDTBPlugin_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), (Boolean)Boolean.FALSE);
        if (error.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u63d0\u793a\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PDMProMaterDTBPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(DTBQTYENTRY);
        int[] indexs = entryGrid.getSelectRows();
        int j = indexs[0];
        DynamicObject dtbQtyEntry = this.getModel().getEntryRowEntity(DTBQTYENTRY, j);
        DynamicObject parent = (DynamicObject)dtbQtyEntry.getParent();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("formId", PDM_DELDTBQTY);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(param);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("qty", dtbQtyEntry.get("dtbsubstepqtymole"));
        parameter.setCustomParam("unit", (Object)parent.getString("dtballocatunit.id"));
        parameter.setCustomParam("usagetype", (Object)"D");
        parameter.setCustomParam("fixscrap", dtbQtyEntry.get("dtbsubstepfixscrap"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "removeStepQty"));
        this.getView().showForm(parameter);
    }

    private void balldeldistribut() {
        StringBuilder error = ProMaterDTBUtil.checkDTBRemoveRight((IDataModel)this.getModel(), (IFormView)this.getView(), (String)DTBQTYENTRY, (String)ResManager.loadKDString((String)"\u9636\u68af\u7528\u91cf\u5206\u914d\u6e05\u5355", (String)"PDMProMaterDTBPlugin_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), (Boolean)Boolean.TRUE);
        if (error.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u63d0\u793a\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PDMProMaterDTBPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(DTBQTYENTRY);
        int[] indexs = entryGrid.getSelectRows();
        DynamicObject parent = null;
        int success = 0;
        for (int j : indexs) {
            DynamicObject dtbQtyEntry = this.getModel().getEntryRowEntity(DTBQTYENTRY, j);
            parent = (DynamicObject)dtbQtyEntry.getParent();
            BigDecimal qty = dtbQtyEntry.getBigDecimal("dtbsubstepqtymole");
            BigDecimal dtbsubstepfixscrap = dtbQtyEntry.getBigDecimal("dtbsubstepfixscrap");
            long dtbsubstepqtyentryid = dtbQtyEntry.getLong("dtbsubstepqtyentryid");
            DynamicObjectCollection notEntryColl = this.getModel().getEntryEntity(NOTALLOCATENTRY);
            for (DynamicObject notEntryObj : notEntryColl) {
                DynamicObjectCollection qtyEntryColl = notEntryObj.getDynamicObjectCollection(QTYENTRY);
                for (DynamicObject qtyEntry : qtyEntryColl) {
                    long id = qtyEntry.getLong("id");
                    if (dtbsubstepqtyentryid == 0L || dtbsubstepqtyentryid != id) continue;
                    BigDecimal substepqtymole = qtyEntry.getBigDecimal("substepqtymole");
                    qtyEntry.set("substepqtymole", (Object)substepqtymole.add(qty));
                    BigDecimal substepfixscrap = qtyEntry.getBigDecimal("substepfixscrap");
                    qtyEntry.set("substepfixscrap", (Object)substepfixscrap.add(dtbsubstepfixscrap));
                }
            }
            ++success;
        }
        this.getModel().deleteEntryRows(DTBQTYENTRY, indexs);
        this.dealParentEntry(parent);
        this.getView().updateView(DTBQTYENTRY);
        this.getView().updateView(QTYENTRY);
        if (error.length() > 0) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff1a%1$s\u6761;\u5931\u8d25\uff1a%2$s\u6761\u3002", (String)"PDMProMaterDTBPlugin_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), success, indexs.length - success), error.toString(), MessageTypes.Default);
        } else if (success != 0) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff1a%s\u6761\u3002", (String)"PDMProMaterDTBPlugin_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), success));
        }
    }

    private void adistribut() {
        StringBuilder error = ProMaterDTBUtil.checkDTBAddRigth((IDataModel)this.getModel(), (IFormView)this.getView(), (String)NOTALLOCATENTRY, (String)ResManager.loadKDString((String)"\u5f85\u5206\u914d\u7269\u6599", (String)"PDMProMaterDTBPlugin_11", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), (Boolean)Boolean.FALSE);
        if (error.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u63d0\u793a\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PDMProMaterDTBPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(NOTALLOCATENTRY);
        int[] indexs = entryGrid.getSelectRows();
        int j = indexs[0];
        DynamicObject materEntry = this.getModel().getEntryRowEntity(NOTALLOCATENTRY, j);
        boolean isOk = this.checkQtys(error, materEntry);
        if (!isOk) {
            this.getView().showMessage(error.toString());
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("formId", PDM_DTBQTY);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(param);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("qty", materEntry.get("nallocatqty"));
        parameter.setCustomParam("unit", (Object)materEntry.getString("nallocatunit.id"));
        parameter.setCustomParam("usagetype", (Object)materEntry.getString("nallocatusagetype"));
        parameter.setCustomParam("fixscrap", materEntry.get("nallocatfixscrap"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addQty"));
        this.getView().showForm(parameter);
    }

    private void adistributCloseCallBack(Map<String, Object> map) {
        DynamicObject matchEntry;
        Boolean allqty = (Boolean)map.get("allqty");
        BigDecimal dtbqtys = (BigDecimal)map.get("dtbqty");
        Boolean step = (Boolean)map.get("step");
        BigDecimal fixScrap = (BigDecimal)map.get("fixscrap");
        int i = this.getModel().getEntryCurrentRowIndex(WORKPROENTRY);
        int j = this.getModel().getEntryCurrentRowIndex(NOTALLOCATENTRY);
        DynamicObject processWork = this.getModel().getEntryRowEntity(WORKPROENTRY, i);
        DynamicObject materEntry = this.getModel().getEntryRowEntity(NOTALLOCATENTRY, j);
        DynamicObjectCollection dtbmater = this.getModel().getEntryEntity(DTBMATERENTRY);
        BigDecimal qty = materEntry.getBigDecimal("nallocatqty");
        BigDecimal nallocatfixscrap = materEntry.getBigDecimal("nallocatfixscrap");
        if (dtbmater != null && dtbmater.size() > 0 && (matchEntry = this.getMatchEntry(dtbmater, materEntry, processWork)) != null) {
            BigDecimal q = matchEntry.getBigDecimal("dtballocatqty");
            matchEntry.set("dtballocatqty", (Object)q.add(dtbqtys));
            this.getModel().setValue("nallocatqty", (Object)qty.subtract(dtbqtys), j);
            if (step.booleanValue()) {
                DynamicObjectCollection dtbQtyEntrys = matchEntry.getDynamicObjectCollection(DTBQTYENTRY);
                DynamicObjectCollection qtyEntrys = materEntry.getDynamicObjectCollection(QTYENTRY);
                ArrayList<DynamicObject> addDtbQtyEntryLs = new ArrayList<DynamicObject>(4);
                if (qtyEntrys != null) {
                    for (DynamicObject qtyEntry : qtyEntrys) {
                        if (BigDecimal.ZERO.compareTo(qtyEntry.getBigDecimal("substepqtymole")) == 0) continue;
                        long qtyEntryId = qtyEntry.getLong("id");
                        if (dtbQtyEntrys.size() == 0) {
                            DynamicObject dObject = new DynamicObject(dtbQtyEntrys.getDynamicObjectType(), true);
                            dObject.set("dtbsubstepbatchstartqty", qtyEntry.get("substepbatchstartqty"));
                            dObject.set("dtbsubstepbatchendqty", qtyEntry.get("substepbatchendqty"));
                            dObject.set("dtbsubstepisstepfix", qtyEntry.get("substepisstepfix"));
                            dObject.set("dtbsubstepqtymole", qtyEntry.get("substepqtymole"));
                            dObject.set("dtbsubstepqtydeno", qtyEntry.get("substepqtydeno"));
                            dObject.set("dtbsubstepmole", qtyEntry.get("substepmole"));
                            dObject.set("dtbsubstepdeno", qtyEntry.get("substepdeno"));
                            dObject.set("dtbsubstepfixscrap", qtyEntry.get("substepfixscrap"));
                            dObject.set("dtbsubstepscraprate", qtyEntry.get("substepscraprate"));
                            dObject.set("dtbsubstepqtyentryid", qtyEntry.get("id"));
                            qtyEntry.set("substepqtymole", (Object)BigDecimal.ZERO);
                            qtyEntry.set("substepfixscrap", (Object)BigDecimal.ZERO);
                            addDtbQtyEntryLs.add(dObject);
                            continue;
                        }
                        boolean isFind = false;
                        for (DynamicObject dtbQtyEntry : dtbQtyEntrys) {
                            long dtbsubstepqtyentryid = dtbQtyEntry.getLong("dtbsubstepqtyentryid");
                            if (dtbsubstepqtyentryid == 0L || dtbsubstepqtyentryid != qtyEntryId) continue;
                            BigDecimal substepqtymole = qtyEntry.getBigDecimal("substepqtymole");
                            BigDecimal dtbsubstepqtymole = dtbQtyEntry.getBigDecimal("dtbsubstepqtymole");
                            dtbQtyEntry.set("dtbsubstepqtymole", (Object)dtbsubstepqtymole.add(substepqtymole));
                            qtyEntry.set("substepqtymole", (Object)BigDecimal.ZERO);
                            BigDecimal substepfixscrap = qtyEntry.getBigDecimal("substepfixscrap");
                            BigDecimal dtbsubstepfixscrap = dtbQtyEntry.getBigDecimal("dtbsubstepfixscrap");
                            dtbQtyEntry.set("dtbsubstepfixscrap", (Object)dtbsubstepfixscrap.add(substepfixscrap));
                            qtyEntry.set("substepfixscrap", (Object)BigDecimal.ZERO);
                            isFind = true;
                            break;
                        }
                        if (isFind) continue;
                        DynamicObject dObject = new DynamicObject(dtbQtyEntrys.getDynamicObjectType(), true);
                        dObject.set("dtbsubstepbatchstartqty", qtyEntry.get("substepbatchstartqty"));
                        dObject.set("dtbsubstepbatchendqty", qtyEntry.get("substepbatchendqty"));
                        dObject.set("dtbsubstepisstepfix", qtyEntry.get("substepisstepfix"));
                        dObject.set("dtbsubstepqtymole", qtyEntry.get("substepqtymole"));
                        dObject.set("dtbsubstepqtydeno", qtyEntry.get("substepqtydeno"));
                        dObject.set("dtbsubstepmole", qtyEntry.get("substepmole"));
                        dObject.set("dtbsubstepdeno", qtyEntry.get("substepdeno"));
                        dObject.set("dtbsubstepfixscrap", qtyEntry.get("substepfixscrap"));
                        dObject.set("dtbsubstepscraprate", qtyEntry.get("substepscraprate"));
                        dObject.set("dtbsubstepqtyentryid", qtyEntry.get("id"));
                        qtyEntry.set("substepqtymole", (Object)BigDecimal.ZERO);
                        qtyEntry.set("substepfixscrap", (Object)BigDecimal.ZERO);
                        addDtbQtyEntryLs.add(dObject);
                    }
                    dtbQtyEntrys.addAll(addDtbQtyEntryLs);
                }
            }
            BigDecimal dtballocatfixscrap = matchEntry.getBigDecimal("dtballocatfixscrap");
            matchEntry.set("dtballocatfixscrap", (Object)dtballocatfixscrap.add(fixScrap));
            this.getModel().setValue("nallocatfixscrap", (Object)nallocatfixscrap.subtract(fixScrap), j);
            this.getView().updateView(DTBMATERENTRY);
            this.getView().updateView(NOTALLOCATENTRY);
            this.getView().updateView(QTYENTRY);
            this.getView().updateView(DTBQTYENTRY);
            return;
        }
        if (BigDecimal.ZERO.compareTo(dtbqtys) >= 0 && !step.booleanValue()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5206\u914d\u6570\u91cf\u4e0d\u80fd\u4e3a0\u3002", (String)"PDMProMaterDTBPlugin_12", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (BigDecimal.ZERO.compareTo(dtbqtys) >= 0) {
            fixScrap = BigDecimal.ZERO;
        }
        if (!allqty.booleanValue()) {
            materEntry.set("nallocatqty", (Object)dtbqtys);
            materEntry.set("nallocatfixscrap", (Object)fixScrap);
        }
        ArrayList<DynamicObject> listMater = new ArrayList<DynamicObject>();
        listMater.add(materEntry);
        this.setDTBAllocatEntryValue(processWork, listMater, step);
        if (allqty.booleanValue()) {
            this.getModel().setValue("nallocatqty", (Object)0, j);
        } else {
            this.getModel().setValue("nallocatqty", (Object)qty.subtract(dtbqtys), j);
        }
        this.getModel().setValue("nallocatfixscrap", (Object)nallocatfixscrap.subtract(fixScrap), j);
        this.getView().showMessage(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff0c\u51711\u6761\u3002", (String)"PDMProMaterDTBPlugin_13", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
    }

    private void alldistribut() {
        int isOk;
        int i;
        StringBuilder error = ProMaterDTBUtil.checkDTBAddRigth((IDataModel)this.getModel(), (IFormView)this.getView(), (String)NOTALLOCATENTRY, (String)ResManager.loadKDString((String)"\u5f85\u5206\u914d\u7269\u6599", (String)"PDMProMaterDTBPlugin_11", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), (Boolean)Boolean.TRUE);
        if (error.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u63d0\u793a\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PDMProMaterDTBPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
            return;
        }
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(NOTALLOCATENTRY);
        ArrayList treeNodes = new ArrayList(16);
        int[] indexs = entryGrid.getSelectRows();
        String rString = this.getPageCache().get(ROOT);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)rString, TreeNode.class);
        for (int i2 = 0; i2 < indexs.length; ++i2) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(NOTALLOCATENTRY, indexs[i2]);
            String longId = entryRowEntity.getString("nallocatlongid");
            TreeNode treeNode = root.getTreeNode(longId, 50);
            if (treeNode == null) continue;
            treeNode.iterate(50, treeNodes::add);
        }
        ArrayList idLs = new ArrayList(16);
        ArrayList tcIdLs = new ArrayList(16);
        treeNodes.stream().filter(node -> "blue".equals(node.getColor())).forEach(node -> tcIdLs.add(node.getId()));
        treeNodes.stream().filter(node -> !"blue".equals(node.getColor())).forEach(node -> idLs.add(node.getId()));
        ArrayList<Integer> seqLs = new ArrayList<Integer>(16);
        ArrayList<Integer> tcSeqLs = new ArrayList<Integer>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(NOTALLOCATENTRY);
        for (i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            String id = entry.getString("nallocatlongid");
            if (idLs.contains(id)) {
                seqLs.add(entry.getInt("seq") - 1);
            }
            if (!tcIdLs.contains(id)) continue;
            tcSeqLs.add(entry.getInt("seq") - 1);
        }
        indexs = ArrayUtils.toPrimitive((Integer[])seqLs.toArray(new Integer[seqLs.size()]));
        i = this.getModel().getEntryCurrentRowIndex(WORKPROENTRY);
        ArrayList<DynamicObject> listMater = new ArrayList<DynamicObject>();
        DynamicObject processWork = this.getModel().getEntryRowEntity(WORKPROENTRY, i);
        int success = 0;
        for (int k = 0; k < indexs.length; ++k) {
            DynamicObject materEntry = this.getModel().getEntryRowEntity(NOTALLOCATENTRY, indexs[k]);
            isOk = this.checkQtys(error, materEntry);
            boolean qtyEntryIsFP = false;
            DynamicObjectCollection qtyentry = materEntry.getDynamicObjectCollection(QTYENTRY);
            if (!qtyentry.isEmpty()) {
                for (DynamicObject entry : qtyentry) {
                    BigDecimal substepqtymole = entry.getBigDecimal("substepqtymole");
                    BigDecimal substepfixscrap = entry.getBigDecimal("substepfixscrap");
                    if (BigDecimal.ZERO.compareTo(substepqtymole) != 0 || BigDecimal.ZERO.compareTo(substepfixscrap) != 0) continue;
                    qtyEntryIsFP = true;
                }
            } else {
                qtyEntryIsFP = true;
            }
            if (isOk == 0 && qtyEntryIsFP) continue;
            error.setLength(0);
            DynamicObjectCollection dCol = this.getModel().getEntryEntity(DTBMATERENTRY);
            DynamicObject matchEntry = this.getMatchEntry(dCol, materEntry, processWork);
            if (matchEntry != null) {
                BigDecimal q = matchEntry.getBigDecimal("dtballocatqty");
                BigDecimal p = materEntry.getBigDecimal("nallocatqty");
                matchEntry.set("dtballocatqty", (Object)q.add(p));
                BigDecimal dtballocatfixscrap = matchEntry.getBigDecimal("dtballocatfixscrap");
                BigDecimal nallocatfixscrap = materEntry.getBigDecimal("nallocatfixscrap");
                matchEntry.set("dtballocatfixscrap", (Object)dtballocatfixscrap.add(nallocatfixscrap));
                DynamicObjectCollection dtbQtyEntrys = matchEntry.getDynamicObjectCollection(DTBQTYENTRY);
                DynamicObjectCollection qtyEntrys = materEntry.getDynamicObjectCollection(QTYENTRY);
                ArrayList<DynamicObject> addDtbQtyEntryLs = new ArrayList<DynamicObject>(4);
                if (qtyEntrys != null) {
                    for (DynamicObject qtyEntry : qtyEntrys) {
                        if (BigDecimal.ZERO.compareTo(qtyEntry.getBigDecimal("substepqtymole")) == 0) continue;
                        long qtyEntryId = qtyEntry.getLong("id");
                        if (dtbQtyEntrys.size() == 0) {
                            DynamicObject dObject = new DynamicObject(dtbQtyEntrys.getDynamicObjectType(), true);
                            dObject.set("dtbsubstepbatchstartqty", qtyEntry.get("substepbatchstartqty"));
                            dObject.set("dtbsubstepbatchendqty", qtyEntry.get("substepbatchendqty"));
                            dObject.set("dtbsubstepisstepfix", qtyEntry.get("substepisstepfix"));
                            dObject.set("dtbsubstepqtymole", qtyEntry.get("substepqtymole"));
                            dObject.set("dtbsubstepqtydeno", qtyEntry.get("substepqtydeno"));
                            dObject.set("dtbsubstepmole", qtyEntry.get("substepmole"));
                            dObject.set("dtbsubstepdeno", qtyEntry.get("substepdeno"));
                            dObject.set("dtbsubstepfixscrap", qtyEntry.get("substepfixscrap"));
                            dObject.set("dtbsubstepscraprate", qtyEntry.get("substepscraprate"));
                            dObject.set("dtbsubstepqtyentryid", qtyEntry.get("id"));
                            qtyEntry.set("substepqtymole", (Object)BigDecimal.ZERO);
                            qtyEntry.set("substepfixscrap", (Object)BigDecimal.ZERO);
                            addDtbQtyEntryLs.add(dObject);
                            continue;
                        }
                        boolean isFind = false;
                        for (DynamicObject dtbQtyEntry : dtbQtyEntrys) {
                            long dtbsubstepqtyentryid = dtbQtyEntry.getLong("dtbsubstepqtyentryid");
                            if (dtbsubstepqtyentryid == 0L || dtbsubstepqtyentryid != qtyEntryId) continue;
                            BigDecimal substepqtymole = qtyEntry.getBigDecimal("substepqtymole");
                            BigDecimal dtbsubstepqtymole = dtbQtyEntry.getBigDecimal("dtbsubstepqtymole");
                            dtbQtyEntry.set("dtbsubstepqtymole", (Object)dtbsubstepqtymole.add(substepqtymole));
                            qtyEntry.set("substepqtymole", (Object)BigDecimal.ZERO);
                            BigDecimal substepfixscrap = qtyEntry.getBigDecimal("substepfixscrap");
                            BigDecimal dtbsubstepfixscrap = dtbQtyEntry.getBigDecimal("dtbsubstepfixscrap");
                            dtbQtyEntry.set("dtbsubstepfixscrap", (Object)dtbsubstepfixscrap.add(substepfixscrap));
                            qtyEntry.set("substepfixscrap", (Object)BigDecimal.ZERO);
                            isFind = true;
                            break;
                        }
                        if (isFind) continue;
                        DynamicObject dObject = new DynamicObject(dtbQtyEntrys.getDynamicObjectType(), true);
                        dObject.set("dtbsubstepbatchstartqty", qtyEntry.get("substepbatchstartqty"));
                        dObject.set("dtbsubstepbatchendqty", qtyEntry.get("substepbatchendqty"));
                        dObject.set("dtbsubstepisstepfix", qtyEntry.get("substepisstepfix"));
                        dObject.set("dtbsubstepqtymole", qtyEntry.get("substepqtymole"));
                        dObject.set("dtbsubstepqtydeno", qtyEntry.get("substepqtydeno"));
                        dObject.set("dtbsubstepmole", qtyEntry.get("substepmole"));
                        dObject.set("dtbsubstepdeno", qtyEntry.get("substepdeno"));
                        dObject.set("dtbsubstepfixscrap", qtyEntry.get("substepfixscrap"));
                        dObject.set("dtbsubstepscraprate", qtyEntry.get("substepscraprate"));
                        dObject.set("dtbsubstepqtyentryid", qtyEntry.get("id"));
                        qtyEntry.set("substepqtymole", (Object)BigDecimal.ZERO);
                        qtyEntry.set("substepfixscrap", (Object)BigDecimal.ZERO);
                        addDtbQtyEntryLs.add(dObject);
                    }
                    dtbQtyEntrys.addAll(addDtbQtyEntryLs);
                }
            } else {
                listMater.add(materEntry);
            }
            ++success;
        }
        this.setDTBAllocatEntryValue(processWork, listMater, Boolean.TRUE);
        Object object = indexs;
        int materEntry = ((int[])object).length;
        for (isOk = 0; isOk < materEntry; ++isOk) {
            Integer integer = object[isOk];
            this.getModel().setValue("nallocatqty", (Object)0, integer.intValue());
            this.getModel().setValue("nallocatfixscrap", (Object)0, integer.intValue());
        }
        object = tcSeqLs.iterator();
        block7: while (object.hasNext()) {
            Integer integer = (Integer)object.next();
            Object longIdObj = this.getModel().getValue("nallocatlongid", integer.intValue());
            String _longId = longIdObj == null ? "" : longIdObj.toString();
            for (String longId : idLs) {
                if (!longId.contains(_longId)) continue;
                this.getModel().setValue("nallocatqty", (Object)0, integer.intValue());
                this.getModel().setValue("nallocatfixscrap", (Object)0, integer.intValue());
                continue block7;
            }
        }
        this.getView().updateView(DTBMATERENTRY);
        this.getView().updateView(NOTALLOCATENTRY);
        if (error.length() > 0) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff1a%1$s\u6761;\u5931\u8d25\uff1a%2$s\u6761\u3002", (String)"PDMProMaterDTBPlugin_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), success, indexs.length - success), error.toString(), MessageTypes.Default);
        } else if (success != 0) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff1a%s\u6761\u3002", (String)"PDMProMaterDTBPlugin_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), success));
        }
    }

    private DynamicObject getMatchEntry(DynamicObjectCollection dCol, DynamicObject materEntry, DynamicObject processWork) {
        for (DynamicObject dynamicObject : dCol) {
            if (!StringUtils.equals((CharSequence)dynamicObject.getString("dtballocatlongid"), (CharSequence)materEntry.getString("nallocatlongid")) || !StringUtils.equals((CharSequence)dynamicObject.getString("dtballocatoprentryid"), (CharSequence)processWork.getString("oprentryid"))) continue;
            return dynamicObject;
        }
        return null;
    }

    private boolean checkQtys(StringBuilder error, DynamicObject materEntry) {
        boolean qtyIsOk = true;
        BigDecimal zero = new BigDecimal("0");
        if (zero.compareTo(materEntry.getBigDecimal("nallocatqty")) == 0) {
            qtyIsOk = false;
        }
        boolean fixScrapIsOk = true;
        if (zero.compareTo(materEntry.getBigDecimal("nallocatfixscrap")) == 0) {
            fixScrapIsOk = false;
        }
        if (!qtyIsOk && !fixScrapIsOk) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u53ef\u5206\u914d\u6570\u91cf/\u56fa\u5b9a\u635f\u8017\u4e3a\u96f6\u3002", (String)"PDMProMaterDTBPlugin_30", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), materEntry.get("nallocatmater.masterid.number"));
            error.append(msg).append("\r\n");
            return false;
        }
        return true;
    }

    private void adeldistribut() {
        Long pid;
        StringBuilder error = ProMaterDTBUtil.checkDTBRemoveRight((IDataModel)this.getModel(), (IFormView)this.getView(), (String)DTBMATERENTRY, (String)ResManager.loadKDString((String)"\u5df2\u5206\u914d\u7269\u6599", (String)"PDMProMaterDTBPlugin_15", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), (Boolean)Boolean.FALSE);
        if (error.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u63d0\u793a\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PDMProMaterDTBPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(DTBMATERENTRY);
        int[] indexs = entryGrid.getSelectRows();
        int j = indexs[0];
        DynamicObject materEntry = this.getModel().getEntryRowEntity(DTBMATERENTRY, j);
        String mode = (String)this.getModel().getValue(DISTRIBUT);
        if (DistributModeEnum.ORDER.getCode().equals(mode) && (pid = Long.valueOf(materEntry.getLong("dtballocatrow"))) != null && pid != 0L) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8be5\u7269\u6599\u5c5e\u4e8e\u8df3\u5c42\u4ef6\u7684\u5b50\u4ef6\uff0c\u8bf7\u4f7f\u7528\u5168\u79fb\u3002", (String)"PDMProMaterDTBPlugin_31", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), materEntry.get("dtballocatmater.masterid.number"));
            this.getView().showMessage(msg);
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("formId", PDM_DELDTBQTY);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(param);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("qty", materEntry.get("dtballocatqty"));
        parameter.setCustomParam("unit", (Object)materEntry.getString("dtballocatunit.id"));
        parameter.setCustomParam("usagetype", (Object)materEntry.getString("dtballocatusagetype"));
        parameter.setCustomParam("fixscrap", materEntry.get("dtballocatfixscrap"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "removeQty"));
        this.getView().showForm(parameter);
    }

    private void adeldistributCloseCallBack(Map<String, Object> map) {
        Boolean allqty = (Boolean)map.get("allqty");
        BigDecimal dtbqtys = (BigDecimal)map.get("dtbqty");
        Boolean step = (Boolean)map.get("step");
        BigDecimal fixScrap = (BigDecimal)map.get("fixscrap");
        EntryGrid entryGrid = (EntryGrid)this.getControl(DTBMATERENTRY);
        int[] indexs = entryGrid.getSelectRows();
        int j = indexs[0];
        DynamicObject materEntry = this.getModel().getEntryRowEntity(DTBMATERENTRY, j);
        DynamicObjectCollection notAllocatEntry = this.getModel().getEntryEntity(NOTALLOCATENTRY);
        BigDecimal qty = materEntry.getBigDecimal("dtballocatqty");
        if (notAllocatEntry != null && notAllocatEntry.size() > 0) {
            for (int i = 0; i < notAllocatEntry.size(); ++i) {
                boolean isZero;
                DynamicObject notallocatDyObj = (DynamicObject)notAllocatEntry.get(i);
                if (!StringUtils.equals((CharSequence)notallocatDyObj.getString("nallocatlongid"), (CharSequence)materEntry.getString("dtballocatlongid"))) continue;
                BigDecimal q = notallocatDyObj.getBigDecimal("nallocatqty");
                BigDecimal newQty = q.add(dtbqtys);
                if (BigDecimal.ZERO.compareTo(newQty) >= 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u56fa\u5b9a\u635f\u8017\u4e0d\u5141\u8bb8\u5355\u72ec\u79fb\u51fa\u3002", (String)"PDMProMaterDTBPlugin_17", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (step.booleanValue()) {
                    DynamicObjectCollection dtbqtyentry = materEntry.getDynamicObjectCollection(DTBQTYENTRY);
                    DynamicObjectCollection qtyEntry = notallocatDyObj.getDynamicObjectCollection(QTYENTRY);
                    if (dtbqtyentry != null && qtyEntry != null) {
                        long qtyEntryId;
                        HashMap<Long, BigDecimal> id_QtyMap = new HashMap<Long, BigDecimal>(dtbqtyentry.size());
                        HashMap<Long, BigDecimal> id_fixscrapMap = new HashMap<Long, BigDecimal>(dtbqtyentry.size());
                        for (DynamicObject dtbqtyObj : dtbqtyentry) {
                            qtyEntryId = dtbqtyObj.getLong("dtbsubstepqtyentryid");
                            BigDecimal dtbSubStepQtyMole = dtbqtyObj.getBigDecimal("dtbsubstepqtymole");
                            id_QtyMap.put(qtyEntryId, dtbSubStepQtyMole);
                            BigDecimal dtbSubStepfixscrap = dtbqtyObj.getBigDecimal("dtbsubstepfixscrap");
                            id_fixscrapMap.put(qtyEntryId, dtbSubStepfixscrap);
                        }
                        for (DynamicObject qtyEntryObj : qtyEntry) {
                            BigDecimal fixscrap;
                            qtyEntryId = qtyEntryObj.getLong("id");
                            BigDecimal qtyMole = (BigDecimal)id_QtyMap.get(qtyEntryId);
                            if (qtyMole != null) {
                                BigDecimal substepqtymole = qtyEntryObj.getBigDecimal("substepqtymole");
                                BigDecimal add = substepqtymole.add(qtyMole);
                                qtyEntryObj.set("substepqtymole", (Object)add);
                            }
                            if ((fixscrap = (BigDecimal)id_fixscrapMap.get(qtyEntryId)) == null) continue;
                            BigDecimal substepfixscrap = qtyEntryObj.getBigDecimal("substepfixscrap");
                            BigDecimal add = substepfixscrap.add(fixscrap);
                            qtyEntryObj.set("substepfixscrap", (Object)add);
                        }
                        dtbqtyentry.clear();
                    }
                }
                BigDecimal nallocatfixscrap = notallocatDyObj.getBigDecimal("nallocatfixscrap");
                notallocatDyObj.set("nallocatfixscrap", (Object)nallocatfixscrap.add(fixScrap));
                BigDecimal dtballocatfixscrap = materEntry.getBigDecimal("dtballocatfixscrap");
                BigDecimal dtbFixScrap = dtballocatfixscrap.subtract(fixScrap);
                this.getModel().setValue("dtballocatfixscrap", (Object)dtbFixScrap, j);
                notallocatDyObj.set("nallocatqty", (Object)newQty);
                this.getModel().setValue("dtballocatqty", (Object)qty.subtract(dtbqtys), j);
                BigDecimal zero = new BigDecimal("0");
                boolean bl = isZero = zero.compareTo(qty.subtract(dtbqtys)) >= 0;
                if (step.booleanValue() && isZero) {
                    this.getModel().deleteEntryRow(DTBMATERENTRY, j);
                    break;
                }
                String dtballocatusagetype = materEntry.getString("dtballocatusagetype");
                if (isZero && !"C".equals(dtballocatusagetype)) {
                    this.getModel().deleteEntryRow(DTBMATERENTRY, j);
                    break;
                }
                this.dealParentEntry(materEntry);
                break;
            }
            this.getView().updateView(NOTALLOCATENTRY);
            this.getView().updateView(DTBMATERENTRY);
            this.getView().updateView(DTBQTYENTRY);
            this.getView().updateView(QTYENTRY);
            this.getView().showMessage(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff0c\u51711\u6761\u3002", (String)"PDMProMaterDTBPlugin_13", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void removeStepQtyCloseCallBack(Map<String, Object> map) {
        BigDecimal dtbqtys = (BigDecimal)map.get("dtbqty");
        BigDecimal fixScrap = (BigDecimal)map.get("fixscrap");
        EntryGrid entryGrid = (EntryGrid)this.getControl(DTBQTYENTRY);
        int[] indexs = entryGrid.getSelectRows();
        int j = indexs[0];
        DynamicObject dtbQtyEntry = this.getModel().getEntryRowEntity(DTBQTYENTRY, j);
        BigDecimal qty = dtbQtyEntry.getBigDecimal("dtbsubstepqtymole");
        BigDecimal dtbsubstepfixscrap = dtbQtyEntry.getBigDecimal("dtbsubstepfixscrap");
        long dtbsubstepqtyentryid = dtbQtyEntry.getLong("dtbsubstepqtyentryid");
        DynamicObjectCollection notEntryColl = this.getModel().getEntryEntity(NOTALLOCATENTRY);
        DynamicObject parent = (DynamicObject)dtbQtyEntry.getParent();
        block0: for (DynamicObject notEntryObj : notEntryColl) {
            DynamicObjectCollection qtyEntryColl = notEntryObj.getDynamicObjectCollection(QTYENTRY);
            for (DynamicObject qtyEntry : qtyEntryColl) {
                long id = qtyEntry.getLong("id");
                if (dtbsubstepqtyentryid == 0L || dtbsubstepqtyentryid != id) continue;
                BigDecimal substepqtymole = qtyEntry.getBigDecimal("substepqtymole");
                BigDecimal newQty = substepqtymole.add(dtbqtys);
                if (BigDecimal.ZERO.compareTo(newQty) >= 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u56fa\u5b9a\u635f\u8017\u4e0d\u5141\u8bb8\u5355\u72ec\u79fb\u51fa\u3002", (String)"PDMProMaterDTBPlugin_17", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                BigDecimal substepfixscrap = qtyEntry.getBigDecimal("substepfixscrap");
                BigDecimal newFixScrap = substepfixscrap.add(fixScrap);
                qtyEntry.set("substepfixscrap", (Object)newFixScrap);
                this.getModel().setValue("dtbsubstepfixscrap", (Object)dtbsubstepfixscrap.subtract(fixScrap), j);
                qtyEntry.set("substepqtymole", (Object)newQty);
                BigDecimal subtract = qty.subtract(dtbqtys);
                if (BigDecimal.ZERO.compareTo(subtract) >= 0) {
                    this.getModel().deleteEntryRow(DTBQTYENTRY, j);
                    continue block0;
                }
                this.getModel().setValue("dtbsubstepqtymole", (Object)subtract, j);
                continue block0;
            }
        }
        this.dealParentEntry(parent);
        this.getView().updateView(DTBQTYENTRY);
        this.getView().updateView(QTYENTRY);
        this.getView().showMessage(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff0c\u51711\u6761\u3002", (String)"PDMProMaterDTBPlugin_13", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
    }

    private void dealParentEntry(DynamicObject parent) {
        if (parent != null) {
            DynamicObjectCollection childer = parent.getDynamicObjectCollection(DTBQTYENTRY);
            BigDecimal dtballocatqty = parent.getBigDecimal("dtballocatqty");
            BigDecimal dtballocatfixscrap = parent.getBigDecimal("dtballocatfixscrap");
            if (BigDecimal.ZERO.compareTo(dtballocatqty) >= 0 && BigDecimal.ZERO.compareTo(dtballocatfixscrap) >= 0 && childer.size() == 0) {
                this.getModel().deleteEntryRow(DTBMATERENTRY, parent.getInt("seq") - 1);
            }
        }
    }

    private void alldeldistribut() {
        StringBuilder error = ProMaterDTBUtil.checkDTBRemoveRight((IDataModel)this.getModel(), (IFormView)this.getView(), (String)DTBMATERENTRY, (String)ResManager.loadKDString((String)"\u5df2\u5206\u914d\u7269\u6599", (String)"PDMProMaterDTBPlugin_15", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), (Boolean)Boolean.TRUE);
        if (error.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u63d0\u793a\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PDMProMaterDTBPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(DTBMATERENTRY);
        int[] indexs = entryGrid.getSelectRows();
        String mode = (String)this.getModel().getValue(DISTRIBUT);
        if (DistributModeEnum.ORDER.getCode().equals(mode)) {
            HashSet<Object> pidSet = new HashSet<Object>(16);
            for (int i = 0; i < indexs.length; ++i) {
                DynamicObject materEntry = this.getModel().getEntryRowEntity(DTBMATERENTRY, indexs[i]);
                Object dtballocatlongid = materEntry.getString("dtballocatlongid");
                if (!StringUtils.isNotEmpty((CharSequence)dtballocatlongid)) continue;
                int index_ = ((String)dtballocatlongid).indexOf(45);
                if (index_ != -1) {
                    dtballocatlongid = ((String)dtballocatlongid).substring(0, index_);
                }
                pidSet.add(dtballocatlongid);
            }
            ArrayList<Integer> seqLs = new ArrayList<Integer>(16);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DTBMATERENTRY);
            for (DynamicObject entry : entryEntity) {
                String dtballocatlongid = entry.getString("dtballocatlongid");
                int index_ = dtballocatlongid.indexOf(45);
                if (index_ == -1 || !pidSet.contains(dtballocatlongid = dtballocatlongid.substring(0, index_))) continue;
                int seq = entry.getInt("seq");
                seqLs.add(seq - 1);
            }
            Arrays.stream(indexs).forEach(seqLs::add);
            HashSet selSet = new HashSet(seqLs);
            indexs = ArrayUtils.toPrimitive((Integer[])selSet.toArray(new Integer[selSet.size()]));
            String rString = this.getPageCache().get(ROOT);
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)rString, TreeNode.class);
            ArrayList treeNodes = new ArrayList(16);
            for (String string : pidSet) {
                TreeNode treeNode = root.getTreeNode(string, 50);
                if (treeNode == null) continue;
                treeNode.iterate(50, treeNodes::add);
            }
            ArrayList tcIdLs = new ArrayList(16);
            treeNodes.stream().filter(node -> "blue".equals(node.getColor())).forEach(node -> tcIdLs.add(node.getId()));
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(NOTALLOCATENTRY);
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                Object data;
                TreeNode treeNode;
                DynamicObject entry = (DynamicObject)dynamicObjectCollection.get(i);
                String id = entry.getString("nallocatlongid");
                if (!tcIdLs.contains(id) || (treeNode = root.getTreeNode(id, 50)) == null || !((data = treeNode.getData()) instanceof Map)) continue;
                Map dataMap = (Map)data;
                entry.set("nallocatqty", dataMap.get("mole"));
                entry.set("nallocatfixscrap", dataMap.get("fixScrap"));
            }
        }
        int success = 0;
        ArrayList<Integer> list = new ArrayList<Integer>(16);
        for (int k = 0; k < indexs.length; ++k) {
            DynamicObject materEntry = this.getModel().getEntryRowEntity(DTBMATERENTRY, indexs[k]);
            DynamicObjectCollection dCol = this.getModel().getEntryEntity(NOTALLOCATENTRY);
            for (DynamicObject notallocatentry : dCol) {
                if (!StringUtils.equals((CharSequence)notallocatentry.getString("nallocatentryid"), (CharSequence)materEntry.getString("dtballocatentryid"))) continue;
                DynamicObjectCollection dtbqtyentry = materEntry.getDynamicObjectCollection(DTBQTYENTRY);
                DynamicObjectCollection dynamicObjectCollection = notallocatentry.getDynamicObjectCollection(QTYENTRY);
                if (dtbqtyentry != null && dynamicObjectCollection != null) {
                    HashMap<Long, BigDecimal> id_QtyMap = new HashMap<Long, BigDecimal>(dtbqtyentry.size());
                    HashMap<Long, BigDecimal> id_fixscrapMap = new HashMap<Long, BigDecimal>(dtbqtyentry.size());
                    for (DynamicObject dtbqtyObj : dtbqtyentry) {
                        long qtyEntryId = dtbqtyObj.getLong("dtbsubstepqtyentryid");
                        BigDecimal dtbSubStepQtyMole = dtbqtyObj.getBigDecimal("dtbsubstepqtymole");
                        id_QtyMap.put(qtyEntryId, dtbSubStepQtyMole);
                        BigDecimal dtbSubStepfixscrap = dtbqtyObj.getBigDecimal("dtbsubstepfixscrap");
                        id_fixscrapMap.put(qtyEntryId, dtbSubStepfixscrap);
                    }
                    for (DynamicObject qtyEntryObj : dynamicObjectCollection) {
                        BigDecimal fixscrap;
                        long qtyEntryId = qtyEntryObj.getLong("id");
                        BigDecimal qtyMole = (BigDecimal)id_QtyMap.get(qtyEntryId);
                        if (qtyMole != null) {
                            BigDecimal substepqtymole = qtyEntryObj.getBigDecimal("substepqtymole");
                            BigDecimal add = substepqtymole.add(qtyMole);
                            qtyEntryObj.set("substepqtymole", (Object)add);
                        }
                        if ((fixscrap = (BigDecimal)id_fixscrapMap.get(qtyEntryId)) == null) continue;
                        BigDecimal substepfixscrap = qtyEntryObj.getBigDecimal("substepfixscrap");
                        BigDecimal add = substepfixscrap.add(fixscrap);
                        qtyEntryObj.set("substepfixscrap", (Object)add);
                    }
                    dtbqtyentry.clear();
                }
                BigDecimal q = notallocatentry.getBigDecimal("nallocatqty");
                BigDecimal p = materEntry.getBigDecimal("dtballocatqty");
                notallocatentry.set("nallocatqty", (Object)q.add(p));
                BigDecimal nallocatfixscrap = notallocatentry.getBigDecimal("nallocatfixscrap");
                BigDecimal dtballocatfixscrap = materEntry.getBigDecimal("dtballocatfixscrap");
                notallocatentry.set("nallocatfixscrap", (Object)nallocatfixscrap.add(dtballocatfixscrap));
                break;
            }
            list.add(indexs[k]);
            ++success;
        }
        int[] d = list.stream().mapToInt(Integer::intValue).toArray();
        this.getModel().deleteEntryRows(DTBMATERENTRY, d);
        this.getView().updateView(DTBMATERENTRY);
        this.getView().updateView(NOTALLOCATENTRY);
        this.getView().updateView(DTBQTYENTRY);
        this.getView().updateView(QTYENTRY);
        if (error.length() > 0) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff1a%1$s\u6761;\u5931\u8d25\uff1a%2$s\u6761\u3002", (String)"PDMProMaterDTBPlugin_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), success, indexs.length - success), error.toString(), MessageTypes.Default);
        } else if (success != 0) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff1a%s\u6761\u3002", (String)"PDMProMaterDTBPlugin_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), success));
        }
    }

    private void addStepQtyCloseCallBack(Map<String, Object> map) {
        Boolean allqty = (Boolean)map.get("allqty");
        BigDecimal dtbqtys = (BigDecimal)map.get("dtbqty");
        BigDecimal fixScrap = (BigDecimal)map.get("fixscrap");
        EntryGrid entryGrid = (EntryGrid)this.getControl(NOTALLOCATENTRY);
        EntryGrid qtyEntryGrid = (EntryGrid)this.getControl(QTYENTRY);
        EntryGrid workEntryGrid = (EntryGrid)this.getControl(WORKPROENTRY);
        int[] indexs = entryGrid.getSelectRows();
        int[] qtyIndexs = qtyEntryGrid.getSelectRows();
        int[] workIndexs = workEntryGrid.getSelectRows();
        int k = qtyIndexs[0];
        DynamicObject qtyMaterEntry = this.getModel().getEntryRowEntity(QTYENTRY, k);
        if (indexs == null || indexs.length == 0) {
            DynamicObject parent = (DynamicObject)qtyMaterEntry.getParent();
            int pIndex = parent.getInt("seq") - 1;
            indexs = new int[]{pIndex};
        }
        int j = indexs[0];
        int i = workIndexs[0];
        DynamicObject processWork = this.getModel().getEntryRowEntity(WORKPROENTRY, i);
        DynamicObject materEntry = this.getModel().getEntryRowEntity(NOTALLOCATENTRY, j);
        DynamicObjectCollection dtbmater = this.getModel().getEntryEntity(DTBMATERENTRY);
        BigDecimal qty = qtyMaterEntry.getBigDecimal("substepqtymole");
        BigDecimal oldFixScrap = qtyMaterEntry.getBigDecimal("substepfixscrap");
        long qtyEntryId = qtyMaterEntry.getLong("id");
        if (dtbmater != null && dtbmater.size() > 0) {
            for (DynamicObject dtbmaterEntry : dtbmater) {
                String dtballocatlongid = dtbmaterEntry.getString("dtballocatlongid");
                String nallocatlongid = materEntry.getString("nallocatlongid");
                String dtballocatoprentryid = dtbmaterEntry.getString("dtballocatoprentryid");
                String oprentryid = processWork.getString("oprentryid");
                if (!StringUtils.equals((CharSequence)dtballocatlongid, (CharSequence)nallocatlongid) || !StringUtils.equals((CharSequence)dtballocatoprentryid, (CharSequence)oprentryid)) continue;
                DynamicObjectCollection dtbQtyEntrys = dtbmaterEntry.getDynamicObjectCollection(DTBQTYENTRY);
                if (dtbQtyEntrys != null) {
                    for (DynamicObject dtbQtyEntry : dtbQtyEntrys) {
                        long dtbsubstepqtyentryid = dtbQtyEntry.getLong("dtbsubstepqtyentryid");
                        if (qtyEntryId == 0L || qtyEntryId != dtbsubstepqtyentryid) continue;
                        BigDecimal dtbsubstepqtymole = dtbQtyEntry.getBigDecimal("dtbsubstepqtymole");
                        dtbQtyEntry.set("dtbsubstepqtymole", (Object)dtbsubstepqtymole.add(dtbqtys));
                        qtyMaterEntry.set("substepqtymole", (Object)qty.subtract(dtbqtys));
                        BigDecimal dtbsubstepfixscrap = dtbQtyEntry.getBigDecimal("dtbsubstepfixscrap");
                        dtbQtyEntry.set("dtbsubstepfixscrap", (Object)dtbsubstepfixscrap.add(fixScrap));
                        qtyMaterEntry.set("substepfixscrap", (Object)oldFixScrap.subtract(fixScrap));
                        this.getView().updateView(DTBMATERENTRY);
                        this.getView().updateView(QTYENTRY);
                        this.getView().updateView(DTBQTYENTRY);
                        return;
                    }
                    if (BigDecimal.ZERO.compareTo(dtbqtys) >= 0) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u5206\u914d\u6570\u91cf\u4e0d\u80fd\u4e3a0\u3002", (String)"PDMProMaterDTBPlugin_12", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject dObject = new DynamicObject(dtbQtyEntrys.getDynamicObjectType(), true);
                    dObject.set("dtbsubstepbatchstartqty", qtyMaterEntry.get("substepbatchstartqty"));
                    dObject.set("dtbsubstepbatchendqty", qtyMaterEntry.get("substepbatchendqty"));
                    dObject.set("dtbsubstepisstepfix", qtyMaterEntry.get("substepisstepfix"));
                    if (allqty.booleanValue()) {
                        dObject.set("dtbsubstepqtymole", (Object)qty);
                        qtyMaterEntry.set("substepqtymole", (Object)BigDecimal.ZERO);
                    } else {
                        dObject.set("dtbsubstepqtymole", (Object)dtbqtys);
                        qtyMaterEntry.set("substepqtymole", (Object)qty.subtract(dtbqtys));
                    }
                    dObject.set("dtbsubstepqtydeno", qtyMaterEntry.get("substepqtydeno"));
                    dObject.set("dtbsubstepmole", qtyMaterEntry.get("substepmole"));
                    dObject.set("dtbsubstepdeno", qtyMaterEntry.get("substepdeno"));
                    dObject.set("dtbsubstepfixscrap", (Object)fixScrap);
                    qtyMaterEntry.set("substepfixscrap", (Object)oldFixScrap.subtract(fixScrap));
                    dObject.set("dtbsubstepscraprate", qtyMaterEntry.get("substepscraprate"));
                    dObject.set("dtbsubstepqtyentryid", qtyMaterEntry.get("id"));
                    dtbQtyEntrys.add((Object)dObject);
                }
                this.getView().updateView(DTBMATERENTRY);
                this.getView().updateView(QTYENTRY);
                this.getView().updateView(DTBQTYENTRY);
                return;
            }
        }
        ArrayList<DynamicObject> qtyEntryObjLs = new ArrayList<DynamicObject>();
        qtyEntryObjLs.add(qtyMaterEntry);
        if (BigDecimal.ZERO.compareTo(dtbqtys) >= 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5206\u914d\u6570\u91cf\u4e0d\u80fd\u4e3a0\u3002", (String)"PDMProMaterDTBPlugin_12", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setStepEntryValue(processWork, materEntry, qtyEntryObjLs, dtbqtys, fixScrap);
        this.getModel().setValue("substepqtymole", (Object)qty.subtract(dtbqtys), k);
        this.getModel().setValue("substepfixscrap", (Object)oldFixScrap.subtract(fixScrap), k);
        this.getView().updateView(DTBMATERENTRY);
        this.getView().updateView(DTBQTYENTRY);
        this.getView().updateView(QTYENTRY);
        this.getView().showMessage(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff0c\u51711\u6761\u3002", (String)"PDMProMaterDTBPlugin_13", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData instanceof Map) {
            Map map = (Map)e.getReturnData();
            switch (actionId) {
                case "addQty": {
                    this.adistributCloseCallBack(map);
                    this.setRowColor();
                    break;
                }
                case "removeQty": {
                    this.adeldistributCloseCallBack(map);
                    this.setRowColor();
                    break;
                }
                case "addStepQty": {
                    this.addStepQtyCloseCallBack(map);
                    break;
                }
                case "removeStepQty": {
                    this.removeStepQtyCloseCallBack(map);
                    break;
                }
            }
        }
    }

    private void setWorkProcessEntryValue(DynamicObjectCollection processEntrys) {
        if (processEntrys == null || processEntrys.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("operationno", new Object[0]);
        vs.addField("operationnum", new Object[0]);
        vs.addField("processseq", new Object[0]);
        vs.addField("operationdesc", new Object[0]);
        vs.addField("oprentryid", new Object[0]);
        vs.addField("machtype", new Object[0]);
        for (int i = 0; i < processEntrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)processEntrys.get(i);
            vs.addRow(new Object[]{entry.get("operationno"), entry.get("operation.id"), entry.get("parent"), entry.get("operationdesc"), entry.getPkValue(), entry.get("machiningtype")});
        }
        model.batchCreateNewEntryRow(WORKPROENTRY, vs);
        model.endInit();
        this.getView().updateView(WORKPROENTRY);
    }

    private void setDisNotAllocatEntryValue(List<BOMQueryObject> proMaterDTBObjects) {
        if (proMaterDTBObjects == null || proMaterDTBObjects.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("nallocatmater", new Object[0]);
        vs.addField("nallocatmaterattr", new Object[0]);
        vs.addField("nallocatunit", new Object[0]);
        vs.addField("nallocatusagetype", new Object[0]);
        vs.addField("nallocatmole", new Object[0]);
        vs.addField("nallocatdeno", new Object[0]);
        vs.addField("nallocatqty", new Object[0]);
        vs.addField("nallocatqtydeno", new Object[0]);
        vs.addField("nallocatparentmater", new Object[0]);
        vs.addField("nallocatparentmaterattr", new Object[0]);
        vs.addField("nallocatfixscrap", new Object[0]);
        vs.addField("nallocatscraprate", new Object[0]);
        vs.addField("nallocatremark", new Object[0]);
        vs.addField("nallocatbomversion", new Object[0]);
        vs.addField("nallocatauxpty", new Object[0]);
        vs.addField("nallocatrow", new Object[0]);
        vs.addField("nallocatentryid", new Object[0]);
        vs.addField("nallocatbomid", new Object[0]);
        vs.addField("nallocatbomentryid", new Object[0]);
        vs.addField("nallocatvaliddate", new Object[0]);
        vs.addField("nallocatinvaliddate", new Object[0]);
        vs.addField("nallocatisjumplevel", new Object[0]);
        vs.addField("id", new Object[0]);
        vs.addField("nallocatisreplace", new Object[0]);
        vs.addField("nallocatreplaceplan", new Object[0]);
        vs.addField("nallocatlongid", new Object[0]);
        Object effectDateObj = this.getModel().getValue("effectdate");
        Date effectDate = null;
        if (effectDateObj instanceof Date) {
            effectDate = PDMDateUtil.getDate((Date)((Date)effectDateObj));
        }
        Object invalidDateObj = this.getModel().getValue("invaliddate");
        Date invalidDate = null;
        if (invalidDateObj instanceof Date) {
            invalidDate = PDMDateUtil.getDate((Date)((Date)invalidDateObj));
        }
        ArrayList<BOMQueryObject> newProMaterDTBObjects = new ArrayList<BOMQueryObject>(proMaterDTBObjects.size());
        for (BOMQueryObject proMaterDTBObject : proMaterDTBObjects) {
            boolean jumpLevel;
            Date effectDate_zj = proMaterDTBObject.getValiddate();
            Date invalidDate_zj = proMaterDTBObject.getInvaliddate();
            boolean flag = true;
            if (effectDate != null && invalidDate != null && (invalidDate_zj.before(effectDate) || !effectDate_zj.before(invalidDate))) {
                flag = false;
            }
            if (jumpLevel = proMaterDTBObject.isJumplevel()) {
                flag = false;
            }
            if (!flag) continue;
            newProMaterDTBObjects.add(proMaterDTBObject);
        }
        proMaterDTBObjects = newProMaterDTBObjects;
        for (int i = 0; i < proMaterDTBObjects.size(); ++i) {
            BOMQueryObject dtbObject = proMaterDTBObjects.get(i);
            vs.addRow(new Object[]{dtbObject.getMater() != null ? dtbObject.getMater() : 0L, dtbObject.getMaterattr(), dtbObject.getUnit() != null ? dtbObject.getUnit() : 0L, dtbObject.getUsagetype(), dtbObject.getMole(), dtbObject.getDeno(), dtbObject.getQtymole(), dtbObject.getQtydeno(), dtbObject.getParentmater() != null ? dtbObject.getParentmater() : 0L, dtbObject.getParentmaterattr(), dtbObject.getFixscrap(), dtbObject.getScraprate(), dtbObject.getRemark(), dtbObject.getBomversion() != null ? dtbObject.getBomversion() : 0L, dtbObject.getAuxpty() != null ? dtbObject.getAuxpty() : 0L, dtbObject.getParententryId(), dtbObject.getEntryId(), dtbObject.getBomId(), dtbObject.getBomEntryId(), dtbObject.getValiddate(), dtbObject.getInvaliddate(), dtbObject.isJumplevel(), dtbObject.getEntryId(), dtbObject.isReplace(), dtbObject.getReplacePlanId(), dtbObject.getLongId()});
        }
        model.batchCreateNewEntryRow(NOTALLOCATENTRY, vs);
        model.endInit();
        this.getView().updateView(NOTALLOCATENTRY);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(NOTALLOCATENTRY);
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)rows.get(i);
            BOMQueryObject materEntry = proMaterDTBObjects.get(i);
            DynamicObjectCollection dCol = dynamicObject.getDynamicObjectCollection(QTYENTRY);
            List qtyCol = materEntry.getQtyentry();
            if (qtyCol == null) continue;
            for (StepEntryObj entry : qtyCol) {
                DynamicObject dObject = new DynamicObject(dCol.getDynamicObjectType(), true);
                this.setQtyEntry(dObject, entry);
                dCol.add((Object)dObject);
            }
        }
        this.getView().updateView(QTYENTRY);
    }

    private void setNotAllocatEntryValue(List<BOMQueryObject> proMaterDTBObjects) {
        if (proMaterDTBObjects == null || proMaterDTBObjects.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("nallocatmater", new Object[0]);
        vs.addField("nallocatmaterattr", new Object[0]);
        vs.addField("nallocatunit", new Object[0]);
        vs.addField("nallocatusagetype", new Object[0]);
        vs.addField("nallocatmole", new Object[0]);
        vs.addField("nallocatdeno", new Object[0]);
        vs.addField("nallocatqty", new Object[0]);
        vs.addField("nallocatqtydeno", new Object[0]);
        vs.addField("nallocatparentmater", new Object[0]);
        vs.addField("nallocatparentmaterattr", new Object[0]);
        vs.addField("nallocatfixscrap", new Object[0]);
        vs.addField("nallocatscraprate", new Object[0]);
        vs.addField("nallocatremark", new Object[0]);
        vs.addField("nallocatbomversion", new Object[0]);
        vs.addField("nallocatauxpty", new Object[0]);
        vs.addField("nallocatrow", new Object[0]);
        vs.addField("nallocatentryid", new Object[0]);
        vs.addField("nallocatbomid", new Object[0]);
        vs.addField("nallocatbomentryid", new Object[0]);
        vs.addField("nallocatvaliddate", new Object[0]);
        vs.addField("nallocatinvaliddate", new Object[0]);
        vs.addField("nallocatisjumplevel", new Object[0]);
        vs.addField("id", new Object[0]);
        vs.addField("pid", new Object[0]);
        vs.addField("nallocatisreplace", new Object[0]);
        vs.addField("nallocatreplaceplan", new Object[0]);
        vs.addField("nallocatlongid", new Object[0]);
        for (int i = 0; i < proMaterDTBObjects.size(); ++i) {
            BOMQueryObject dtbObject = proMaterDTBObjects.get(i);
            vs.addRow(new Object[]{dtbObject.getMater() != null ? dtbObject.getMater() : 0L, dtbObject.getMaterattr(), dtbObject.getUnit() != null ? dtbObject.getUnit() : 0L, dtbObject.getUsagetype(), dtbObject.getMole(), dtbObject.getDeno(), dtbObject.getQtymole(), dtbObject.getQtydeno(), dtbObject.getParentmater() != null ? dtbObject.getParentmater() : 0L, dtbObject.getParentmaterattr(), dtbObject.getFixscrap(), dtbObject.getScraprate(), dtbObject.getRemark(), dtbObject.getBomversion() != null ? dtbObject.getBomversion() : 0L, dtbObject.getAuxpty() != null ? dtbObject.getAuxpty() : 0L, dtbObject.getParententryId(), dtbObject.getEntryId(), dtbObject.getBomId(), dtbObject.getBomEntryId(), dtbObject.getValiddate(), dtbObject.getInvaliddate(), dtbObject.isJumplevel(), dtbObject.getEntryId(), dtbObject.getParententryId(), dtbObject.isReplace(), dtbObject.getReplacePlanId(), dtbObject.getLongId()});
        }
        model.batchCreateNewEntryRow(NOTALLOCATENTRY, vs);
        model.endInit();
        this.getView().updateView(NOTALLOCATENTRY);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(NOTALLOCATENTRY);
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)rows.get(i);
            BOMQueryObject materEntry = proMaterDTBObjects.get(i);
            DynamicObjectCollection dCol = dynamicObject.getDynamicObjectCollection(QTYENTRY);
            List qtyCol = materEntry.getQtyentry();
            if (qtyCol == null) continue;
            for (StepEntryObj entry : qtyCol) {
                DynamicObject dObject = new DynamicObject(dCol.getDynamicObjectType(), true);
                this.setQtyEntry(dObject, entry);
                dCol.add((Object)dObject);
            }
        }
        this.getView().updateView(QTYENTRY);
    }

    private void setRowColor() {
        EntryGrid grid = (EntryGrid)this.getControl(NOTALLOCATENTRY);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(NOTALLOCATENTRY);
        ArrayList<Integer> seqLs = new ArrayList<Integer>(16);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryEntity.get(i);
            long pid = entryObj.getLong("pid");
            if (pid == 0L) continue;
            int seq = entryObj.getInt("seq");
            seqLs.add(seq - 1);
        }
        int[] cols = ArrayUtils.toPrimitive((Integer[])seqLs.toArray(new Integer[seqLs.size()]));
        this.getPageCache().put("notselectrows", SerializationUtils.toJsonString(seqLs));
        grid.setRowBackcolor("#dee1e6", cols);
    }

    private void setDTBAllocatEntryValue(DynamicObject processWork, List<DynamicObject> materEntrys, Boolean step) {
        if (materEntrys == null || materEntrys.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("dtballocatmater", new Object[0]);
        vs.addField("dtballocatmaterattr", new Object[0]);
        vs.addField("dtballocatunit", new Object[0]);
        vs.addField("dtballocatusagetype", new Object[0]);
        vs.addField("dtballocatmole", new Object[0]);
        vs.addField("dtballocatdeno", new Object[0]);
        vs.addField("dtballocatqty", new Object[0]);
        vs.addField("dtballocatqtydeno", new Object[0]);
        vs.addField("dtballocatparentmater", new Object[0]);
        vs.addField("dtballocatentryid", new Object[0]);
        vs.addField("dtballocatrow", new Object[0]);
        vs.addField("dtballocatbomid", new Object[0]);
        vs.addField("dtballocatbomentryid", new Object[0]);
        vs.addField("dtballocatfixscrap", new Object[0]);
        vs.addField("dtballocatscraprate", new Object[0]);
        vs.addField("dtballocatremark", new Object[0]);
        vs.addField("dtballocatauxpty", new Object[0]);
        vs.addField("dtballocatoperationno", new Object[0]);
        vs.addField("dtballocatoperationnum", new Object[0]);
        vs.addField("dtballocatoperaname", new Object[0]);
        vs.addField("dtballocatprocessseq", new Object[0]);
        vs.addField("dtballocatoprentryid", new Object[0]);
        vs.addField("dtballocatmachtype", new Object[0]);
        vs.addField("dtballocatbomversion", new Object[0]);
        vs.addField("dtballocavaliddate", new Object[0]);
        vs.addField("dtballocainvaliddate", new Object[0]);
        vs.addField("dtballocatisreplace", new Object[0]);
        vs.addField("dtballocatreplaceplan", new Object[0]);
        vs.addField("dtballocatlongid", new Object[0]);
        for (int i = 0; i < materEntrys.size(); ++i) {
            DynamicObject materEntry = materEntrys.get(i);
            vs.addRow(new Object[]{materEntry.get("nallocatmater.id"), materEntry.get("nallocatmaterattr"), materEntry.get("nallocatunit.id"), materEntry.get("nallocatusagetype"), materEntry.getBigDecimal("nallocatmole"), materEntry.getBigDecimal("nallocatdeno"), materEntry.getBigDecimal("nallocatqty"), materEntry.getBigDecimal("nallocatqtydeno"), materEntry.get("nallocatparentmater.id"), materEntry.get("nallocatentryid"), materEntry.get("nallocatrow"), materEntry.get("nallocatbomid"), materEntry.get("nallocatbomentryid"), materEntry.get("nallocatfixscrap"), materEntry.get("nallocatscraprate"), materEntry.get("nallocatremark"), materEntry.get("nallocatauxpty.id"), processWork.get("operationno"), processWork.get("operationnum.id"), processWork.get("operationdesc"), processWork.get("processseq"), processWork.get("oprentryid"), processWork.get("machtype"), materEntry.get("nallocatbomversion.id"), materEntry.get("nallocatvaliddate"), materEntry.get("nallocatinvaliddate"), materEntry.get("nallocatisreplace"), materEntry.get("nallocatreplaceplan.id"), materEntry.get("nallocatlongid")});
        }
        int[] rowIndexs = model.batchCreateNewEntryRow(DTBMATERENTRY, vs);
        if (step.booleanValue()) {
            for (int i = 0; i < materEntrys.size(); ++i) {
                DynamicObject materEntry = materEntrys.get(i);
                DynamicObject dtbMaterEntry = this.getModel().getEntryRowEntity(DTBMATERENTRY, rowIndexs[i]);
                DynamicObjectCollection dtbQtyEntrys = dtbMaterEntry.getDynamicObjectCollection(DTBQTYENTRY);
                DynamicObjectCollection qtyEntrys = materEntry.getDynamicObjectCollection(QTYENTRY);
                if (qtyEntrys == null) continue;
                for (DynamicObject qtyEntry : qtyEntrys) {
                    if (BigDecimal.ZERO.compareTo(qtyEntry.getBigDecimal("substepqtymole")) == 0) continue;
                    DynamicObject dObject = new DynamicObject(dtbQtyEntrys.getDynamicObjectType(), true);
                    dObject.set("dtbsubstepbatchstartqty", qtyEntry.get("substepbatchstartqty"));
                    dObject.set("dtbsubstepbatchendqty", qtyEntry.get("substepbatchendqty"));
                    dObject.set("dtbsubstepisstepfix", qtyEntry.get("substepisstepfix"));
                    dObject.set("dtbsubstepqtymole", qtyEntry.get("substepqtymole"));
                    dObject.set("dtbsubstepqtydeno", qtyEntry.get("substepqtydeno"));
                    dObject.set("dtbsubstepmole", qtyEntry.get("substepmole"));
                    dObject.set("dtbsubstepdeno", qtyEntry.get("substepdeno"));
                    dObject.set("dtbsubstepfixscrap", qtyEntry.get("substepfixscrap"));
                    dObject.set("dtbsubstepscraprate", qtyEntry.get("substepscraprate"));
                    dObject.set("dtbsubstepqtyentryid", qtyEntry.get("id"));
                    qtyEntry.set("substepqtymole", (Object)BigDecimal.ZERO);
                    qtyEntry.set("substepfixscrap", (Object)BigDecimal.ZERO);
                    dtbQtyEntrys.add((Object)dObject);
                }
            }
        }
        model.endInit();
        this.getView().updateView(DTBMATERENTRY);
        this.getView().updateView(NOTALLOCATENTRY);
        this.getView().updateView(DTBQTYENTRY);
        this.getView().updateView(QTYENTRY);
    }

    private void setStepEntryValue(DynamicObject processWork, DynamicObject materEntry, List<DynamicObject> qtyEntryObjLs, BigDecimal qty, BigDecimal fixScarp) {
        if (qtyEntryObjLs == null || qtyEntryObjLs.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("dtballocatmater", new Object[0]);
        vs.addField("dtballocatmaterattr", new Object[0]);
        vs.addField("dtballocatunit", new Object[0]);
        vs.addField("dtballocatusagetype", new Object[0]);
        vs.addField("dtballocatmole", new Object[0]);
        vs.addField("dtballocatdeno", new Object[0]);
        vs.addField("dtballocatqty", new Object[0]);
        vs.addField("dtballocatqtydeno", new Object[0]);
        vs.addField("dtballocatparentmater", new Object[0]);
        vs.addField("dtballocatentryid", new Object[0]);
        vs.addField("dtballocatrow", new Object[0]);
        vs.addField("dtballocatbomid", new Object[0]);
        vs.addField("dtballocatbomentryid", new Object[0]);
        vs.addField("dtballocatfixscrap", new Object[0]);
        vs.addField("dtballocatscraprate", new Object[0]);
        vs.addField("dtballocatremark", new Object[0]);
        vs.addField("dtballocatauxpty", new Object[0]);
        vs.addField("dtballocatoperationno", new Object[0]);
        vs.addField("dtballocatoperationnum", new Object[0]);
        vs.addField("dtballocatoperaname", new Object[0]);
        vs.addField("dtballocatprocessseq", new Object[0]);
        vs.addField("dtballocatoprentryid", new Object[0]);
        vs.addField("dtballocatmachtype", new Object[0]);
        vs.addField("dtballocatbomversion", new Object[0]);
        vs.addField("dtballocavaliddate", new Object[0]);
        vs.addField("dtballocainvaliddate", new Object[0]);
        vs.addField("dtballocatisreplace", new Object[0]);
        vs.addField("dtballocatreplaceplan", new Object[0]);
        vs.addField("dtballocatlongid", new Object[0]);
        vs.addRow(new Object[]{materEntry.get("nallocatmater.id"), materEntry.get("nallocatmaterattr"), materEntry.get("nallocatunit.id"), materEntry.get("nallocatusagetype"), materEntry.getBigDecimal("nallocatmole"), materEntry.getBigDecimal("nallocatdeno"), BigDecimal.ZERO, materEntry.getBigDecimal("nallocatqtydeno"), materEntry.get("nallocatparentmater.id"), materEntry.get("nallocatentryid"), materEntry.get("nallocatrow"), materEntry.get("nallocatbomid"), materEntry.get("nallocatbomentryid"), BigDecimal.ZERO, materEntry.get("nallocatscraprate"), materEntry.get("nallocatremark"), materEntry.get("nallocatauxpty.id"), processWork.get("operationno"), processWork.get("operationnum.id"), processWork.get("operationdesc"), processWork.get("processseq"), processWork.get("oprentryid"), processWork.get("machtype"), materEntry.get("nallocatbomversion.id"), materEntry.get("nallocatvaliddate"), materEntry.get("nallocatinvaliddate"), materEntry.get("nallocatisreplace"), materEntry.get("nallocatreplaceplan.id"), materEntry.get("nallocatlongid")});
        int[] rowIndex = model.batchCreateNewEntryRow(DTBMATERENTRY, vs);
        DynamicObject dtbMaterEntry = this.getModel().getEntryRowEntity(DTBMATERENTRY, rowIndex[0]);
        DynamicObjectCollection dtbQtyEntrys = dtbMaterEntry.getDynamicObjectCollection(DTBQTYENTRY);
        for (DynamicObject qtyEntry : qtyEntryObjLs) {
            DynamicObject dObject = new DynamicObject(dtbQtyEntrys.getDynamicObjectType(), true);
            dObject.set("dtbsubstepbatchstartqty", qtyEntry.get("substepbatchstartqty"));
            dObject.set("dtbsubstepbatchendqty", qtyEntry.get("substepbatchendqty"));
            dObject.set("dtbsubstepisstepfix", qtyEntry.get("substepisstepfix"));
            if (qty != null) {
                dObject.set("dtbsubstepqtymole", (Object)qty);
            } else {
                dObject.set("dtbsubstepqtymole", qtyEntry.get("substepqtymole"));
                qtyEntry.set("substepqtymole", (Object)BigDecimal.ZERO);
            }
            dObject.set("dtbsubstepqtydeno", qtyEntry.get("substepqtydeno"));
            dObject.set("dtbsubstepmole", qtyEntry.get("substepmole"));
            dObject.set("dtbsubstepdeno", qtyEntry.get("substepdeno"));
            if (fixScarp != null) {
                dObject.set("dtbsubstepfixscrap", (Object)fixScarp);
            } else {
                dObject.set("dtbsubstepfixscrap", qtyEntry.get("substepfixscrap"));
                qtyEntry.set("substepfixscrap", (Object)BigDecimal.ZERO);
            }
            dObject.set("dtbsubstepscraprate", qtyEntry.get("substepscraprate"));
            dObject.set("dtbsubstepqtyentryid", qtyEntry.get("id"));
            dtbQtyEntrys.add((Object)dObject);
        }
        model.endInit();
        this.getView().updateView(DTBMATERENTRY);
        this.getView().updateView(DTBQTYENTRY);
        this.getView().updateView(QTYENTRY);
    }

    private void setQtyEntry(DynamicObject qty, StepEntryObj entry) {
        qty.set("substepbatchstartqty", (Object)entry.getBatchStartQty());
        qty.set("substepbatchendqty", (Object)entry.getBatchEndQty());
        qty.set("substepfixscrap", (Object)entry.getFixScrap());
        Boolean isStepFix = entry.getStepFix();
        if (isStepFix.booleanValue()) {
            qty.set("substepqtymole", (Object)entry.getMole());
            qty.set("substepqtydeno", (Object)entry.getDeno());
        } else {
            qty.set("substepqtymole", (Object)entry.getQtyMole());
            qty.set("substepqtydeno", (Object)entry.getQtyDeno());
        }
        qty.set("substepisstepfix", (Object)isStepFix);
        qty.set("substepscraprate", (Object)entry.getScrapRate());
        qty.set("substepmole", (Object)entry.getMole());
        qty.set("substepdeno", (Object)entry.getDeno());
        ORM orm = ORM.create();
        long id = orm.genLongId(qty.getDataEntityType());
        qty.set("id", (Object)id);
    }

    public void registerListener(EventObject e) {
        Search search;
        BasedataEdit process;
        super.registerListener(e);
        BasedataEdit bom = (BasedataEdit)this.getView().getControl(BOM);
        if (bom != null) {
            bom.addAfterF7SelectListener((AfterF7SelectListener)this);
            bom.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((process = (BasedataEdit)this.getView().getControl(PROCESSROUTE)) != null) {
            process.addAfterF7SelectListener((AfterF7SelectListener)this);
            process.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        Tab tab = (Tab)this.getView().getControl("tabap");
        Tab tab2 = (Tab)this.getView().getControl("tabap2");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        if (tab2 != null) {
            tab2.addTabSelectListener((TabSelectListener)this);
        }
        if ((search = (Search)this.getView().getControl("searchap")) != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        EntryGrid grid = (EntryGrid)this.getControl(NOTALLOCATENTRY);
        grid.addRowClickListener((RowClickEventListener)this);
        EntryGrid dtbGrid = (EntryGrid)this.getControl(DTBQTYENTRY);
        dtbGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void search(SearchEnterEvent evt) {
        evt.getSearchFields();
        String text = evt.getText();
        String rString = this.getPageCache().get(ROOT);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)rString, TreeNode.class);
        TreeNode node = root.getTreeNodeByText(text, 10);
        if (node != null) {
            TreeView matertree = (TreeView)this.getView().getControl(TREEVIEWAP);
            TreeNode node2 = node;
            while (!root.getId().equals(node2.getId())) {
                matertree.expand(node2.getParentid());
                node2 = root.getTreeNode(node2.getParentid(), 10);
            }
            matertree.focusNode(node);
            this.getPageCache().put(CURNODEID, node.getId());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22", (String)"PDMProMaterDTBPlugin_18", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"PDMProMaterDTBPlugin_19", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
        if (createorg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PDMProMaterDTBPlugin_20", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
        switch (key) {
            case "bom": {
                this.bomBeforeF7Select(e);
                break;
            }
            case "processroute": {
                this.processRouteBeforF7Select(e);
                break;
            }
        }
    }

    private void processRouteBeforF7Select(BeforeF7SelectEvent e) {
        DynamicObject product = (DynamicObject)this.getModel().getValue(PRODUCT);
        if (product == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e3b\u4ea7\u54c1\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9BOM\u7f16\u7801\u3002", (String)"PDMProMaterDTBPlugin_21", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Object material = product.get("masterid");
        Object materId = product.getPkValue();
        if (material instanceof DynamicObject) {
            materId = ((DynamicObject)material).getPkValue();
        }
        Set proIds = ProMaterDTBUtil.getProIds((Long)Long.valueOf(materId.toString()));
        HashSet ids = new HashSet(proIds.size());
        ids.addAll(proIds);
        Object effectDate = this.getModel().getValue("effectdate");
        Object invalidDate = this.getModel().getValue("invaliddate");
        if (effectDate instanceof Date && invalidDate instanceof Date) {
            Date efDate = (Date)effectDate;
            Date inDate = (Date)invalidDate;
            Set<Long> intersectDatePRouteIds = PDMProMaterDTBPlugin.getIntersectDatePRouteIds(efDate, inDate);
            ids.retainAll(intersectDatePRouteIds);
        }
        ListShowParameter fParameter = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter filterParameter = fParameter.getListFilterParameter();
        List qList = filterParameter.getQFilters();
        QFilter qFilter = new QFilter("id", "in", ids);
        qList.add(qFilter);
        DynamicObject process = (DynamicObject)this.getModel().getValue(PROCESSROUTE);
        if (process != null) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("changeProcess");
            String confirmTip = ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u5207\u6362\u540e\uff0c\u5de5\u5e8f\u6e05\u5355\u548c\u5206\u914d\u7ed3\u679c\u5c06\u88ab\u6e05\u7a7a\u3002", (String)"PDMProMaterDTBPlugin_22", (String)"mmc-pdm-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u786e\u5b9a\u91cd\u65b0\u9009\u62e9\u5de5\u827a\u8def\u7ebf\uff1f", (String)"PDMProMaterDTBPlugin_23", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            String string = SerializationUtils.serializeToBase64((Object)e);
            this.getPageCache().put("e", string);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        }
    }

    private void bomBeforeF7Select(BeforeF7SelectEvent e) {
        ListShowParameter fParameter = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter filterParameter = fParameter.getListFilterParameter();
        List qList = filterParameter.getQFilters();
        QFilter qFilterAttr = new QFilter("material.materialattr", "!=", (Object)MaterialAttrEnum.PHANTOMPART.getValue());
        qList.add(qFilterAttr);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate formOperate;
        String operateKey;
        super.beforeDoOperation(e);
        Object source = e.getSource();
        if (source instanceof FormOperate && ("save".equals(operateKey = (formOperate = (FormOperate)source).getOperateKey()) || "submit".equals(operateKey))) {
            int rowCount = this.getModel().getEntryEntity(NOTALLOCATENTRY).getRowCount();
            for (int k = 0; k < rowCount; ++k) {
                BigDecimal fixscrap;
                DynamicObjectCollection qtyEntry;
                String usageType;
                DynamicObject materEntry = this.getModel().getEntryRowEntity(NOTALLOCATENTRY, k);
                boolean isJumplevel = materEntry.getBoolean("nallocatisjumplevel");
                if (isJumplevel) continue;
                boolean isOk = true;
                BigDecimal zero = new BigDecimal("0");
                if (zero.compareTo(materEntry.getBigDecimal("nallocatqty")) != 0) {
                    isOk = false;
                }
                if ("C".equals(usageType = materEntry.getString("nallocatusagetype")) && (qtyEntry = materEntry.getDynamicObjectCollection(QTYENTRY)) != null) {
                    for (DynamicObject qtyEntryObj : qtyEntry) {
                        BigDecimal substepqtymole = qtyEntryObj.getBigDecimal("substepqtymole");
                        if (zero.compareTo(substepqtymole) == 0) continue;
                        isOk = false;
                    }
                }
                if (zero.compareTo(fixscrap = materEntry.getBigDecimal("nallocatfixscrap")) != 0) {
                    isOk = false;
                }
                if (isOk) continue;
                String msg = ResManager.loadKDString((String)"\u5b58\u5728\u5f85\u5206\u914d\u7528\u91cf/\u9636\u68af\u7528\u91cf/\u56fa\u5b9a\u635f\u8017\u6ca1\u6709\u5b8c\u5168\u5206\u914d\uff0c\u662f\u5426\u5c06\u81ea\u52a8\u5176\u5206\u914d\u5230\u7b2c\u4e00\u9053\u5de5\u5e8f\uff1f\u82e5\u4e0d\u81ea\u52a8\u5206\u914d\uff0c\u8bf7\u624b\u5de5\u5206\u914d\u540e\u518d\u4fdd\u5b58\u3002", (String)"PDMProMaterDTBPlugin_24", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(operateKey));
                e.setCancel(true);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String eString;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)"changeProcess", (CharSequence)callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && StringUtils.isNotBlank((CharSequence)(eString = this.getPageCache().get("e")))) {
            BeforeF7SelectEvent e = (BeforeF7SelectEvent)SerializationUtils.deSerializeFromBase64((String)eString);
            ListShowParameter fParameter = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParameter = fParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
            QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
            qList.add(qFilterEnable);
            qList.add(qFilterStatus);
            this.getPageCache().put("e", null);
            this.getView().showForm((FormShowParameter)fParameter);
        }
        if (("save".equals(callBackId) || "submit".equals(callBackId)) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.saveAlldistribut();
            this.getView().invokeOperation(callBackId);
            this.setRowColor();
        }
        if (StringUtils.equals((CharSequence)DISTRIBUT, (CharSequence)callBackId)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                String dtbMode = (String)this.getModel().getValue(DISTRIBUT);
                this.changeDTBQuery(dtbMode);
            } else {
                this.getModel().beginInit();
                this.getModel().setValue(DISTRIBUT, (Object)this.getPageCache().get("distributoldValue"));
                this.getModel().endInit();
                this.getView().updateView(DISTRIBUT);
            }
        }
        if (StringUtils.equals((CharSequence)"effectdate", (CharSequence)callBackId) || StringUtils.equals((CharSequence)"invaliddate", (CharSequence)callBackId)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.cleanData();
            } else {
                this.getModel().beginInit();
                this.getModel().setValue(callBackId, SerializationUtils.fromJsonString((String)this.getPageCache().get(callBackId), Date.class));
                this.getModel().endInit();
                this.getView().updateView(callBackId);
            }
        }
    }

    private void cleanData() {
        this.getModel().setValue(BOM, null);
        this.getModel().setValue(PROCESSROUTE, null);
        if (this.getModel().getEntryEntity(NOTALLOCATENTRY) != null) {
            this.getModel().deleteEntryData(NOTALLOCATENTRY);
        }
        if (this.getModel().getEntryEntity(STEPENTRY) != null) {
            this.getModel().deleteEntryData(STEPENTRY);
        }
        if (this.getModel().getEntryEntity(VIRTUALENTRY) != null) {
            this.getModel().deleteEntryData(VIRTUALENTRY);
        }
        if (this.getModel().getEntryEntity(DTBMATERENTRY) != null) {
            this.getModel().deleteEntryData(DTBMATERENTRY);
        }
        if (this.getModel().getEntryEntity(DTBSTEPENTRY) != null) {
            this.getModel().deleteEntryData(DTBSTEPENTRY);
        }
        if (this.getModel().getEntryEntity(DTBVIRTUALENTRY) != null) {
            this.getModel().deleteEntryData(DTBVIRTUALENTRY);
        }
        if (this.getModel().getEntryEntity(WORKPROENTRY) != null) {
            this.getModel().deleteEntryData(WORKPROENTRY);
        }
        this.getView().updateView(NOTALLOCATENTRY);
        this.getView().updateView(STEPENTRY);
        this.getView().updateView(VIRTUALENTRY);
        this.getView().updateView(DTBMATERENTRY);
        this.getView().updateView(DTBSTEPENTRY);
        this.getView().updateView(DTBVIRTUALENTRY);
        this.getView().updateView(SUBVIRTUALENTRY);
        this.getView().updateView(DTBSUBVIRTUALENTRY);
        this.getView().updateView(QTYENTRY);
        this.getView().updateView(DTBQTYENTRY);
        this.getView().updateView(WORKPROENTRY);
    }

    public void tabSelected(TabSelectEvent arg0) {
        String key = arg0.getTabKey();
        if ("tabpageap".equals(key) || "tabpageap1".equals(key)) {
            this.getPageCache().put("tabpageap", key);
        }
        if ("tabpageap51".equals(key) || "tabpageap4".equals(key)) {
            this.getPageCache().put("tabpageapdtb", key);
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (key) {
            case "tabpageap": {
                break;
            }
            case "tabpageap1": {
                this.checkSelected(model, view, NOTALLOCATENTRY, QTYENTRY, "nallocatusagetype");
                break;
            }
            case "tabpageap4": {
                this.checkSelected(model, view, DTBMATERENTRY, DTBQTYENTRY, "dtballocatusagetype");
                break;
            }
        }
    }

    private void checkSelected(IDataModel model, IFormView view, String entryKey, String entryChildKey, String fieldKey) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        int[] selectRows = entryGrid.getSelectRows();
        int entryRowIndex = -1;
        if (selectRows.length != 0) {
            entryRowIndex = selectRows[0];
        }
        DynamicObject entryDO = model.getEntryRowEntity(entryKey, entryRowIndex);
        if (entryRowIndex >= 0) {
            String nallocatusagetype = entryDO.getString(fieldKey);
            if ("C".equals(nallocatusagetype)) {
                view.setVisible(Boolean.TRUE, new String[]{entryChildKey});
            } else {
                view.setVisible(Boolean.FALSE, new String[]{entryChildKey});
                if (entryKey.equals(NOTALLOCATENTRY)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7528\u91cf\u7c7b\u578b\u201d\u4e3a\u9636\u68af\u7684\u5f85\u5206\u914d\u7269\u6599\u3002", (String)"PDMProMaterDTBPlugin_25", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7528\u91cf\u7c7b\u578b\u201d\u4e3a\u9636\u68af\u7684\u5206\u914d\u7269\u6599\u3002", (String)"PDMProMaterDTBPlugin_26", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                }
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{entryChildKey});
            if (entryKey.equals(NOTALLOCATENTRY)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u5f85\u5206\u914d\u7269\u6599\u3002", (String)"PDMProMaterDTBPlugin_27", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u7269\u6599\u3002", (String)"PDMProMaterDTBPlugin_28", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            }
        }
        entryGrid.selectRows(selectRows, entryRowIndex);
    }

    private void saveAlldistribut() {
        int k;
        StringBuilder error = ProMaterDTBUtil.saveCheckDTBAddRigth((IDataModel)this.getModel(), (IFormView)this.getView(), (String)NOTALLOCATENTRY, (String)ResManager.loadKDString((String)"\u5f85\u5206\u914d\u7269\u6599", (String)"PDMProMaterDTBPlugin_11", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
        if (error.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u63d0\u793a\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PDMProMaterDTBPlugin_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(WORKPROENTRY);
        int first = 0;
        for (DynamicObject dynamicObject : entryEntity) {
            String processSeq = dynamicObject.getString("processseq");
            String operationNo = dynamicObject.getString("operationno");
            if (!"1".equals(processSeq) || !"10".equals(operationNo)) continue;
            first = dynamicObject.getInt("seq") - 1;
            break;
        }
        ArrayList<DynamicObject> listMater = new ArrayList<DynamicObject>();
        DynamicObject processWork = this.getModel().getEntryRowEntity(WORKPROENTRY, first);
        int rowCount = this.getModel().getEntryEntity(NOTALLOCATENTRY).getRowCount();
        String rString = this.getPageCache().get(ROOT);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)rString, TreeNode.class);
        ArrayList treeNodes = new ArrayList(16);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(NOTALLOCATENTRY, i);
            String id = entryRowEntity.getString("nallocatlongid");
            TreeNode treeNode = root.getTreeNode(id, 50);
            if (treeNode == null) continue;
            treeNode.iterate(50, treeNodes::add);
        }
        ArrayList idLs = new ArrayList(16);
        treeNodes.stream().filter(node -> !"blue".equals(node.getColor())).forEach(node -> idLs.add(node.getId()));
        ArrayList<Integer> seqLs = new ArrayList<Integer>(16);
        DynamicObjectCollection notallocatEntry = this.getModel().getEntryEntity(NOTALLOCATENTRY);
        for (int i = 0; i < notallocatEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)notallocatEntry.get(i);
            String id = entry.getString("nallocatlongid");
            if (!idLs.contains(id)) continue;
            seqLs.add(entry.getInt("seq") - 1);
        }
        int[] indexs = ArrayUtils.toPrimitive((Integer[])seqLs.toArray(new Integer[seqLs.size()]));
        for (k = 0; k < indexs.length; ++k) {
            DynamicObject materEntry = this.getModel().getEntryRowEntity(NOTALLOCATENTRY, indexs[k]);
            BigDecimal zero = new BigDecimal("0");
            boolean isZero = true;
            if (zero.compareTo(materEntry.getBigDecimal("nallocatqty")) == 0) {
                DynamicObjectCollection qtyEntry;
                String usageType = materEntry.getString("nallocatusagetype");
                if ("C".equals(usageType) && (qtyEntry = materEntry.getDynamicObjectCollection(QTYENTRY)) != null) {
                    for (DynamicObject qtyEntryObj : qtyEntry) {
                        BigDecimal substepqtymole = qtyEntryObj.getBigDecimal("substepqtymole");
                        if (zero.compareTo(substepqtymole) == 0) continue;
                        isZero = false;
                    }
                }
                if (isZero) continue;
            }
            Boolean flag = Boolean.TRUE;
            DynamicObjectCollection dCol = this.getModel().getEntryEntity(DTBMATERENTRY);
            for (DynamicObject dynamicObject : dCol) {
                if (!StringUtils.equals((CharSequence)dynamicObject.getString("dtballocatlongid"), (CharSequence)materEntry.getString("nallocatlongid")) || !StringUtils.equals((CharSequence)dynamicObject.getString("dtballocatoprentryid"), (CharSequence)processWork.getString("oprentryid"))) continue;
                BigDecimal q = dynamicObject.getBigDecimal("dtballocatqty");
                BigDecimal p = materEntry.getBigDecimal("nallocatqty");
                dynamicObject.set("dtballocatqty", (Object)q.add(p));
                BigDecimal q1 = dynamicObject.getBigDecimal("dtballocatfixscrap");
                BigDecimal p1 = materEntry.getBigDecimal("nallocatfixscrap");
                dynamicObject.set("dtballocatfixscrap", (Object)q1.add(p1));
                String usageType = materEntry.getString("nallocatusagetype");
                if ("C".equals(usageType)) {
                    DynamicObjectCollection dtbQtyEntrys = dynamicObject.getDynamicObjectCollection(DTBQTYENTRY);
                    DynamicObjectCollection qtyEntrys = materEntry.getDynamicObjectCollection(QTYENTRY);
                    ArrayList<DynamicObject> addDtbQtyEntryLs = new ArrayList<DynamicObject>(4);
                    if (qtyEntrys != null) {
                        for (DynamicObject qtyEntry : qtyEntrys) {
                            long qtyEntryId = qtyEntry.getLong("id");
                            if (dtbQtyEntrys.size() == 0) {
                                DynamicObject dObject = new DynamicObject(dtbQtyEntrys.getDynamicObjectType(), true);
                                dObject.set("dtbsubstepbatchstartqty", qtyEntry.get("substepbatchstartqty"));
                                dObject.set("dtbsubstepbatchendqty", qtyEntry.get("substepbatchendqty"));
                                dObject.set("dtbsubstepisstepfix", qtyEntry.get("substepisstepfix"));
                                dObject.set("dtbsubstepqtymole", qtyEntry.get("substepqtymole"));
                                dObject.set("dtbsubstepqtydeno", qtyEntry.get("substepqtydeno"));
                                dObject.set("dtbsubstepmole", qtyEntry.get("substepmole"));
                                dObject.set("dtbsubstepdeno", qtyEntry.get("substepdeno"));
                                dObject.set("dtbsubstepfixscrap", qtyEntry.get("substepfixscrap"));
                                dObject.set("dtbsubstepscraprate", qtyEntry.get("substepscraprate"));
                                dObject.set("dtbsubstepqtyentryid", qtyEntry.get("id"));
                                qtyEntry.set("substepqtymole", (Object)BigDecimal.ZERO);
                                addDtbQtyEntryLs.add(dObject);
                                qtyEntry.set("substepfixscrap", (Object)BigDecimal.ZERO);
                                addDtbQtyEntryLs.add(dObject);
                                continue;
                            }
                            boolean isFind = false;
                            for (DynamicObject dtbQtyEntry : dtbQtyEntrys) {
                                long dtbsubstepqtyentryid = dtbQtyEntry.getLong("dtbsubstepqtyentryid");
                                if (dtbsubstepqtyentryid == 0L || dtbsubstepqtyentryid != qtyEntryId) continue;
                                BigDecimal substepqtymole = qtyEntry.getBigDecimal("substepqtymole");
                                BigDecimal dtbsubstepqtymole = dtbQtyEntry.getBigDecimal("dtbsubstepqtymole");
                                dtbQtyEntry.set("dtbsubstepqtymole", (Object)dtbsubstepqtymole.add(substepqtymole));
                                qtyEntry.set("substepqtymole", (Object)BigDecimal.ZERO);
                                BigDecimal substepfixscrap = qtyEntry.getBigDecimal("substepfixscrap");
                                BigDecimal dtbsubstepfixscrap = dtbQtyEntry.getBigDecimal("dtbsubstepfixscrap");
                                dtbQtyEntry.set("dtbsubstepfixscrap", (Object)dtbsubstepfixscrap.add(substepfixscrap));
                                qtyEntry.set("substepfixscrap", (Object)BigDecimal.ZERO);
                                isFind = true;
                                break;
                            }
                            if (isFind) continue;
                            DynamicObject dObject = new DynamicObject(dtbQtyEntrys.getDynamicObjectType(), true);
                            dObject.set("dtbsubstepbatchstartqty", qtyEntry.get("substepbatchstartqty"));
                            dObject.set("dtbsubstepbatchendqty", qtyEntry.get("substepbatchendqty"));
                            dObject.set("dtbsubstepisstepfix", qtyEntry.get("substepisstepfix"));
                            dObject.set("dtbsubstepqtymole", qtyEntry.get("substepqtymole"));
                            dObject.set("dtbsubstepqtydeno", qtyEntry.get("substepqtydeno"));
                            dObject.set("dtbsubstepmole", qtyEntry.get("substepmole"));
                            dObject.set("dtbsubstepdeno", qtyEntry.get("substepdeno"));
                            dObject.set("dtbsubstepfixscrap", qtyEntry.get("substepfixscrap"));
                            dObject.set("dtbsubstepscraprate", qtyEntry.get("substepscraprate"));
                            dObject.set("dtbsubstepqtyentryid", qtyEntry.get("id"));
                            qtyEntry.set("substepqtymole", (Object)BigDecimal.ZERO);
                            qtyEntry.set("substepfixscrap", (Object)BigDecimal.ZERO);
                            addDtbQtyEntryLs.add(dObject);
                        }
                        dtbQtyEntrys.addAll(addDtbQtyEntryLs);
                    }
                }
                flag = Boolean.FALSE;
                break;
            }
            if (!flag.booleanValue()) continue;
            listMater.add(materEntry);
        }
        this.setDTBAllocatEntryValue(processWork, listMater, Boolean.TRUE);
        block8: for (k = 0; k < rowCount; ++k) {
            Object longIdObj = this.getModel().getValue("nallocatlongid", k);
            String _longId = longIdObj == null ? "" : longIdObj.toString();
            for (String longId : idLs) {
                if (!longId.contains(_longId)) continue;
                this.getModel().setValue("nallocatqty", (Object)0, k);
                this.getModel().setValue("nallocatfixscrap", (Object)0, k);
                continue block8;
            }
        }
        this.getView().updateView(DTBMATERENTRY);
        this.getView().updateView(NOTALLOCATENTRY);
    }

    public void entryRowClick(RowClickEvent evt) {
        String mode = (String)this.getModel().getValue(DISTRIBUT);
        int row = evt.getRow();
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String key = entryGrid.getKey();
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        HashSet<Integer> selectSet = new HashSet<Integer>(16);
        List<Integer> selectedRowLs = Arrays.asList(ArrayUtils.toObject((int[])selectedRows));
        selectSet.addAll(selectedRowLs);
        if (NOTALLOCATENTRY.equals(key)) {
            if (DistributModeEnum.ORDER.getCode().equals(mode)) {
                String notSelectRows = this.getPageCache().get("notselectrows");
                List notSelectRowLs = SerializationUtils.fromJsonStringToList((String)notSelectRows, Integer.class);
                selectSet.removeAll(notSelectRowLs);
            }
            int[] newSelectedRows = ArrayUtils.toPrimitive((Integer[])selectSet.toArray(new Integer[selectSet.size()]));
            entryGrid.selectRows(newSelectedRows, row);
        }
        if (DTBQTYENTRY.equals(key)) {
            Boolean flag;
            EntryGrid dtbmaterentry = (EntryGrid)this.getControl(DTBMATERENTRY);
            int[] rows = dtbmaterentry.getEntryState().getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            int index = rows[0];
            DynamicObject dyn = this.getModel().getEntryRowEntity(DTBMATERENTRY, index);
            String dtballocatusagetype = dyn.getString("dtballocatusagetype");
            if (!"C".equals(dtballocatusagetype)) {
                return;
            }
            String longId = dyn.getString("dtballocatlongid");
            if (!longId.contains("-")) {
                return;
            }
            String[] longSubId = longId.split("-");
            DynamicObjectCollection col = this.getModel().getEntryEntity(NOTALLOCATENTRY);
            DynamicObject currnode = null;
            for (DynamicObject obj : col) {
                if (!longSubId[0].equals(obj.getString("nallocatlongid"))) continue;
                currnode = obj;
                break;
            }
            if (null != currnode && (flag = Boolean.valueOf(currnode.getBoolean("nallocatisjumplevel"))).booleanValue()) {
                entryGrid.selectRows(-1);
            }
        }
    }

    public static Set<Long> getIntersectDatePRouteIds(Date minDate, Date maxDate) {
        Objects.requireNonNull(minDate, "minDate is null");
        Objects.requireNonNull(maxDate, "maxDate is null");
        HashSet<Long> ids = new HashSet<Long>(16);
        minDate = PDMDateUtil.getDate((Date)minDate);
        maxDate = PDMDateUtil.getDate((Date)maxDate);
        QFilter routeFilter0 = new QFilter("routeversion", "=", (Object)0L);
        QFilter routeFilter1 = new QFilter("routeversion.effectdate", "<=", (Object)minDate);
        QFilter routeFilter2 = new QFilter("routeversion.invaliddate", ">=", (Object)minDate);
        QFilter routeFilter = routeFilter1.and(routeFilter2);
        QFilter processFilter1 = new QFilter("routeversion.effectdate", ">=", (Object)minDate);
        QFilter processFilter2 = new QFilter("routeversion.effectdate", "<=", (Object)maxDate);
        QFilter processFilter = processFilter1.and(processFilter2);
        QFilter qFilter = routeFilter0.or(routeFilter.or(processFilter));
        QFilter[] qFilters = new QFilter[]{qFilter};
        String algoKey = "kd.mmc.pdm.formplugin.processroute.PDMProMaterDTBPlugin#getIntersectDatePRouteIds";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pdm_route", (String)"id", (QFilter[])qFilters, null);){
            dataSet.forEach(r -> ids.add(r.getLong("id")));
        }
        return ids;
    }
}

