/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.productconfig;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;

public class FeatureDefinitionSelectEditPlugin
extends AbstractFormPlugin {
    private static Boolean isEdit = Boolean.FALSE;
    private static Boolean isAllowMulValue = Boolean.FALSE;
    private static int selectRowCount = 0;
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ENTRY_VALUE = "entryvalue";
    private static final String ENTRY_VALUE_NAME = "entryvaluename";
    private static final String ENTRY_ID = "entryid";
    private static Long featureDefPK = 0L;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object listData = param.get("list");
        Object isEditObj = param.get("isedit");
        Object selectData = param.get("selectData");
        Object isAllowMulValueObj = param.get("isallowmulvalue");
        Object selectRowCountObj = param.get("selectrowcount");
        Object featurePkValue = param.get("featurepkvalue");
        List paramListData = null;
        List selectDataList = null;
        if (isEditObj instanceof Boolean) {
            isEdit = (Boolean)isEditObj;
        }
        if (listData != null) {
            paramListData = (List)listData;
        }
        if (selectData != null) {
            selectDataList = (List)selectData;
        }
        if (isAllowMulValueObj != null) {
            isAllowMulValue = (Boolean)isAllowMulValueObj;
        }
        if (selectRowCountObj != null) {
            selectRowCount = (Integer)selectRowCountObj;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (isEdit.booleanValue()) {
            this.controlValueInput(view, model, param);
        }
        if (featurePkValue instanceof Long) {
            featureDefPK = (Long)featurePkValue;
        }
        this.bindValueData(view, model, paramListData, selectDataList);
    }

    private void controlValueInput(IFormView view, IDataModel model, Map<String, Object> param) {
        if (view == null || model == null || param == null) {
            return;
        }
        Object featureTypeObj = param.get("featuretype");
        Object isAllowNegativeObj = param.get("isallownegative");
        Object lenObj = param.get("len");
        String featureType = "";
        boolean isAllowNegative = false;
        int len = 0;
        if (featureTypeObj instanceof String) {
            featureType = String.valueOf(featureTypeObj);
            this.getView().getPageCache().put("featurevaluetype", featureType);
        }
        if (isAllowNegativeObj instanceof Boolean) {
            isAllowNegative = (Boolean)isAllowNegativeObj;
        }
        if (lenObj instanceof Integer) {
            len = (Integer)lenObj;
            this.getView().getPageCache().put("scale", len + "");
        }
        TextEdit entryvalueTextEdit = (TextEdit)view.getControl(ENTRY_VALUE);
        EntryGrid entryGrid = (EntryGrid)view.getControl(ENTRY_ENTITY);
        switch (featureType) {
            case "A": {
                view.setVisible(Boolean.valueOf(true), new String[]{ENTRY_VALUE_NAME});
                HashMap<String, Object> data = new HashMap<String, Object>();
                if (len > 0 && len <= 1000) {
                    data.put("maxlength", len);
                } else {
                    data.put("maxlength", 1000);
                }
                data.put("type", "text");
                entryGrid.setColumnProperty(ENTRY_VALUE, "editor", data);
                view.updateView(ENTRY_ENTITY);
                break;
            }
            case "B": {
                view.setVisible(Boolean.valueOf(true), new String[]{ENTRY_VALUE});
                view.setVisible(Boolean.valueOf(false), new String[]{ENTRY_VALUE_NAME});
                this.setTextTranDecimal(entryGrid, len, isAllowNegative);
                view.updateView(ENTRY_ENTITY);
                break;
            }
            default: {
                view.setVisible(Boolean.valueOf(true), new String[]{ENTRY_VALUE_NAME});
            }
        }
    }

    private void setTextTranDecimal(EntryGrid entryGrid, int scale, boolean isAllowNegative) {
        if (entryGrid == null) {
            return;
        }
        HashMap<String, Object> decimalParam = new HashMap<String, Object>();
        decimalParam.put("pc", 23);
        if (scale >= 0 && scale <= 10) {
            decimalParam.put("sc", scale);
        } else {
            decimalParam.put("sc", 10);
        }
        decimalParam.put("type", "number");
        decimalParam.put("nt", "decimal");
        decimalParam.put("zs", true);
        if (!isAllowNegative) {
            decimalParam.put("minm", 0);
            decimalParam.put("min", 0);
        }
        entryGrid.setColumnProperty(ENTRY_VALUE, "editor", decimalParam);
    }

    private void bindValueData(IFormView view, IDataModel model, List<Map<String, Object>> paramListData, List<Map<String, Object>> selectDataList) {
        if (view == null || model == null) {
            return;
        }
        DynamicObjectCollection entryEntity = model.getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        if (!isEdit.booleanValue() && paramListData != null) {
            view.setEnable(Boolean.valueOf(false), new String[]{ENTRY_ENTITY});
            this.writeEntryData(entryEntity, paramListData);
        } else {
            view.setEnable(Boolean.valueOf(true), new String[]{ENTRY_ENTITY});
            this.writeEntryData(entryEntity, paramListData);
        }
        HashMap<String, Boolean> ismul = new HashMap<String, Boolean>();
        ismul.put("ismul", isAllowMulValue);
        this.getView().updateControlMetadata(ENTRY_ENTITY, ismul);
        model.updateCache();
        view.updateView(ENTRY_ENTITY);
        DynamicObjectCollection entryEntityDOC = model.getEntryEntity(ENTRY_ENTITY);
        if (!isEdit.booleanValue()) {
            if (selectDataList != null && selectRowCount == 0) {
                this.setSelectRow(entryEntityDOC, selectDataList, view);
            } else if (selectDataList == null) {
                this.setSelectPreCountRow(view, entryEntityDOC, selectRowCount);
            }
        } else {
            this.writeEntrySelectData(view, model, entryEntityDOC, selectDataList);
        }
    }

    private void writeEntrySelectData(IFormView view, IDataModel model, DynamicObjectCollection entryEntityDOC, List<Map<String, Object>> selectDataList) {
        if (view == null || model == null) {
            return;
        }
        if (entryEntityDOC != null) {
            HashSet<Integer> rowSet = new HashSet<Integer>(4);
            if (selectDataList != null && !selectDataList.isEmpty()) {
                for (int i = 0; i < entryEntityDOC.size(); ++i) {
                    DynamicObject entryDO = (DynamicObject)entryEntityDOC.get(i);
                    if (entryDO == null) continue;
                    String entryValueStr = entryDO.getString(ENTRY_VALUE);
                    String entryValueNameStr = entryDO.getString(ENTRY_VALUE_NAME);
                    Iterator<Map<String, Object>> selectIterator = selectDataList.iterator();
                    while (selectIterator.hasNext()) {
                        String entryValueName;
                        Map<String, Object> valueMap = selectIterator.next();
                        String entryValue = valueMap.get(ENTRY_VALUE) == null ? "" : String.valueOf(valueMap.get(ENTRY_VALUE));
                        String string = entryValueName = valueMap.get(ENTRY_VALUE_NAME) == null ? "" : String.valueOf(valueMap.get(ENTRY_VALUE_NAME));
                        if (!StringUtils.equals((CharSequence)entryValueStr, (CharSequence)entryValue) || !StringUtils.equals((CharSequence)entryValueNameStr, (CharSequence)entryValueName)) continue;
                        selectIterator.remove();
                        rowSet.add(entryDO.getInt("seq") - 1);
                    }
                }
                for (Map<String, Object> valueMap : selectDataList) {
                    String entryValue = valueMap.get(ENTRY_VALUE) == null ? "" : String.valueOf(valueMap.get(ENTRY_VALUE));
                    String entryValueName = valueMap.get(ENTRY_VALUE_NAME) == null ? "" : String.valueOf(valueMap.get(ENTRY_VALUE_NAME));
                    int rowIndex = model.insertEntryRow(ENTRY_ENTITY, entryEntityDOC.size());
                    model.setValue(ENTRY_VALUE, (Object)entryValue, rowIndex);
                    model.setValue(ENTRY_VALUE_NAME, (Object)entryValueName, rowIndex);
                    rowSet.add(rowIndex);
                }
            }
            if (entryEntityDOC != null) {
                model.createNewEntryRow(ENTRY_ENTITY);
            }
            model.updateCache();
            view.updateView(ENTRY_ENTITY);
            this.setEntrRows(view, rowSet);
        }
    }

    private void writeEntryData(DynamicObjectCollection entryEntity, List<Map<String, Object>> paramListData) {
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        entryEntity.clear();
        if (paramListData == null || paramListData.isEmpty()) {
            return;
        }
        for (int i = 0; i < paramListData.size(); ++i) {
            Map<String, Object> listDataMap = paramListData.get(i);
            DynamicObject entryDO = entryEntity.addNew();
            Object entryValue = listDataMap.get(ENTRY_VALUE);
            Object entryName = listDataMap.get(ENTRY_VALUE_NAME);
            Object entryID = listDataMap.get(ENTRY_ID);
            Object entryAuxValueID = listDataMap.get("entryauxvalueid");
            entryDO.set(ENTRY_VALUE, entryValue);
            entryDO.set(ENTRY_VALUE_NAME, entryName);
            entryDO.set(ENTRY_ID, entryID);
            entryDO.set("entryauxvalueid", entryAuxValueID);
        }
    }

    private void setSelectPreCountRow(IFormView view, DynamicObjectCollection entryEntityDOC, int selectRowCount) {
        if (entryEntityDOC == null || entryEntityDOC.isEmpty()) {
            return;
        }
        HashSet<Integer> rowSet = new HashSet<Integer>(4);
        if (selectRowCount > 0) {
            for (int i = 0; i < entryEntityDOC.size(); ++i) {
                rowSet.add(i);
                if (i == selectRowCount - 1) break;
            }
        }
        this.setEntrRows(view, rowSet);
    }

    private void setEntrRows(IFormView view, Set<Integer> rowSet) {
        if (view == null || rowSet == null || rowSet.isEmpty()) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)view.getControl(ENTRY_ENTITY);
        Integer[] rowInteger = rowSet.toArray(new Integer[rowSet.size()]);
        int[] rows = Arrays.stream(rowInteger).mapToInt(Integer::intValue).toArray();
        if (rows != null && rows.length > 0) {
            entryGrid.selectRows(rows, rows[0]);
        }
    }

    private void setSelectRow(DynamicObjectCollection entryEntityDOC, List<Map<String, Object>> selectDataList, IFormView view) {
        HashSet<Integer> rowSet = new HashSet<Integer>(4);
        if (entryEntityDOC != null && !entryEntityDOC.isEmpty() && selectDataList != null && !selectDataList.isEmpty()) {
            block0: for (DynamicObject entryEntityDO : entryEntityDOC) {
                int seq = entryEntityDO.getInt("seq");
                Object entryid = entryEntityDO.get(ENTRY_ID);
                for (int i = 0; i < selectDataList.size(); ++i) {
                    Map<String, Object> dataMap = selectDataList.get(i);
                    Object entryID = dataMap.get(ENTRY_ID);
                    if (entryID == null || entryid == null || !StringUtils.equals((CharSequence)String.valueOf(entryID), (CharSequence)String.valueOf(entryid))) continue;
                    rowSet.add(seq - 1);
                    continue block0;
                }
            }
            this.setEntrRows(view, rowSet);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        for (int i = 0; i < changeSet.length; ++i) {
            this.propertyChanged(property, changeSet[i]);
        }
    }

    private void propertyChanged(String property, ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int rowIndex = changeData.getRowIndex();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRY_ENTITY);
        switch (property) {
            case "entryvalue": {
                boolean isRepeat = this.repeatVal(model, newValue, rowIndex);
                if (isRepeat) {
                    Object oldValue = changeData.getOldValue();
                    model.setValue(ENTRY_VALUE, oldValue, rowIndex);
                    view.showTipNotification(ResManager.loadKDString((String)"\u7279\u5f81\u503c\u5e94\u8be5\u552f\u4e00(\u4e0d\u533a\u5206\u5927\u5c0f\u5199)\u3002", (String)"FeatureDefinitionSelectEditPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!isEdit.booleanValue() || newValue == null || entryEntity == null || entryEntity.isEmpty()) break;
                this.handleAddDeleteEntry(entryEntity, rowIndex);
                break;
            }
            case "entryvaluename": {
                if (!isEdit.booleanValue() || newValue == null || entryEntity == null || entryEntity.isEmpty()) break;
                this.handleAddDeleteEntry(entryEntity, rowIndex);
            }
        }
    }

    private void handleAddDeleteEntry(DynamicObjectCollection entryEntity, int rowIndex) {
        String entryId;
        String entryName;
        String entryvalue;
        DynamicObject entryDO = (DynamicObject)entryEntity.get(entryEntity.size() - 1);
        DynamicObject entryRowDO = (DynamicObject)entryEntity.get(rowIndex);
        if (entryDO != null) {
            entryvalue = entryDO.getString(ENTRY_VALUE);
            entryName = entryDO.getString(ENTRY_VALUE_NAME);
            entryId = entryDO.getString(ENTRY_ID);
            if (!(StringUtils.isEmpty((CharSequence)entryvalue) && StringUtils.isEmpty((CharSequence)entryName) && StringUtils.isEmpty((CharSequence)entryId))) {
                this.getView().invokeOperation("newentry");
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
                entryGrid.selectRows(rowIndex);
            }
        }
        if (entryRowDO != null) {
            entryvalue = entryRowDO.getString(ENTRY_VALUE);
            entryName = entryRowDO.getString(ENTRY_VALUE_NAME);
            entryId = entryRowDO.getString(ENTRY_ID);
            if (StringUtils.isEmpty((CharSequence)entryvalue) && StringUtils.isEmpty((CharSequence)entryName) && StringUtils.isEmpty((CharSequence)entryId)) {
                this.getView().invokeOperation("deleteentry");
            }
        }
    }

    private boolean repeatVal(IDataModel model, Object newValue, int rowIndex) {
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRY_ENTITY);
        boolean isRepeat = false;
        if (entryEntity == null || entryEntity.size() == 0) {
            return isRepeat;
        }
        if (newValue == null || StringUtils.isEmpty((CharSequence)String.valueOf(newValue))) {
            return isRepeat;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryDO = (DynamicObject)entryEntity.get(i);
            if (entryDO == null) continue;
            String entryValue = entryDO.getString(ENTRY_VALUE);
            if (i == rowIndex || entryValue == null || !StringUtils.equals((CharSequence)entryValue, (CharSequence)String.valueOf(newValue))) continue;
            isRepeat = true;
        }
        return isRepeat;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("btnok".equals(fieldKey)) {
            List<Map<String, Object>> cacheManualList;
            EntryGrid entryEntity = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = entryEntity.getSelectRows();
            HashMap<String, Object> param = new HashMap<String, Object>();
            ArrayList numbers = new ArrayList(8);
            if (selectRows != null) {
                if (selectRowCount > 0 && selectRows.length > selectRowCount) {
                    view.showTipNotification(String.format(ResManager.loadKDString((String)"\u9009\u62e9\u884c\u4e0d\u80fd\u8d85\u8fc7%1$s\u884c\u3002", (String)"FeatureDefinitionSelectEditPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), selectRowCount));
                    return;
                }
                boolean isBigDecimal = false;
                String featureValueType = this.getView().getPageCache().get("featurevaluetype");
                String scaleStr = this.getView().getPageCache().get("scale");
                int scale = 0;
                if (StringUtils.isNotEmpty((CharSequence)scaleStr) && Pattern.matches("^[0-9]*$", scaleStr)) {
                    scale = Integer.parseInt(scaleStr);
                }
                if (StringUtils.equals((CharSequence)"B", (CharSequence)featureValueType)) {
                    isBigDecimal = true;
                }
                for (int i = 0; i < selectRows.length; ++i) {
                    Object entryValue = model.getValue(ENTRY_VALUE, selectRows[i]);
                    Object entryName = model.getValue(ENTRY_VALUE_NAME, selectRows[i]);
                    Object entryID = model.getValue(ENTRY_ID, selectRows[i]);
                    if (!(entryValue != null && !StringUtils.isEmpty((CharSequence)String.valueOf(entryValue)) || entryName != null && !StringUtils.isEmpty((CharSequence)String.valueOf(entryName)) || entryID != null && !StringUtils.isEmpty((CharSequence)String.valueOf(entryID)))) continue;
                    HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
                    if (isBigDecimal) {
                        if (StringUtils.isNotBlank((Object)entryValue) && Pattern.matches("^((-?\\d+)(\\.\\d+)?)|(-?\\d+)$", String.valueOf(entryValue))) {
                            paramMap.put(ENTRY_VALUE, new BigDecimal(String.valueOf(entryValue)).setScale(scale));
                        } else {
                            paramMap.put(ENTRY_VALUE, "");
                        }
                    } else {
                        paramMap.put(ENTRY_VALUE, entryValue);
                    }
                    paramMap.put(ENTRY_VALUE_NAME, entryName);
                    paramMap.put(ENTRY_ID, entryID);
                    numbers.add(paramMap);
                }
            }
            if (isEdit.booleanValue() && (cacheManualList = this.getManualData()) != null) {
                param.put("cachemanualdata", cacheManualList);
            }
            param.put("datas", numbers.isEmpty() ? "" : numbers);
            param.put("featurepkvalue", featureDefPK);
            this.getView().returnDataToParent(param);
            this.getView().close();
        }
    }

    private List<Map<String, Object>> getManualData() {
        ArrayList<Map<String, Object>> cacheManualList = new ArrayList<Map<String, Object>>(4);
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRY_ENTITY);
        if (entryEntity == null || entryEntity.isEmpty()) {
            return cacheManualList;
        }
        boolean isBigDecimal = false;
        String featureValueType = this.getView().getPageCache().get("featurevaluetype");
        String scaleStr = this.getView().getPageCache().get("scale");
        int scale = 0;
        if (StringUtils.isNotEmpty((CharSequence)scaleStr) && Pattern.matches("^[0-9]*$", scaleStr)) {
            scale = Integer.parseInt(scaleStr);
        }
        if (StringUtils.equals((CharSequence)"B", (CharSequence)featureValueType)) {
            isBigDecimal = true;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryDO = (DynamicObject)entryEntity.get(i);
            if (entryDO == null) continue;
            String entryValue = entryDO.getString(ENTRY_VALUE);
            String entryValueName = entryDO.getString(ENTRY_VALUE_NAME);
            String entryId = entryDO.getString(ENTRY_ID);
            if (!StringUtils.isNotEmpty((CharSequence)entryValue) && !StringUtils.isNotEmpty((CharSequence)entryValueName) && !StringUtils.isNotEmpty((CharSequence)entryId)) continue;
            HashMap<String, Object> manualDataMap = new HashMap<String, Object>(4);
            if (isBigDecimal) {
                if (StringUtils.isNotBlank((CharSequence)entryValue) && Pattern.matches("^((-?\\d+)(\\.\\d+)?)|(-?\\d+)$", String.valueOf(entryValue))) {
                    manualDataMap.put(ENTRY_VALUE, new BigDecimal(String.valueOf(entryValue)).setScale(scale));
                } else {
                    manualDataMap.put(ENTRY_VALUE, "");
                }
            } else {
                manualDataMap.put(ENTRY_VALUE, entryValue);
            }
            manualDataMap.put(ENTRY_VALUE_NAME, entryValueName);
            manualDataMap.put(ENTRY_ID, entryId);
            cacheManualList.add(manualDataMap);
        }
        return cacheManualList;
    }
}

