/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.superbom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.mmc.pdm.common.enums.StatusEnum;
import kd.mmc.pdm.common.util.MMCUtils;

public class SuperBOMBaseEdit
extends AbstractBillPlugIn {
    protected static Set<String> mOptCtls = new HashSet<String>();
    protected static Set<String> mTabPage = new HashSet<String>();
    protected static Set<String> mTabHeadFields = new HashSet<String>();
    protected static Set<String> mMaterialType = new HashSet<String>();
    protected static final String KEY_BASEUNIT = "baseunit";

    protected List<String> getOprVisibleCtls(String tabPageKey) {
        List<String> oprCtl = new ArrayList<String>();
        switch (tabPageKey) {
            case "tabpage_matchctlentry": {
                oprCtl.add("acptbi_mathctlentry_prev");
                oprCtl.add("acptbi_mathctlentry_next");
                oprCtl.add("flex_matchctlentry");
                break;
            }
            case "tabpage_chararule": {
                oprCtl = this.getCharaRuleVisibleCtls();
                break;
            }
        }
        return oprCtl;
    }

    private List<String> getCharaRuleVisibleCtls() {
        ArrayList<String> oprCtl = new ArrayList<String>();
        oprCtl.add("acptbi_chararule_prev");
        oprCtl.add("acptbi_chararuley_next");
        oprCtl.add("acptbi_chararule_new");
        oprCtl.add("acptbi_chararule_delete");
        oprCtl.add("flex_chararule");
        return oprCtl;
    }

    protected List<String> getOprHideCtls(String tabPageKey) {
        List<String> oprCtls = new ArrayList<String>();
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        String status = MMCUtils.getDataModelStringData((IDataModel)dm, (String)"status", (String)StatusEnum.SAVED.getValue());
        Boolean submitOrAudit = status.equals(StatusEnum.SUBMITED.getValue()) || status.equals(StatusEnum.AUDITED.getValue());
        int entryRowIndex = this.getEntryRowIndex();
        switch (tabPageKey) {
            case "tabpage_matchctlentry": {
                oprCtls = this.getMatchHideCtl(entryRowIndex);
                break;
            }
            case "tabpage_chararule": {
                oprCtls = this.getCharaRuleHideCtl(submitOrAudit, entryRowIndex);
                break;
            }
        }
        return oprCtls;
    }

    private List<String> getMatchHideCtl(int entryRowIndex) {
        ArrayList<String> oprCtls = new ArrayList<String>();
        if (entryRowIndex < 0) {
            oprCtls.add("flex_matchctlentry");
        }
        return oprCtls;
    }

    private List<String> getCharaRuleHideCtl(Boolean submitOrAudit, int entryRowIndex) {
        ArrayList<String> oprCtls = new ArrayList<String>();
        if (submitOrAudit.booleanValue()) {
            oprCtls.add("acptbi_chararule_new");
            oprCtls.add("acptbi_chararule_delete");
        }
        if (entryRowIndex < 0) {
            oprCtls.add("flex_chararule");
        }
        return oprCtls;
    }

    protected int getEntryRowIndex() {
        int entryRowIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        AbstractGrid.GridState entryGS = null;
        if (StringUtils.isNotBlank((Object)entryGrid)) {
            entryGS = entryGrid.getEntryState();
        }
        if (entryGS != null) {
            entryRowIndex = entryGS.getFocusRow();
        }
        return entryRowIndex;
    }

    protected String getPageSuffix(String tabPageKey) {
        String suffix = "";
        switch (tabPageKey) {
            case "tabpage_qtyentry": {
                suffix = "_qty";
                break;
            }
            case "tabpage_setupentry": {
                suffix = "_set";
                break;
            }
            case "tabpage_matchctlentry": {
                suffix = "_optctl";
                break;
            }
            case "tabpage_chararule": {
                suffix = "_rulctl";
                break;
            }
        }
        return suffix;
    }

    protected Boolean checkViewNotNull() {
        Boolean checkViewNotNull = Boolean.TRUE;
        IFormView fv = this.getView();
        if (fv == null || fv.getModel() == null) {
            checkViewNotNull = Boolean.FALSE;
        }
        return checkViewNotNull;
    }

    protected Boolean validTabSelected(TabSelectEvent evt) {
        Boolean validTabSelected = Boolean.TRUE;
        if (StringUtils.isBlank((Object)evt) || !this.checkViewNotNull().booleanValue() || StringUtils.isNotBlank((Object)evt) && StringUtils.isBlank((CharSequence)evt.getTabKey())) {
            validTabSelected = Boolean.FALSE;
        }
        return validTabSelected;
    }

    protected Boolean valideBeforeF7Select(BeforeF7SelectEvent evt) {
        ListFilterParameter lfp;
        Boolean valideBeforeF7Select = Boolean.TRUE;
        if (evt == null) {
            return Boolean.FALSE;
        }
        if (!this.checkViewNotNull().booleanValue()) {
            return Boolean.FALSE;
        }
        FormShowParameter fsp = evt.getFormShowParameter();
        ListShowParameter lsp = fsp instanceof ListShowParameter ? (ListShowParameter)fsp : null;
        ListFilterParameter listFilterParameter = lfp = lsp == null ? null : lsp.getListFilterParameter();
        if (StringUtils.isBlank((Object)lfp)) {
            valideBeforeF7Select = Boolean.FALSE;
        }
        return valideBeforeF7Select;
    }

    static {
        mOptCtls = new HashSet<String>();
        mOptCtls.add("qtyopt_optctl");
        mOptCtls.add("maxqtyopt_optctl");
        mOptCtls.add("minqtyopt_optctl");
        mOptCtls.add("opt_optctl");
        mOptCtls.add("preferopt_optctl");
        mOptCtls.add("mutuexcopt_optctl");
        mTabPage = new HashSet<String>();
        mTabPage.add("tabpage_qtyentry");
        mTabPage.add("tabpage_setupentry");
        mTabPage.add("tabpage_matchctlentry");
        mTabPage.add("tabpage_chararule");
        mTabHeadFields = new HashSet<String>();
        mTabHeadFields.add("entryseq");
        mTabHeadFields.add("entrymaterial");
        mTabHeadFields.add("entryunit");
        mTabHeadFields.add("entrymaterialname");
        mTabHeadFields.add("entrymaterialmodel");
        mMaterialType = new HashSet<String>();
        mMaterialType.add("4");
        mMaterialType.add("5");
    }
}

