/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.workcard;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.mmc.pdm.common.workcard.ToolRequireCardUpdateStatus;

public class ToolRequireCardEditPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"tbmain"});
    }

    public void afterBindData(EventObject e) {
        String source;
        super.afterBindData(e);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        if (null != entryentity) {
            for (DynamicObject entry : entryentity) {
                String toolstatus = entry.getString("toolstatus");
                int seq = entry.getInt("seq");
                if (StringUtils.equals((CharSequence)"A", (CharSequence)toolstatus)) {
                    this.setForeColor("toolstatus", seq - 1, "entryentity", "#276FF5");
                    continue;
                }
                if (StringUtils.equals((CharSequence)"B", (CharSequence)toolstatus)) {
                    this.setForeColor("toolstatus", seq - 1, "entryentity", "#FF991C");
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)toolstatus)) continue;
                this.setForeColor("toolstatus", seq - 1, "entryentity", "#1BA854");
            }
        }
        if (StringUtils.equals((CharSequence)"B", (CharSequence)(source = (String)this.getModel().getValue("source")))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"projectrange"});
        }
    }

    private void setForeColor(String field, int row, String entryNum, String colorcode) {
        ArrayList<CellStyle> style = new ArrayList<CellStyle>();
        CellStyle c1 = new CellStyle();
        c1.setForeColor(colorcode);
        c1.setFieldKey(field);
        c1.setRow(row);
        style.add(c1);
        EntryGrid entryGrid1 = (EntryGrid)this.getControl(entryNum);
        entryGrid1.setCellStyle(style);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        HashSet op = Sets.newHashSet((Object[])new String[]{"assign", "unassign", "updatetool", "updatenottool"});
        if (selectRows.length == 0 && op.contains(operateKey)) {
            String messgage = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u5de5\u5361\u3002", (String)"ToolRequireCardEditPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), this.getModel().getDataEntity().get("billno"));
            this.getView().showTipNotification(messgage);
            args.setCancel(true);
            return;
        }
        HashSet<Long> ids = new HashSet<Long>(16);
        for (int rowIndex = 0; rowIndex < selectRows.length; ++rowIndex) {
            Object entryPK = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(selectRows[rowIndex])).getPkValue();
            ids.add((Long)entryPK);
        }
        operate.getOption().setVariableValue("updateids", Joiner.on((String)"@@").skipNulls().join(ids));
        if ("assign".equals(operateKey)) {
            boolean flag = Boolean.FALSE;
            for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
                DynamicObjectCollection mulwarehouse = (DynamicObjectCollection)this.getModel().getValue("muluser", entryGrid.getSelectRows()[i]);
                if (mulwarehouse.isEmpty()) continue;
                flag = Boolean.TRUE;
            }
            if (flag) {
                ConfirmCallBackListener listener = new ConfirmCallBackListener("checkAssign", (IFormPlugin)this);
                String messgage = String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u5206\u914d\uff0c\u662f\u5426\u91cd\u65b0\u5206\u914d\uff1f", (String)"ToolRequireCardEditPlugin_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), this.getModel().getDataEntity().get("billno"));
                this.getView().showConfirm(messgage, MessageBoxOptions.YesNo, listener);
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs ade) {
        super.afterDoOperation(ade);
        String operateKey = ade.getOperateKey();
        if ("assign".equals(operateKey) && ade.getOperationResult().isSuccess()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("pdm_assign_person");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "assigncallback"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("checkAssign".equals(callBackId) && MessageBoxResult.Yes.equals((Object)(result = messageBoxClosedEvent.getResult()))) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("pdm_assign_person");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "assigncallback"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        HashMap returnData;
        String actionId = e.getActionId();
        if ("assigncallback".equals(actionId) && (returnData = (HashMap)e.getReturnData()) != null) {
            String maintenanceperson = (String)returnData.get("maintenanceperson");
            List updatePersonIds = Splitter.on((String)"@@").omitEmptyStrings().trimResults().splitToStream((CharSequence)maintenanceperson).map(Long::valueOf).collect(Collectors.toList());
            if (updatePersonIds != null && updatePersonIds.size() > 0) {
                HashSet<Object> entryidSet = new HashSet<Object>(16);
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
                DynamicObjectCollection objEntrys = this.getModel().getEntryEntity("entryentity");
                for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
                    DynamicObject entryRow = (DynamicObject)objEntrys.get(entryGrid.getSelectRows()[i]);
                    entryidSet.add(entryRow.getPkValue());
                }
                Object pkvalue = this.getModel().getDataEntity().getPkValue();
                HashSet<Long> ids = new HashSet<Long>(16);
                ids.add((Long)pkvalue);
                ToolRequireCardUpdateStatus.updateMuluser(ids, entryidSet, updatePersonIds);
                this.getView().invokeOperation("refresh");
            }
        }
        super.closedCallBack(e);
    }
}

