/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.workcard;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.pdm.common.workcard.ToolRequireCardUpdateStatus;

public class ToolRequireCardListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"tbmain"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selects = billList.getSelectedRows();
        HashSet<Long> entryids = new HashSet<Long>(16);
        HashSet<Long> ids = new HashSet<Long>(16);
        if (selects != null && !selects.isEmpty()) {
            for (int i = 0; i < selects.size(); ++i) {
                ListSelectedRow row = selects.get(i);
                Object entryPK = row.getEntryPrimaryKeyValue();
                Object primaryKeyValue = row.getPrimaryKeyValue();
                if (null != entryPK) {
                    entryids.add((Long)entryPK);
                }
                ids.add((Long)primaryKeyValue);
            }
            operate.getOption().setVariableValue("updateids", Joiner.on((String)"@@").skipNulls().join(entryids));
            String billNo = "";
            if ("assign".equals(operateKey)) {
                DynamicObject[] load;
                boolean flag = Boolean.FALSE;
                QFilter qf = new QFilter("id", "in", ids);
                String selectproperties = "id,billno,entryentity.cardnum,entryentity.moduser,entryentity.muluser,entryentity.moddate";
                for (DynamicObject tool : load = BusinessDataServiceHelper.load((String)"pdm_toolrequirecard", (String)selectproperties, (QFilter[])new QFilter[]{qf})) {
                    DynamicObjectCollection entrycoll = tool.getDynamicObjectCollection("entryentity");
                    for (DynamicObject eRow : entrycoll) {
                        DynamicObjectCollection muluser;
                        Long entryrid = (Long)eRow.getPkValue();
                        if (!entryids.contains(entryrid) || (muluser = (DynamicObjectCollection)eRow.get("muluser")).isEmpty()) continue;
                        flag = Boolean.TRUE;
                        billNo = tool.getString("billno");
                    }
                }
                if (flag) {
                    ConfirmCallBackListener listener = new ConfirmCallBackListener("checkAssign", (IFormPlugin)this);
                    String messgage = String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u5206\u914d\uff0c\u662f\u5426\u91cd\u65b0\u5206\u914d\uff1f", (String)"ToolRequireCardListPlugin_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), billNo);
                    this.getView().showConfirm(messgage, MessageBoxOptions.YesNo, listener);
                    args.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs ade) {
        super.afterDoOperation(ade);
        String operateKey = ade.getOperateKey();
        if ("assign".equals(operateKey) && ade.getOperationResult().isSuccess()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("pdm_assign_person");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "assigncallback"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("checkAssign".equals(callBackId) && MessageBoxResult.Yes.equals((Object)(result = messageBoxClosedEvent.getResult()))) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("pdm_assign_person");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "assigncallback"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        HashMap returnData;
        String actionId = e.getActionId();
        if ("assigncallback".equals(actionId) && (returnData = (HashMap)e.getReturnData()) != null) {
            String maintenanceperson = (String)returnData.get("maintenanceperson");
            List updatePersonIds = Splitter.on((String)"@@").omitEmptyStrings().trimResults().splitToStream((CharSequence)maintenanceperson).map(Long::valueOf).collect(Collectors.toList());
            if (updatePersonIds != null && updatePersonIds.size() > 0) {
                HashSet<Object> entryidSet = new HashSet<Object>(16);
                BillList billList = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selects = billList.getSelectedRows();
                if (selects != null && !selects.isEmpty()) {
                    HashSet<Long> ids = new HashSet<Long>(16);
                    for (int i = 0; i < selects.size(); ++i) {
                        ListSelectedRow row = selects.get(i);
                        Object entryPK = row.getEntryPrimaryKeyValue();
                        Object primaryKeyValue = row.getPrimaryKeyValue();
                        if (null != entryPK) {
                            entryidSet.add(entryPK);
                        }
                        ids.add((Long)primaryKeyValue);
                    }
                    ToolRequireCardUpdateStatus.updateMuluser(ids, entryidSet, updatePersonIds);
                }
                this.getView().invokeOperation("refresh");
            }
        }
        super.closedCallBack(e);
    }
}

