/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.bom;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class BomRptHeadFilterHelper {
    private static final Log log = LogFactory.getLog(BomRptHeadFilterHelper.class);
    private static final int IDBATCHMAXSIZE = 50000;

    private static Set<String> getAllFiledSet(RowMeta rowMeta) {
        Field[] allFields = rowMeta.getFields();
        HashSet<String> fieldSet = new HashSet<String>(allFields.length);
        for (Field field : allFields) {
            fieldSet.add(field.getName().toUpperCase());
        }
        return fieldSet;
    }

    public static DataSet setHeadFilter(ReportQueryParam reportQueryParam, DataSet srcData, Map<String, String> fieldEntityMap) {
        List headFilters = reportQueryParam.getFilter().getHeadFilters();
        if (headFilters != null && !headFilters.isEmpty()) {
            RowMeta rowMeta = srcData.getRowMeta();
            Set<String> allFieldSet = BomRptHeadFilterHelper.getAllFiledSet(rowMeta);
            for (QFilter headFilter : headFilters) {
                Object value = headFilter.getValue();
                String fieldNumber = headFilter.getProperty();
                if (StringUtils.isEmpty((String)fieldNumber) || !allFieldSet.contains(fieldNumber.toUpperCase())) continue;
                Field field = rowMeta.getField(fieldNumber);
                DataType dataType = field.getDataType();
                if (value instanceof Date) {
                    HashMap<String, Object> params = new HashMap<String, Object>(1);
                    srcData = srcData.filter(BomRptHeadFilterHelper.getDateFilter(headFilter, params), params);
                    continue;
                }
                String entityId = fieldEntityMap.get(fieldNumber + "_entity");
                String entityField = fieldEntityMap.get(fieldNumber + "_field");
                if (!StringUtils.isEmpty((String)entityId)) {
                    srcData = srcData.filter(BomRptHeadFilterHelper.getBaseDynamicObjectSql(headFilter, entityId, fieldNumber, entityField));
                    continue;
                }
                if ("is null".equals(headFilter.getCP()) || "is not null".equals(headFilter.getCP())) {
                    headFilter.__setValue(null);
                }
                if (DataType.TimestampType.equals((Object)dataType) && "=".equals(headFilter.getCP()) && headFilter.getValue() instanceof String) {
                    Date startDate = BomRptHeadFilterHelper.parseDate(headFilter.getValue().toString());
                    headFilter.__setCP(">=");
                    headFilter.__setValue((Object)startDate);
                    Date endDate = BomRptHeadFilterHelper.addDate(startDate, 1);
                    headFilter.and(headFilter.getProperty(), "<", (Object)endDate);
                    HashMap<String, Object> params = new HashMap<String, Object>(1);
                    srcData = srcData.filter(BomRptHeadFilterHelper.getDateFilter(headFilter, params), params);
                    continue;
                }
                if (DataType.BigDecimalType.equals((Object)dataType)) {
                    headFilter.__setValue((Object)new BigDecimal((String)headFilter.getValue()));
                } else if (DataType.LongType.equals((Object)dataType)) {
                    headFilter.__setValue((Object)Long.parseLong((String)headFilter.getValue()));
                } else if (DataType.IntegerType.equals((Object)dataType)) {
                    headFilter.__setValue((Object)Integer.parseInt((String)headFilter.getValue()));
                }
                srcData = srcData.filter(headFilter.toString());
            }
        }
        return srcData;
    }

    private static Date addDate(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        return calendar.getTime();
    }

    private static Date parseDate(String dateStr) {
        Date date = null;
        if (StringUtils.isEmpty((String)dateStr)) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sd.parse(dateStr);
        }
        catch (ParseException e) {
            log.error((Throwable)e);
        }
        return date;
    }

    private static String getDateFilter(QFilter headFilter, Map<String, Object> params) {
        StringBuilder filter = new StringBuilder();
        int i = 1;
        Date date = (Date)headFilter.getValue();
        params.put("date1", date);
        filter.append(headFilter.getProperty()).append(" ").append(headFilter.getCP()).append(" ").append("date1").append(" ");
        List nests = headFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter qFilter = nest.getFilter();
            Date date2 = (Date)qFilter.getValue();
            params.put("date" + (i + 1), date2);
            filter.append(nest.getOp()).append(" ").append(qFilter.getProperty()).append(" ").append(qFilter.getCP()).append(" ").append("date").append(i + 1).append(" ");
        }
        return filter.toString();
    }

    private static String getBaseDynamicObjectSql(QFilter qFilter, String entityName, String filed, String baseFieldName) {
        int size;
        StringBuilder partSql = new StringBuilder();
        String filterCP = qFilter.getCP();
        if (filterCP.contains("is null")) {
            return filed + " = 0";
        }
        if (filterCP.contains("not null")) {
            return filed + " > 0";
        }
        String filterField = StringUtils.isEmpty((String)baseFieldName) ? "number" : baseFieldName;
        qFilter.__setProperty(filterField);
        List nests = qFilter.getNests(true);
        if (nests != null) {
            qFilter.clearNests();
            for (QFilter.QFilterNest qFilterNest : nests) {
                QFilter filter = qFilterNest.getFilter();
                filter.__setProperty(filterField);
                qFilter.addFirstNest(filter, "and");
            }
        }
        DynamicObjectCollection dynamicObject = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qFilter.toArray());
        Iterator iterator = dynamicObject.iterator();
        ArrayList<String> longs = new ArrayList<String>(64);
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            longs.add(next.getString("id"));
        }
        if (longs.isEmpty()) {
            longs.add("0");
        }
        if ((size = longs.size()) > 50000) {
            throw new KDBizException(new ErrorCode("BomRptHeadFilterHelper", String.format(ResManager.loadKDString((String)"\u5b9e\u4f53[%1$s]\u4e0b\u7684\u5b57\u6bb5[%2$s]\u5728\u4f9d\u636e\u8fc7\u6ee4\u6761\u4ef6[%3$s]\u8fdb\u884cID\u67e5\u8be2\u65f6\u6570\u636e\u91cf\u8d85\u8fc7\u4e86\u6700\u5927\u503c[%4$s],\u8bf7\u8c03\u6574\u3002", (String)"BomRptHeadFilterHelper_01", (String)"mmc-pdm-common", (Object[])new Object[0]), entityName, filed, qFilter, 50000)), new Object[0]);
        }
        partSql.append(filed).append(" in (");
        if (size == 1) {
            partSql.append((String)longs.get(0));
        } else {
            for (String aLong : longs) {
                partSql.append(aLong).append(",");
            }
            partSql.deleteCharAt(partSql.length() - 1);
        }
        partSql.append(')');
        return partSql.toString();
    }

    public static void buildDefaultBaseDataMap(Map<String, String> entityMap) {
        entityMap.put("rootmaterialid_entity", "bd_material");
        entityMap.put("rootmaterialid_field", "number");
        entityMap.put("rootmaterialname_entity", "bd_material");
        entityMap.put("rootmaterialname_field", "name");
        entityMap.put("materialid_entity", "bd_material");
        entityMap.put("materialid_field", "number");
        entityMap.put("materialname_entity", "bd_material");
        entityMap.put("materialname_field", "name");
        entityMap.put("materialmodel_entity", "bd_material");
        entityMap.put("materialmodel_field", "modelnum");
        entityMap.put("entrymaterialid_entity", "bd_material");
        entityMap.put("entrymaterialid_field", "number");
        entityMap.put("entrymaterialname_entity", "bd_material");
        entityMap.put("entrymaterialname_field", "name");
        entityMap.put("entrymaterialmodel_entity", "bd_material");
        entityMap.put("entrymaterialmodel_field", "modelnum");
        entityMap.put("featuretype_entity", "mpdm_featuretype");
        entityMap.put("featuretype_field", "number");
        entityMap.put("featuretypename_entity", "mpdm_featuretype");
        entityMap.put("featuretypename_field", "name");
        entityMap.put("version_entity", "bd_bomversion_new");
        entityMap.put("version_field", "name");
        entityMap.put("entryversion_entity", "bd_bomversion_new");
        entityMap.put("entryversion_field", "name");
        entityMap.put("pconfigcode_entity", "bd_configuredcode");
        entityMap.put("pconfigcode_field", "number");
        entityMap.put("entryconfigcode_entity", "bd_configuredcode");
        entityMap.put("entryconfigcode_field", "number");
        entityMap.put("unit_entity", "bd_measureunits");
        entityMap.put("unit_field", "name");
        entityMap.put("entryunit_entity", "bd_measureunits");
        entityMap.put("entryunit_field", "name");
        entityMap.put("rootfeaturetype_entity", "mpdm_featuretype");
        entityMap.put("rootfeaturetype_field", "number");
        entityMap.put("rootfeaturetypename_entity", "mpdm_featuretype");
        entityMap.put("rootfeaturetypename_field", "name");
        entityMap.put("wbs_entity", "bd_wbs");
        entityMap.put("wbs_field", "name");
        entityMap.put("productmaterialid_entity", "bd_material");
        entityMap.put("productmaterialid_field", "number");
        entityMap.put("productmaterialid1_entity", "bd_material");
        entityMap.put("productmaterialid1_field", "number");
    }
}

