/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.bom.bean;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.mmc.pdm.common.bom.bean.BOMEntryBean;

public class BOMBean {
    public final Long id;
    private String number;
    private String materialid;
    private Long bomvison;
    public final List<BOMEntryBean> entrys = new ArrayList<BOMEntryBean>();

    public BOMBean(Long id) {
        this.id = id;
    }

    public static BOMBean toBOMBean(DynamicObject bomdynamicObj, Date expendbomtime) {
        if (bomdynamicObj == null) {
            return null;
        }
        BOMBean bom = new BOMBean(Long.parseLong(bomdynamicObj.getPkValue().toString()));
        bom.number = bomdynamicObj.getString("number");
        bom.materialid = bomdynamicObj.getDynamicObject("material").getPkValue().toString();
        bom.bomvison = bomdynamicObj.getDynamicObject("version") == null ? 0L : Long.parseLong(bomdynamicObj.getDynamicObject("version").getPkValue().toString());
        DynamicObjectCollection bomentrys = bomdynamicObj.getDynamicObjectCollection("entry");
        for (int i = 0; i < bomentrys.size(); ++i) {
            DynamicObject entryecn;
            DynamicObject entry = (DynamicObject)bomentrys.get(i);
            BOMEntryBean e = new BOMEntryBean(bom, Long.parseLong(entry.getPkValue().toString()));
            e.setValiddate(entry.getDate("entryvaliddate"));
            e.setInvaliddate(entry.getDate("entryinvaliddate"));
            if (e.getValiddate() == null) {
                e.setValiddate(expendbomtime);
            }
            if (e.getInvaliddate() == null) {
                e.setInvaliddate(expendbomtime);
            }
            if ((entryecn = entry.getDynamicObject("entryecn")) == null) {
                e.setEcn_validdate(e.getValiddate());
                e.setEcn_invaliddate(e.getInvaliddate());
                e.setEcnid(0L);
                e.setEcn_vison("0");
            } else {
                e.setEcn_validdate(entryecn.getDate("validdate"));
                e.setEcn_invaliddate(entryecn.getDate("invaliddate"));
                e.setEcnid(Long.parseLong(entryecn.getPkValue().toString()));
                e.setEcn_vison(entryecn.getString("number"));
            }
            e.setMaterialid(Long.parseLong(entry.getDynamicObject("entrymaterial").getPkValue().toString()));
            e.setBomvison(entry.getDynamicObject("entryversion") == null ? 0L : Long.parseLong(entry.getDynamicObject("entryversion").getPkValue().toString()));
        }
        return bom;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getMaterialid() {
        return this.materialid;
    }

    public void setMaterialid(String materialid) {
        this.materialid = materialid;
    }

    public Long getBomvison() {
        return this.bomvison;
    }

    public void setBomvison(Long bomvison) {
        this.bomvison = bomvison;
    }
}

