/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.bom.ecoplatform;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.form.operate.MutexHelper;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;

public class OrderMutexLockUtils {
    private static final String STOCKLOCKOP = "change";

    public static void releaseLock(Set<Long> ids, String entityNumber) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        for (Long id : ids) {
            MutexHelper.release((String)entityNumber, (String)STOCKLOCKOP, (String)String.valueOf(id));
        }
    }

    public static String addAllLocks(List<Map<String, Object>> allData, Map<String, Set<Long>> successIdMaps, String billType) {
        HashSet<String> repeatSet = new HashSet<String>(16);
        return OrderMutexLockUtils.addAllLocks(allData, successIdMaps, repeatSet, billType);
    }

    public static String addAllLocks(List<Map<String, Object>> allData, Map<String, Set<Long>> successIdMaps, Set<String> repeatSet, String billType) {
        StringBuilder lockDetialMsg = new StringBuilder();
        HashSet<String> unLockStockIdSet = new HashSet<String>(16);
        String isLockField = OrderMutexLockUtils.getIsLockField(billType);
        String orderTypeField = OrderMutexLockUtils.getOrderTypeField(billType);
        for (Map<String, Object> data : allData) {
            Long billId = OrderMutexLockUtils.getBillId(data, billType);
            String orderType = (String)data.get(orderTypeField);
            String keyString = billId + "_" + orderType;
            if (repeatSet.add(keyString)) {
                StringBuilder lockMsg;
                String entityNumber = OrderMutexLockUtils.getEntityByOrderType(orderType, billType);
                boolean mutex = MutexHelper.require((String)entityNumber, (Object)billId, (String)STOCKLOCKOP, (boolean)true, (StringBuilder)(lockMsg = new StringBuilder()));
                if (mutex) {
                    Set<Long> ids = successIdMaps.get(orderType);
                    if (ids == null) {
                        ids = new HashSet<Long>(16);
                    }
                    ids.add(billId);
                    successIdMaps.put(orderType, ids);
                } else {
                    unLockStockIdSet.add(keyString);
                    lockDetialMsg.append(String.join((CharSequence)"\uff1a", OrderMutexLockUtils.getBillNo(data, billType), lockMsg.toString())).append("\r\n");
                }
            }
            if (unLockStockIdSet.contains(keyString)) {
                data.put(isLockField, Boolean.TRUE);
                continue;
            }
            data.put(isLockField, Boolean.FALSE);
        }
        return lockDetialMsg.toString();
    }

    private static boolean isManuftechBill(String billType) {
        return "B".equals(billType);
    }

    private static Long getBillId(Map<String, Object> data, String billType) {
        if (OrderMutexLockUtils.isManuftechBill(billType)) {
            return OrderMutexLockUtils.getTechId(data);
        }
        return OrderMutexLockUtils.getStockId(data);
    }

    private static String getBillNo(Map<String, Object> data, String billType) {
        if (OrderMutexLockUtils.isManuftechBill(billType)) {
            return OrderMutexLockUtils.getTechBillNo(data);
        }
        return OrderMutexLockUtils.getStockBillNo(data);
    }

    private static Long getStockId(Map<String, Object> data) {
        Long stockId = (Long)data.get("stockid");
        if (PlatformUtils.isNullLong(stockId)) {
            stockId = (Long)data.get("id");
        }
        return stockId;
    }

    private static String getStockBillNo(Map<String, Object> data) {
        String stockBillNo = (String)data.get("stockno");
        if (PlatformUtils.isNullString(stockBillNo)) {
            stockBillNo = (String)data.get("billno");
        }
        return stockBillNo;
    }

    private static Long getTechId(Map<String, Object> data) {
        Long techId = (Long)data.get("techidsfc");
        if (PlatformUtils.isNullLong(techId)) {
            techId = (Long)data.get("id");
        }
        return techId;
    }

    private static String getIsLockField(String billType) {
        return OrderMutexLockUtils.isManuftechBill(billType) ? "islocksfc" : "islock";
    }

    private static String getOrderTypeField(String billType) {
        return OrderMutexLockUtils.isManuftechBill(billType) ? "ordertypesfc" : "ordertype";
    }

    private static String getTechBillNo(Map<String, Object> data) {
        String techBillNo = (String)data.get("technosfc");
        if (PlatformUtils.isNullString(techBillNo)) {
            techBillNo = (String)data.get("billno");
        }
        return techBillNo;
    }

    private static String getEntityByOrderType(String orderType, String billType) {
        if (OrderMutexLockUtils.isManuftechBill(billType)) {
            return "A".equals(orderType) ? "sfc_manftech" : "om_mfttechnics";
        }
        return "A".equals(orderType) ? "pom_mftstock" : "om_mftstock";
    }

    public static void clearAllLocks(Map<String, Set<Long>> dataMap, String billType) {
        if (dataMap == null || dataMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Set<Long>> datas : dataMap.entrySet()) {
            String orderType = datas.getKey();
            Set<Long> billIdset = datas.getValue();
            String entityNumber = OrderMutexLockUtils.getEntityByOrderType(orderType, billType);
            OrderMutexLockUtils.releaseLock(billIdset, entityNumber);
        }
    }
}

