/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.bom.ecoplatform;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.UrlUtil;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.common.bom.bean.Fraction;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;

public class PlatformUtils {
    private static final byte[] empty_bs = new byte[0];
    private static final Pattern pattern = Pattern.compile("^[+-@=](.*?)\\d$");

    public static void openBillInfoShowPage(String billNumber, Long billId, IReportView view, OperationStatus value) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(billNumber);
        showParameter.setPkId((Object)billId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(value);
        view.showForm((FormShowParameter)showParameter);
    }

    public static boolean checkBillExist(Long billId) {
        QFilter billFilter = new QFilter("id", "=", (Object)billId);
        boolean isExists = false;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)PlatformUtils.class.getName(), (String)"pdm_bom_eco", (String)"id", (QFilter[])new QFilter[]{billFilter}, null);){
            if (dataSet.hasNext()) {
                isExists = true;
            }
        }
        return isExists;
    }

    public static List<Long> getMyPermissOrgUnit(Long userId, String appId, String entityNum, String permItemId) {
        return PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)appId, (String)entityNum, (String)permItemId);
    }

    public static Date addInteger(Date date, int dateType, int amount) {
        Date myDate = null;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(dateType, amount);
            myDate = calendar.getTime();
        }
        return myDate;
    }

    public static Date addDay(Date date, int dayAmount) {
        return PlatformUtils.addInteger(date, 5, dayAmount);
    }

    public static Date addSecond(Date date, int dayAmount) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, dayAmount);
        return calendar.getTime();
    }

    public static boolean isDiffBoolean(boolean b1, boolean b2) {
        return !(b1 && b2 || !b1 && !b2);
    }

    public static boolean isDiffDate(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return false;
        }
        if (date1 == null || date2 == null) {
            return true;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return !sdf.format(date1).equals(sdf.format(date2));
    }

    public static boolean isDiffString(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return false;
        }
        if (s1 == null || s2 == null) {
            return true;
        }
        return !s1.equals(s2);
    }

    public static boolean isDiffDynamicObject(DynamicObject d1, DynamicObject d2) {
        Object d1Pk = d1 == null ? Long.valueOf(0L) : d1.getPkValue();
        Object d2Pk = d2 == null ? Long.valueOf(0L) : d2.getPkValue();
        return !d1Pk.equals(d2Pk);
    }

    public static void addList(List<DynamicObject> list, DynamicObject dy) {
        Object pk = dy.getPkValue();
        if (pk == null || pk.equals(0L)) {
            list.add(dy);
            return;
        }
        for (DynamicObject dy2 : list) {
            if (!dy2.getPkValue().equals(pk)) continue;
            return;
        }
        list.add(dy);
    }

    public static Set<Long> jsonArrayToSet(JSONArray jsArray) {
        int size = jsArray.size();
        HashSet<Long> set = new HashSet<Long>(size);
        for (int i = 0; i < size; ++i) {
            set.add(jsArray.getLong(i));
        }
        return set;
    }

    public static boolean isNullJsonObject(JSONObject data) {
        return data == null || data.isEmpty() || data.size() < 1;
    }

    public static boolean isNullSet(Set data) {
        return data == null || data.isEmpty();
    }

    public static boolean isNullList(List data) {
        return data == null || data.isEmpty();
    }

    public static boolean isNullLong(Long data) {
        return data == null || data.equals(0L);
    }

    public static boolean isNullString(String data) {
        return StringUtils.isEmpty((String)data);
    }

    public static boolean isNullDataSet(DataSet data) {
        return data == null || data.isEmpty();
    }

    public static boolean isNullCollection(DynamicObjectCollection data) {
        return data == null || data.isEmpty();
    }

    public static Long getLongValue(Map<String, Object> data, String field) {
        Object value = data.get(field);
        return value == null ? 0L : (value instanceof Integer ? Long.parseLong(value.toString()) : (value instanceof Long ? (Long)value : Long.parseLong(value.toString())));
    }

    public static int getIntValue(Map<String, Object> data, String field) {
        Object value = data.get(field);
        return value == null ? 0 : (value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString()));
    }

    public static BigDecimal getBigDecimalValue(Map<String, Object> data, String field) {
        Object value = data.get(field);
        return value == null ? BigDecimal.ZERO : (value instanceof Integer ? new BigDecimal(value.toString()) : (BigDecimal)value);
    }

    public static Date getDateValue(Map<String, Object> data, String field) {
        Object value = data.get(field);
        return value == null ? null : (value instanceof Long ? new Date((Long)value) : (Date)value);
    }

    public static String getStringValue(Map<String, Object> data, String field) {
        Object value = data.get(field);
        return value == null ? "" : (value instanceof String ? (String)value : value.toString());
    }

    public static boolean getBooleanValue(Map<String, Object> data, String field) {
        Object value = data.get(field);
        return value == null || "".equals(value.toString()) || "0".equals(value.toString()) ? false : (Boolean)value;
    }

    public static boolean isStop(String pageCacheOption) {
        PageCache pageCache = new PageCache(pageCacheOption);
        String startProgress = pageCache.get("opProgressStop");
        return "1".equals(startProgress);
    }

    public static Set<Long> ListToSet(List<Object> list) {
        HashSet<Long> set = new HashSet<Long>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            set.add((Long)list.get(i));
        }
        return set;
    }

    public static String getUnionString(Object obj1, Object obj2) {
        StringBuilder sb = new StringBuilder();
        sb.append(obj1 == null ? "" : obj1.toString());
        sb.append("_");
        sb.append(obj2 == null ? "" : obj2.toString());
        return sb.toString();
    }

    public static String getUnionString(Object obj1, Object obj2, Object obj3, Object obj4) {
        StringBuilder sb = new StringBuilder();
        sb.append(obj1 == null ? "" : obj1.toString());
        sb.append("_");
        sb.append(obj2 == null ? "" : obj2.toString());
        sb.append("_");
        sb.append(obj3 == null ? "" : obj3.toString());
        sb.append("_");
        sb.append(obj4 == null ? "" : obj4.toString());
        return sb.toString();
    }

    public static Long getEcoBomId(String keyString) {
        int idx = keyString.indexOf("_");
        return Long.parseLong(keyString.substring(0, idx));
    }

    public static String getGroupNo(String keyString) {
        int idx = keyString.indexOf("_");
        return keyString.substring(idx + 1);
    }

    public static Set<Long> ParseStringToLongSet(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return new HashSet<Long>(16);
        }
        str = str.replace("[", "");
        str = str.replace("]", "");
        String[] array = str.split(",");
        int size = array.length;
        HashSet<Long> set = new HashSet<Long>(size);
        for (int i = 0; i < size; ++i) {
            String value = array[i];
            if (StringUtils.isEmpty((String)value)) continue;
            value = value.trim();
            set.add(Long.parseLong(value));
        }
        return set;
    }

    public static List<Long> ParseStringToLongList(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return new ArrayList<Long>(16);
        }
        str = str.replace("[", "");
        str = str.replace("]", "");
        String[] array = str.split(",");
        int size = array.length;
        ArrayList<Long> set = new ArrayList<Long>(size);
        for (int i = 0; i < size; ++i) {
            String value = array[i];
            if (StringUtils.isEmpty((String)value)) continue;
            value = value.trim();
            set.add(Long.parseLong(value));
        }
        return set;
    }

    public static Set<String> ParseStringToSet(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return new HashSet<String>(16);
        }
        str = str.replace("[", "");
        str = str.replace("]", "");
        String[] array = str.split(",");
        int size = array.length;
        HashSet<String> set = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            String value = array[i];
            if (StringUtils.isEmpty((String)value)) continue;
            set.add(value.trim());
        }
        return set;
    }

    public static String getErrorMsg(OperationResult operationResult) {
        StringBuilder errMsg = new StringBuilder();
        List validateErrors = operationResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateResult : validateErrors) {
            List allErrorInfo = validateResult.getAllErrorInfo();
            allErrorInfo.forEach(operateErrorInfo -> {
                String message = operateErrorInfo.getMessage();
                errMsg.append(message);
            });
        }
        if (errMsg.length() < 1 && !operationResult.getAllErrorInfo().isEmpty()) {
            errMsg.append(operationResult.getAllErrorInfo());
        }
        if (errMsg.length() < 1 && !operationResult.isSuccess() && operationResult.getMessage() != null) {
            errMsg.append(operationResult.getMessage());
        }
        if (errMsg.length() < 1 && operationResult.getInteractionContext() != null && operationResult.getInteractionContext().getSimpleMessage() != null) {
            errMsg.append(operationResult.getInteractionContext().getSimpleMessage());
        }
        if (errMsg.length() < 1 && !operationResult.isSuccess()) {
            errMsg.append(operationResult.toString());
        }
        return errMsg.toString();
    }

    public static QFilter getQFilter(String filterContent, String entityName) {
        FilterBuilder fb = PlatformUtils.getFilterBuilder(filterContent, entityName);
        return fb.getQFilter();
    }

    public static FilterBuilder getFilterBuilder(String filterContent, String entityName) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterContent, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(entityType, filterCondition);
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        return fb;
    }

    public static String getSimpleExceptionString(Exception ex) {
        String msg = ex.getMessage();
        if (StringUtils.isEmpty((String)msg)) {
            msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
        }
        return msg;
    }

    public static String getExceptionString(Exception ex) {
        return ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
    }

    public static Date getMaxDate(Date d1, Date d2) {
        return d1.compareTo(d2) >= 0 ? d1 : d2;
    }

    public static Date getMinDate(Date d1, Date d2) {
        return d1.compareTo(d2) <= 0 ? d1 : d2;
    }

    public static Long getFirstLongValueFromMap(Map<Long, Long> dataMap) {
        if (dataMap == null || dataMap.isEmpty()) {
            return 0L;
        }
        return dataMap.entrySet().iterator().next().getValue();
    }

    public static DynamicObject copyDynamicObject(DynamicObject sourceObj) {
        if (sourceObj == null) {
            return null;
        }
        DynamicObject copyObj = new DynamicObject(sourceObj.getDynamicObjectType());
        DataEntityPropertyCollection properties = sourceObj.getDynamicObjectType().getProperties();
        for (IDataEntityProperty propertyName : properties) {
            copyObj.set(propertyName, sourceObj.get(propertyName));
        }
        return copyObj;
    }

    public static Set<String> ParseLongToStringSet(Set<Long> longSet) {
        if (longSet == null) {
            return null;
        }
        HashSet<String> sSet = new HashSet<String>(longSet.size());
        for (Long id : longSet) {
            sSet.add(String.valueOf(id));
        }
        return sSet;
    }

    public static List<Object> getPkIdsFromMap(Map<String, Object> returnMap, String paramName) {
        ArrayList<Object> sucessPkIds = new ArrayList<Object>(16);
        if (returnMap == null) {
            return sucessPkIds;
        }
        Object result = returnMap.get(paramName);
        if (result == null) {
            return sucessPkIds;
        }
        if (result instanceof JSONArray) {
            for (Object json : (JSONArray)result) {
                sucessPkIds.add(json);
            }
            return sucessPkIds;
        }
        if (result instanceof List) {
            return (ArrayList)result;
        }
        return sucessPkIds;
    }

    public static boolean isDisableGroupNo() {
        return PdmParamSetHelper.getBooleanParamValue("ECN_DisableGroupNo");
    }

    /*
     * Exception decompiling
     */
    public static final byte[] encode(Object object) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final String decodeToString(byte[] bs) {
        if (bs == null) {
            return "";
        }
        Object ret = PlatformUtils.decode(bs);
        if (ret == null) {
            return null;
        }
        if (ret instanceof String) {
            return (String)ret;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static final Object decode(byte[] bs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void addFilePermission(String url, String appid, String entity, String permissionid) {
        String tempFileId = UrlUtil.getParam((String)url, (String)"id");
        HashMap<String, String> refEntitiyMap = new HashMap<String, String>(2);
        refEntitiyMap.put("entityNum", entity);
        refEntitiyMap.put("appId", appid);
        refEntitiyMap.put("permissionItemId", permissionid);
        DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", true);
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
    }

    public static Fraction qtyMul(BigDecimal parentMole, BigDecimal parentDone, BigDecimal childMole, BigDecimal childDone) {
        BigDecimal newMole = MMCUtils.multiply(parentMole, childMole);
        BigDecimal newDone = parentDone.multiply(childDone);
        return PlatformUtils.getDivideComQty(newMole, newDone);
    }

    public static boolean isIntBigdecimal(BigDecimal value) {
        int valueInt = value.intValue();
        return value.compareTo(new BigDecimal(valueInt)) == 0;
    }

    public static Fraction convertToFraction(BigDecimal qty) {
        if (PlatformUtils.isIntBigdecimal(qty) || qty.compareTo(BigDecimal.ZERO) == 0) {
            return new Fraction(qty, BigDecimal.ONE);
        }
        int decimalPlaces = String.valueOf(qty).split("\\.")[1].length();
        BigDecimal done = BigDecimal.valueOf(Math.pow(10.0, decimalPlaces));
        BigDecimal mole = MMCUtils.multiply(qty, done);
        return PlatformUtils.getDivideComQty(mole, done);
    }

    public static Fraction qtyAdd(BigDecimal oldMole, BigDecimal oldDone, BigDecimal newMole, BigDecimal newDone) {
        BigDecimal comDone = MMCUtils.multiply(oldDone, newDone);
        BigDecimal oldMole2 = MMCUtils.multiply(oldMole, newDone);
        BigDecimal newMole2 = MMCUtils.multiply(newMole, oldDone);
        BigDecimal addMole = newMole2.add(oldMole2);
        Fraction addFraction = PlatformUtils.getDivideComQty(addMole, comDone);
        if (addFraction.getMole().compareTo(BigDecimal.ZERO) == 0) {
            if (oldDone.compareTo(newDone) == 0) {
                addFraction.setDone(oldDone);
            } else {
                addFraction.setDone(newDone);
            }
        }
        return addFraction;
    }

    public static Fraction qtySub(BigDecimal oldMole, BigDecimal oldDone, BigDecimal newMole, BigDecimal newDone) {
        BigDecimal comDone = MMCUtils.multiply(oldDone, newDone);
        BigDecimal oldMole2 = MMCUtils.multiply(oldMole, newDone);
        BigDecimal newMole2 = MMCUtils.multiply(newMole, oldDone);
        BigDecimal diffMole = newMole2.subtract(oldMole2);
        return PlatformUtils.getDivideComQty(diffMole, comDone);
    }

    public static Fraction getDivideComQty(BigDecimal mole, BigDecimal done) {
        BigDecimal com;
        if (mole.compareTo(BigDecimal.ZERO) == 0 || done.compareTo(BigDecimal.ZERO) == 0) {
            mole = BigDecimal.ZERO;
            done = BigDecimal.ONE;
        } else if (done.compareTo(BigDecimal.ONE) != 0 && (com = PlatformUtils.getCom(mole.abs(), done)).compareTo(BigDecimal.ONE) != 0) {
            mole = MMCUtils.divide(mole, com);
            done = MMCUtils.divide(done, com);
        }
        return new Fraction(mole, done);
    }

    public static BigDecimal getCom(BigDecimal num1, BigDecimal num2) {
        while (num2.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal temp = num2;
            num2 = num1.remainder(num2);
            num1 = temp;
        }
        return num1;
    }

    public static String excelCSVChar(String value) {
        if (value == null || "".equals(value)) {
            return value;
        }
        String firstChar = value.substring(0, 1);
        if (firstChar.equals("+") || firstChar.equals("-") || firstChar.equals("@") || firstChar.equals("=")) {
            value = "\t" + value;
        } else if ((value.startsWith("\"+") || value.startsWith("\"-") || value.startsWith("\"@") || value.startsWith("\"=")) && value.endsWith("\"")) {
            value = "\t" + value;
        }
        return value;
    }

    public static Long getDynamicObjectId(DynamicObject dy) {
        if (dy == null) {
            return 0L;
        }
        return (Long)dy.getPkValue();
    }
}

