/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.enums;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public enum CodeTypeItemEnum {
    TXT(CodeTypeItemEnum.getTxtName(), "A"),
    DATE(CodeTypeItemEnum.getDateName(), "B"),
    SEQ(CodeTypeItemEnum.getSeqName(), "C"),
    CONST(CodeTypeItemEnum.getCountName(), "D"),
    SERIALNUM(CodeTypeItemEnum.getSerialNumName(), "E");

    private String name;
    private String value;

    private CodeTypeItemEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    private static String getTxtName() {
        return ResManager.loadKDString((String)"\u6587\u672c", (String)"CodeTypeItemEnum_0", (String)"mmc-pdm-common", (Object[])new Object[0]);
    }

    private static String getDateName() {
        return ResManager.loadKDString((String)"\u65e5\u671f", (String)"CodeTypeItemEnum_1", (String)"mmc-pdm-common", (Object[])new Object[0]);
    }

    private static String getSeqName() {
        return ResManager.loadKDString((String)"\u884c\u53f7", (String)"CodeTypeItemEnum_2", (String)"mmc-pdm-common", (Object[])new Object[0]);
    }

    private static String getCountName() {
        return ResManager.loadKDString((String)"\u5e38\u91cf", (String)"CodeTypeItemEnum_3", (String)"mmc-pdm-common", (Object[])new Object[0]);
    }

    private static String getSerialNumName() {
        return ResManager.loadKDString((String)"\u6d41\u6c34\u53f7", (String)"CodeTypeItemEnum_4", (String)"mmc-pdm-common", (Object[])new Object[0]);
    }

    private String getEnumName() {
        switch (this) {
            case TXT: {
                return CodeTypeItemEnum.getTxtName();
            }
            case DATE: {
                return CodeTypeItemEnum.getDateName();
            }
            case SEQ: {
                return CodeTypeItemEnum.getSeqName();
            }
            case CONST: {
                return CodeTypeItemEnum.getCountName();
            }
            case SERIALNUM: {
                return CodeTypeItemEnum.getSerialNumName();
            }
        }
        return "";
    }

    public String getName() {
        return this.getEnumName();
    }

    public String getValue() {
        return this.value;
    }

    public static String getName(String value) {
        String name = null;
        for (CodeTypeItemEnum type : CodeTypeItemEnum.values()) {
            if (!type.getValue().equals(value)) continue;
            name = type.name;
            break;
        }
        return name;
    }

    public static CodeTypeItemEnum getLotCodeItemTypeEnumByValue(String value) {
        for (CodeTypeItemEnum e : CodeTypeItemEnum.values()) {
            if (!e.value.equals(value)) continue;
            return e;
        }
        throw new KDBizException("error value data : " + value);
    }
}

