/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.errorcode.PDMErrorCode;
import kd.mmc.pdm.common.util.MMCUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BOMVersionUtil {
    private static Log logger = LogFactory.getLog(BOMVersionUtil.class);
    private static final String KEY_VERSION = "version";
    private static final String KEY_ENTITY_RULE = "bd_bomversionrule_new";
    private static final String KEY_MATERIAL = "material";
    private static final String KEY_NAME = "name";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_BOMVERSIONRULE = "bomversionrule";
    private static final String KEY_TYPE = "type";
    private static final String KEY_ENTITY_VERSION = "bd_bomversion_new";
    private static final String APPID = "mmc-pdm-common";
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", BOMVersionUtil.getDateFormat(), "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyyMMdd"};

    public static String getAutoVersion(Object orgId, Object materId, Object ruleId) {
        DynamicObject version = BOMVersionUtil.getAutoVersionWithDynamicObject(orgId, materId, ruleId, "A");
        return version == null ? null : version.getString(KEY_VERSION);
    }

    public static String getAutoVersion(Object orgId, Object materId, Object ruleId, String type) {
        DynamicObject version = BOMVersionUtil.getAutoVersionWithDynamicObject(orgId, materId, ruleId, type);
        return version == null ? null : version.getString(KEY_VERSION);
    }

    public static DynamicObject getAutoVersionWithDynamicObject(Object orgId, Object materId, Object ruleId, String type) {
        int maxSeq = BOMVersionUtil.getExistsVersionMaxSeq(orgId, materId, ruleId, type);
        return BOMVersionUtil.getNotBomVersionDynamicObject(ruleId, maxSeq);
    }

    public static DynamicObject getAutoVersionWithDynamicObject(Object orgId, Object materId, Object ruleId) {
        int maxSeq = BOMVersionUtil.getExistsVersionMaxSeq(orgId, materId, ruleId, "A");
        return BOMVersionUtil.getNotBomVersionDynamicObject(ruleId, maxSeq);
    }

    private static DynamicObject getNotBomVersionDynamicObject(Object ruleId, int maxSeq) {
        DynamicObjectCollection rules;
        QFilter qFilter = new QFilter("id", "=", ruleId);
        if (maxSeq >= 0) {
            qFilter.and(new QFilter("entryentity.seq", ">", (Object)maxSeq));
        }
        if (PlatformUtils.isNullCollection(rules = QueryServiceHelper.query((String)KEY_ENTITY_RULE, (String)"entryentity.id id,entryentity.version version,entryentity.seq seq", (QFilter[])new QFilter[]{qFilter}, (String)"entryentity.seq"))) {
            return null;
        }
        return (DynamicObject)rules.get(0);
    }

    private static int getExistsVersionMaxSeq(Object orgId, Object materId, Object ruleId, String type) {
        QFilter qFilter1 = new QFilter(KEY_MATERIAL, "=", materId);
        QFilter qFilter2 = new QFilter(KEY_BOMVERSIONRULE, "=", ruleId);
        QFilter qFilter3 = new QFilter(KEY_TYPE, "=", (Object)type);
        String selectProperties = "versionname.entryseq entryseq";
        int maxSeq = -1;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(BOMVersionUtil.class.getName() + "_getExistsVersionNameSet"), (String)KEY_ENTITY_VERSION, (String)selectProperties, (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3}, (String)" versionname.entryseq desc ");){
            for (Row arow : ds) {
                if (maxSeq >= arow.getInteger("entryseq")) continue;
                maxSeq = arow.getInteger("entryseq");
            }
        }
        return maxSeq;
    }

    public static Long getAutoVersionId(Object orgId, Object materId, Object ruleId) {
        DynamicObject version = BOMVersionUtil.getAutoVersionWithDynamicObject(orgId, materId, ruleId);
        return version == null ? null : Long.valueOf(version.getLong("id"));
    }

    public static Boolean isQuoteVersion(Object ruleId, Object materId, String version) {
        if (ruleId != null && materId != null && StringUtils.isNotBlank((CharSequence)version)) {
            QFilter qFilter = new QFilter(KEY_MATERIAL, "=", materId);
            QFilter qFilter2 = new QFilter(KEY_NAME, "=", (Object)version);
            QFilter qFilter3 = new QFilter(KEY_BOMVERSIONRULE, "=", ruleId);
            QFilter qFilter4 = new QFilter(KEY_TYPE, "=", (Object)"A");
            if (QueryServiceHelper.exists((String)KEY_ENTITY_VERSION, (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter3, qFilter4})) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static DynamicObject getNextVersionByECN(DynamicObject createorg, DynamicObject material, String ecnbillno, String type) {
        if (material == null) {
            logger.info((Object)"---BOMVersionUtil----getNextVersionByECN----material == null ,not find");
            return null;
        }
        Object materId = material.getPkValue();
        QFilter qFilter = new QFilter(KEY_MATERIAL, "=", materId);
        QFilter qFilter2 = new QFilter("ecnbillno", "=", (Object)ecnbillno);
        QFilter qFilter3 = new QFilter(KEY_TYPE, "=", (Object)type);
        return BusinessDataServiceHelper.loadSingle((String)KEY_ENTITY_VERSION, (String)"id,number,name,material,type,ecnbillno", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter3});
    }

    private static Long getEcnIdByBillno(String ecnBillNo) {
        DynamicObject ecoBill = QueryServiceHelper.queryOne((String)"pdm_bom_eco", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)ecnBillNo)});
        return ecoBill == null ? 0L : ecoBill.getLong("id");
    }

    public static DynamicObject autoCreateBOMVersion(DynamicObject createorg, DynamicObject material, DynamicObject rule, Date validdate, Date invaliddate, String ecnbillno) {
        return BOMVersionUtil.autoCreateBOMVersion(createorg, material, rule, validdate, invaliddate, ecnbillno, BOMVersionUtil.getEcnIdByBillno(ecnbillno));
    }

    public static DynamicObject autoCreateBOMVersion(DynamicObject createorg, DynamicObject material, DynamicObject rule, Date validdate, Date invaliddate, String ecnbillno, Long ecnBillId) {
        return BOMVersionUtil.autoCreateVersion(createorg, material, rule, validdate, invaliddate, ecnbillno, ecnBillId, "A");
    }

    public static DynamicObject autoCreateRouteVersion(DynamicObject createorg, DynamicObject material, DynamicObject rule, Date validdate, Date invaliddate, String ecnbillno, Long ecnBillId) {
        return BOMVersionUtil.autoCreateVersion(createorg, material, rule, validdate, invaliddate, ecnbillno, ecnBillId, "B");
    }

    public static String getTypeName(String type) {
        String versionName = ResManager.loadKDString((String)"BOM", (String)"BOMVersionUtil_0", (String)APPID, (Object[])new Object[0]);
        if ("B".equals(type)) {
            versionName = ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf", (String)"BOMVersionUtil_1", (String)APPID, (Object[])new Object[0]);
        } else if ("C".equals(type)) {
            versionName = ResManager.loadKDString((String)"\u4ea7\u54c1\u914d\u65b9", (String)"BOMVersionUtil_2", (String)APPID, (Object[])new Object[0]);
        }
        return versionName;
    }

    public static DynamicObject autoCreateVersion(DynamicObject createorg, DynamicObject material, DynamicObject rule, Date validdate, Date invaliddate, String ecnbillno, Long ecnBillId, String type) {
        DynamicObject versionDy;
        if (createorg == null) {
            ErrorCode ec = new ErrorCode("createorg", String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efa%1$s\u7248\u672c\u3002", (String)"BOMVersionUtil_3", (String)APPID, (Object[])new Object[0]), BOMVersionUtil.getTypeName(type)));
            throw new KDBizException(ec, new Object[0]);
        }
        if (material == null) {
            ErrorCode ec = new ErrorCode(KEY_MATERIAL, String.format(ResManager.loadKDString((String)"\u7269\u6599\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efa%1$s\u7248\u672c\u3002", (String)"BOMVersionUtil_4", (String)APPID, (Object[])new Object[0]), BOMVersionUtil.getTypeName(type)));
            throw new KDBizException(ec, new Object[0]);
        }
        if (rule == null && (rule = BOMVersionUtil.getDefaultVersionRule(type)) == null) {
            ErrorCode ec = new ErrorCode("rule", String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u9ed8\u8ba4\u7248\u672c\u89c4\u5219\uff0c\u65e0\u6cd5\u521b\u5efa%1$s\u7248\u672c\u3002", (String)"BOMVersionUtil_5", (String)APPID, (Object[])new Object[0]), BOMVersionUtil.getTypeName(type)));
            throw new KDBizException(ec, new Object[0]);
        }
        if (validdate == null) {
            validdate = new Date();
        }
        if (invaliddate == null) {
            try {
                invaliddate = BOMVersionUtil.parseDate("2999-12-31");
            }
            catch (ParseException e) {
                logger.info((Object)e.getMessage());
                throw new KDBizException((Throwable)e, PDMErrorCode.DATE_PARSE_ERROR, new Object[]{e.getMessage()});
            }
        }
        if ((versionDy = BOMVersionUtil.getAutoVersionWithDynamicObject(createorg.getPkValue(), material.getPkValue(), rule.getPkValue(), type)) == null) {
            ErrorCode ec = new ErrorCode(KEY_VERSION, String.format(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7248\u672c\u53f7\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa%1$s\u7248\u672c\u3002", (String)"BOMVersionUtil_6", (String)APPID, (Object[])new Object[0]), BOMVersionUtil.getTypeName(type)));
            throw new KDBizException(ec, new Object[0]);
        }
        String version = versionDy.getString(KEY_VERSION);
        Long versionId = versionDy.getLong("id");
        DynamicObject bomversion = ORM.create().newDynamicObject(KEY_ENTITY_VERSION);
        String materNum = material.getString(KEY_NUMBER);
        String ruleNum = rule.getString(KEY_NUMBER);
        DynamicObject ruleEntry = BusinessDataServiceHelper.loadSingleFromCache((Object)versionId, (String)"bd_bomversionruleentry_f7");
        ILocaleString verName = ruleEntry.getLocaleString(KEY_VERSION);
        String verNum = verName.getLocaleValue();
        bomversion.set(KEY_NUMBER, (Object)BOMVersionUtil.getAutoVersionNumber(materNum, ruleNum, verNum, type));
        bomversion.set(KEY_NAME, (Object)version);
        bomversion.set(KEY_TYPE, (Object)type);
        bomversion.set("versionname", (Object)ruleEntry);
        bomversion.set(KEY_BOMVERSIONRULE, (Object)rule);
        bomversion.set(KEY_MATERIAL, (Object)material);
        bomversion.set("createorg", (Object)createorg);
        bomversion.set("effectdate", (Object)validdate);
        bomversion.set("invaliddate", (Object)invaliddate);
        bomversion.set("ctrlstrategy", (Object)"5");
        bomversion.set("enable", (Object)"1");
        bomversion.set("status", (Object)"C");
        bomversion.set("ecnbillno", (Object)ecnbillno);
        bomversion.set("srcbillid", (Object)ecnBillId);
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)KEY_ENTITY_VERSION, (DynamicObject[])new DynamicObject[]{bomversion}, (OperateOption)OperateOption.create());
        if (!operateResult.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            for (IOperateInfo info : operateResult.getAllErrorOrValidateInfo()) {
                sb.append(info.getMessage()).append('\n');
            }
            if (sb.length() <= 0) {
                sb.append(operateResult.getMessage());
            }
            ErrorCode ec = new ErrorCode("save", sb.toString());
            throw new KDBizException(ec, new Object[0]);
        }
        List addPkIds = operateResult.getSuccessPkIds();
        return BOMVersionUtil.getCurrentVersionByFilter(new QFilter("id", "in", (Object)addPkIds));
    }

    private static String getDateFormat() {
        return ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"BOMVersionUtil_7", (String)APPID, (Object[])new Object[0]);
    }

    public static Date parseDate(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        return DateUtils.parseDate((String)string, (String[])parsePatterns);
    }

    public static DynamicObject getDefaultVersionRule(String type) {
        String defField = "B".equals(type) ? "isdefaultroute" : ("C".equals(type) ? "isdefaultprograme" : "isdefault");
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterType = new QFilter("multype", "like", (Object)("%" + type + "%"));
        QFilter qFilter2 = new QFilter(defField, "=", (Object)Boolean.TRUE);
        return BusinessDataServiceHelper.loadSingleFromCache((String)KEY_ENTITY_RULE, (String)"id,number,entryentity.version", (QFilter[])new QFilter[]{qFilter2, qFilterStatus, qFilterEnable, qFilterType});
    }

    public static boolean isExistsVersionId(Object id) {
        return QueryServiceHelper.exists((String)KEY_ENTITY_VERSION, (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
    }

    public static DynamicObject getOrg(DynamicObject pentry, DynamicObject ecnBill) {
        DynamicObject org = ecnBill.getDynamicObject("org");
        String versionCtr = pentry.getString("entryversioncontrol");
        if ("B".equals(versionCtr)) {
            if ("B".equals(ecnBill.getString("changetype"))) {
                DynamicObject route = pentry.getDynamicObject("pentryroute");
                return route.getDynamicObject("createorg");
            }
            DynamicObject bom = pentry.getDynamicObject("pentrybom");
            return bom.getDynamicObject("createorg");
        }
        return org;
    }

    public static DynamicObject getBomTypeDefVersionRule(DynamicObject bomType) {
        if (bomType != null) {
            DynamicObject versionRuleNew;
            DynamicObject bomTypeNew = bomType;
            if (!bomType.containsProperty("isversion") || !bomType.containsProperty("versionrule")) {
                bomTypeNew = BusinessDataServiceHelper.loadSingleFromCache((Object)bomType.getPkValue(), (String)"mpdm_bomtype", (String)"isversion,versionrule");
            }
            boolean isversion = bomTypeNew.getBoolean("isversion");
            DynamicObject versionRule = bomTypeNew.getDynamicObject("versionrule");
            DynamicObject dynamicObject = versionRuleNew = isversion && versionRule != null ? versionRule : null;
            if (versionRuleNew != null) {
                return BusinessDataServiceHelper.loadSingleFromCache((String)KEY_ENTITY_RULE, (String)"id,number,entryentity.version", (QFilter[])new QFilter[]{new QFilter("id", "=", versionRuleNew.getPkValue())});
            }
        }
        return null;
    }

    public static boolean checkIsSameRule(DynamicObject versionRule, DynamicObject version) {
        if (versionRule != null && version != null) {
            DynamicObject rule = BOMVersionUtil.getVersionRule(version);
            return versionRule.getPkValue().equals(rule.getPkValue());
        }
        return true;
    }

    public static DynamicObject getVersionRule(DynamicObject version) {
        DynamicObject newVersion = version;
        if (!version.containsProperty(KEY_BOMVERSIONRULE)) {
            newVersion = BOMVersionUtil.getCurrentVersionById(version.getLong("id"));
        }
        return newVersion.getDynamicObject(KEY_BOMVERSIONRULE);
    }

    public static boolean isNeedVersion(boolean isBomChange, DynamicObject ecnBill, DynamicObject pentry) {
        DynamicObject bomType = pentry.getDynamicObject("bomtype");
        DynamicObject ppmarterial = pentry.getDynamicObject("proentrymaterialid");
        if (ppmarterial == null) {
            ppmarterial = pentry.getDynamicObject("proentrymaterial").getDynamicObject("masterid");
            pentry.set("proentrymaterialid", (Object)ppmarterial);
        }
        Long pmarterialPkId = 0L;
        if (ppmarterial != null) {
            pmarterialPkId = (Long)ppmarterial.getPkValue();
        }
        DynamicObject org = BOMVersionUtil.getOrg(pentry, ecnBill);
        Long orgpk = (Long)org.getPkValue();
        if (isBomChange) {
            boolean isVersion = MMCUtils.getDynamicObjectBooleanData(bomType, "isversion");
            boolean isenablematerialversion = MMCUtils.getDynamicObjectBooleanData(ppmarterial, "isenablematerialversion");
            return pmarterialPkId > 0L && orgpk > 0L && (isenablematerialversion || isVersion);
        }
        return BOMVersionUtil.isRouteVsersion(orgpk);
    }

    public static String createBomVersionByECN(DynamicObject ecnBill, DynamicObjectCollection pentrys) {
        boolean flag = true;
        String errorMsg = "";
        int size = pentrys.size();
        ArrayList<Object> newversionIds = new ArrayList<Object>(size);
        String ecnbillno = ecnBill.getString("billno");
        Long ecnbillId = (Long)ecnBill.getPkValue();
        for (int k = 0; k < size; ++k) {
            String versionCtr;
            DynamicObject pentry = (DynamicObject)pentrys.get(k);
            DynamicObject mater = pentry.getDynamicObject("proentrymaterialid");
            DynamicObject pentrynewver = pentry.getDynamicObject("pentrynewversion");
            if (mater == null || pentrynewver != null && BOMVersionUtil.isExistsVersionId(pentrynewver.getPkValue()) || !"B".equals(versionCtr = pentry.getString("entryversioncontrol")) && !"D".equals(versionCtr) || !BOMVersionUtil.isNeedVersion(true, ecnBill, pentry)) continue;
            DynamicObject org = BOMVersionUtil.getOrg(pentry, ecnBill);
            DynamicObject pentrynewversion = BOMVersionUtil.getNextVersionByECN(org, mater, ecnbillno, "A");
            if (pentrynewversion != null) {
                pentry.set("pentrynewversion", (Object)pentrynewversion);
                continue;
            }
            try {
                DynamicObject rule = BOMVersionUtil.getBomTypeDefVersionRule(pentry.getDynamicObject("bomtype"));
                pentrynewversion = BOMVersionUtil.autoCreateBOMVersion(org, mater, rule, null, null, ecnbillno, ecnbillId);
                pentry.set("pentrynewversion", (Object)pentrynewversion);
            }
            catch (KDBizException exp) {
                flag = false;
                errorMsg = exp.getMessage();
                if (kd.bos.util.StringUtils.isEmpty((String)errorMsg)) {
                    errorMsg = PlatformUtils.getSimpleExceptionString((Exception)((Object)exp));
                }
                logger.error((Object)exp);
                break;
            }
            newversionIds.add(pentrynewversion.getPkValue());
        }
        if (!flag && !newversionIds.isEmpty()) {
            DeleteServiceHelper.delete((String)KEY_ENTITY_VERSION, (QFilter[])new QFilter[]{new QFilter("id", "in", newversionIds)});
        }
        return errorMsg;
    }

    public static String createRouteVersionByECN(DynamicObject ecnBill, DynamicObjectCollection pentrys) {
        boolean flag = true;
        String errorMsg = "";
        int size = pentrys.size();
        ArrayList<Object> newversionIds = new ArrayList<Object>(size);
        String ecnbillno = ecnBill.getString("billno");
        Long ecnbillId = (Long)ecnBill.getPkValue();
        for (int k = 0; k < size; ++k) {
            DynamicObject pentry = (DynamicObject)pentrys.get(k);
            String versionCtr = pentry.getString("entryversioncontrol");
            if (!"B".equals(versionCtr) && !"D".equals(versionCtr)) continue;
            DynamicObject mater = pentry.getDynamicObject("proentrymaterialid");
            DynamicObject pentrynewver = pentry.getDynamicObject("pentrynewrtversion");
            if (mater == null || pentrynewver != null && BOMVersionUtil.isExistsVersionId(pentrynewver.getPkValue()) || !BOMVersionUtil.isNeedVersion(false, ecnBill, pentry)) continue;
            DynamicObject org = BOMVersionUtil.getOrg(pentry, ecnBill);
            DynamicObject pentrynewversion = BOMVersionUtil.getNextVersionByECN(org, mater, ecnbillno, "B");
            if (pentrynewversion != null) {
                pentry.set("pentrynewrtversion", (Object)pentrynewversion);
                continue;
            }
            try {
                pentrynewversion = BOMVersionUtil.autoCreateRouteVersion(org, mater, null, null, null, ecnbillno, ecnbillId);
                pentry.set("pentrynewrtversion", (Object)pentrynewversion);
            }
            catch (KDBizException exp) {
                flag = false;
                errorMsg = exp.getMessage();
                if (kd.bos.util.StringUtils.isEmpty((String)errorMsg)) {
                    errorMsg = PlatformUtils.getSimpleExceptionString((Exception)((Object)exp));
                }
                logger.error((Object)exp);
                break;
            }
            newversionIds.add(pentrynewversion.getPkValue());
        }
        if (!flag && !newversionIds.isEmpty()) {
            DeleteServiceHelper.delete((String)KEY_ENTITY_VERSION, (QFilter[])new QFilter[]{new QFilter("id", "in", newversionIds)});
        }
        return errorMsg;
    }

    public static DynamicObject getInitVersion(DynamicObject createorg, DynamicObject material, String type, DynamicObject rule) {
        if (material == null || createorg == null) {
            return null;
        }
        if (rule == null) {
            rule = BOMVersionUtil.getDefaultVersionRule(type);
        }
        return rule == null ? null : BOMVersionUtil.getVersion(createorg, material, rule, type, false);
    }

    public static DynamicObject getVersion(DynamicObject createorg, DynamicObject material, DynamicObject rule, String type, boolean isFirst) {
        Set<Long> usedVersionIdSet;
        QFilter qFilter = new QFilter(KEY_MATERIAL, "=", material.getPkValue());
        qFilter.and(new QFilter(KEY_BOMVERSIONRULE, "=", rule.getPkValue()));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter(KEY_TYPE, "=", (Object)type));
        Date date = new Date();
        QFilter qFilterDate = new QFilter("effectdate", "<=", (Object)date);
        qFilterDate.and(new QFilter("invaliddate", ">", (Object)date));
        String orderBy = "versionname.entryseq " + (isFirst ? "" : "desc");
        DynamicObjectCollection coll = QueryServiceHelper.query((String)KEY_ENTITY_VERSION, (String)"id,name,versionname.entryseq entryseq", (QFilter[])new QFilter[]{qFilter, qFilterDate}, (String)orderBy);
        Set<Long> versionIdSet = coll.stream().map(p -> p.getLong("id")).collect(Collectors.toSet());
        if (versionIdSet == null || versionIdSet.isEmpty()) {
            return null;
        }
        List<Long> versionIdList = coll.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        Long maxVersionId = BOMVersionUtil.getNotUsedVersionId(versionIdList, usedVersionIdSet = BOMVersionUtil.getUsedVersionId((Long)material.getPkValue(), createorg.getLong("id"), versionIdSet, type));
        return maxVersionId == null || maxVersionId.equals(0L) ? null : BOMVersionUtil.getCurrentVersionById(maxVersionId);
    }

    public static Long getNotUsedVersionId(List<Long> versionIdList, Set<Long> routeVersionIdSet) {
        int maxSeq = -1;
        int size = versionIdList.size();
        int i = 0;
        while (i < size) {
            Long id = versionIdList.get(i);
            if (routeVersionIdSet.contains(id)) {
                maxSeq = i - 1;
                break;
            }
            maxSeq = i++;
        }
        return maxSeq >= 0 ? versionIdList.get(maxSeq) : Long.valueOf(0L);
    }

    public static Set<Long> getUsedVersionId(Long materialId, Long orgId, Set<Long> versionIdSet, String type) {
        String materialIdField = "A".equalsIgnoreCase(type) ? "materialid" : KEY_MATERIAL;
        String versionIdField = "A".equalsIgnoreCase(type) ? KEY_VERSION : "routeversion";
        String entityNumber = "A".equalsIgnoreCase(type) ? "pdm_mftbom" : "pdm_route";
        QFilter qFilter = new QFilter(materialIdField, "=", (Object)materialId);
        qFilter.and(new QFilter(versionIdField, "in", versionIdSet));
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)entityNumber, (Long)orgId));
        DynamicObjectCollection versionColl = QueryServiceHelper.query((String)entityNumber, (String)versionIdField, (QFilter[])new QFilter[]{qFilter}, (String)"");
        return versionColl.stream().map(p -> p.getLong(versionIdField)).collect(Collectors.toSet());
    }

    public static DynamicObject getCurrentVersionById(Long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        return BOMVersionUtil.getCurrentVersionByFilter(qFilter);
    }

    public static DynamicObject getCurrentVersionByFilter(QFilter qfilter) {
        return BusinessDataServiceHelper.loadSingle((String)KEY_ENTITY_VERSION, (String)BOMVersionUtil.getVersonSelectProperties(), (QFilter[])new QFilter[]{qfilter});
    }

    private static String getVersonSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",number");
        sb.append(",name");
        sb.append(",material");
        sb.append(",ecnbillno");
        sb.append(",srcbillid");
        sb.append(",bomversionrule");
        return sb.toString();
    }

    private static String getAutoVersionNumber(String materialNumber, String ruleNumber, String version, String type) {
        StringBuilder versionNumber = new StringBuilder();
        versionNumber.append(materialNumber);
        versionNumber.append('-');
        versionNumber.append(ruleNumber);
        versionNumber.append('-');
        versionNumber.append("B".equals(type) ? "route" : ("C".equals(type) ? "formula" : "bom"));
        versionNumber.append('-');
        versionNumber.append(version);
        return versionNumber.toString();
    }

    public static boolean isRouteVsersion(Long orgId) {
        return BOMVersionUtil.getBizAppParam(orgId, "isopenrouteversion", "fmm");
    }

    public static boolean getBizAppParam(Long orgId, String paramNumber, String bizAppNum) {
        AppParam appParam = new AppParam();
        DynamicObject bizApp = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id,orgfunc", (QFilter[])new QFilter[]{new QFilter(KEY_NUMBER, "=", (Object)bizAppNum)});
        appParam.setAppId(bizApp.getString("id"));
        appParam.setViewType(bizApp.getString("orgfunc"));
        appParam.setOrgId(orgId);
        appParam.setActBookId(Long.valueOf(0L));
        Map syPparams = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        return syPparams.getOrDefault(paramNumber, false);
    }
}

