/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.util;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pdm.common.enums.CodeRuleFormatEnum;
import kd.mmc.pdm.common.enums.CodeTypeItemEnum;
import kd.mmc.pdm.common.enums.UseModeEnum;
import kd.mmc.pdm.common.objectbeen.CodeRuleBean;
import kd.mmc.pdm.common.objectbeen.CodeRuleEntryBean;
import kd.mmc.pdm.common.util.MMCUtils;

public class ConfigNumberGenerateUtils {
    private static final Log log = LogFactory.getLog(ConfigNumberGenerateUtils.class);
    private static final String CODE_RULE_ENTITY = "bd_configcoderule";
    private static final String RULE_ENTRY = "entryentity";
    private static final String RULE_NUMBER = "number";
    private static String materialKey = "";

    public static DynamicObject getRule(long ruleID, String ruleEntityName) {
        if (ruleID < 0L || StringUtils.isEmpty((CharSequence)ruleEntityName)) {
            return null;
        }
        DynamicObject ruleDO = BusinessDataServiceHelper.loadSingle((Object)ruleID, (String)ruleEntityName);
        return ruleDO;
    }

    private static int getEntryRowNum(DynamicObject productConfigDO, int seqParams) {
        int retNum = -1;
        DynamicObjectCollection productConfigEntryDOC = productConfigDO.getDynamicObjectCollection("treeentryentity");
        for (int i = 0; i < productConfigEntryDOC.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)productConfigEntryDOC.get(i);
            int seq = entryObj.getInt("seq");
            if (seq != seqParams) continue;
            retNum = i + 1;
            break;
        }
        return retNum;
    }

    public static JSONObject autoGenerateConfigNumer(DynamicObject productConfigDO, String sourceBillName, Map<String, Object> params) {
        return ConfigNumberGenerateUtils.autoGenerateConfigNumer(productConfigDO, null, sourceBillName, params);
    }

    public static JSONObject autoGenerateConfigNumer(DynamicObject productConfigDO, DynamicObject bomVersion, String sourceBillName, Map<String, Object> params) {
        boolean checkCodeRuleFlag;
        DynamicObject entryDO;
        JSONObject result = new JSONObject();
        if (productConfigDO == null) {
            log.info("RuleResolveUtils->autoGenerateConfigNumer\uff1a\u4ea7\u54c1\u914d\u7f6e\u5bf9\u8c61\u4e3a\u7a7a\uff01");
            throw new KDBizException(ResManager.loadKDString((String)"\u4ea7\u54c1\u914d\u7f6e\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"ConfigNumberGenerateUtils_0", (String)"mmc-pdm-common", (Object[])new Object[0]));
        }
        if (!StringUtils.equals((CharSequence)productConfigDO.getDataEntityType().getName(), (CharSequence)"pdm_productconfig") && !StringUtils.equals((CharSequence)productConfigDO.getDataEntityType().getName(), (CharSequence)"pdm_productconfigure")) {
            log.info("RuleResolveUtils->autoGenerateConfigNumer\uff1a\u975e\u4ea7\u54c1\u914d\u7f6e\u5668\u5bf9\u8c61\uff08\u5bf9\u8c61\u7c7b\u578b\u4e0d\u5339\u914d\uff09\u3002");
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u4ea7\u54c1\u914d\u7f6e\u5668\u5bf9\u8c61\uff08\u5bf9\u8c61\u7c7b\u578b\u4e0d\u5339\u914d\uff09\u3002", (String)"ConfigNumberGenerateUtils_1", (String)"mmc-pdm-common", (Object[])new Object[0]));
        }
        DynamicObject configPlanDO = MMCUtils.getDynamicObjectDynamicObjectData(productConfigDO, "productconfigplan");
        DynamicObject customCodeRuleDO = MMCUtils.getDynamicObjectDynamicObjectData(configPlanDO, "customcoderule");
        DynamicObject codeRuleDO = null;
        if (customCodeRuleDO != null) {
            Object pkValue = customCodeRuleDO.getPkValue();
            codeRuleDO = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)CODE_RULE_ENTITY);
        }
        int vEntrySeq = -1;
        int entrySeq = -1;
        if (params != null && params.get("ventryseq") instanceof Integer) {
            entrySeq = (Integer)params.get("ventryseq");
            vEntrySeq = ConfigNumberGenerateUtils.getEntryRowNum(productConfigDO, entrySeq);
        }
        int vEntryPK = -1;
        if (params != null && params.get("ventrypk") instanceof Integer) {
            vEntryPK = (Integer)params.get("ventrypk");
        }
        DynamicObjectCollection productConfigEntryDOC = productConfigDO.getDynamicObjectCollection("treeentryentity");
        DynamicObject entryMaterialDO = null;
        if (productConfigEntryDOC == null || productConfigEntryDOC.isEmpty()) {
            return result;
        }
        if (vEntrySeq > 0 && vEntrySeq <= productConfigEntryDOC.size() && (entryDO = (DynamicObject)productConfigEntryDOC.get(vEntrySeq - 1)) != null) {
            entryMaterialDO = entryDO.getDynamicObject("entrymaterial");
        }
        if (!(checkCodeRuleFlag = ConfigNumberGenerateUtils.checkParamCodeRule(productConfigDO, configPlanDO, codeRuleDO, entryMaterialDO, result)) || entrySeq == -1) {
            return result;
        }
        Object sourcebillID = null;
        if (params != null && params.get("sbillid") != null) {
            sourcebillID = params.get("sbillid");
        }
        String sourcebillEntity = "";
        sourcebillEntity = StringUtils.isNotEmpty((CharSequence)sourceBillName) ? sourceBillName : (params != null && params.get("sbillentityname") instanceof String ? String.valueOf(params.get("sbillentityname")) : "pdm_productconfig");
        int sEntrySeq = -1;
        if (params != null && params.get("sentryseq") instanceof Integer) {
            sEntrySeq = (Integer)params.get("sentryseq");
        } else if (StringUtils.equals((CharSequence)sourcebillEntity, (CharSequence)"pdm_productconfig")) {
            sEntrySeq = vEntrySeq;
        }
        Object sentryPK = null;
        if (params != null && params.get("sentrypk") != null) {
            sentryPK = params.get("sentrypk");
        }
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("snrule", codeRuleDO);
        param.put("size", 1);
        param.put("sourcebillid", sourcebillID);
        param.put("sourcebillentity", sourcebillEntity);
        param.put("sentryseq", sEntrySeq);
        param.put("sentrypk", sentryPK);
        param.put("ventryseq", vEntrySeq);
        param.put("ventrypk", vEntryPK);
        long startTime = System.currentTimeMillis();
        List<String> sns = ConfigNumberGenerateUtils.getSns(productConfigDO, null, param);
        Long resultPK = -1L;
        if (vEntrySeq > 0 && sns != null && !sns.isEmpty()) {
            String configNumber = sns.get(0);
            DynamicObjectCollection entryDOC = productConfigDO.getDynamicObjectCollection("treeentryentity");
            DynamicObject entryDO2 = (DynamicObject)entryDOC.get(vEntrySeq - 1);
            if (entryDO2 != null) {
                DynamicObject entrymaterial = entryDO2.getDynamicObject("entrymaterial");
                DynamicObject configCodeDO = ORM.create().newDynamicObject("bd_configuredcode");
                configCodeDO.set("material", (Object)entrymaterial);
                configCodeDO.set("createtype", (Object)2);
                configCodeDO.set(RULE_NUMBER, (Object)configNumber);
                configCodeDO.set("status", (Object)"C");
                configCodeDO.set("enable", (Object)1);
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bd_configuredcode", (DynamicObject[])new DynamicObject[]{configCodeDO}, (OperateOption)OperateOption.create());
                boolean success = operationResult.isSuccess();
                if (!success) {
                    List errorValidataInfos = operationResult.getAllErrorOrValidateInfo();
                    if (errorValidataInfos == null || errorValidataInfos.isEmpty()) {
                        log.info("RuleResolveUtils->autoGenerateConfigNumer\uff1a\u4fdd\u5b58\u914d\u7f6e\u53f7\u5931\u8d25\uff0c\u4f46\u662f\u6ca1\u6709\u8fd4\u56de\u9519\u8bef\u63d0\u793a\u4fe1\u606f\u3002");
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u53f7\u201c%s\u201d\u4fdd\u5b58\u5931\u8d25\u3002", (String)"ConfigNumberGenerateUtils_2", (String)"mmc-pdm-common", (Object[])new Object[0]), configNumber));
                    }
                    StringBuilder infoMessage = new StringBuilder();
                    for (int i = 0; i < errorValidataInfos.size(); ++i) {
                        IOperateInfo info = (IOperateInfo)errorValidataInfos.get(i);
                        String message = info.getMessage();
                        infoMessage.append(message);
                        if (i < errorValidataInfos.size() - 1) {
                            infoMessage.append("\n");
                        }
                        log.info("RuleResolveUtils->autoGenerateConfigNumer\uff1a\u4fdd\u5b58\u914d\u7f6e\u53f7\u5931\u8d25\uff0c\u4f46\u662f\u6ca1\u6709\u8fd4\u56de\u9519\u8bef\u63d0\u793a\u4fe1\u606f\u3002");
                    }
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u53f7\u201c%1$s\u201d\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s\u3002", (String)"ConfigNumberGenerateUtils_3", (String)"mmc-pdm-common", (Object[])new Object[0]), configNumber, infoMessage.toString()));
                }
                List successPkIds = operationResult.getSuccessPkIds();
                if (successPkIds != null && !successPkIds.isEmpty() && successPkIds.get(0) instanceof Long) {
                    resultPK = (Long)successPkIds.get(0);
                }
            }
        }
        if (vEntrySeq > 0 && sns != null && !sns.isEmpty()) {
            result.put(String.valueOf(entrySeq), (Object)resultPK);
        }
        return result;
    }

    public static List<String> getSns(DynamicObject dataEntity, List<DynamicObject> updateEntrys, Map<String, Object> param) {
        ArrayList<String> listSns = new ArrayList(16);
        try {
            listSns = ConfigNumberGenerateUtils.getSnCodeNum(dataEntity, updateEntrys, param);
        }
        catch (KDBizException e) {
            ErrorCode errorCode = new ErrorCode("mmc.pdm.configcodeerror", ResManager.loadKDString((String)"\u914d\u7f6e\u53f7\u751f\u6210\u5931\u8d25\u3002", (String)"ConfigNumberGenerateUtils_4", (String)"mmc-pdm-common", (Object[])new Object[0]));
            throw new KDBizException((Throwable)e, errorCode, new Object[]{e.getMessage()});
        }
        return listSns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSnCodeNum(DynamicObject dataEntity, List<DynamicObject> updateEntrys, Map<String, Object> returnParam) {
        int sEntrySeq = (Integer)returnParam.get("sentryseq");
        DynamicObject snRule = null;
        if (returnParam != null && returnParam.get("snrule") != null) {
            snRule = (DynamicObject)returnParam.get("snrule");
        }
        int size = (Integer)returnParam.get("size");
        if (snRule == null) {
            log.info("RuleResolveUtils->getSnCodeNum\uff1a\u65e0\u6cd5\u627e\u5230\u89c4\u5219");
            return null;
        }
        HashMap<Long, DynamicObject> ruleEntryMap = new HashMap<Long, DynamicObject>();
        DynamicObjectCollection lotCodeRuleEntry = snRule.getDynamicObjectCollection(RULE_ENTRY);
        ArrayList<Object> lotItemIds = new ArrayList<Object>();
        for (DynamicObject row : lotCodeRuleEntry) {
            DynamicObject codeAttrDO = MMCUtils.getDynamicObjectDynamicObjectData(row, "codeattr");
            Long codeAttrPK = MMCUtils.getDynamicObjectPK(codeAttrDO);
            lotItemIds.add(codeAttrPK);
            ruleEntryMap.put(codeAttrPK, row);
        }
        CodeRuleBean codeInfo = ConfigNumberGenerateUtils.buildCodeInfo(sEntrySeq, lotItemIds, ruleEntryMap, dataEntity, returnParam, null, snRule);
        codeInfo.setRuleId(snRule.get("id"));
        HashMap<Integer, CodeRuleBean> codeRuleMap = new HashMap<Integer, CodeRuleBean>();
        codeRuleMap.put(0, codeInfo);
        HashMap propSeqMap = new HashMap();
        if (!codeInfo.isRight()) {
            throw new KDBizException(codeInfo.getMsg());
        }
        ArrayList<Integer> seqs = new ArrayList<Integer>(size);
        seqs.add(0);
        propSeqMap.put(snRule.getString("id"), seqs);
        Integer serialNum = 0;
        if (codeInfo.isHaveSerial()) {
            long begin = System.currentTimeMillis();
            ReentrantLock lock = new ReentrantLock();
            try {
                lock.lock();
                long end = System.currentTimeMillis();
                try {
                    serialNum = ConfigNumberGenerateUtils.setMaxSerialNum(codeRuleMap, (List)propSeqMap.values().iterator().next());
                    long l = System.currentTimeMillis();
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
                }
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        ArrayList<String> snNums = new ArrayList<String>(size);
        StringBuilder numsb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            numsb.setLength(0);
            String preSplitSign = "";
            for (CodeRuleEntryBean row : codeInfo.getEntry()) {
                if (StringUtils.isEmpty((CharSequence)row.getPropValue())) continue;
                if (numsb.length() > 0) {
                    numsb.append(preSplitSign);
                }
                if (row.getPropType() == CodeTypeItemEnum.SERIALNUM) {
                    serialNum = serialNum + codeInfo.getStep();
                    String seNum = serialNum.toString();
                    int max = codeInfo.getLenth() - seNum.length();
                    for (int j = 0; j < max; ++j) {
                        numsb.append('0');
                    }
                    numsb.append(seNum);
                } else {
                    numsb.append(row.getPropValue());
                }
                preSplitSign = row.getSplitsign();
            }
            snNums.add(numsb.toString());
        }
        return snNums;
    }

    public static Integer setMaxSerialNum(Map<Integer, CodeRuleBean> lotCodeRuleMap, List<Integer> seqs) {
        DynamicObject maxSerialEntity;
        Integer serialNum = 0;
        if (seqs == null || seqs.isEmpty()) {
            return serialNum;
        }
        CodeRuleBean info = lotCodeRuleMap.get(seqs.get(0));
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(new QFilter("confcoderuleid", "=", info.getRuleId()));
        if (info.isMatNumOnly()) {
            // empty if block
        }
        if (StringUtils.isNotEmpty((CharSequence)info.getPropCol())) {
            qfilters.add(new QFilter("accordpropnumber", "=", (Object)info.getPropCol()));
        }
        if ((maxSerialEntity = BusinessDataServiceHelper.loadSingle((String)"pdm_confcode_maxserial", (String)"id,maxserial", (QFilter[])qfilters.toArray(new QFilter[qfilters.size()]))) == null) {
            maxSerialEntity = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pdm_confcode_maxserial"));
            serialNum = Integer.parseInt(info.getSettingValue()) - info.getStep();
            maxSerialEntity.set("confcoderuleid", info.getRuleId());
            maxSerialEntity.set("materialid", info.getMaterialId());
            maxSerialEntity.set("accordpropnumber", (Object)info.getPropCol());
        } else {
            int setValue = Integer.parseInt(info.getSettingValue()) - info.getStep();
            serialNum = Math.max(maxSerialEntity.getInt("maxserial"), setValue);
        }
        int maxSerialNum = serialNum + info.getStep() * seqs.size();
        maxSerialEntity.set("maxserial", (Object)maxSerialNum);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{maxSerialEntity});
        return serialNum;
    }

    public static CodeRuleBean buildCodeInfo(int seq, List<Object> codeItemIds, Map<Long, DynamicObject> ruleEntryMap, DynamicObject dataEntity, Map<String, Object> params, DynamicObject material, DynamicObject lotCodeRule) {
        CodeRuleBean codeInfo = new CodeRuleBean();
        String entityType = dataEntity.getDataEntityType().getName();
        StringBuilder buildMsg = new StringBuilder();
        Map items = BusinessDataServiceHelper.loadFromCache((Object[])codeItemIds.toArray(), (String)"bd_configcodeattr");
        if (items == null || items.isEmpty()) {
            log.info("RuleResolveUtils->buildCodeInfo\uff1a\u89c4\u5219\u65e0\u5c5e\u6027");
            buildMsg.append(ResManager.loadKDString((String)"\u89c4\u5219\u65e0\u5c5e\u6027", (String)"ConfigNumberGenerateUtils_5", (String)"mmc-pdm-common", (Object[])new Object[0]));
            codeInfo.setMsg(buildMsg);
            return codeInfo;
        }
        for (Object id : codeItemIds) {
            DynamicObject item = (DynamicObject)items.get(id);
            String type = item.getString("attrtype");
            Object pvalue = "";
            String endValue = "";
            DynamicObject ruleRow = ruleEntryMap.get(id);
            if (ruleRow == null) continue;
            CodeTypeItemEnum iEnum = CodeTypeItemEnum.getLotCodeItemTypeEnumByValue(type);
            switch (iEnum) {
                case TXT: 
                case DATE: {
                    DynamicObjectCollection itemEntry;
                    String sourceBillEntity = "";
                    if (params != null && params.get("sourcebillentity") instanceof String) {
                        sourceBillEntity = String.valueOf(params.get("sourcebillentity"));
                    }
                    if ((itemEntry = item.getDynamicObjectCollection(RULE_ENTRY)) == null) {
                        log.info("\u65e0\u5c5e\u6027\u5206\u5f55");
                    } else {
                        for (DynamicObject irow : itemEntry) {
                            DynamicObject sourceEntityTypeDO = MMCUtils.getDynamicObjectDynamicObjectData(irow, "sourceobject");
                            String sourceEntityNumber = MMCUtils.getDynamicObjectStringData(sourceEntityTypeDO, "id", "");
                            Object vEntryPk = params.get("ventrypk");
                            HashSet<String> entityNameSet = new HashSet<String>(2);
                            entityNameSet.add("pdm_productconfigure");
                            entityNameSet.add("pdm_productconfig");
                            if (entityNameSet.contains(sourceEntityNumber) && entityNameSet.contains(entityType)) {
                                String sourceProp = irow.getString("sourcefield");
                                Object sourceDO = null;
                                Object sourceEntry = null;
                                Object sEntryPk = params.get("sentrypk");
                                DynamicObject valueObj = ConfigNumberGenerateUtils.readDOFiled(irow, dataEntity, sourceProp, seq, sEntryPk);
                                String valueProp = irow.getString("valuefield");
                                try {
                                    pvalue = ConfigNumberGenerateUtils.getLotPropValue(valueObj, vEntryPk, seq, valueProp, irow);
                                }
                                catch (KDBizException e) {
                                    codeInfo.setRight(false);
                                    codeInfo.appendMsg(e.getMessage());
                                }
                                break;
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)sourceBillEntity) || !sourceBillEntity.equals(sourceEntityNumber)) continue;
                            Object sourceBillPK = -1L;
                            if (params != null && params.get("sourcebillid") != null) {
                                sourceBillPK = params.get("sourcebillid");
                            }
                            DynamicObject sourceDataDO = BusinessDataServiceHelper.loadSingle((Object)sourceBillPK, (String)sourceEntityNumber);
                            String valueProp = irow.getString("valuefield");
                            pvalue = ConfigNumberGenerateUtils.getLotPropValue(sourceDataDO, vEntryPk, seq, valueProp, irow);
                            break;
                        }
                    }
                    if (pvalue == null || StringUtils.isEmpty((CharSequence)pvalue.toString().trim())) {
                        endValue = "";
                        break;
                    }
                    if (iEnum == CodeTypeItemEnum.DATE) {
                        DynamicObject entryDO = ruleEntryMap.get(id);
                        String format = MMCUtils.getDynamicObjectStringData(entryDO, "format", "");
                        SimpleDateFormat sdf = new SimpleDateFormat(format);
                        if (!(pvalue instanceof Date)) break;
                        endValue = sdf.format(pvalue);
                        break;
                    }
                    endValue = ConfigNumberGenerateUtils.delUseMode(pvalue.toString(), ruleRow);
                    break;
                }
                case SEQ: {
                    endValue = ConfigNumberGenerateUtils.delUseMode(String.valueOf(seq), ruleRow);
                    break;
                }
                case SERIALNUM: {
                    codeInfo.setHaveSerial(true);
                    String setValueStr = ruleRow.getString("setvalue");
                    if (StringUtils.isEmpty((CharSequence)setValueStr)) {
                        buildMsg.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6d41\u6c34\u53f7\u201c\u8bbe\u7f6e\u503c\u201d\u3002", (String)"ConfigNumberGenerateUtils_6", (String)"mmc-pdm-common", (Object[])new Object[0]));
                        codeInfo.setMsg(buildMsg);
                        break;
                    }
                    codeInfo.setSettingValue(ruleRow.getString("setvalue"));
                    codeInfo.setLenth(ruleRow.getInt("entrylength"));
                    codeInfo.setStep(ruleRow.getInt("steplength"));
                }
                case CONST: {
                    endValue = ruleRow.getString("setvalue");
                }
            }
            endValue = ConfigNumberGenerateUtils.delString2LowUp(endValue, iEnum, ruleRow.getString("formatvalue"));
            CodeRuleEntryBean entryInfo = new CodeRuleEntryBean(seq, ruleRow.getString("entryseparator"), iEnum, endValue, ruleRow.getBoolean("runnumberjudge"));
            codeInfo.getEntry().add(entryInfo);
            codeInfo.setSeq(seq);
        }
        if (codeInfo.isRight()) {
            StringBuilder sb = new StringBuilder();
            for (CodeRuleEntryBean entry : codeInfo.getEntry()) {
                if (!entry.isNumAccord()) continue;
                sb.append(entry.getPropValue());
            }
            codeInfo.setPropCol(sb.toString());
        }
        return codeInfo;
    }

    public static DynamicObject readDOFiled(DynamicObject irow, DynamicObject dataEntity, String sourceProp, int seq, Object entryPk) {
        if (dataEntity == null || StringUtils.isEmpty((CharSequence)sourceProp)) {
            log.info("");
            return null;
        }
        DynamicObject resultDO = null;
        String[] splits = sourceProp.split("\\.");
        String preSourceProp = splits[0];
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        IDataEntityProperty property = null;
        if (properties.containsKey((Object)preSourceProp)) {
            property = (IDataEntityProperty)properties.get((Object)preSourceProp);
        } else {
            List collProperties = properties.getCollectionProperties(false);
            for (IDataEntityProperty idProperty : collProperties) {
                DynamicObjectCollection doc = (DynamicObjectCollection)dataEntity.get(idProperty);
                DataEntityPropertyCollection docProperties = doc.getDynamicObjectType().getProperties();
                DynamicObject entryDO = null;
                if (docProperties.containsKey((Object)preSourceProp) && entryPk != null) {
                    for (DynamicObject entryDObj : doc) {
                        Object pkValue = entryDObj.getPkValue();
                        if (pkValue == null || !String.valueOf(pkValue).equals(String.valueOf(entryPk))) continue;
                        entryDO = entryDObj;
                    }
                }
                if (entryDO == null && docProperties.containsKey((Object)preSourceProp) && seq > 0 && doc.size() >= seq) {
                    entryDO = (DynamicObject)doc.get(seq - 1);
                }
                if (entryDO == null) continue;
                DynamicObject preSourceDO = null;
                if (!(entryDO.get(preSourceProp) instanceof DynamicObject)) {
                    if (entryDO.get(preSourceProp) instanceof DynamicObjectCollection) {
                        return entryDO;
                    }
                    return entryDO;
                }
                preSourceDO = MMCUtils.getDynamicObjectDynamicObjectData(entryDO, preSourceProp);
                DynamicObject valueObj = MMCUtils.getDynamicObjectDynamicObjectData(irow, "valueobject");
                String valueObjStr = MMCUtils.getDynamicObjectStringData(valueObj, "id");
                if (!StringUtils.isNotEmpty((CharSequence)valueObjStr) || preSourceDO == null || !preSourceDO.getDataEntityType().getName().equals(valueObjStr)) continue;
                Object pkValue = preSourceDO.getPkValue();
                resultDO = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)valueObjStr);
                return resultDO;
            }
        }
        Class propertyType = null;
        if (property != null) {
            propertyType = property.getPropertyType();
        }
        String typeName = "";
        typeName = propertyType == null ? "" : propertyType.getTypeName();
        if ("kd.bos.dataentity.entity.DynamicObject".equals(typeName)) {
            DynamicObject valueObj = MMCUtils.getDynamicObjectDynamicObjectData(irow, "valueobject");
            Object pkValue = ConfigNumberGenerateUtils.getSourcePropDynamicObject(dataEntity, preSourceProp);
            String entityNumber = ConfigNumberGenerateUtils.getSourcePropEntityNumber(dataEntity, preSourceProp);
            String valueObjStr = MMCUtils.getDynamicObjectStringData(valueObj, "id");
            if (StringUtils.isNotEmpty((CharSequence)valueObjStr) && pkValue != null && valueObjStr.equals(entityNumber)) {
                resultDO = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)valueObjStr);
            }
        } else {
            resultDO = dataEntity;
        }
        return resultDO;
    }

    private static String getSourcePropEntityNumber(DynamicObject dataEntity, String preSourceProp) {
        Object propValueObj = dataEntity.get(preSourceProp);
        String entityNumber = "";
        if (propValueObj instanceof DynamicObject) {
            entityNumber = ((DynamicObject)propValueObj).getDataEntityType().getName();
        } else {
            DynamicProperty property = dataEntity.getDynamicObjectType().getProperty(preSourceProp);
            if (property instanceof BasedataProp) {
                entityNumber = ((BasedataProp)property).getBaseEntityId();
            }
        }
        return entityNumber;
    }

    private static Object getSourcePropDynamicObject(DynamicObject dataEntity, String preSourceProp) {
        Object propValueObj = dataEntity.get(preSourceProp);
        Object pkValue = null;
        if (propValueObj instanceof DynamicObject) {
            pkValue = ((DynamicObject)propValueObj).getPkValue();
        } else if (propValueObj instanceof Long) {
            pkValue = propValueObj;
        }
        return pkValue;
    }

    public static String delString2LowUp(String endValue, CodeTypeItemEnum iEnum, String formatvalue) {
        if (StringUtils.isNotEmpty((CharSequence)formatvalue)) {
            block0 : switch (iEnum) {
                case DATE: {
                    break;
                }
                default: {
                    CodeRuleFormatEnum key = CodeRuleFormatEnum.getCodeRuleFormatEnumByValue(formatvalue);
                    if (key == null) break;
                    switch (key) {
                        default: {
                            break block0;
                        }
                        case LOW: {
                            endValue = endValue.toLowerCase();
                            break block0;
                        }
                        case UP: 
                    }
                    endValue = endValue.toUpperCase();
                }
            }
        }
        return endValue;
    }

    public static Object getLotPropValue(DynamicObject valueObj, Object vEntryPk, int seq, String valueProp, DynamicObject irow) {
        if (valueObj == null || StringUtils.isEmpty((CharSequence)valueProp)) {
            return "";
        }
        String[] props = valueProp.split("\\.");
        String ObjProp = props[0];
        DataEntityPropertyCollection properties = valueObj.getDataEntityType().getProperties();
        if (!properties.containsKey((Object)ObjProp)) {
            Object obj = null;
            List collProperties = properties.getCollectionProperties(false);
            for (IDataEntityProperty collProperty : collProperties) {
                DynamicObjectCollection doc = (DynamicObjectCollection)valueObj.get(collProperty);
                DataEntityPropertyCollection docProperties = doc.getDynamicObjectType().getProperties();
                if (docProperties.containsKey((Object)ObjProp) && vEntryPk != null) {
                    for (DynamicObject vEntryDO : doc) {
                        Object pkValue = vEntryDO.getPkValue();
                        if (pkValue == null || !String.valueOf(pkValue).equals(String.valueOf(vEntryPk))) continue;
                        obj = vEntryDO;
                    }
                }
                if (obj != null || !docProperties.containsKey((Object)ObjProp) || seq <= 0 || doc.size() < seq) continue;
                obj = ((DynamicObject)doc.get(seq - 1)).get(valueProp);
            }
            if (obj == null) {
                return "";
            }
            return obj;
        }
        try {
            return valueObj.get(valueProp);
        }
        catch (Exception var11) {
            throw new KDBizException((Throwable)var11, new ErrorCode("config-prop-resolve-error", String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u53f7\u5c5e\u6027\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u5c5e\u6027%1$s\u5b57\u6bb5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ConfigNumberGenerateUtils_7", (String)"mmc-pdm-common", (Object[])new Object[0]), valueProp)), new Object[0]);
        }
    }

    public static boolean checkEntryExistProp(DynamicObjectCollection entryDOC, String prop) {
        boolean flag = false;
        if (entryDOC == null || entryDOC.isEmpty() || StringUtils.isEmpty((CharSequence)prop)) {
            return flag;
        }
        DynamicObject entryDO = (DynamicObject)entryDOC.get(0);
        if (entryDO != null && entryDO.getDataEntityType().getProperties().containsKey((Object)prop)) {
            flag = true;
        }
        return flag;
    }

    public static String delUseMode(String value, DynamicObject ruleRow) {
        String result = "";
        int ruleLength = ruleRow.getInt("entrylength");
        switch (UseModeEnum.getUseModeEnumEnumByValue(ruleRow.getString("usemode"))) {
            case CUT: {
                if (value.length() == ruleLength) {
                    return value;
                }
                if (value.length() > ruleRow.getInt("entrylength")) {
                    String sparaMode = ruleRow.getString("sparamode");
                    if (StringUtils.equals((CharSequence)"A", (CharSequence)sparaMode)) {
                        result = value.substring(0, ruleLength);
                        break;
                    }
                    result = value.substring(value.length() - ruleLength, value.length());
                    break;
                }
                StringBuilder endString = new StringBuilder();
                String settingvalue = ruleRow.getString("fillsysmbol");
                for (int i = 0; i < ruleLength - value.length(); ++i) {
                    endString.append(settingvalue);
                }
                String fileMode = ruleRow.getString("fillmode");
                if (StringUtils.equals((CharSequence)"B", (CharSequence)fileMode)) {
                    StringBuilder re = new StringBuilder();
                    result = re.append(value).append((CharSequence)endString).toString();
                    break;
                }
                StringBuilder re = new StringBuilder();
                result = re.append((CharSequence)endString).append(value).toString();
                break;
            }
            case TOTAL: {
                result = value;
            }
        }
        return result;
    }

    public static boolean checkParamCodeRule(DynamicObject productConfigDO, DynamicObject configPlanDO, DynamicObject codeRuleDO, DynamicObject entryMaterialDO, JSONObject result) {
        String configPropStr;
        boolean resultFlag = false;
        DynamicObject materielNoDO = MMCUtils.getDynamicObjectDynamicObjectData(productConfigDO, "materielno");
        String materialNumber = MMCUtils.getDynamicObjectStringData(materielNoDO, RULE_NUMBER, "");
        DynamicObject materialInfoDO = null;
        if (entryMaterialDO != null) {
            materialInfoDO = QueryServiceHelper.queryOne((String)"bd_material", (String)"id,number,configproperties", (QFilter[])new QFilter[]{new QFilter("id", "=", entryMaterialDO.getPkValue())});
        }
        if (materialInfoDO != null && StringUtils.equals((CharSequence)(configPropStr = materialInfoDO.getString("configproperties")), (CharSequence)"1")) {
            return resultFlag;
        }
        if (configPlanDO == null) {
            log.info("RuleResolveUtils->autoGenerateConfigNumer\uff1a\u672a\u627e\u5230\u4ea7\u54c1\u914d\u7f6e\u65b9\u6848\u3002");
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4ea7\u54c1\u914d\u7f6e\u65b9\u6848\u3002", (String)"ConfigNumberGenerateUtils_8", (String)"mmc-pdm-common", (Object[])new Object[0]));
        }
        if (codeRuleDO == null) {
            log.info("RuleResolveUtils->autoGenerateConfigNumer\uff1a\u4ea7\u54c1\u914d\u7f6e\u65b9\u6848\u672a\u7ef4\u62a4\u914d\u7f6e\u53f7\u89c4\u5219\uff0c\u8bf7\u4fee\u6539\u3002");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4ea7\u54c1\u914d\u7f6e\u65b9\u6848\u672a\u7ef4\u62a4\u914d\u7f6e\u53f7\u89c4\u5219\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ConfigNumberGenerateUtils_9", (String)"mmc-pdm-common", (Object[])new Object[0]), materialNumber));
        }
        String ruleNumber = codeRuleDO.getString(RULE_NUMBER);
        String enable = codeRuleDO.getString("enable");
        if (!StringUtils.equals((CharSequence)enable, (CharSequence)"1")) {
            log.info("RuleResolveUtils->autoGenerateConfigNumer\uff1a\u4ea7\u54c1\u914d\u7f6e\u65b9\u6848\u7684\u914d\u7f6e\u53f7\u7f16\u7801\u89c4\u5219\u5df2\u88ab\u7981\u7528\u3002\"\u3002");
            result.put("errorInfo", (Object)String.format(ResManager.loadKDString((String)"%1$s\u4ea7\u54c1\u914d\u7f6e\u65b9\u6848\u7684\u914d\u7f6e\u53f7\u7f16\u7801\u89c4\u5219%2$s\u5df2\u88ab\u7981\u7528\u3002", (String)"ConfigNumberGenerateUtils_10", (String)"mmc-pdm-common", (Object[])new Object[0]), materialNumber, ruleNumber));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4ea7\u54c1\u914d\u7f6e\u65b9\u6848\u7684\u914d\u7f6e\u53f7\u7f16\u7801\u89c4\u5219%2$s\u5df2\u88ab\u7981\u7528\u3002", (String)"ConfigNumberGenerateUtils_10", (String)"mmc-pdm-common", (Object[])new Object[0]), materialNumber, ruleNumber));
        }
        DynamicObjectCollection codeRuleAttrDOC = codeRuleDO.getDynamicObjectCollection(RULE_ENTRY);
        if (codeRuleAttrDOC == null || codeRuleAttrDOC.isEmpty()) {
            log.info("RuleResolveUtils->autoGenerateConfigNumer\uff1a\u914d\u7f6e\u53f7\u89c4\u5219\u3010%s\u3011\u672a\u7ef4\u62a4\u914d\u7f6e\u53f7\u5c5e\u6027\uff0c\u8bf7\u4fee\u6539\u3002");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4ea7\u54c1\u914d\u7f6e\u65b9\u6848\u7684\u914d\u7f6e\u53f7\u89c4\u5219%2$s\u672a\u7ef4\u62a4\u914d\u7f6e\u53f7\u5c5e\u6027\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ConfigNumberGenerateUtils_11", (String)"mmc-pdm-common", (Object[])new Object[0]), materialNumber, ruleNumber));
        }
        ArrayList<Long> ruleAttrPKList = new ArrayList<Long>(8);
        for (DynamicObject ruleAttrDO : codeRuleAttrDOC) {
            DynamicObject codeAttr;
            if (ruleAttrDO == null || (codeAttr = ruleAttrDO.getDynamicObject("codeattr")) == null || !(codeAttr.getPkValue() instanceof Long)) continue;
            ruleAttrPKList.add((Long)codeAttr.getPkValue());
        }
        QFilter qFilter = new QFilter("id", "in", ruleAttrPKList);
        DynamicObject[] configCodeAttrs = BusinessDataServiceHelper.load((String)"bd_configcodeattr", (String)"id,number,enable", (QFilter[])new QFilter[]{qFilter});
        if (configCodeAttrs != null && configCodeAttrs.length > 0) {
            for (int i = 0; i < configCodeAttrs.length; ++i) {
                String attrEnable = configCodeAttrs[i].getString("enable");
                if (StringUtils.equals((CharSequence)"1", (CharSequence)attrEnable)) continue;
                String attrNumber = configCodeAttrs[i].getString(RULE_NUMBER);
                log.info("RuleResolveUtils->autoGenerateConfigNumer\uff1a\u914d\u7f6e\u53f7\u89c4\u5219\u3010%s\u3011\u672a\u7ef4\u62a4\u914d\u7f6e\u53f7\u5c5e\u6027\uff0c\u8bf7\u4fee\u6539\u3002");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4ea7\u54c1\u914d\u7f6e\u65b9\u6848\u7684\u914d\u7f6e\u53f7\u7f16\u7801\u89c4\u5219%2$s\u6240\u4f7f\u7528\u7684\u7f16\u7801\u5c5e\u6027%3$s\u5df2\u88ab\u7981\u7528\u3002", (String)"ConfigNumberGenerateUtils_12", (String)"mmc-pdm-common", (Object[])new Object[0]), materialNumber, ruleNumber, attrNumber));
            }
        }
        resultFlag = true;
        return resultFlag;
    }
}

