/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.AdvConAp;
import kd.bos.metadata.form.container.AdvConChildPanelAp;
import kd.bos.metadata.form.container.AdvConSummaryPanelAp;
import kd.bos.metadata.form.container.AdvConToolbarAp;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.EntryAp;

public class FormMetaDataUtil {
    private static FormMetadata getFormMetadata(String formNumber) {
        FormMetadata meta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        return meta;
    }

    public static ControlAp<?> getControlAp(String formNumber, String filedName) {
        FormMetadata meta = FormMetaDataUtil.getFormMetadata(formNumber);
        List controlAps = meta.getItems();
        for (ControlAp controlAp : controlAps) {
            if (!StringUtils.equals((CharSequence)filedName, (CharSequence)controlAp.getKey())) continue;
            return controlAp;
        }
        return null;
    }

    public static List<ControlAp<?>> getContainerAps(String formNumber, String containerName) {
        ArrayList resultControlAps = new ArrayList();
        FormMetadata meta = FormMetaDataUtil.getFormMetadata(formNumber);
        List controlAps = meta.getItems();
        for (ControlAp controlAp : controlAps) {
            if (!StringUtils.equals((CharSequence)containerName, (CharSequence)controlAp.getKey())) continue;
            return FormMetaDataUtil.getAllControlAp(controlAp, resultControlAps);
        }
        return null;
    }

    public static List<String> getContainerApNames(String formNumber, String containerName) {
        ArrayList<String> resultList = new ArrayList<String>(32);
        ArrayList resultControlAps = new ArrayList(16);
        FormMetadata meta = FormMetaDataUtil.getFormMetadata(formNumber);
        List controlAps = meta.getItems();
        for (ControlAp controlAp : controlAps) {
            if (!StringUtils.equals((CharSequence)containerName, (CharSequence)controlAp.getKey())) continue;
            FormMetaDataUtil.getAllControlAp(controlAp, resultControlAps);
        }
        if (resultControlAps != null && !resultControlAps.isEmpty()) {
            for (ControlAp controlAp : resultControlAps) {
                resultList.add(controlAp.getKey());
            }
        }
        return resultList;
    }

    private static List<ControlAp<?>> getAllControlAp(ControlAp<?> controlAp, List<ControlAp<?>> resultControlAps) {
        String simpleName = controlAp.getClass().getSimpleName();
        List controlAps = new ArrayList();
        switch (simpleName) {
            case "TabAp": {
                controlAps = ((TabAp)controlAp).getItems();
                break;
            }
            case "TabPageAp": {
                controlAps = ((TabPageAp)controlAp).getItems();
                break;
            }
            case "AdvConAp": {
                controlAps = ((AdvConAp)controlAp).getItems();
                break;
            }
            case "FlexPanelAp": {
                controlAps = ((FlexPanelAp)controlAp).getItems();
                break;
            }
            case "AdvConSummaryPanelAp": {
                controlAps = ((AdvConSummaryPanelAp)controlAp).getItems();
                break;
            }
            case "AdvConToolbarAp": {
                controlAps = ((AdvConToolbarAp)controlAp).getItems();
                break;
            }
            case "AdvConChildPanelAp": {
                controlAps = ((AdvConChildPanelAp)controlAp).getItems();
                break;
            }
            case "EntryAp": {
                controlAps = ((EntryAp)controlAp).getItems();
                break;
            }
            case "FieldsetPanelAp": {
                controlAps = ((FieldsetPanelAp)controlAp).getItems();
                break;
            }
            case "AdvConBarItemAp": {
                return resultControlAps;
            }
            case "EntryFieldAp": 
            case "FieldAp": {
                resultControlAps.add(controlAp);
                break;
            }
            default: {
                return resultControlAps;
            }
        }
        for (ControlAp control : controlAps) {
            resultControlAps = FormMetaDataUtil.getAllControlAp(control, resultControlAps);
        }
        return resultControlAps;
    }
}

