/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.lang.Lang;
import kd.bos.workflow.form.operate.flowchart.AbstractViewFlowchart;

public class MMCUtils {
    public final Calendar calendar = Calendar.getInstance();
    protected static final Date currDate = new Date();
    protected static final Timestamp currTime = new Timestamp(System.currentTimeMillis());
    public static final long dayTime = 86400000L;
    public static final String ENTITY_EQUARCHIVES = "eam_equarchives";
    public static final String ENTITY_FUNCTIONPOSITION = "eam_functionposition";
    public static final String ENTITY_FUNCTIONPOSITION_F7 = "eam_functionposition_bd";
    public static final long hourTime = 3600000L;
    public static final long minuteTime = 60000L;
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    public static final long secondTime = 1000L;
    public static final DBRoute sysDBRoute = new DBRoute("sys");
    public static final int treeNodeMaxLevel = 50;
    public static final DBRoute wfsDBRoute = new DBRoute("wfs");

    private MMCUtils() {
    }

    public static BillShowParameter createBillShowParameter(String formID, ShowType showType, OperationStatus operationStatus, long id, Map customParameters, CloseCallBack closeCallBack) {
        if (MMCUtils.isEmptyString(formID) || showType == null) {
            return null;
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(formID);
        OpenStyle openStyle = billShowParameter.getOpenStyle();
        if (openStyle != null) {
            openStyle.setShowType(showType);
        }
        if (id > 0L) {
            billShowParameter.setPkId((Object)id);
            if (operationStatus != null) {
                billShowParameter.setStatus(operationStatus);
            }
        }
        if (customParameters != null) {
            billShowParameter.setCustomParams(customParameters);
        }
        if (closeCallBack != null) {
            billShowParameter.setCloseCallBack(closeCallBack);
        }
        return billShowParameter;
    }

    public static FormShowParameter createFormShowParameter(String formID, ShowType showType, Map customParameters, CloseCallBack closeCallBack) {
        if (MMCUtils.isEmptyString(formID) || showType == null) {
            return null;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formID);
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        if (openStyle != null) {
            openStyle.setShowType(showType);
        }
        if (customParameters != null) {
            formShowParameter.setCustomParams(customParameters);
        }
        if (closeCallBack != null) {
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        return formShowParameter;
    }

    public static BigDecimal getDataModelBigDecimalData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param);
        return value instanceof BigDecimal ? (BigDecimal)value : null;
    }

    public static BigDecimal getDataModelBigDecimalData(IDataModel dataModel, String param, BigDecimal defaultValue) {
        if (dataModel == null || param == null) {
            return defaultValue;
        }
        BigDecimal value = MMCUtils.getDataModelBigDecimalData(dataModel, param);
        return value == null ? defaultValue : value;
    }

    public static BigDecimal getDataModelBigDecimalData(IDataModel dataModel, String param, int rowIndex) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param, rowIndex);
        return value instanceof BigDecimal ? (BigDecimal)value : null;
    }

    public static BigDecimal getDataModelBigDecimalData(IDataModel dataModel, String param, int rowIndex, BigDecimal defaultValue) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return defaultValue;
        }
        BigDecimal value = MMCUtils.getDataModelBigDecimalData(dataModel, param, rowIndex);
        return value == null ? defaultValue : value;
    }

    public static Boolean getDataModelBooleanData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return Boolean.FALSE;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param);
        return value instanceof Boolean ? (Boolean)value : Boolean.FALSE;
    }

    public static Boolean getDataModelBooleanData(IDataModel dataModel, String param, int rowIndex) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return Boolean.FALSE;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param, rowIndex);
        return value instanceof Boolean ? (Boolean)value : Boolean.FALSE;
    }

    public static Object getDataModelData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        IDataEntityProperty dep = dataModel.getProperty(param);
        Object value = dep == null ? null : dataModel.getValue(param);
        return value;
    }

    public static Object getDataModelData(IDataModel dataModel, String param, int rowIndex) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return null;
        }
        IDataEntityProperty dep = dataModel.getProperty(param);
        Object value = dep == null ? null : dataModel.getValue(param, rowIndex);
        return value;
    }

    public static Date getDataModelDateData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param);
        return value instanceof Date ? (Date)value : null;
    }

    public static Date getDataModelDateData(IDataModel dataModel, String param, int rowIndex) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param, rowIndex);
        return value instanceof Date ? (Date)value : null;
    }

    public static DynamicObject getDataModelDynamicObjectData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param);
        return value instanceof DynamicObject ? (DynamicObject)value : null;
    }

    public static DynamicObject getDataModelDynamicObjectData(IDataModel dataModel, String param, int rowIndex) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param, rowIndex);
        return value instanceof DynamicObject ? (DynamicObject)value : null;
    }

    public static Integer getDataModelIntegerData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param);
        return value instanceof Integer ? (Integer)value : null;
    }

    public static Integer getDataModelIntegerData(IDataModel dataModel, String param, int rowIndex) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param, rowIndex);
        return value instanceof Integer ? (Integer)value : null;
    }

    public static Integer getDataModelIntegerData(IDataModel dataModel, String param, int rowIndex, Integer defaultValue) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return defaultValue;
        }
        Integer value = MMCUtils.getDataModelIntegerData(dataModel, param, rowIndex);
        return value == null ? defaultValue : value;
    }

    public static Integer getDataModelIntegerData(IDataModel dataModel, String param, Integer defaultValue) {
        if (dataModel == null || param == null) {
            return defaultValue;
        }
        Integer value = MMCUtils.getDataModelIntegerData(dataModel, param);
        return value == null ? defaultValue : value;
    }

    public static ILocaleString getDataModelLocaleStringData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param);
        return value instanceof ILocaleString ? (ILocaleString)value : null;
    }

    public static ILocaleString getDataModelLocaleStringData(IDataModel dataModel, String param, int rowIndex) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param, rowIndex);
        return value instanceof ILocaleString ? (ILocaleString)value : null;
    }

    public static String getDataModelStringData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param);
        return value == null ? null : value.toString();
    }

    public static String getDataModelStringData(IDataModel dataModel, String param, int rowIndex) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param, rowIndex);
        return value == null ? null : value.toString();
    }

    public static String getDataModelStringData(IDataModel dataModel, String param, int rowIndex, String defaultValue) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return defaultValue;
        }
        String value = MMCUtils.getDataModelStringData(dataModel, param, rowIndex);
        return value == null ? defaultValue : value;
    }

    public static String getDataModelStringData(IDataModel dataModel, String param, String defaultValue) {
        if (dataModel == null || param == null) {
            return defaultValue;
        }
        String value = MMCUtils.getDataModelStringData(dataModel, param);
        return value == null ? defaultValue : value;
    }

    public static Timestamp getDataModelTimestampData(IDataModel dataModel, String param) {
        if (dataModel == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param);
        return value instanceof Timestamp ? (Timestamp)value : null;
    }

    public static Timestamp getDataModelTimestampData(IDataModel dataModel, String param, int rowIndex) {
        if (dataModel == null || param == null || rowIndex < 0) {
            return null;
        }
        Object value = MMCUtils.getDataModelData(dataModel, param, rowIndex);
        return value instanceof Timestamp ? (Timestamp)value : null;
    }

    public static BigDecimal getDynamicObjectBigDecimalData(DynamicObject dynObj, String param) {
        if (dynObj == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDynamicObjectData(dynObj, param);
        return value instanceof BigDecimal ? (BigDecimal)value : null;
    }

    public static BigDecimal getDynamicObjectBigDecimalData(DynamicObject dynObj, String param, BigDecimal defaultValue) {
        if (dynObj == null || param == null) {
            return defaultValue;
        }
        BigDecimal value = MMCUtils.getDynamicObjectBigDecimalData(dynObj, param);
        return value == null ? defaultValue : value;
    }

    public static Boolean getDynamicObjectBooleanData(DynamicObject dynObj, String param) {
        if (dynObj == null || param == null) {
            return Boolean.FALSE;
        }
        Object value = MMCUtils.getDynamicObjectData(dynObj, param);
        return value instanceof Boolean ? (Boolean)value : Boolean.FALSE;
    }

    public static Object getDynamicObjectData(DynamicObject dynObj, String param) {
        if (dynObj == null || param == null) {
            return null;
        }
        IDataEntityType det = dynObj.getDataEntityType();
        if (det == null) {
            return null;
        }
        DataEntityPropertyCollection depc = det.getProperties();
        if (MMCUtils.isEmptyList((List)depc)) {
            return null;
        }
        if (!depc.containsKey((Object)param)) {
            return null;
        }
        Object value = dynObj.get(param);
        return value;
    }

    public static Date getDynamicObjectDateData(DynamicObject dynObj, String param) {
        if (dynObj == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDynamicObjectData(dynObj, param);
        return value instanceof Date ? (Date)value : null;
    }

    public static DynamicObject getDynamicObjectDynamicObjectData(DynamicObject dynObj, String param) {
        if (dynObj == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDynamicObjectData(dynObj, param);
        return value instanceof DynamicObject ? (DynamicObject)value : null;
    }

    public static Integer getDynamicObjectIntegerData(DynamicObject dynObj, String param) {
        if (dynObj == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDynamicObjectData(dynObj, param);
        return value instanceof Integer ? (Integer)value : null;
    }

    public static Integer getDynamicObjectIntegerData(DynamicObject dynObj, String param, Integer defaultValue) {
        if (dynObj == null || param == null) {
            return defaultValue;
        }
        Integer value = MMCUtils.getDynamicObjectIntegerData(dynObj, param);
        return value == null ? defaultValue : value;
    }

    public static ILocaleString getDynamicObjectLocaleStringData(DynamicObject dynObj, String param) {
        if (dynObj == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDynamicObjectData(dynObj, param);
        return value instanceof ILocaleString ? (ILocaleString)value : null;
    }

    public static Long getDynamicObjectPK(DynamicObject dynObj) {
        Object pkObj = dynObj == null ? null : dynObj.getPkValue();
        Long pk = pkObj == null ? Long.valueOf(-1L) : Long.valueOf(Long.parseLong(pkObj.toString()));
        return pk > 0L ? pk : -1L;
    }

    public static String getDynamicObjectStringData(DynamicObject dynObj, String param) {
        if (dynObj == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDynamicObjectData(dynObj, param);
        return value == null ? null : value.toString();
    }

    public static String getDynamicObjectStringData(DynamicObject dynObj, String param, String defaultValue) {
        if (dynObj == null || param == null) {
            return defaultValue;
        }
        String value = MMCUtils.getDynamicObjectStringData(dynObj, param);
        return value == null ? defaultValue : value;
    }

    public static Timestamp getDynamicObjectTimestampData(DynamicObject dynObj, String param) {
        if (dynObj == null || param == null) {
            return null;
        }
        Object value = MMCUtils.getDynamicObjectData(dynObj, param);
        return value instanceof Timestamp ? (Timestamp)value : null;
    }

    public static Object getListData(List list, int index) {
        if (MMCUtils.isEmptyList(list) || index < 0) {
            return null;
        }
        int size = list.size();
        if (index + 1 > size) {
            return null;
        }
        return list.get(index);
    }

    public static Map getListMapData(List list, int index) {
        if (MMCUtils.isEmptyList(list) || index < 0) {
            return null;
        }
        Object value = MMCUtils.getListData(list, index);
        return value instanceof Map ? (Map)value : null;
    }

    public static Map getListMapData(List list, int index, Map defaultValue) {
        if (MMCUtils.isEmptyList(list) || index < 0) {
            return defaultValue;
        }
        Map value = MMCUtils.getListMapData(list, index);
        return value == null ? defaultValue : value;
    }

    public static String getLocaleID() {
        RequestContext requestContext = RequestContext.get();
        if (requestContext == null) {
            return null;
        }
        Lang lang = requestContext.getLang();
        if (lang == null) {
            return null;
        }
        Locale locale = lang.getLocale();
        if (locale == null) {
            return null;
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (MMCUtils.isEmptyString(language) || MMCUtils.isEmptyString(country)) {
            return null;
        }
        String localeID = language + "_" + country;
        return localeID;
    }

    public static BigDecimal getMapBigDecimalData(Map map, Object param) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = MMCUtils.getMapData(map, param);
        return value instanceof BigDecimal ? (BigDecimal)value : null;
    }

    public static BigDecimal getMapBigDecimalData(Map map, Object param, BigDecimal defaultValue) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        BigDecimal value = MMCUtils.getMapBigDecimalData(map, param);
        return value == null ? defaultValue : value;
    }

    public static Boolean getMapBooleanData(Map map, Object param) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = MMCUtils.getMapData(map, param);
        return value instanceof Boolean ? (Boolean)value : null;
    }

    public static Boolean getMapBooleanData(Map map, Object param, Boolean defaultValue) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        Boolean value = MMCUtils.getMapBooleanData(map, param);
        return value == null ? defaultValue : value;
    }

    public static Object getMapData(Map map, Object param) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = null;
        if (map.get(param) != null) {
            value = map.get(param);
        }
        return value;
    }

    public static Date getMapDateData(Map map, Object param) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = MMCUtils.getMapData(map, param);
        return value instanceof Date ? (Date)value : null;
    }

    public static Integer getMapIntegerData(Map map, Object param) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = MMCUtils.getMapData(map, param);
        return value instanceof Integer ? (Integer)value : null;
    }

    public static Integer getMapIntegerData(Map map, Object param, Integer defaultValue) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        Integer value = MMCUtils.getMapIntegerData(map, param);
        return value == null ? defaultValue : value;
    }

    public static List getMapListData(Map map, Object param) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return new ArrayList();
        }
        Object value = MMCUtils.getMapData(map, param);
        return value instanceof List ? (List)value : new ArrayList();
    }

    public static List getMapListData(Map map, Object param, List defaultValue) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        List value = MMCUtils.getMapListData(map, param);
        return value.isEmpty() ? defaultValue : value;
    }

    public static Long getMapLongData(Map map, Object param) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = MMCUtils.getMapData(map, param);
        return value instanceof Long ? (Long)value : null;
    }

    public static Map getMapMapData(Map map, Object param) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = MMCUtils.getMapData(map, param);
        return value instanceof Map ? (Map)value : null;
    }

    public static Map getMapMapData(Map map, Object param, Map defaultValue) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        Map value = MMCUtils.getMapMapData(map, param);
        return value == null ? defaultValue : value;
    }

    public static Set getMapSetData(Map map, Object param) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return new HashSet();
        }
        Object value = MMCUtils.getMapData(map, param);
        return value instanceof Set ? (Set)value : new HashSet();
    }

    public static Set getMapSetData(Map map, Object param, Set defaultValue) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        Set value = MMCUtils.getMapSetData(map, param);
        return value.isEmpty() ? defaultValue : value;
    }

    public static String getMapStringData(Map map, Object param) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = MMCUtils.getMapData(map, param);
        return value == null ? null : value.toString();
    }

    public static String getMapStringData(Map map, Object param, String defaultValue) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        Object value = MMCUtils.getMapData(map, param);
        return value == null ? defaultValue : value.toString();
    }

    public static Time getMapTimeData(Map map, Object param) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = MMCUtils.getMapData(map, param);
        return value instanceof Time ? (Time)value : null;
    }

    public static Timestamp getMapTimestampData(Map map, Object param) {
        if (MMCUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = MMCUtils.getMapData(map, param);
        return value instanceof Timestamp ? (Timestamp)value : null;
    }

    public static TreeNode getTreeNode(TreeNode tn, String nodeID) {
        if (tn == null || MMCUtils.isEmptyString(nodeID)) {
            return null;
        }
        return tn.getTreeNode(nodeID, 50);
    }

    public static boolean isEmptyArray(Object[] array) {
        if (array == null) {
            return true;
        }
        return array.length == 0;
    }

    public static boolean isEmptyList(List list) {
        if (list == null) {
            return true;
        }
        return list.size() == 0;
    }

    public static boolean isEmptyMap(Map map) {
        if (map == null) {
            return true;
        }
        return map.size() == 0;
    }

    public static boolean isEmptySet(Set set) {
        if (set == null) {
            return true;
        }
        return set.size() == 0;
    }

    public static boolean isEmptyString(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() == 0;
    }

    public static boolean isEmptyStringBuilder(String sb) {
        if (sb == null) {
            return true;
        }
        if (sb.length() == 0) {
            return true;
        }
        return sb.trim().length() == 0;
    }

    public static boolean isZeroBigDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return true;
        }
        return bigDecimal.compareTo(BigDecimal.ZERO) == 0;
    }

    public static boolean isZeroInteger(Integer integer) {
        if (integer == null) {
            return true;
        }
        return integer.compareTo(0) == 0;
    }

    public static LocaleString LocaleDynamicObjectCollectionToLocaleString(Object ldocObj, String propName) {
        String localeID;
        if (ldocObj == null || MMCUtils.isEmptyString(propName)) {
            return null;
        }
        LocaleString ls = new LocaleString();
        LocaleDynamicObjectCollection ldoc = ldocObj instanceof LocaleDynamicObjectCollection ? (LocaleDynamicObjectCollection)ldocObj : null;
        IDataEntityProperty localeDEP = ldoc == null ? null : ldoc.getLocaleIdProperty();
        String localeDEPName = localeDEP == null ? null : localeDEP.getName();
        int ldocSize = ldoc == null ? 0 : ldoc.size();
        Object localeIDObj = ldoc == null || localeDEP == null ? null : ldoc.getCurrentLocaleValue(localeDEP);
        String string = localeID = localeIDObj == null ? null : localeIDObj.toString();
        if (!MMCUtils.isEmptyString(localeID)) {
            for (int ldocIndex = 0; ldocIndex < ldocSize && ldoc != null && !ldoc.isEmpty(); ++ldocIndex) {
                String tmpLocaleID;
                DynamicObject ldo = (DynamicObject)ldoc.get(ldocIndex);
                if (ldo == null || MMCUtils.isEmptyString(localeDEPName) || MMCUtils.isEmptyString(tmpLocaleID = MMCUtils.getDynamicObjectStringData(ldo, localeDEPName))) continue;
                String localeText = MMCUtils.getDynamicObjectStringData(ldo, propName);
                ls.setItem(tmpLocaleID, (Object)localeText);
            }
        }
        if (ls.size() == 0) {
            return null;
        }
        return ls;
    }

    public static LocaleString OrmLocaleValueToLocaleString(Object olvObj) {
        Iterator olvIterator;
        if (olvObj == null) {
            return null;
        }
        LocaleString ls = new LocaleString();
        OrmLocaleValue olv = olvObj instanceof OrmLocaleValue ? (OrmLocaleValue)olvObj : null;
        Set olvKeySet = olv == null ? null : olv.keySet();
        Iterator iterator = olvIterator = olvKeySet == null ? null : olvKeySet.iterator();
        if (olvIterator != null) {
            while (olvIterator.hasNext()) {
                String olvKey;
                Object olvKeyObj = olvIterator.next();
                String string = olvKey = olvKeyObj == null ? null : olvKeyObj.toString();
                if (MMCUtils.isEmptyString(olvKey)) continue;
                String olvValue = olv.get((Object)olvKey);
                ls.setItem(olvKey, (Object)olvValue);
            }
        }
        if (ls.size() == 0) {
            return null;
        }
        return ls;
    }

    public static void showWorkFlowChart(IFormView formView, String billID) {
        if (formView == null || MMCUtils.isEmptyString(billID)) {
            return;
        }
        AbstractViewFlowchart abstractViewFlow = new AbstractViewFlowchart();
        abstractViewFlow.setBillId((Object)billID);
        abstractViewFlow.showFlowchart(formView);
    }

    public static String timeFormat(long time, String format) {
        long mod;
        boolean formatS;
        if (MMCUtils.isEmptyString(format)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        long newTime = time;
        String formatStr = format;
        String transStr = formatStr.toUpperCase().trim();
        boolean formatH = transStr.indexOf(72) >= 0;
        boolean formatM = transStr.indexOf(77) >= 0;
        boolean bl = formatS = transStr.indexOf(83) >= 0;
        if (formatH) {
            if (newTime >= 3600000L) {
                mod = newTime % 3600000L;
                long h = (newTime -= mod) / 3600000L;
                sb.append(h);
                newTime = mod;
            } else {
                sb.append('0');
            }
            sb.append(ResManager.loadKDString((String)"\u65f6", (String)"MMCUtils_0", (String)"mmc-pdm-common", (Object[])new Object[0]));
        }
        if (formatM) {
            if (newTime >= 60000L) {
                mod = newTime % 60000L;
                long m = (newTime -= mod) / 60000L;
                if (formatH && m < 10L) {
                    sb.append('0');
                }
                sb.append(m);
                newTime = mod;
            } else {
                sb.append("00");
            }
            sb.append(ResManager.loadKDString((String)"\u5206", (String)"MMCUtils_1", (String)"mmc-pdm-common", (Object[])new Object[0]));
        }
        if (formatS) {
            if (newTime >= 1000L) {
                mod = newTime % 1000L;
                long s = (newTime -= mod) / 1000L;
                if (formatM && s < 10L) {
                    sb.append('0');
                }
                sb.append(s);
                newTime = mod;
            } else {
                sb.append("00");
            }
            sb.append(ResManager.loadKDString((String)"\u79d2", (String)"MMCUtils_2", (String)"mmc-pdm-common", (Object[])new Object[0]));
        }
        return sb.toString();
    }

    public static List<Map<String, Object>> parseNonSyncronizedToList(DataSet dateSet) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(7);
        try {
            if (dateSet == null) {
                ArrayList<Map<String, Object>> arrayList = list;
                return arrayList;
            }
            String[] fieldNames = dateSet.getRowMeta().getFieldNames();
            int size = fieldNames.length;
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                HashMap<String, Object> map = new HashMap<String, Object>(7);
                for (int i = 0; i < size; ++i) {
                    String key = fieldNames[i];
                    Object value = row.get(key);
                    map.put(key, value);
                }
                if (map.isEmpty()) continue;
                list.add(map);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (dateSet != null) {
                dateSet.close();
            }
        }
        return list;
    }

    public static JSONArray parseToJSONArray(DataSet dateSet) {
        JSONArray retArray = new JSONArray();
        try {
            if (dateSet == null) {
                JSONArray jSONArray = retArray;
                return jSONArray;
            }
            String[] fieldNames = dateSet.getRowMeta().getFieldNames();
            int size = fieldNames.length;
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                JSONObject obj = new JSONObject();
                for (int i = 0; i < size; ++i) {
                    String key = fieldNames[i];
                    Object value = row.get(key);
                    obj.put(key, value);
                }
                if (obj.isEmpty()) continue;
                retArray.add((Object)obj);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (dateSet != null) {
                dateSet.close();
            }
        }
        return retArray;
    }

    public static List<Map<String, Object>> parseToList(DataSet dateSet) {
        List<Map<String, Object>> list = Collections.synchronizedList(new ArrayList());
        try {
            if (dateSet == null) {
                List<Map<String, Object>> list2 = list;
                return list2;
            }
            String[] fieldNames = dateSet.getRowMeta().getFieldNames();
            int size = fieldNames.length;
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Map<String, Object> map = Collections.synchronizedMap(new HashMap());
                for (int i = 0; i < size; ++i) {
                    String key = fieldNames[i];
                    Object value = row.get(key);
                    map.put(key, value);
                }
                if (map.isEmpty()) continue;
                list.add(map);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (dateSet != null) {
                dateSet.close();
            }
        }
        return list;
    }

    public static Set<Map<String, Object>> parseToSet(DataSet dateSet) {
        HashSet<Map<String, Object>> retSet = new HashSet<Map<String, Object>>();
        try {
            if (dateSet == null) {
                HashSet<Map<String, Object>> hashSet = retSet;
                return hashSet;
            }
            String[] fieldNames = dateSet.getRowMeta().getFieldNames();
            int size = fieldNames.length;
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Map<String, Object> map = Collections.synchronizedMap(new HashMap());
                for (int i = 0; i < size; ++i) {
                    String key = fieldNames[i];
                    Object value = row.get(key);
                    map.put(key, value);
                }
                if (map.isEmpty()) continue;
                retSet.add(map);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (dateSet != null) {
                dateSet.close();
            }
        }
        return retSet;
    }

    public static DataSet parseToDataSet(Object plugin, List<Map<String, Object>> list, RowMeta rowMeta) {
        Algo algo = Algo.create((String)plugin.getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        String[] names = rowMeta.getFieldNames();
        int size = list.size();
        int namesSize = names.length;
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = list.get(i);
            Object[] objArray = new Object[map.size()];
            for (int k = 0; k < namesSize; ++k) {
                Object value;
                String fiedName = names[k];
                objArray[k] = value = map.get(fiedName);
            }
            builder.append(objArray);
        }
        AbstractDataSet dateSet = (AbstractDataSet)builder.build();
        return dateSet;
    }

    public static List<Map<String, Object>> dyColToList(DynamicObjectCollection col) {
        List<Map<String, Object>> list = Collections.synchronizedList(new ArrayList());
        if (col.isEmpty()) {
            return list;
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = Collections.synchronizedMap(new HashMap());
            DynamicObject obj = (DynamicObject)col.get(i);
            DataEntityPropertyCollection dataEntityCol = obj.getDataEntityType().getProperties();
            int colSize = dataEntityCol.size();
            for (int k = 0; k < colSize; ++k) {
                String fieldName = ((IDataEntityProperty)dataEntityCol.get(k)).getName();
                Object value = obj.get(fieldName);
                map.put(fieldName, value);
            }
            if (map.isEmpty()) continue;
            list.add(map);
        }
        return list;
    }

    public static Map<String, Object> mapCopy(Map<String, Object> dataMap) {
        Map<String, Object> retMap = Collections.synchronizedMap(new HashMap(100));
        if (dataMap == null || dataMap.isEmpty()) {
            return retMap;
        }
        Set<Map.Entry<String, Object>> set = dataMap.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            retMap.put(entry.getKey(), entry.getValue());
        }
        return retMap;
    }

    public static boolean isNewWsMode() {
        return false;
    }

    public static boolean isOne(BigDecimal a) {
        return a.compareTo(BigDecimal.ONE) == 0;
    }

    public static BigDecimal divide(BigDecimal a, BigDecimal b) {
        return MMCUtils.isOne(b) ? a : a.divide(b, 10, RoundingMode.HALF_UP);
    }

    public static BigDecimal multiply(BigDecimal a, BigDecimal b) {
        return MMCUtils.isOne(a) ? b : (MMCUtils.isOne(b) ? a : a.multiply(b).setScale(10, RoundingMode.HALF_UP));
    }

    public static BigDecimal multiplyAndDivide(BigDecimal a, BigDecimal b, BigDecimal c) {
        if (b.compareTo(c) == 0) {
            return a;
        }
        BigDecimal mulValue = MMCUtils.multiply(a, b);
        return MMCUtils.divide(mulValue, c);
    }
}

