/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.util.batchbom;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mutex.DataMutex;
import kd.mmc.pdm.common.util.MMCUtils;

public class BatchBOMUtils {
    private static final String CONFIG_CODE = "entryconfiguredcode";

    public static List<String> getModifyFieldList(List<String> modifyFieldList, DataEntityPropertyCollection properties, DynamicObject bomInfo) {
        List<String> mPropList = BatchBOMUtils.fieldTrans(modifyFieldList, properties, bomInfo);
        return mPropList;
    }

    public static List<String> getModifyFieldList(List<String> modifyFiledList, DynamicObject bomInfo) {
        DataEntityPropertyCollection properties = bomInfo.getDynamicObjectCollection("entry").getDynamicObjectType().getProperties();
        return BatchBOMUtils.getReplaceFieldList(modifyFiledList, properties, bomInfo);
    }

    public static List<String> getReplaceFieldList(List<String> modifyField, DataEntityPropertyCollection properties, DynamicObject bomInfo) {
        List<String> rplacePropList = BatchBOMUtils.fieldTrans(modifyField, properties, bomInfo);
        rplacePropList.add("configproperties");
        rplacePropList.add("entryunit");
        return rplacePropList;
    }

    private static List<String> fieldTrans(List<String> modifyField, DataEntityPropertyCollection properties, DynamicObject bomInfo) {
        ArrayList<String> replaceFiedList = new ArrayList<String>(16);
        modifyField.forEach(fieldName -> {
            if (StringUtils.contains((CharSequence)fieldName, (CharSequence)"_ctrl") || StringUtils.contains((CharSequence)fieldName, (CharSequence)"_qty") || StringUtils.contains((CharSequence)fieldName, (CharSequence)"_set")) {
                replaceFiedList.add(fieldName.substring(0, fieldName.indexOf("_")));
            } else {
                replaceFiedList.add((String)fieldName);
            }
        });
        DynamicObject bomTypeDO = bomInfo.getDynamicObject("type");
        BatchBOMUtils.isConfigCodeEdit(replaceFiedList, bomTypeDO);
        ArrayList rplacePropList = new ArrayList(32);
        properties.forEach(property -> {
            if (replaceFiedList.contains(property.getName())) {
                rplacePropList.add(property.getName());
            }
        });
        return replaceFiedList;
    }

    private static void isConfigCodeEdit(List<String> propList, DynamicObject bomTypeDO) {
        boolean issalebom;
        if (propList == null || propList.isEmpty()) {
            return;
        }
        if (!(bomTypeDO == null || (issalebom = MMCUtils.getDynamicObjectBooleanData(bomTypeDO, "issalebom").booleanValue()) && propList.contains(CONFIG_CODE))) {
            propList.remove(CONFIG_CODE);
        }
    }

    public static Date getInvalidityDateFromChangeEntry(DynamicObject invalidEntry) {
        Date modifVaildDate = MMCUtils.getDynamicObjectDateData(invalidEntry, "entryvaliddate");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(modifVaildDate);
        int second = calendar.get(13) - 1;
        calendar.set(13, second);
        Date invalidDate = calendar.getTime();
        return invalidDate;
    }

    public static boolean checkInvalidDate(DynamicObject bomEntry, Date invalidDate) {
        boolean checkRes = false;
        Date bomEntryEffectuateDate = MMCUtils.getDynamicObjectDateData(bomEntry, "entryvaliddate");
        Date bomEntryInvalidDate = MMCUtils.getDynamicObjectDateData(bomEntry, "entryinvaliddate");
        if (invalidDate == null || bomEntryEffectuateDate == null || bomEntryInvalidDate == null) {
            return checkRes;
        }
        if (bomEntryEffectuateDate.before(invalidDate) && bomEntryInvalidDate.after(invalidDate)) {
            checkRes = true;
        }
        return checkRes;
    }

    public static Date getNewEntryValidDate(Date validTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(validTime);
        int second = calendar.get(13) - 1;
        calendar.set(13, second);
        return calendar.getTime();
    }

    public static void batchReleaseMutex(DynamicObjectCollection modifyBomDOC) {
        if (modifyBomDOC.isEmpty()) {
            return;
        }
        ArrayList mutexRequireList = new ArrayList(1);
        String groupId = "default_netctrl";
        for (DynamicObject bom : modifyBomDOC) {
            long bomPk = bom.getLong("id");
            HashMap<String, String> requireParam = new HashMap<String, String>();
            requireParam.put("dataObjId", bomPk + "");
            requireParam.put("groupId", groupId);
            requireParam.put("entityKey", "pdm_mftbom");
            requireParam.put("operationKey", "modify");
            mutexRequireList.add(requireParam);
        }
        try (DataMutex dataMutex = DataMutex.create();){
            Map map = dataMutex.batchRelease(mutexRequireList);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("ReleaseMutexException", e.getMessage()), new Object[0]);
        }
    }

    public static DynamicObject repeatEcoEntryValidate(String verifyDimension, Map<String, List<DynamicObject>> repeatEntryDataMap, DynamicObject entryData) {
        if (StringUtils.isEmpty((CharSequence)verifyDimension.trim())) {
            return null;
        }
        String[] splits = verifyDimension.split(",");
        StringBuilder uniqueBuilder = new StringBuilder();
        block14: for (int i = 0; i < splits.length; ++i) {
            switch (splits[i]) {
                case "A": {
                    DynamicObject material = entryData.getDynamicObject("entrymaterialid");
                    if (material == null) continue block14;
                    long materialPk = material.getLong("id");
                    uniqueBuilder.append(materialPk).append(":");
                    continue block14;
                }
                case "B": {
                    DynamicObject version = entryData.getDynamicObject("entryversion");
                    if (version == null) continue block14;
                    long versionPk = version.getLong("id");
                    uniqueBuilder.append(versionPk).append(":");
                    continue block14;
                }
                case "C": {
                    DynamicObject auxproperty = entryData.getDynamicObject("entryauxproperty");
                    if (auxproperty == null) continue block14;
                    long auxpropertyPk = auxproperty.getLong("id");
                    uniqueBuilder.append(auxpropertyPk).append(":");
                    continue block14;
                }
                case "D": {
                    String operationNumber = entryData.getString("entryoperationnumber");
                    if (!StringUtils.isNotEmpty((CharSequence)operationNumber)) continue block14;
                    uniqueBuilder.append(operationNumber).append(":");
                    continue block14;
                }
                case "E": {
                    DynamicObject configCode = entryData.getDynamicObject(CONFIG_CODE);
                    if (configCode == null) continue block14;
                    long configCodePk = configCode.getLong("id");
                    uniqueBuilder.append(configCodePk).append(":");
                }
            }
        }
        List repeatEntrys = repeatEntryDataMap.getOrDefault(uniqueBuilder.toString(), new ArrayList(2));
        DynamicObject repeatRow = null;
        if (repeatEntrys.isEmpty()) {
            repeatEntrys.add(entryData);
        } else {
            Date validate = BatchBOMUtils.getEntryValidData(entryData);
            Date invalidate = BatchBOMUtils.getEntryInValidData(entryData);
            for (DynamicObject rowData : repeatEntrys) {
                Date repeatInvalidate;
                Date repeatValidate = BatchBOMUtils.getEntryValidData(rowData);
                if (!BatchBOMUtils.valiDateIntersect(validate, invalidate, repeatValidate, repeatInvalidate = BatchBOMUtils.getEntryInValidData(rowData))) continue;
                repeatRow = rowData;
                break;
            }
            if (repeatRow == null) {
                repeatEntrys.add(entryData);
            }
        }
        repeatEntryDataMap.put(uniqueBuilder.toString(), repeatEntrys);
        return repeatRow;
    }

    private static Date getEntryValidData(DynamicObject entryData) {
        String entryMode = BatchBOMUtils.getEntryMode(entryData);
        Date validate = entryData.getDate("entryvaliddate");
        if (StringUtils.isNotEmpty((CharSequence)entryMode)) {
            if (StringUtils.equals((CharSequence)"A", (CharSequence)entryMode)) {
                validate = entryData.getDate("acttime");
            } else if (StringUtils.equals((CharSequence)"B", (CharSequence)entryMode)) {
                validate = entryData.getDate("entryvaliddate");
            } else if (StringUtils.equals((CharSequence)"C", (CharSequence)entryMode)) {
                validate = BatchBOMUtils.getNewEntryValidDate(entryData.getDate("acttime"));
            } else if (StringUtils.equals((CharSequence)"D", (CharSequence)entryMode)) {
                validate = entryData.getDate("entryvaliddate");
            }
        }
        return validate;
    }

    private static Date getEntryInValidData(DynamicObject entryData) {
        String entryMode = BatchBOMUtils.getEntryMode(entryData);
        Date invalidate = entryData.getDate("entryinvaliddate");
        if (StringUtils.isNotEmpty((CharSequence)entryMode)) {
            if (StringUtils.equals((CharSequence)"A", (CharSequence)entryMode)) {
                invalidate = entryData.getDate("entryinvaliddate");
            } else if (StringUtils.equals((CharSequence)"B", (CharSequence)entryMode)) {
                invalidate = BatchBOMUtils.getNewEntryValidDate(entryData.getDate("acttime"));
            } else if (StringUtils.equals((CharSequence)"C", (CharSequence)entryMode)) {
                invalidate = entryData.getDate("entryinvaliddate");
            } else if (StringUtils.equals((CharSequence)"D", (CharSequence)entryMode)) {
                invalidate = BatchBOMUtils.getNewEntryValidDate(entryData.getDate("acttime"));
            }
        }
        return invalidate;
    }

    private static String getEntryMode(DynamicObject entryData) {
        String entryMode = "";
        DataEntityPropertyCollection properties = entryData.getDynamicObjectType().getProperties();
        if (properties.containsKey((Object)"acttime") && properties.containsKey((Object)"entrymode")) {
            entryMode = entryData.getString("entrymode");
        }
        return entryMode;
    }

    private static String getMaterialNumber(DynamicObject entry) {
        DynamicObject matInfo = entry.getDynamicObject("entrymaterial");
        DynamicObject material = null;
        material = matInfo != null ? matInfo.getDynamicObject("masterid") : entry.getDynamicObject("entrymaterialid");
        String materialNumber = "";
        if (material != null) {
            materialNumber = material.getString("number");
        }
        return materialNumber;
    }

    public static String buildErrorMessageInfo(String verifyDimension, DynamicObject entry, DynamicObject repeatRow, String checkRepeat, String changeType) {
        String verifyDimensionStr = BatchBOMUtils.getVerifyDimensionStr(verifyDimension);
        String errorInfo = "";
        if ("B".equals(checkRepeat)) {
            String matNumber = BatchBOMUtils.getMaterialNumber(entry);
            errorInfo = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u7f16\u7801%1$s\u5728\u540c\u4e00\u65f6\u95f4\u5185\u5b58\u5728%2$s\u5b8c\u5168\u76f8\u540c\u7684\u591a\u884c\u5206\u5f55\u3002", (String)"BatchBOMUtils_0", (String)"mmc-pdm-common", (Object[])new Object[0]), matNumber, verifyDimensionStr);
        } else if ("C".equals(checkRepeat)) {
            String matNumber = BatchBOMUtils.getMaterialNumber(entry);
            errorInfo = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u201d\u91cd\u590d\u6027\u6821\u9a8c\u201d\u4e3a\u201c\u4e25\u683c\u63a7\u5236\u201d\uff0c\u4e0d\u5141\u8bb8\u5b58\u5728\u91cd\u590d\u884c\uff0c\u7ec4\u4ef6\u7f16\u7801%1$s\u5728\u540c\u4e00\u65f6\u95f4\u5185\u5b58\u5728%2$s\u5b8c\u5168\u76f8\u540c\u7684\u591a\u884c\u5206\u5f55\u3002", (String)"BatchBOMUtils_1", (String)"mmc-pdm-common", (Object[])new Object[0]), matNumber, verifyDimensionStr);
        }
        return errorInfo;
    }

    public static String getVerifyDimensionStr(String verifyDimension) {
        if (StringUtils.isEmpty((CharSequence)verifyDimension.trim())) {
            return null;
        }
        String[] splits = verifyDimension.split(",");
        StringBuilder messageBuilder = new StringBuilder();
        block14: for (int i = 0; i < splits.length; ++i) {
            switch (splits[i]) {
                case "A": {
                    messageBuilder.append(ResManager.loadKDString((String)"\u201c\u7269\u6599\u201d", (String)"BatchBOMUtils_2", (String)"mmc-pdm-common", (Object[])new Object[0])).append("\u3001");
                    continue block14;
                }
                case "B": {
                    messageBuilder.append(ResManager.loadKDString((String)"\u201c\u7248\u672c\u53f7\u201d", (String)"BatchBOMUtils_3", (String)"mmc-pdm-common", (Object[])new Object[0])).append("\u3001");
                    continue block14;
                }
                case "C": {
                    messageBuilder.append(ResManager.loadKDString((String)"\u201c\u8f85\u52a9\u5c5e\u6027\u201d", (String)"BatchBOMUtils_4", (String)"mmc-pdm-common", (Object[])new Object[0])).append("\u3001");
                    continue block14;
                }
                case "D": {
                    messageBuilder.append(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u53f7\u201d", (String)"BatchBOMUtils_5", (String)"mmc-pdm-common", (Object[])new Object[0])).append("\u3001");
                    continue block14;
                }
                case "E": {
                    messageBuilder.append(ResManager.loadKDString((String)"\u201c\u914d\u7f6e\u53f7\u201d", (String)"BatchBOMUtils_6", (String)"mmc-pdm-common", (Object[])new Object[0])).append("\u3001");
                }
            }
        }
        String message = "";
        if (StringUtils.isNotEmpty((CharSequence)messageBuilder.toString())) {
            message = messageBuilder.substring(0, messageBuilder.length() - 1);
        }
        return message;
    }

    public static String repeatAddEcoEntrys(DynamicObjectCollection ecoBomEntryDoc, DynamicObjectCollection bomEntryDOC, String checkRepeat, String verifyDimension, String changeType) {
        HashMap<String, List<DynamicObject>> repeatEntryDataMap = new HashMap<String, List<DynamicObject>>(16);
        StringBuilder errorMsgBuilder = new StringBuilder();
        ArrayList<DynamicObject> addEcoBoms = new ArrayList<DynamicObject>(16);
        Map<Long, DynamicObject> ecnEntryMap = BatchBOMUtils.transFormEcoBomData(ecoBomEntryDoc, addEcoBoms);
        for (DynamicObject bomEntry : bomEntryDOC) {
            long bomEntryPk = bomEntry.getLong("id");
            DynamicObject ecnBomEntry = ecnEntryMap.get(bomEntryPk);
            DynamicObject repeatRow = null;
            if (ecnBomEntry != null) {
                String entryMode = ecnBomEntry.getString("entrymode");
                if (StringUtils.equals((CharSequence)"B", (CharSequence)entryMode)) continue;
                repeatRow = BatchBOMUtils.repeatEcoEntryValidate(verifyDimension, repeatEntryDataMap, bomEntry);
            } else {
                repeatRow = BatchBOMUtils.repeatEcoEntryValidate(verifyDimension, repeatEntryDataMap, bomEntry);
            }
            if (repeatRow == null) continue;
            errorMsgBuilder.append(BatchBOMUtils.buildErrorMessageInfo(verifyDimension, bomEntry, repeatRow, checkRepeat, changeType));
            break;
        }
        for (DynamicObject ecoBomEntry : addEcoBoms) {
            DynamicObject repeatRow = BatchBOMUtils.repeatEcoEntryValidate(verifyDimension, repeatEntryDataMap, ecoBomEntry);
            if (repeatRow == null) continue;
            errorMsgBuilder.append(BatchBOMUtils.buildErrorMessageInfo(verifyDimension, ecoBomEntry, repeatRow, checkRepeat, changeType));
            break;
        }
        return errorMsgBuilder.toString();
    }

    private static Map<Long, DynamicObject> transFormEcoBomData(DynamicObjectCollection ecoBomEntryDoc, List<DynamicObject> addEcoBoms) {
        HashMap<Long, DynamicObject> ecnEntryMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject ecoBomEntry : ecoBomEntryDoc) {
            long entryBomEntryId = ecoBomEntry.getLong("entrybomentryid");
            String entryMode = ecoBomEntry.getString("entrymode");
            if (entryBomEntryId > 0L && (StringUtils.equals((CharSequence)"C", (CharSequence)entryMode) || StringUtils.equals((CharSequence)"E", (CharSequence)entryMode))) {
                ecnEntryMap.put(entryBomEntryId, ecoBomEntry);
                continue;
            }
            if (!StringUtils.equals((CharSequence)"A", (CharSequence)entryMode)) continue;
            addEcoBoms.add(ecoBomEntry);
        }
        return ecnEntryMap;
    }

    public static boolean valiDateIntersect(Date validate, Date invalidate, Date repeatValidate, Date repeatInvalidate) {
        boolean dateFlag = false;
        if (!validate.before(repeatValidate) && !validate.after(repeatInvalidate)) {
            dateFlag = true;
        } else if (!invalidate.before(repeatValidate) && !invalidate.after(repeatInvalidate)) {
            dateFlag = true;
        } else if (!repeatValidate.before(validate) && !repeatValidate.after(invalidate)) {
            dateFlag = true;
        } else if (!repeatInvalidate.before(validate) && !repeatInvalidate.after(invalidate)) {
            dateFlag = true;
        }
        return dateFlag;
    }
}

