/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.common.util.ecoroute;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.common.util.ecoroute.ExistRouteEntity;

public class EcoPdmRouteUtils {
    private static Set<String> aMainSet = new HashSet<String>();
    private static Set<String> bMainSet = new HashSet<String>();
    private static Set<String> cMainSet = new HashSet<String>();
    private static Set<String> aReplaceSet = new HashSet<String>();
    private static Set<String> bReplaceSet = new HashSet<String>();
    private static Set<String> cReplaceSet = new HashSet<String>();

    public static void clearData() {
        aMainSet.clear();
        bMainSet.clear();
        cMainSet.clear();
        aReplaceSet.clear();
        bReplaceSet.clear();
        cReplaceSet.clear();
    }

    public static ExistRouteEntity getRouteByDatabase(Map<Long, DynamicObject> ecoRouteMap) {
        HashSet<Object> orgSet = new HashSet<Object>(ecoRouteMap.size());
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        HashSet<Long> materialGroupIdSet = new HashSet<Long>(16);
        HashSet<Long> groupIdSet = new HashSet<Long>(16);
        for (Map.Entry<Long, DynamicObject> ecoRoute : ecoRouteMap.entrySet()) {
            DynamicObject route = ecoRoute.getValue();
            String processtype = route.getString("processtype");
            if ("A".equals(processtype)) {
                DynamicObject material = route.getDynamicObject("material");
                materialIdSet.add(material == null ? 0L : material.getLong("id"));
            } else if ("B".equals(processtype)) {
                DynamicObject materialGroup = route.getDynamicObject("materialgroup");
                materialGroupIdSet.add(materialGroup == null ? 0L : materialGroup.getLong("id"));
            } else {
                DynamicObject group = route.getDynamicObject("group");
                groupIdSet.add(group == null ? 0L : group.getLong("id"));
            }
            if (EcoPdmRouteUtils.isNull(route.getDynamicObject("createorg"))) continue;
            orgSet.add(route.getDynamicObject("createorg").getPkValue());
        }
        ExistRouteEntity entity = new ExistRouteEntity();
        if (!orgSet.isEmpty()) {
            for (int i = 0; i < 3; ++i) {
                QFilter qfilter = new QFilter("createorg", "in", orgSet);
                qfilter.and(new QFilter("status", "in", (Object)new String[]{"B", "C"}));
                if (i == 0) {
                    if (materialIdSet.isEmpty()) continue;
                    qfilter = qfilter.and(new QFilter("processtype", "=", (Object)"A"));
                    qfilter = qfilter.and(new QFilter("material", "in", materialIdSet));
                } else if (i == 1) {
                    if (materialGroupIdSet.isEmpty()) continue;
                    qfilter = qfilter.and(new QFilter("processtype", "=", (Object)"B"));
                    qfilter = qfilter.and(new QFilter("materialgroup", "in", materialGroupIdSet));
                } else {
                    if (groupIdSet.isEmpty()) continue;
                    qfilter = qfilter.and(new QFilter("processtype", "=", (Object)"C"));
                    qfilter = qfilter.and(new QFilter("group", "in", groupIdSet));
                }
                DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.mmc.pdm.common.util.ecoroute.EcoPdmRouteUtils", (String)"pdm_route", (String)"id,createorg.id createorg,ismainprocess ismainprocess,routeversion.name version,processtype processtype,material material,auxproperty auxproperty,materialgroup materialgroup,group group,routereplace routereplace,wbs wbs", (QFilter[])new QFilter[]{qfilter}, null);
                StringBuilder str = new StringBuilder();
                for (Row row : queryDataSet) {
                    HashSet<Long> mianASet;
                    str.setLength(0);
                    String processtype = row.getString("processtype");
                    boolean isMainprocess = row.getBoolean("ismainprocess");
                    Long id = row.getLong("id");
                    str.append(row.getLong("createorg"));
                    str.append(row.getString("version") == null ? "0" : row.getString("version"));
                    str.append(row.getLong("wbs") == null ? "0" : row.getLong("wbs"));
                    if ("A".equals(processtype)) {
                        if (isMainprocess) {
                            str.append(row.getLong("material"));
                            str.append(row.getLong("auxproperty"));
                            mianASet = entity.getMainAMap().getOrDefault(str.toString(), new HashSet(2));
                            mianASet.add(id);
                            entity.getMainAMap().put(str.toString(), mianASet);
                            continue;
                        }
                        str.append(row.getLong("routereplace"));
                        str.append(row.getLong("material"));
                        str.append(row.getLong("auxproperty"));
                        mianASet = entity.getNoMainAMap().getOrDefault(str.toString(), new HashSet(2));
                        mianASet.add(id);
                        entity.getNoMainAMap().put(str.toString(), mianASet);
                        continue;
                    }
                    if ("B".equals(processtype)) {
                        if (isMainprocess) {
                            str.append(row.getLong("materialgroup"));
                            mianASet = entity.getMainBMap().getOrDefault(str.toString(), new HashSet(2));
                            mianASet.add(id);
                            entity.getMainBMap().put(str.toString(), mianASet);
                            continue;
                        }
                        str.append(row.getLong("routereplace"));
                        str.append(row.getLong("materialgroup"));
                        mianASet = entity.getNoMainBMap().getOrDefault(str.toString(), new HashSet(2));
                        mianASet.add(id);
                        entity.getNoMainBMap().put(str.toString(), mianASet);
                        continue;
                    }
                    if (isMainprocess) {
                        str.append(row.getLong("group"));
                        mianASet = entity.getMainCMap().getOrDefault(str.toString(), new HashSet(2));
                        mianASet.add(id);
                        entity.getMainCMap().put(str.toString(), mianASet);
                        continue;
                    }
                    str.append(row.getLong("routereplace"));
                    str.append(row.getLong("group"));
                    mianASet = entity.getNoMainCMap().getOrDefault(str.toString(), new HashSet(2));
                    mianASet.add(id);
                    entity.getNoMainCMap().put(str.toString(), mianASet);
                }
            }
        }
        return entity;
    }

    private static boolean isNull(Object obj) {
        if (obj instanceof String) {
            return obj.toString().trim().length() == 0;
        }
        return obj == null;
    }

    public static String validateRouteHead(ExistRouteEntity existRoute, DynamicObject ecoRoute, Map<String, String> param) {
        String groupPk;
        StringBuilder errorInfo = new StringBuilder();
        String createOrgPk = ecoRoute.getDynamicObject("createorg") == null ? "0" : ecoRoute.getDynamicObject("createorg").getPkValue().toString();
        String routeVersionPk = ecoRoute.getDynamicObject("routeversion") == null ? "0" : ecoRoute.getDynamicObject("routeversion").getString("name");
        StringBuilder str = new StringBuilder();
        str.append(createOrgPk);
        str.append(routeVersionPk);
        String wbsPk = ecoRoute.getDynamicObject("wbs") != null ? String.valueOf(ecoRoute.getDynamicObject("wbs").getPkValue()) : "0";
        str.append(wbsPk);
        long routePkV = ecoRoute.getLong("routeid");
        String materialPk = ecoRoute.getDynamicObject("material").getPkValue() == null ? "0" : ecoRoute.getDynamicObject("material").getPkValue().toString();
        String auxpropertyPk = ecoRoute.getDynamicObject("auxproperty") == null ? "0" : ecoRoute.getDynamicObject("auxproperty").getPkValue().toString();
        String routeGroupPk = ecoRoute.getDynamicObject("group") == null ? "0" : ecoRoute.getDynamicObject("group").getPkValue().toString();
        String string = groupPk = ecoRoute.getDynamicObject("materialgroup") == null ? "0" : ecoRoute.getDynamicObject("materialgroup").getPkValue().toString();
        if (ecoRoute.getBoolean("ismainprocess")) {
            param.put("ismain", "1");
            if ("A".equals(ecoRoute.getString("processtype"))) {
                param.put("type", "A");
                str.append(materialPk).append(auxpropertyPk);
                if (EcoPdmRouteUtils.validateMainAUnique(existRoute.getMainAMap(), str.toString(), routePkV)) {
                    errorInfo.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u3001\u8f85\u52a9\u5c5e\u6027\u548cWBS\u7684\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"EcoPdmRouteUtils_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                } else if (aMainSet.contains(str.toString())) {
                    errorInfo.append(ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u201d\u672c\u6b21\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\uff0c\u4e14\u5177\u6709\u76f8\u540c\u8f85\u52a9\u5c5e\u6027\u548cWBS\u7684\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"EcoPdmRouteUtils_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                }
            } else if ("B".equals(ecoRoute.getString("processtype"))) {
                param.put("type", "B");
                str.append(groupPk);
                if (EcoPdmRouteUtils.validateMainAUnique(existRoute.getMainBMap(), str.toString(), routePkV)) {
                    errorInfo.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\u5df2\u5b58\u5728\u76f8\u540cWBS\u548c\u7269\u6599\u63a7\u5236\u7ec4\u7684\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"EcoPdmRouteUtils_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                } else if (bMainSet.contains(str.toString())) {
                    errorInfo.append(ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u7ec4\u201d\u672c\u6b21\u5df2\u5b58\u5728\u76f8\u540cWBS\u548c\u7269\u6599\u63a7\u5236\u7ec4\u7684\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"EcoPdmRouteUtils_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                }
            } else {
                param.put("type", "C");
                str.append(routeGroupPk);
                if (EcoPdmRouteUtils.validateMainAUnique(existRoute.getMainCMap(), str.toString(), routePkV)) {
                    errorInfo.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\u3001WBS\u548c\u5de5\u827a\u8def\u7ebf\u5206\u7ec4\u4e0b\u5df2\u5b58\u5728\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"EcoPdmRouteUtils_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                } else if (cMainSet.contains(str.toString())) {
                    errorInfo.append(ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u7ec4\u201d\u672c\u6b21\u5df2\u5b58\u5728\u76f8\u540cWBS\u548c\u7269\u6599\u63a7\u5236\u7ec4\u7684\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"EcoPdmRouteUtils_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                }
            }
        } else {
            String replacePk;
            param.put("ismain", "0");
            String string2 = replacePk = ecoRoute.getDynamicObject("routereplace") == null ? "0" : ecoRoute.getDynamicObject("routereplace").getPkValue().toString();
            if (EcoPdmRouteUtils.isNull(ecoRoute.getDynamicObject("routereplace"))) {
                errorInfo.append(ResManager.loadKDString((String)"\u975e\u4e3b\u5de5\u827a\u8def\u7ebf,\u66ff\u4ee3\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EcoPdmRouteUtils_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                return errorInfo.toString();
            }
            if ("A".equals(ecoRoute.getString("processtype"))) {
                param.put("type", "A");
                str.setLength(0);
                str.append(createOrgPk).append(routeVersionPk).append(wbsPk).append(replacePk).append(materialPk).append(auxpropertyPk);
                if (aReplaceSet.contains(str.toString())) {
                    errorInfo.append(ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u201d\u672c\u6b21\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u3001\u8f85\u52a9\u5c5e\u6027\u548cWBS\u7684\u66ff\u4ee3\u5de5\u827a\u8def\u7ebf\u3002", (String)"EcoPdmRouteUtils_7", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                } else if (EcoPdmRouteUtils.validateMainAUnique(existRoute.getNoMainAMap(), str.toString(), routePkV)) {
                    errorInfo.append(ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u3001\u8f85\u52a9\u5c5e\u6027\u548cWBS\u4e14\u66ff\u4ee3\u53f7\u76f8\u540c\u7684\u5de5\u827a\u8def\u7ebf\u3002", (String)"EcoPdmRouteUtils_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                }
            } else if ("B".equals(ecoRoute.getString("processtype"))) {
                param.put("type", "B");
                str.setLength(0);
                str.append(createOrgPk).append(routeVersionPk).append(wbsPk).append(replacePk).append(groupPk);
                if (bReplaceSet.contains(str.toString())) {
                    errorInfo.append(ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u7ec4\u201d\u672c\u6b21\u5df2\u5b58\u5728\u76f8\u540cWBS\u548c\u7269\u6599\u63a7\u5236\u7ec4\u7684\u66ff\u4ee3\u5de5\u827a\u8def\u7ebf\u3002", (String)"EcoPdmRouteUtils_9", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                } else if (EcoPdmRouteUtils.validateMainAUnique(existRoute.getNoMainBMap(), str.toString(), routePkV)) {
                    errorInfo.append(ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\u5df2\u5b58\u5728\u76f8\u540cWBS\u3001\u7269\u6599\u63a7\u5236\u7ec4\u3001\u76f8\u540c\u66ff\u4ee3\u53f7\u7684\u5de5\u827a\u8def\u7ebf\u3002", (String)"EcoPdmRouteUtils_10", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                }
            } else {
                param.put("type", "C");
                str.setLength(0);
                str.append(createOrgPk).append(routeVersionPk).append(replacePk).append(routeGroupPk).append(wbsPk);
                if (cReplaceSet.contains(str.toString())) {
                    errorInfo.append(ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u901a\u7528\u201d\u5f53\u524dWBS\u548c\u5de5\u827a\u8def\u7ebf\u5206\u7ec4\u4e0b\u672c\u6b21\u5df2\u5b58\u5728\u66ff\u4ee3\u5de5\u827a\u8def\u7ebf\u3002", (String)"EcoPdmRouteUtils_11", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                } else if (EcoPdmRouteUtils.validateMainAUnique(existRoute.getNoMainCMap(), str.toString(), routePkV)) {
                    errorInfo.append(ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\u3001WBS\u3001\u5de5\u827a\u8def\u7ebf\u5206\u7ec4\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u66ff\u4ee3\u53f7\u7684\u5de5\u827a\u8def\u7ebf\u3002", (String)"EcoPdmRouteUtils_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                }
            }
        }
        return errorInfo.toString();
    }

    private static boolean validateMainAUnique(Map<String, Object> mainAMap, String str, long routePkV) {
        HashSet mainAMapSet = mainAMap.get(str) != null ? (HashSet)mainAMap.get(str) : null;
        boolean mainAMapUnique = false;
        if (mainAMapSet == null || mainAMapSet.isEmpty()) {
            return mainAMapUnique;
        }
        if (mainAMapSet.size() > 1 || !mainAMapSet.contains(routePkV)) {
            mainAMapUnique = true;
        }
        return mainAMapUnique;
    }

    public static void addRepeatMainSet(DynamicObject ecoRoute, Map<String, String> param) {
        StringBuilder str = new StringBuilder();
        String wbsPk = ecoRoute.getDynamicObject("wbs") != null ? String.valueOf(ecoRoute.getDynamicObject("wbs").getPkValue()) : "0";
        String createOrgPk = ecoRoute.getDynamicObject("createorg") == null ? "0" : ecoRoute.getDynamicObject("createorg").getPkValue().toString();
        String routeVersionPk = ecoRoute.getDynamicObject("routeversion") == null ? "0" : ecoRoute.getDynamicObject("routeversion").getString("name");
        String materialPk = ecoRoute.getDynamicObject("material") == null ? "0" : ecoRoute.getDynamicObject("material").getPkValue().toString();
        String auxPropertyPk = ecoRoute.getDynamicObject("auxproperty") == null ? "0" : ecoRoute.getDynamicObject("auxproperty").getPkValue().toString();
        String groupPk = ecoRoute.getDynamicObject("materialgroup") == null ? "0" : ecoRoute.getDynamicObject("materialgroup").getPkValue().toString();
        String routeGroupPk = ecoRoute.getDynamicObject("group") == null ? "0" : ecoRoute.getDynamicObject("group").getPkValue().toString();
        str.append(createOrgPk);
        str.append(routeVersionPk);
        str.append(wbsPk);
        if ("1".equals(param.get("ismain"))) {
            if ("A".equals(param.get("type"))) {
                str.append(materialPk).append(auxPropertyPk);
                aMainSet.add(str.toString());
            } else if ("B".equals(param.get("type"))) {
                str.append(groupPk);
                bMainSet.add(str.toString());
            } else {
                str.append(routeGroupPk);
                cMainSet.add(str.toString());
            }
        } else {
            str.append(ecoRoute.getDynamicObject("routereplace").getPkValue().toString());
            if ("A".equals(param.get("type"))) {
                str.append(materialPk).append(auxPropertyPk);
                aReplaceSet.add(str.toString());
            } else if ("B".equals(param.get("type"))) {
                str.append(groupPk);
                bReplaceSet.add(str.toString());
            } else {
                str.append(routeGroupPk);
                cReplaceSet.add(str.toString());
            }
        }
    }
}

