/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.mservice;

import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPools;

public class UpdateECNEntryDataServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(UpdateECNEntryDataServiceImpl.class);
    public static final DBRoute scmDBRoute = new DBRoute("scm");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ThreadPools.executeOnce((String)"UpdateECNEntryDataServiceImpl", (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (TXHandle h1 = TX.requiresNew();){
                    UpgradeResult result = new UpgradeResult();
                    try {
                        result = UpdateECNEntryDataServiceImpl.this.exec();
                    }
                    finally {
                        if (!result.isSuccess()) {
                            h1.markRollback();
                        }
                    }
                }
            }
        });
        return new UpgradeResult();
    }

    public boolean isExistsColumn(DBRoute dbRoute, String tableName, String columnName) {
        if (this.isExistsTable(dbRoute, tableName)) {
            List columns = DB.getColumnNames((DBRoute)scmDBRoute, (String)tableName);
            for (String column : columns) {
                if (!column.equalsIgnoreCase(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExistsTable(DBRoute dbRoute, String tableName) {
        return DB.exitsTable((DBRoute)scmDBRoute, (String)tableName);
    }

    public UpgradeResult exec() {
        logger.info("begin exec UpdateECNEntryDataServiceImpl data ...");
        this.execSql();
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog("update sql successful");
        return result;
    }

    public void execSql() {
        StringBuilder sb = new StringBuilder();
        boolean isExistsTable = this.isExistsTable(scmDBRoute, "T_PDM_BOMECOPENTRY");
        String tableName = "T_PDM_ECOTYPE";
        String columnName = "fstatustype";
        if (isExistsTable) {
            long startTime = System.currentTimeMillis();
            if (this.isExistsColumn(scmDBRoute, tableName, columnName)) {
                sb.append(" update T_FMM_ECOBOMENTRY a set festimatestatus = 'C' where exists( ");
                sb.append(" select 1 from t_pdm_bom_eco h inner join t_pdm_bomecopentry d on h.fid = d.fid  ");
                sb.append(" where d.fecobomid = a.fid  ");
                sb.append(" and h.fbillstatus = 'C' ");
                sb.append(" and d.fecotype in(select fid from t_pdm_ecotype where fstatustype = 'A')) ");
                sb.append(" and festimatestatus <> 'C'  ");
            } else {
                sb.append(" update T_FMM_ECOBOMENTRY a set festimatestatus = 'C' where exists( ");
                sb.append(" select 1 from t_pdm_bom_eco h inner join t_pdm_bomecopentry d on h.fid = d.fid  ");
                sb.append(" where d.fecobomid = a.fid  ");
                sb.append(" and h.fbillstatus = 'C' ");
                sb.append(" ) ");
                sb.append(" and festimatestatus <> 'C'  ");
            }
            DB.execute((DBRoute)scmDBRoute, (String)sb.toString());
            long endTime = System.currentTimeMillis();
            logger.info("\u603b\u8017\u65f6\uff1a" + (endTime - startTime) + "\u6beb\u79d2\uff0csql:" + sb);
            startTime = System.currentTimeMillis();
            sb.setLength(0);
            sb.append(" update T_FMM_ECOBOMENTRY a set festimatestatus = 'C' where exists(  ");
            sb.append(" select 1 from t_pdm_bom_eco h inner join t_pdm_bomecopentry d on h.fid = d.fid   ");
            sb.append(" where d.fecobomid = a.fid   ");
            sb.append(" and h.fbillstatus = 'C'  ");
            sb.append(" and d.fecotype = 0  )  ");
            sb.append(" and festimatestatus <> 'C'  ");
            DB.execute((DBRoute)scmDBRoute, (String)sb.toString());
            logger.info("\u603b\u8017\u65f6\uff1a" + (endTime - startTime) + "\u6beb\u79d2\uff0csql:" + sb);
            startTime = System.currentTimeMillis();
            sb.setLength(0);
            sb.append(" update t_fmm_ecobomentry t3 set ftranstartdate = (select t1.fcreatetime from t_pdm_bom_eco t1   ");
            sb.append(" inner join t_pdm_bomecopentry t2 on t1.fid = t2.fid where t2.fecobomid = t3.fid)   ");
            sb.append(" where ftranstartdate is null   ");
            DB.execute((DBRoute)scmDBRoute, (String)sb.toString());
            logger.info("\u603b\u8017\u65f6\uff1a" + (endTime - startTime) + "\u6beb\u79d2\uff0csql:" + sb);
            startTime = System.currentTimeMillis();
            sb.setLength(0);
            sb.append(" update t_fmm_ecobomentry t set facttime = (select t2.fvaliddate from t_pdm_bomecopentry t2 where t2.fecobomid = t.fid)   ");
            sb.append(" where facttime is null   ");
            DB.execute((DBRoute)scmDBRoute, (String)sb.toString());
            logger.info("\u603b\u8017\u65f6\uff1a" + (endTime - startTime) + "\u6beb\u79d2\uff0csql:" + sb);
        }
    }
}

