/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.UpgradeResult;

public class ECNDataUpdateService {
    private static final Log logger = LogFactory.getLog(ECNDataUpdateService.class);
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    public static final DBRoute sysDBRoute = new DBRoute("sys");

    public static UpgradeResult exec() {
        logger.info("begin exec ECNDataUpdateService data ...");
        long startTime = System.currentTimeMillis();
        int count = ECNDataUpdateService.execSql();
        ECNDataUpdateService.execSql2();
        long endTime = System.currentTimeMillis();
        logger.info("\u603b\u8017\u65f6\uff1a" + (endTime - startTime) + "\u6beb\u79d2\uff1b");
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(String.format(ResManager.loadKDString((String)"\u5171\u6267\u884c\u4e86\u201c%1$s\u201d\u6761ECN\u6570\u636e\u3002", (String)"ECNDataUpdateService_02", (String)"mmc-pdm-mservice", (Object[])new Object[0]), count));
        return result;
    }

    public static int execSql() {
        HashSet<Long> mftIdSet = new HashSet<Long>(128);
        HashMap<Long, Long> dataMap = new HashMap<Long, Long>(128);
        StringBuilder sb = new StringBuilder();
        sb.append(" select d.fentryid ,d.fpentrymaterialid ,d.fproentrymaterial  ");
        sb.append(" from t_pdm_bom_eco h   ");
        sb.append(" inner join t_pdm_bomecopentry d on h.fid = d.fid  ");
        sb.append(" where d.fpentrymaterialid = 0 and d.fproentrymaterial > 0  ");
        try (DataSet ds = DB.queryDataSet((String)ECNDataUpdateService.class.getName(), (DBRoute)scmDBRoute, (String)sb.toString());){
            while (ds.hasNext()) {
                Row arow = ds.next();
                Long entryId = arow.getLong("fentryid");
                Long fproentrymaterial = arow.getLong("fproentrymaterial");
                mftIdSet.add(fproentrymaterial);
                dataMap.put(entryId, fproentrymaterial);
            }
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(128);
        String updateSql = " update t_pdm_bomecopentry set fpentrymaterialid = ? where fentryid = ? ";
        if (!mftIdSet.isEmpty()) {
            HashMap<Long, Long> matMap = new HashMap<Long, Long>(128);
            SqlBuilder sqlb = new SqlBuilder();
            sqlb.append("select fid,fmasterid from t_bd_materialmftinfo where  ", new Object[0]);
            sqlb.appendIn("fid", mftIdSet.toArray());
            try (DataSet ds = DB.queryDataSet((String)ECNDataUpdateService.class.getName(), (DBRoute)sysDBRoute, (SqlBuilder)sqlb);){
                while (ds.hasNext()) {
                    Row arow = ds.next();
                    Long fid = arow.getLong("fid");
                    Long fmasterid = arow.getLong("fmasterid");
                    matMap.put(fid, fmasterid);
                }
            }
            for (Map.Entry entrys : dataMap.entrySet()) {
                Long entryId = (Long)entrys.getKey();
                Long mftId = (Long)entrys.getValue();
                Long materialId = (Long)matMap.get(mftId);
                if (materialId == null || materialId.equals(0L)) continue;
                paramList.add(new Object[]{materialId, entryId});
            }
            if (!paramList.isEmpty()) {
                DB.executeBatch((DBRoute)scmDBRoute, (String)updateSql, paramList);
            }
        }
        return paramList.size();
    }

    public static int execSql2() {
        Set entryIds;
        StringBuilder sb = new StringBuilder();
        sb.append(" select fentryid ,frequirebilltype  ");
        sb.append(" from t_pdm_estimateresultentry    ");
        sb.append(" where frequirebilltypename =  ' ' ");
        HashMap<Long, HashSet<Long>> maps = new HashMap<Long, HashSet<Long>>(16);
        HashSet<Long> billTypeIdSet = new HashSet<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)ECNDataUpdateService.class.getName(), (DBRoute)scmDBRoute, (String)sb.toString());){
            while (ds.hasNext()) {
                HashSet<Long> ids;
                Row arow = ds.next();
                Long entryId = arow.getLong("fentryid");
                Long frequirebilltype = arow.getLong("frequirebilltype");
                if (frequirebilltype == null) {
                    frequirebilltype = 0L;
                }
                if ((ids = (HashSet<Long>)maps.get(frequirebilltype)) == null) {
                    ids = new HashSet<Long>(64);
                }
                ids.add(entryId);
                maps.put(frequirebilltype, ids);
                if (frequirebilltype == null || frequirebilltype.equals(0L)) continue;
                billTypeIdSet.add(frequirebilltype);
            }
        }
        String updateSql = " update t_pdm_estimateresultentry set frequirebilltypename = ? where fentryid = ? ";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(64);
        if (!billTypeIdSet.isEmpty()) {
            SqlBuilder sqlb = new SqlBuilder();
            sqlb.append("select h.fid,d.fname from T_BAS_BILLTYPE h inner join T_BAS_BILLTYPE_L d on h.fid = d.fid where  ", new Object[0]);
            sqlb.appendIn("h.fid", billTypeIdSet.toArray());
            sqlb.append(" and d.flocaleid ='zh_CN' ", new Object[0]);
            DataSet ds = DB.queryDataSet((String)ECNDataUpdateService.class.getName(), (DBRoute)sysDBRoute, (SqlBuilder)sqlb);
            Object object = null;
            try {
                while (ds.hasNext()) {
                    Set entryIds2;
                    Row arow = ds.next();
                    Long fid = arow.getLong("fid");
                    String fname = arow.getString("fname");
                    if (fname == null || "".equals(fname) || (entryIds2 = (Set)maps.get(fid)) == null || entryIds2.isEmpty()) continue;
                    for (Long entryId : entryIds2) {
                        paramList.add(new Object[]{fname, entryId});
                    }
                }
            }
            catch (Throwable arow) {
                object = arow;
                throw arow;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable arow) {
                            ((Throwable)object).addSuppressed(arow);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        if ((entryIds = (Set)maps.get(0L)) != null && !entryIds.isEmpty()) {
            String fname = ResManager.loadKDString((String)"\u5373\u65f6\u5e93\u5b58", (String)"ECNDataUpdateService_03", (String)"mmc-pdm-mservice", (Object[])new Object[0]);
            for (Long entryId : entryIds) {
                paramList.add(new Object[]{fname, entryId});
            }
        }
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)scmDBRoute, (String)updateSql, paramList);
        }
        return paramList.size();
    }
}

