/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.UpgradeResult;

public class ExcuteSQLMuLanguageSynHistory {
    private static final String ALGO_KEY = ExcuteSQLMuLanguageSynHistory.class.getName();
    private static final DBRoute DB_ROUTE = DBRoute.of((String)"scm");
    private static final int BATCH_NUM = 1000;
    private static final int DEFAULT_BATCHSIZE = 5000;

    public static UpgradeResult synHistoryData() {
        UpgradeResult result = new UpgradeResult();
        String initData_lSql = "SELECT FID FROM T_PDM_INITDATA_L where FINITRESULT=' ' and flocaleid='zh_CN';";
        HashSet<String> dataIds = new HashSet<String>(16);
        try (DataSet dropLogDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE, (String)initData_lSql);){
            while (dropLogDataSet.hasNext()) {
                Row row = dropLogDataSet.next();
                dataIds.add(row.getString("FID"));
            }
        }
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(1000);
        dataIds.stream().collect(Collectors.joining(","));
        String str = dataIds.stream().collect(Collectors.joining(","));
        String initDataSql = "SELECT FID,FINITRESULT FROM T_PDM_INITDATA where fid in (" + str + ")";
        try (DataSet initDataDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE, (String)initDataSql);){
            while (initDataDataSet.hasNext()) {
                Row row = initDataDataSet.next();
                Object[] param = new Object[]{row.getString("FINITRESULT"), row.getLong("FID")};
                updateParamList.add(param);
            }
        }
        String updateSQL = "UPDATE  T_MRP_BILLTRANFERENTRY_L SET FINITRESULT = ? WHERE FID = ? AND FLOCALEID='zh_CN';";
        if (updateParamList.size() != 0) {
            ExcuteSQLMuLanguageSynHistory.batchUpdate(DB_ROUTE, updateSQL, updateParamList);
        }
        result.setSuccess(true);
        return result;
    }

    public static void batchUpdate(DBRoute dbRoute, String sql, List<Object[]> values) {
        int totalCount = values.size();
        if (totalCount > 5000) {
            int times = totalCount / 5000;
            times = totalCount % 5000 != 0 ? times + 1 : times;
            for (int i = 0; i < times; ++i) {
                int startIndex = i * 5000;
                int endIndex = Math.min(startIndex + 5000, totalCount);
                DB.executeBatch((DBRoute)dbRoute, (String)sql, values.subList(startIndex, endIndex));
            }
        } else {
            DB.executeBatch((DBRoute)dbRoute, (String)sql, values);
        }
    }
}

