/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.pdm.common.bom.bean.BOMBean;
import kd.mmc.pdm.common.bom.bean.BOMEntryBean;
import kd.mmc.pdm.common.util.BOMVersionUtil;

public class ECNAuditValidator
extends AbstractValidator {
    public void validate() {
        String operate = this.getOperateKey();
        if ("audit".equals(operate)) {
            ExtendedDataEntity[] objs;
            for (ExtendedDataEntity obj : objs = this.getDataEntities()) {
                try (TXHandle h = TX.required((String)"pdm_ecn_audit");){
                    try {
                        DynamicObject pverson;
                        DynamicObject dObject = obj.getDataEntity();
                        DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
                        DynamicObjectCollection entrys = dObject.getDynamicObjectCollection("entry");
                        ArrayList<Integer> idxs = new ArrayList<Integer>(0);
                        DynamicObject org = dObject.getDynamicObject("org");
                        String ecnbillno = dObject.getString("billno");
                        boolean flag = true;
                        Date neweffectdate = new Date();
                        for (int k = 0; k < pentrys.size(); ++k) {
                            DynamicObject pentry = (DynamicObject)pentrys.get(k);
                            DynamicObject pbom = pentry.getDynamicObject("pentrybom");
                            String ECNVersion = pentry.getString("pentryecn");
                            String entryversioncontrol = pentry.getString("entryversioncontrol");
                            if (StringUtils.equals((CharSequence)entryversioncontrol, (CharSequence)"B")) {
                                idxs.add(k);
                            }
                            Long pbomPk = (Long)pbom.getPkValue();
                            BOMBean bomBean = new BOMBean(pbomPk);
                            for (int i = 0; i < entrys.size(); ++i) {
                                Date invaliddate;
                                DynamicObject entry = (DynamicObject)entrys.get(i);
                                String entrymode = entry.getString("entrymode");
                                if (!StringUtils.equals((CharSequence)"A", (CharSequence)entrymode) && !StringUtils.equals((CharSequence)"C", (CharSequence)entrymode)) continue;
                                DynamicObject bom = entry.getDynamicObject("entrybom");
                                if (!pbom.getPkValue().equals(bom.getPkValue())) continue;
                                BOMEntryBean bomEntryBean = new BOMEntryBean(bomBean, Long.valueOf(entry.getLong("entrybomentryid")));
                                DynamicObject mater = entry.getDynamicObject("entrymaterial");
                                Object masterid = mater.get("masterid");
                                masterid = masterid instanceof DynamicObject ? ((DynamicObject)masterid).get("id") : mater.get("id");
                                bomEntryBean.setSeq(Long.valueOf(i + 1));
                                bomEntryBean.setMaterialid((Long)masterid);
                                DynamicObject version = entry.getDynamicObject("entryversion");
                                if (version != null) {
                                    bomEntryBean.setBomvison((Long)version.getPkValue());
                                } else {
                                    bomEntryBean.setBomvison(Long.valueOf(0L));
                                }
                                DynamicObject auxpty = entry.getDynamicObject("entryauxproperty");
                                if (auxpty != null) {
                                    bomEntryBean.setMaterialaux((Long)auxpty.getPkValue());
                                } else {
                                    bomEntryBean.setMaterialaux(Long.valueOf(0L));
                                }
                                Date validdate = entry.getDate("entryvaliddate");
                                if (validdate != null) {
                                    bomEntryBean.setValiddate(validdate);
                                }
                                if ((invaliddate = entry.getDate("entryinvaliddate")) != null) {
                                    bomEntryBean.setInvaliddate(invaliddate);
                                }
                                if (invaliddate != null && invaliddate.compareTo(neweffectdate) < 0) {
                                    String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u201c\u5931\u6548\u65e5\u671f\u201d\uff1c\u201c\u5f53\u524d\u65e5\u671f\u201d\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"ECNAuditValidator_8", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), k + 1, i + 1);
                                    this.addErrorMessage(obj, msg);
                                    flag = false;
                                    break;
                                }
                                bomEntryBean.setEcn_vison(ECNVersion);
                                Date ecn_validdate = pentry.getDate("pentryvaliddate");
                                if (ecn_validdate == null) continue;
                                bomEntryBean.setEcn_validdate(ecn_validdate);
                            }
                            if (!flag) break;
                        }
                        if (!flag) continue;
                        ArrayList<DynamicObject> newversions = new ArrayList<DynamicObject>(idxs.size());
                        for (Integer k : idxs) {
                            DynamicObject pentry = (DynamicObject)pentrys.get(k.intValue());
                            DynamicObject product = pentry.getDynamicObject("proentrymaterial");
                            if (product == null) continue;
                            DynamicObject mater = product.getDynamicObject("masterid");
                            DynamicObject pentrynewversion = null;
                            try {
                                pentrynewversion = BOMVersionUtil.autoCreateBOMVersion((DynamicObject)org, (DynamicObject)mater, null, (Date)neweffectdate, null, (String)ecnbillno, null);
                            }
                            catch (KDBizException exp) {
                                flag = false;
                                this.addErrorMessage(obj, exp.getMessage());
                                break;
                            }
                            newversions.add(pentrynewversion);
                        }
                        if (flag || newversions.size() <= 0 || (pverson = (DynamicObject)newversions.get(0)) == null) continue;
                        BusinessDataServiceHelper.delete((IDataEntityType)pverson.getDynamicObjectType(), (Object[])newversions.toArray(new DynamicObject[newversions.size()]));
                    }
                    catch (Throwable e) {
                        h.markRollback();
                    }
                }
            }
        }
    }
}

