/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;

public class ECNBaseOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ECNBaseOpPlugin.class);
    public static final String SUCCESSFUL_COUNT = "successful_count";
    public static final String FAILED_COUNT = "failed_count";

    public boolean isBomChange(DynamicObject obj) {
        String changeType = obj.getString("changetype");
        return StringUtils.isEmpty((Object)changeType) || "A".equals(changeType);
    }

    public boolean isRouteChange(DynamicObject obj) {
        String changeType = obj.getString("changetype");
        return "B".equals(changeType);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("changetype");
        e.getFieldKeys().add("type");
        e.getFieldKeys().add("errormsg");
        e.getFieldKeys().add("pentry.seq");
        e.getFieldKeys().add("pentry.entryversioncontrol");
        e.getFieldKeys().add("pentry.pentryvaliddate");
        e.getFieldKeys().add("pentry.pentryinvaliddate");
        e.getFieldKeys().add("pentry.proentrymaterial");
        e.getFieldKeys().add("pentry.proentrymaterialid");
        e.getFieldKeys().add("pentry.pentryexecmode");
        e.getFieldKeys().add("pentry.pentryexecdate");
        e.getFieldKeys().add("pentry.pentryexecstatus");
        e.getFieldKeys().add("pentry.pentryreplaceno");
        e.getFieldKeys().add("pentry.pentryecreason");
        e.getFieldKeys().add("pentry.bomauxproperty");
        e.getFieldKeys().add("pentry.ecotype");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String key = e.getOperationKey();
        if ("unsubmit".equals(key)) {
            ArrayList<Long> listBom = new ArrayList<Long>(16);
            ArrayList<Long> listRoute = new ArrayList<Long>(16);
            for (DynamicObject data : e.getDataEntities()) {
                boolean isBomChange = this.isBomChange(data);
                boolean isRouteChange = this.isRouteChange(data);
                DynamicObjectCollection pentrys = data.getDynamicObjectCollection("pentry");
                for (DynamicObject pentry : pentrys) {
                    if (isBomChange) {
                        String ecobomid = pentry.getString("ecobomid");
                        listBom.add(Long.parseLong(ecobomid));
                    }
                    if (!isRouteChange) continue;
                    String ecorouteid = pentry.getString("ecorouteid");
                    listRoute.add(Long.parseLong(ecorouteid));
                }
            }
            this.setStatus(listBom, "pdm_ecobom", "A");
            this.setStatus(listRoute, "pdm_ecoroute", "A");
        }
    }

    public void setStatus(List<Long> idList, String entityNumber, String status) {
        if (!PlatformUtils.isNullList(idList)) {
            DynamicObject[] col;
            QFilter qfilter = new QFilter("id", "in", idList);
            for (DynamicObject sub : col = BusinessDataServiceHelper.load((String)entityNumber, (String)"id,status", (QFilter[])new QFilter[]{qfilter})) {
                sub.set("status", (Object)status);
            }
            SaveServiceHelper.save((DynamicObject[])col);
        }
    }

    public Set<Long> getAllEcoObjIds(DynamicObject dObject) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
        boolean isBomChange = this.isBomChange(dObject);
        for (DynamicObject obj : pentrys) {
            DynamicObject ecoType = obj.getDynamicObject("ecotype");
            if (ecoType == null) continue;
            Long ecoBomId = isBomChange ? obj.getLong("ecobomid") : obj.getLong("ecorouteid");
            idSet.add(ecoBomId);
        }
        return idSet;
    }

    public Set<Long> getAllInitVersionEcoObjIds(DynamicObject dObject) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
        boolean isBomChange = this.isBomChange(dObject);
        for (DynamicObject obj : pentrys) {
            String controlVersion = obj.getString("entryversioncontrol");
            if (!"D".equals(controlVersion)) continue;
            Long ecoBomId = isBomChange ? obj.getLong("ecobomid") : obj.getLong("ecorouteid");
            idSet.add(ecoBomId);
        }
        return idSet;
    }

    public String getEcoEntityNumber(DynamicObject dObject) {
        if (this.isRouteChange(dObject)) {
            return "pdm_ecoroute";
        }
        return "pdm_ecobom";
    }

    public DynamicObject getEcoEntityDynamicObject(DynamicObject dObject) {
        return BusinessDataServiceHelper.newDynamicObject((String)this.getEcoEntityNumber(dObject));
    }

    public void auditInitVersionEcoObj(DynamicObject dObject) {
        Set<Long> ecoBomIdSet = this.getAllInitVersionEcoObjIds(dObject);
        if (!PlatformUtils.isNullSet(ecoBomIdSet)) {
            DynamicObject[] col;
            DynamicObject ecoDynamicObject = this.getEcoEntityDynamicObject(dObject);
            String ecoEntityNumber = this.getEcoEntityNumber(dObject);
            OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)ecoEntityNumber, (DynamicObject[])(col = BusinessDataServiceHelper.load((Object[])ecoBomIdSet.toArray(new Object[ecoBomIdSet.size()]), (DynamicObjectType)ecoDynamicObject.getDynamicObjectType())), null);
            List subInfoList = result.getAllErrorOrValidateInfo();
            if (!subInfoList.isEmpty()) {
                String msg = String.format(ResManager.loadKDString((String)"\u5ba1\u6838ECOBOM\u53d1\u751f\u9519\u8bef\uff1a%1$s", (String)"ECNBaseOpPlugin_0", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), ((IOperateInfo)subInfoList.get(0)).toString());
                throw new KDBizException(new ErrorCode("pdm-bom-eco", msg), new Object[0]);
            }
        }
    }

    public void updateEstimateStatus(DynamicObject dObject) {
        DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
        ArrayList<Long> list = new ArrayList<Long>(16);
        ArrayList<Long> list2 = new ArrayList<Long>(16);
        boolean isRouteChange = this.isRouteChange(dObject);
        for (DynamicObject obj : pentrys) {
            String ecoTypeStatusType;
            DynamicObject ecoType = obj.getDynamicObject("ecotype");
            if (ecoType == null || (ecoTypeStatusType = ecoType.getString("statustype")) == null || "".equals(ecoTypeStatusType)) continue;
            Long ecoBomId = isRouteChange ? obj.getLong("ecorouteid") : obj.getLong("ecobomid");
            if ("A".equals(ecoTypeStatusType)) {
                list.add(ecoBomId);
                continue;
            }
            list2.add(ecoBomId);
        }
        if (!list.isEmpty()) {
            String esremark = ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u5ba1\u6838\u65f6\u4f9d\u636e\u53d8\u66f4\u7c7b\u578b\u81ea\u52a8\u5b8c\u6210\u8bc4\u4f30\u3002", (String)"ECNBaseOpPlugin_1", (String)"mmc-pdm-opplugin", (Object[])new Object[0]);
            this.updateEcoBomEntry(list, esremark, "C", this.getEcoEntityNumber(dObject));
        }
        if (!list2.isEmpty()) {
            this.updateEcoBomEntry(list2, "", "A", this.getEcoEntityNumber(dObject));
        }
    }

    public String getEntryEntity(String ecoEntity) {
        return "pdm_ecoroute".equals(ecoEntity) ? "processentry" : "entry";
    }

    private void updateEcoBomEntry(List<Long> ecoBomIds, String esremark, String esstatus, String entityNumber) {
        DynamicObject[] col;
        QFilter qFilter = new QFilter("id", "in", (Object)ecoBomIds.toArray());
        String selectProperties = this.getEcoSelectProperties(entityNumber);
        for (DynamicObject ecoBom : col = BusinessDataServiceHelper.load((String)entityNumber, (String)selectProperties, (QFilter[])new QFilter[]{qFilter})) {
            DynamicObjectCollection coll = ecoBom.getDynamicObjectCollection(this.getEntryEntity(entityNumber));
            int collSize = coll.size();
            for (int i = 0; i < collSize; ++i) {
                DynamicObject ecoBomEntry = (DynamicObject)coll.get(i);
                ecoBomEntry.set("estimatestatus", (Object)esstatus);
                ecoBomEntry.set("esremark", (Object)esremark);
                Date acttime = ecoBomEntry.getDate("acttime");
                Date minacttime = ecoBomEntry.getDate("minacttime");
                if (minacttime != null && minacttime.compareTo(acttime) == 0) continue;
                ecoBomEntry.set("minacttime", (Object)acttime);
            }
            if (!this.isEcoBom(entityNumber)) continue;
            DynamicObjectCollection copColl = ecoBom.getDynamicObjectCollection("copentry");
            collSize = copColl.size();
            for (int i = 0; i < collSize; ++i) {
                DynamicObject ecoBomCopEntry = (DynamicObject)copColl.get(i);
                ecoBomCopEntry.set("copestimatestatus", (Object)esstatus);
                ecoBomCopEntry.set("copesremark", (Object)esremark);
            }
        }
        SaveServiceHelper.update((DynamicObject[])col);
    }

    private String getEcoSelectProperties(String entityNumber) {
        String entry = this.getEntryEntity(entityNumber);
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",").append(entry);
        sb.append(",").append(entry).append(".").append("estimatestatus");
        sb.append(",").append(entry).append(".").append("esremark");
        sb.append(",").append(entry).append(".").append("acttime");
        sb.append(",").append(entry).append(".").append("minacttime");
        if (this.isEcoBom(entityNumber)) {
            sb.append(",copentry");
            sb.append(",copentry.copestimatestatus");
            sb.append(",copentry.copesremark");
            sb.append(",copentry.copacttime");
        }
        return sb.toString();
    }

    private boolean isEcoBom(String entityNumber) {
        return "pdm_ecobom".equalsIgnoreCase(entityNumber);
    }

    public Set<Long> getAllEcoObjIds(DynamicObject[] datas, boolean isRouteChange) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject dObject : datas) {
            DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
            for (DynamicObject obj : pentrys) {
                Long ecoBomId = isRouteChange ? obj.getLong("ecorouteid") : obj.getLong("ecobomid");
                if (ecoBomId == null || ecoBomId.equals(0L)) continue;
                idSet.add(ecoBomId);
            }
        }
        return idSet;
    }

    public OperateOption getOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("strictvalidation", String.valueOf(true));
        operateOption.setVariableValue("needlog", String.valueOf(true));
        return operateOption;
    }

    public String execOperate(Set<Long> idSet, String entityName, String operKey) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operKey, (String)entityName, (Object[])idSet.toArray(), (OperateOption)this.getOperateOption());
        return PlatformUtils.getErrorMsg((OperationResult)operationResult);
    }

    public Map<Long, DynamicObject> getEcoBomDatas(Set<Long> ecoBomIdSet) {
        if (PlatformUtils.isNullSet(ecoBomIdSet)) {
            return new HashMap<Long, DynamicObject>(16);
        }
        String selectProperties = EcoUtils.getEcoBomSic();
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"pdm_ecobom", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", ecoBomIdSet)});
        if (datas == null || datas.length < 1) {
            return new HashMap<Long, DynamicObject>(16);
        }
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dy : datas) {
            map.put(dy.getLong("id"), dy);
        }
        return map;
    }

    public void throwAduitErrorMsg(Map<String, String> errorMap) {
        if (errorMap == null || errorMap.isEmpty()) {
            return;
        }
        String successCount = errorMap.get(SUCCESSFUL_COUNT);
        String failedCount = errorMap.get(FAILED_COUNT);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entrys : errorMap.entrySet()) {
            String billno = entrys.getKey();
            if (SUCCESSFUL_COUNT.equals(billno) || FAILED_COUNT.equals(billno)) continue;
            sb.append(billno).append(":").append(entrys.getValue());
        }
        if (sb.length() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5df2\u5b8c\u6210\uff0c\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\uff1a%3$s", (String)"ECNNewAuditOp_1", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), successCount, failedCount, sb));
        }
    }
}

