/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.BOMVersionUtil;

public class ECNBaseValidatorPlugin
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(ECNBaseValidatorPlugin.class);

    public void validate() {
        ExtendedDataEntity[] objs = this.getDataEntities();
        if (null == objs || objs.length == 0) {
            return;
        }
    }

    public Set<String> getStatusEnumSet() {
        HashSet<String> statusEmunSet = new HashSet<String>(2);
        statusEmunSet.add("A");
        statusEmunSet.add("B");
        return statusEmunSet;
    }

    public boolean isNeedMaterialMft(DynamicObject bomType) {
        if (bomType == null) {
            return false;
        }
        String purpose = bomType.getString("purpose");
        return "A".equals(purpose) || "C".equals(purpose);
    }

    public boolean isBomChange(DynamicObject obj) {
        String changeType = obj.getString("changetype");
        return StringUtils.isEmpty((Object)changeType) || "A".equals(changeType);
    }

    public boolean isRouteChange(DynamicObject obj) {
        String changeType = obj.getString("changetype");
        return "B".equals(changeType);
    }

    public DynamicObject getMaterialMasterObj(DynamicObject pentry) {
        DynamicObject mft;
        DynamicObject master = pentry.getDynamicObject("proentrymaterialid");
        if (master == null && (mft = pentry.getDynamicObject("proentrymaterial")) != null) {
            master = mft.getDynamicObject("masterid");
        }
        return master;
    }

    public void setDefaultEcoType(DynamicObject ecnBill, DynamicObject pentry) {
        DynamicObject ecoType = pentry.getDynamicObject("ecotype");
        if (ecoType == null) {
            if (this.isRouteChange(ecnBill)) {
                pentry.set("ecotype", (Object)EcoUtils.getDefaultEcoTypeByRt((Long)ecnBill.getDynamicObject("org").getLong("id")));
            } else {
                pentry.set("ecotype", (Object)EcoUtils.getDefaultEcoType((Long)ecnBill.getDynamicObject("org").getLong("id")));
            }
        }
    }

    public String checkExistsEcnBill(DynamicObject obj, DynamicObject ecoSubObj) {
        QFilter qFilterBom;
        if (ecoSubObj == null) {
            return "";
        }
        Long billId = (Long)obj.getPkValue();
        QFilter qFilterStatus = new QFilter("billstatus", "in", this.getStatusEnumSet());
        qFilterStatus.and(new QFilter("changetype", "=", (Object)obj.getString("changetype")));
        boolean isBomChange = this.isBomChange(obj);
        boolean isRouteChange = this.isRouteChange(obj);
        Long ecoObjId = (Long)ecoSubObj.getPkValue();
        if (isRouteChange) {
            qFilterBom = new QFilter("pentry.pentryroute", "=", (Object)ecoObjId);
        } else if (isBomChange) {
            qFilterBom = new QFilter("pentry.pentrybom", "=", (Object)ecoObjId);
        } else {
            return "";
        }
        QFilter qFilterBillNo = new QFilter("id", "!=", (Object)billId);
        QFilter qFilter = qFilterStatus.and(qFilterBom).and(qFilterBillNo);
        DynamicObjectCollection sameDatas = QueryServiceHelper.query((String)"pdm_bom_eco", (String)"org.name orgName, id, billno", (QFilter[])new QFilter[]{qFilter});
        if (!PlatformUtils.isNullCollection((DynamicObjectCollection)sameDatas)) {
            DynamicObject data = (DynamicObject)sameDatas.get(0);
            String orgname = data.getString("orgName");
            String ecnbillno = data.getString("billno");
            if (isBomChange) {
                return String.format(ResManager.loadKDString((String)"BOM\u7f16\u7801%1$s\u5728\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\u5b58\u5728\u201c\u672a\u5ba1\u6838\u201d\u72b6\u6001\u7684\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%3$s\u201d\uff0c\u8bf7\u5148\u5904\u7406\u3002", (String)"ECNBaseValidatorPlugin_1", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), ecoSubObj.getString("number"), orgname, ecnbillno);
            }
            return String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7f16\u7801%1$s\u5728\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\u5b58\u5728\u201c\u672a\u5ba1\u6838\u201d\u72b6\u6001\u7684\u5de5\u7a0b\u53d8\u66f4\u5355%3$s\uff0c\u8bf7\u5904\u7406\u3002", (String)"ECNBaseValidatorPlugin_2", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), ecoSubObj.getString("number"), orgname, ecnbillno);
        }
        return "";
    }

    public boolean isNullString(String obj) {
        return obj == null || "".equals(obj);
    }

    public Long getReplaceId(DynamicObject pentry) {
        Long ecoRouteId = pentry.getLong("ecorouteid");
        if (PlatformUtils.isNullLong((Long)ecoRouteId)) {
            return 0L;
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_ecoroute", (String)"routereplace", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ecoRouteId)});
        if (PlatformUtils.isNullCollection((DynamicObjectCollection)coll)) {
            return 0L;
        }
        return ((DynamicObject)coll.get(0)).getLong("routereplace");
    }

    public String checkNewRtVersionIsNull(DynamicObject ecnBill, DynamicObject pentry) {
        String versionCtr = pentry.getString("entryversioncontrol");
        if ("B".equals(versionCtr) || "C".equals(versionCtr) || "D".equals(versionCtr)) {
            DynamicObject newRtVersion = pentry.getDynamicObject("pentrynewrtversion");
            if (newRtVersion == null && (BOMVersionUtil.isNeedVersion((boolean)false, (DynamicObject)ecnBill, (DynamicObject)pentry) && "D".equals(versionCtr) || "B".equals(versionCtr) || "C".equals(versionCtr))) {
                DynamicObject master = this.getMaterialMasterObj(pentry);
                return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\u7684\u4ea7\u54c1\u7f16\u7801%2$s\u6ca1\u6709\u5f55\u5165\u65b0\u7248\u672c\u53f7\uff0c\u8bf7\u5148\u8fdb\u884c\u5904\u7406\u3002", (String)"ECNBaseValidatorPlugin_3", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentry.getString("seq"), master.getString("number"));
            }
            DynamicObject oldRtVersion = pentry.getDynamicObject("pentryoldrtversion");
            if (newRtVersion != null && !PlatformUtils.isDiffDynamicObject((DynamicObject)oldRtVersion, (DynamicObject)newRtVersion)) {
                DynamicObject master = this.getMaterialMasterObj(pentry);
                return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\u7684\u4ea7\u54c1\u7f16\u7801%2$s\u7684\u65b0\u7248\u672c\u53f7\u4e0e\u65e7\u7248\u672c\u53f7\u5b8c\u5168\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ECNBaseValidatorPlugin_4", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentry.getString("seq"), master.getString("number"));
            }
        }
        return "";
    }

    public String checkRouteNameIsNull(DynamicObject ecnBill, DynamicObject pentry) {
        String routeName;
        String versionCtr = pentry.getString("entryversioncontrol");
        if ("D".equals(versionCtr) && this.isNullString(routeName = pentry.getString("pentryroutename"))) {
            DynamicObject master = this.getMaterialMasterObj(pentry);
            return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\u7684\u4ea7\u54c1\u7f16\u7801%2$s\u6ca1\u6709\u5f55\u5165\u5de5\u827a\u8def\u7ebf\u540d\u79f0\uff0c\u8bf7\u5148\u8fdb\u884c\u5904\u7406\u3002", (String)"ECNBaseValidatorPlugin_5", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentry.getString("seq"), master.getString("number"));
        }
        return "";
    }

    public boolean checkAddAuth(DynamicObject org, String entityNumber) {
        RequestContext requestContext = RequestContext.get();
        long userID = requestContext.getCurrUserId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)BizAppServiceHelp.getAppIdByAppNumber((String)"pdm"), (String)entityNumber, (String)"47156aff000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains((Long)org.getPkValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Set<Long> getEcoRouteIdSet(ExtendedDataEntity[] objs) {
        HashSet<Long> ecoRouteIdSet = new HashSet<Long>(16);
        for (ExtendedDataEntity obj : objs) {
            DynamicObjectCollection pentrys;
            DynamicObject dObject = obj.getDataEntity();
            if (!this.isRouteChange(dObject) || (pentrys = dObject.getDynamicObjectCollection("pentry")).isEmpty()) continue;
            for (int i = 0; i < pentrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)pentrys.get(i);
                Long ecoRouteId = entry.getLong("ecorouteid");
                ecoRouteIdSet.add(ecoRouteId);
            }
        }
        return ecoRouteIdSet;
    }

    public Set<Long> getEcoBomIdSet(ExtendedDataEntity[] objs) {
        HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
        for (ExtendedDataEntity obj : objs) {
            DynamicObjectCollection pentrys;
            DynamicObject dObject = obj.getDataEntity();
            if (!this.isBomChange(dObject) || (pentrys = dObject.getDynamicObjectCollection("pentry")).isEmpty()) continue;
            for (int i = 0; i < pentrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)pentrys.get(i);
                Long ecoBomId = entry.getLong("ecobomid");
                ecoBomIdSet.add(ecoBomId);
            }
        }
        return ecoBomIdSet;
    }

    public Map<Long, DynamicObject> getEcoRoutes(ExtendedDataEntity[] objs) {
        DynamicObject[] ecoRoutes;
        Set<Long> ecoRouteIdSet = this.getEcoRouteIdSet(objs);
        if (ecoRouteIdSet.isEmpty()) {
            return new HashMap<Long, DynamicObject>(16);
        }
        HashMap<Long, DynamicObject> maps = new HashMap<Long, DynamicObject>(16);
        DynamicObject ecoRoute = BusinessDataServiceHelper.newDynamicObject((String)"pdm_ecoroute");
        for (DynamicObject dy : ecoRoutes = BusinessDataServiceHelper.load((Object[])ecoRouteIdSet.toArray(), (DynamicObjectType)ecoRoute.getDynamicObjectType())) {
            maps.put(dy.getLong("id"), dy);
        }
        return maps;
    }

    private Set<Long> getUnAuditIds(Set<Long> ids, String entityNumber) {
        QFilter qfilter = new QFilter("id", "in", ids);
        QFilter statusQfilter = new QFilter("status", "in", this.getStatusEnumSet());
        QFilter enableQfilter = new QFilter("enable", "=", (Object)"0");
        qfilter.and(statusQfilter.or(enableQfilter));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])new QFilter[]{qfilter});
        if (PlatformUtils.isNullCollection((DynamicObjectCollection)coll)) {
            return new HashSet<Long>(16);
        }
        return coll.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
    }

    public String checkBomRtIsAuditStatus(DynamicObject dObject) {
        HashSet<Long> ecoRouteIdSet = new HashSet<Long>(16);
        HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
        DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
        for (int i = 0; i < pentrys.size(); ++i) {
            DynamicObject bom;
            DynamicObject entry = (DynamicObject)pentrys.get(i);
            DynamicObject route = entry.getDynamicObject("pentryroute");
            if (route != null) {
                ecoRouteIdSet.add(route.getLong("id"));
            }
            if ((bom = entry.getDynamicObject("pentrybom")) == null) continue;
            ecoBomIdSet.add(bom.getLong("id"));
        }
        if (!PlatformUtils.isNullSet(ecoRouteIdSet)) {
            Set<Long> unAuditIds = this.getUnAuditIds(ecoRouteIdSet, "pdm_route");
            return this.getUnAuditStatusData(pentrys, unAuditIds, "B");
        }
        if (!PlatformUtils.isNullSet(ecoBomIdSet)) {
            Set<Long> unAuditIds = this.getUnAuditIds(ecoBomIdSet, "pdm_mftbom");
            return this.getUnAuditStatusData(pentrys, unAuditIds, "A");
        }
        return "";
    }

    public String getUnAuditStatusData(DynamicObjectCollection pentrys, Set<Long> unAuditIds, String changeType) {
        if (PlatformUtils.isNullSet(unAuditIds)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pentrys.size(); ++i) {
            DynamicObject route;
            DynamicObject entry = (DynamicObject)pentrys.get(i);
            String msg = "";
            DynamicObject bom = entry.getDynamicObject("pentrybom");
            if (bom != null && "A".equals(changeType) && unAuditIds.contains(bom.getLong("id"))) {
                msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\u7684BOM\u7f16\u7801%2$s\u4e0d\u5904\u4e8e\u5df2\u5ba1\u6838\u53ef\u7528\u72b6\u6001\uff0c\u8bf7\u5148\u8fdb\u884c\u5904\u7406\u3002", (String)"ECNBaseValidatorPlugin_7", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), entry.getString("seq"), bom.getString("number"));
            }
            if ((route = entry.getDynamicObject("pentryroute")) != null && "B".equals(changeType) && unAuditIds.contains(route.getLong("id"))) {
                msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\u7684\u5de5\u827a\u8def\u7ebf\u7f16\u7801%2$s\u4e0d\u5904\u4e8e\u5df2\u5ba1\u6838\u53ef\u7528\u72b6\u6001\uff0c\u8bf7\u5148\u8fdb\u884c\u5904\u7406\u3002", (String)"ECNBaseValidatorPlugin_8", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), entry.getString("seq"), route.getString("number"));
            }
            if (msg == null || "".equals(msg)) continue;
            sb.append(msg).append("\r\n");
        }
        return sb.toString();
    }

    public String checkOrgPermItem(DynamicObject ecnBill) {
        List createOrgs;
        Long orgId = ecnBill.getDynamicObject("org").getLong("id");
        DynamicObjectCollection pentrys = ecnBill.getDynamicObjectCollection("pentry");
        boolean isAdd = false;
        int size = pentrys.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject pentry = (DynamicObject)pentrys.get(i);
            String versionCtr = pentry.getString("entryversioncontrol");
            if (!"B".equals(versionCtr) && !"C".equals(versionCtr) && !"D".equals(versionCtr)) continue;
            isAdd = true;
            break;
        }
        if (!isAdd) {
            return "";
        }
        String entity = "pdm_mftbom";
        String entityName = ResManager.loadKDString((String)"BOM\u7ef4\u62a4", (String)"ECNBaseValidatorPlugin_9", (String)"mmc-pdm-opplugin", (Object[])new Object[0]);
        if (this.isRouteChange(ecnBill)) {
            entity = "pdm_route";
            entityName = ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf", (String)"ECNBaseValidatorPlugin_10", (String)"mmc-pdm-opplugin", (Object[])new Object[0]);
        }
        if ((createOrgs = BaseDataServiceHelper.getCreateOrgList((String)entity, (String)"pdm")).isEmpty()) {
            return String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6709\u6743\u521b\u5efa%1$s\u7684\u4e1a\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u529f\u80fd\u6743\u9650\u6216\u8005\u63a7\u5236\u89c4\u5219\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002", (String)"ECNBaseValidatorPlugin_11", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), entityName);
        }
        if (!createOrgs.contains(orgId)) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7%1$s\u4e0d\u5141\u8bb8\u521b\u5efa%2$s\u57fa\u7840\u6570\u636e\u3002", (String)"ECNBaseValidatorPlugin_12", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), ecnBill.getDynamicObject("org").getString("name"), entityName);
        }
        return "";
    }

    private String getEcoBomSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",number");
        sb.append(",materialid");
        sb.append(",bomid");
        sb.append(",entry");
        sb.append(",entry.id");
        sb.append(",entry.entrytype");
        sb.append(",entry.entrymaterial");
        sb.append(",entry.entrymaterialid");
        sb.append(",entry.entryversion");
        sb.append(",entry.entryauxproperty");
        sb.append(",entry.featuretype");
        sb.append(",entry.entryrefno");
        sb.append(",entry.entrygroupno");
        sb.append(",entry.estimatestatus");
        sb.append(",entry.entrymaterialattr");
        sb.append(",entry.refkey");
        sb.append(",entry.groupkey");
        sb.append(",entry.entrymode");
        sb.append(",entry.entrybomentryid");
        sb.append(",entry.entryvaliddate");
        sb.append(",entry.entryinvaliddate");
        sb.append(",entry.bomentry");
        sb.append(",entry.acttime");
        sb.append(",entry.entryreplacegroup");
        sb.append(",entry.entryreplaceplan");
        sb.append(",entry.entryisreplace");
        sb.append(",entry.seq");
        sb.append(",entry.entryqtytype");
        sb.append(",entry.qtyentry");
        sb.append(",entry.qtyentry.id");
        sb.append(",entry.entryoperationnumber");
        sb.append(",entry.entryconfiguredcode");
        sb.append(",copentry");
        sb.append(",copentry.id");
        sb.append(",copentry.oldcopentryid");
        sb.append(",copentry.newcopentryid");
        sb.append(",copentry.copacttime");
        sb.append(",copentry.copestimatestatus");
        sb.append(",copentry.copentryvaliddate");
        sb.append(",copentry.copentryinvaliddate");
        sb.append(",copentry.copentrymode");
        sb.append(",copentry.copentrytype");
        sb.append(",copentry.copentrymaterial");
        sb.append(",copentry.copentrymaterialid");
        sb.append(",copentry.copentryversion");
        sb.append(",copentry.copentryauxproperty");
        sb.append(",copentry.copentryqty");
        sb.append(",copentry.seq");
        return sb.toString();
    }

    public Map<Long, DynamicObject> getEcoBomDatas(Set<Long> ecoBomIdSet) {
        if (PlatformUtils.isNullSet(ecoBomIdSet)) {
            return new HashMap<Long, DynamicObject>(16);
        }
        String selectProperties = this.getEcoBomSelectProperties();
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"pdm_ecobom", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", ecoBomIdSet)});
        if (datas == null || datas.length < 1) {
            return new HashMap<Long, DynamicObject>(16);
        }
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dy : datas) {
            map.put(dy.getLong("id"), dy);
        }
        return map;
    }

    private String getEcoRouteSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",number");
        sb.append(",createorg");
        sb.append(",ismainprocess");
        sb.append(",routereplace");
        sb.append(",processtype");
        sb.append(",materialgroup");
        sb.append(",material");
        sb.append(",routeversion");
        sb.append(",auxproperty");
        sb.append(",configcode");
        sb.append(",wbs");
        sb.append(",group");
        sb.append(",routeid");
        sb.append(",processentry");
        sb.append(",processentry.id");
        sb.append(",processentry.operationno");
        sb.append(",processentry.parent");
        sb.append(",processentry.storagepoint");
        sb.append(",processentry.entrymode");
        sb.append(",processentry.oldprocessentryid");
        sb.append(",processentry.entryvaliddate");
        sb.append(",processentry.entryinvaliddate");
        sb.append(",processentry.newprocessentryid");
        sb.append(",processentry.acttime");
        sb.append(",processentry.seq");
        return sb.toString();
    }

    public Map<Long, DynamicObject> getEcoRouteDatas(Set<Long> ecoRouteIdSet) {
        if (PlatformUtils.isNullSet(ecoRouteIdSet)) {
            return new HashMap<Long, DynamicObject>(16);
        }
        String selectProperties = this.getEcoRouteSelectProperties();
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"pdm_ecoroute", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", ecoRouteIdSet)});
        if (datas == null || datas.length < 1) {
            return new HashMap<Long, DynamicObject>(16);
        }
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dy : datas) {
            map.put(dy.getLong("id"), dy);
        }
        return map;
    }

    public void queryMftBomEntryIdSet(Long bomId, Set<Long> materialMasterIdSet) {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_mftbom", (String)"entry.entrymaterialid entrymaterialid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bomId)});
        if (coll != null && !coll.isEmpty()) {
            for (DynamicObject entry : coll) {
                materialMasterIdSet.add(entry.getLong("entrymaterialid"));
            }
        }
    }

    public void queryMftBomCopEntryIdSet(Long bomId, Set<Long> materialMasterIdSet) {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_mftbom", (String)"copentry.copentrymaterialid entrymaterialid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bomId)});
        if (coll != null && !coll.isEmpty()) {
            for (DynamicObject entry : coll) {
                materialMasterIdSet.add(entry.getLong("entrymaterialid"));
            }
        }
    }

    public boolean chekIsExistsContinuesEcn(Long ecoBillEntryId) {
        HashSet<Long> ecoBomEntryIdSet = new HashSet<Long>(2);
        ecoBomEntryIdSet.add(ecoBillEntryId);
        Map ecnMap = EcoUtils.getContinuityEcnIdMap(ecoBomEntryIdSet);
        return ecnMap != null && !ecnMap.isEmpty();
    }
}

