/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.pdm.business.ecoplatform.EcoCopUtils;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;
import kd.mmc.pdm.common.util.batchbom.BatchBOMUtils;
import kd.mmc.pdm.opplugin.ecn.ECNBaseValidatorPlugin;

public class ECNNewAuditValidator
extends ECNBaseValidatorPlugin {
    private static final Log logger = LogFactory.getLog(ECNNewAuditValidator.class);
    private static final String LONG_FORMAT = "^\\d+$";

    @Override
    public void validate() {
        String operate = this.getOperateKey();
        if (!"audit".equals(operate)) {
            return;
        }
        ExtendedDataEntity[] objs = this.getDataEntities();
        HashSet<Long> bomentryIdSet = new HashSet<Long>(16);
        HashSet<Long> bomCopEntryIdSet = new HashSet<Long>(16);
        HashMap<Long, String> bomEntryEcoBillMap = new HashMap<Long, String>(16);
        HashMap<Long, String> bomCopEntryEcoBillMap = new HashMap<Long, String>(16);
        Date neweffectdate = new Date();
        HashSet<Object> orgIdSet = new HashSet<Object>(16);
        Set<Long> ecoBomIdSet = this.getEcoBomIdSet(objs);
        Map<Long, DynamicObject> ecoBomDataMap = this.getEcoBomDatas(ecoBomIdSet);
        Map<Long, DynamicObject> bomDataMap = this.getBomDatas(objs);
        boolean isOpenCP = PdmParamSetHelper.getBooleanParamValue((String)"ECNOpeContinuesPoint");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (ExtendedDataEntity obj : objs) {
            DynamicObject dObject = obj.getDataEntity();
            if (!this.isBomChange(dObject)) continue;
            String ecoBillNo = dObject.getString("billno");
            DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
            DynamicObject ecnorg = dObject.getDynamicObject("org");
            String changeType = dObject.getString("changetype");
            int psize = pentrys.size();
            block1: for (int k = 0; k < psize; ++k) {
                Date entryinvaliddate;
                Date entryvaliddate;
                Date acttime;
                boolean versionres;
                DynamicObject pentry = (DynamicObject)pentrys.get(k);
                String entryversioncontrol = pentry.getString("entryversioncontrol");
                if (StringUtils.equals((CharSequence)entryversioncontrol, (CharSequence)"D") && orgIdSet.add(ecnorg.getPkValue()) && !(versionres = this.checkAddAuth(ecnorg, "pdm_mftbom"))) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ec4\u7ec7:\u201c%s\u201d\u7684bom\u65b0\u589e\u6743\u9650\u3002", (String)"ECNNewAuditValidator_4", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), ecnorg.getString("name")));
                    break;
                }
                DynamicObject pbom = pentry.getDynamicObject("pentrybom");
                if (pbom == null) {
                    this.validateInitialBom(obj, changeType, pentry, ecoBomDataMap);
                    continue;
                }
                Long ecobomid = pentry.getLong("ecobomid");
                if (PlatformUtils.isNullLong((Long)ecobomid)) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4ea7\u54c1\u5206\u5f55\uff0c\u5de5\u7a0b\u53d8\u66f4BOM\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"ECNNewAuditValidator_10", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), k + 1));
                    break;
                }
                DynamicObject pEntryBOMDO = ecoBomDataMap.get(ecobomid);
                DynamicObjectCollection entrys = pEntryBOMDO.getDynamicObjectCollection("entry");
                DynamicObjectCollection copentrys = pEntryBOMDO.getDynamicObjectCollection("copentry");
                if (PlatformUtils.isNullCollection((DynamicObjectCollection)entrys) && PlatformUtils.isNullCollection((DynamicObjectCollection)copentrys)) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4ea7\u54c1\u5206\u5f55\uff0c\u7ec4\u4ef6\u5206\u5f55\u53ca\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7684\u53d8\u66f4\u4fe1\u606f\u5747\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"ECNNewAuditValidator_0", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), k + 1));
                    break;
                }
                int entrySize = entrys.size();
                Map<Long, DynamicObject> mftBomEntryDataMap = this.getMftBomEntryData(entrys);
                for (int i = 0; i < entrySize; ++i) {
                    DynamicObject mftentry;
                    Long bomentryId;
                    Date invaliddate;
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    String entrymode = entry.getString("entrymode");
                    Long entrybomentryid = entry.getLong("entrybomentryid");
                    if (entrybomentryid != null && !entrybomentryid.equals(0L)) {
                        if (!bomentryIdSet.add(entrybomentryid)) {
                            String otherEcoBillNo = (String)bomEntryEcoBillMap.get(entrybomentryid);
                            if (otherEcoBillNo != null && !ecoBillNo.equals(otherEcoBillNo)) {
                                String msg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355%1$s\u4e0e\u53d8\u66f4\u5355%2$s\u7684\u7ec4\u4ef6\u5206\u5f55\u4e2d\u5b58\u5728\u76f8\u540c\u7684BOM\u5206\u5f55\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u8fdb\u884c\u5ba1\u6838\u5904\u7406\u3002", (String)"ECNNewAuditValidator_2", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), ecoBillNo, otherEcoBillNo);
                                this.addErrorMessage(obj, msg);
                                break;
                            }
                        } else {
                            bomEntryEcoBillMap.put(entrybomentryid, ecoBillNo);
                        }
                    }
                    if ((StringUtils.equals((CharSequence)"A", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"C", (CharSequence)entrymode)) && (invaliddate = entry.getDate("entryinvaliddate")) != null && invaliddate.compareTo(neweffectdate) < 0) {
                        String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u201c\u5931\u6548\u65e5\u671f\u201d\uff1c\u201c\u5f53\u524d\u65e5\u671f\u201d\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"ECNNewAuditValidator_1", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), k + 1, i + 1);
                        this.addErrorMessage(obj, msg);
                        break;
                    }
                    Long ecoBomEntryId = entry.getLong("id");
                    boolean isExistsECN = false;
                    if (isOpenCP) {
                        isExistsECN = this.chekIsExistsContinuesEcn(ecoBomEntryId);
                    }
                    if (!StringUtils.equals((CharSequence)"E", (CharSequence)entrymode) || PlatformUtils.isNullLong((Long)(bomentryId = Long.valueOf(entry.getLong("entrybomentryid"))))) continue;
                    DynamicObject dynamicObject = mftentry = mftBomEntryDataMap == null ? null : mftBomEntryDataMap.get(bomentryId);
                    if (mftentry == null) continue;
                    acttime = entry.getDate("acttime");
                    entryvaliddate = mftentry.getDate("entryvaliddate");
                    entryinvaliddate = mftentry.getDate("entryinvaliddate");
                    if (!(acttime == null || sdf.format(acttime).compareTo(sdf.format(entryvaliddate)) > 0 || isOpenCP && isExistsECN)) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8eBOM\u5206\u5f55\u6700\u65b0\u7ec4\u4ef6\u751f\u6548\u65f6\u95f4\u3002", (String)"ECNNewAuditValidator_5", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), k + 1, i + 1));
                        break;
                    }
                    if (acttime == null || sdf.format(acttime).compareTo(sdf.format(entryinvaliddate)) <= 0 || isOpenCP && isExistsECN) continue;
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8eBOM\u5206\u5f55\u6700\u65b0\u7ec4\u4ef6\u5931\u6548\u65f6\u95f4\u3002", (String)"ECNNewAuditValidator_6", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), k + 1, i + 1));
                    break;
                }
                int copentrySize = copentrys.size();
                Map<Long, DynamicObject> mftBomCopEntryDataMap = this.getMftBomCopEntryData(copentrys);
                for (int i = 0; i < copentrySize; ++i) {
                    DynamicObject mftCopEntry;
                    Long bomCopEntryId;
                    Date invaliddate;
                    String msg;
                    DynamicObject entry = (DynamicObject)copentrys.get(i);
                    String entrymode = entry.getString("copentrymode");
                    Long oldCopEntryId = entry.getLong("oldcopentryid");
                    if (oldCopEntryId != null && !oldCopEntryId.equals(0L)) {
                        if (!bomCopEntryIdSet.add(oldCopEntryId)) {
                            String otherEcoBillNo = (String)bomCopEntryEcoBillMap.get(oldCopEntryId);
                            if (otherEcoBillNo != null && !ecoBillNo.equals(otherEcoBillNo)) {
                                msg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355%1$s\u4e0e\u53d8\u66f4\u5355%2$s\u7684\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u4e2d\u5b58\u5728\u76f8\u540c\u7684BOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u8fdb\u884c\u5ba1\u6838\u5904\u7406\u3002", (String)"ECNNewAuditValidator_3", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), ecoBillNo, otherEcoBillNo);
                                this.addErrorMessage(obj, msg);
                                continue block1;
                            }
                        } else {
                            bomCopEntryEcoBillMap.put(oldCopEntryId, ecoBillNo);
                        }
                    }
                    if ((StringUtils.equals((CharSequence)"A", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"C", (CharSequence)entrymode)) && (invaliddate = entry.getDate("copentryinvaliddate")) != null && invaliddate.compareTo(neweffectdate) < 0) {
                        msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u201c\u5931\u6548\u65e5\u671f\u201d\uff1c\u201c\u5f53\u524d\u65e5\u671f\u201d\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"ECNNewAuditValidator_7", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), k + 1, i + 1);
                        this.addErrorMessage(obj, msg);
                        continue block1;
                    }
                    if (!StringUtils.equals((CharSequence)"E", (CharSequence)entrymode) || PlatformUtils.isNullLong((Long)(bomCopEntryId = Long.valueOf(entry.getLong("oldcopentryid"))))) continue;
                    DynamicObject dynamicObject = mftCopEntry = mftBomCopEntryDataMap == null ? null : mftBomCopEntryDataMap.get(bomCopEntryId);
                    if (mftCopEntry == null) continue;
                    acttime = entry.getDate("copacttime");
                    entryvaliddate = mftCopEntry.getDate("copentryvaliddate");
                    entryinvaliddate = mftCopEntry.getDate("copentryinvaliddate");
                    if (acttime != null && acttime.compareTo(entryvaliddate) <= 0) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8eBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u6700\u65b0\u8054\u526f\u4ea7\u54c1\u751f\u6548\u65f6\u95f4\u3002", (String)"ECNNewAuditValidator_8", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), k + 1, i + 1));
                        continue block1;
                    }
                    if (acttime == null || acttime.compareTo(entryinvaliddate) <= 0) continue;
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8eBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u6700\u65b0\u8054\u526f\u4ea7\u54c1\u5931\u6548\u65f6\u95f4\u3002", (String)"ECNNewAuditValidator_9", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), k + 1, i + 1));
                    continue block1;
                }
            }
            this.validatePentryRepeat(obj, pentrys, ecoBomDataMap, bomDataMap, changeType);
        }
    }

    private void validatePentryRepeat(ExtendedDataEntity obj, DynamicObjectCollection pentrys, Map<Long, DynamicObject> ecoBomDataMap, Map<Long, DynamicObject> bomDataMap, String changeType) {
        if (!"A".equals(changeType)) {
            return;
        }
        for (DynamicObject pentry : pentrys) {
            DynamicObject ecoBom;
            String bomPkValue;
            long bomPk;
            DynamicObject bom;
            Long ecobomid = pentry.getLong("ecobomid");
            if (PlatformUtils.isNullLong((Long)ecobomid) || (bom = bomDataMap.get(bomPk = StringUtils.isNotEmpty((CharSequence)(bomPkValue = (ecoBom = ecoBomDataMap.get(ecobomid)).getString("bomid"))) && Pattern.matches(LONG_FORMAT, bomPkValue) ? Long.parseLong(bomPkValue) : 0L)) == null) continue;
            DynamicObjectCollection bomEntryDOC = bom.getDynamicObjectCollection("entry");
            DynamicObjectCollection ecoBomEntryDoc = ecoBom.getDynamicObjectCollection("entry");
            DynamicObject bomType = bom.getDynamicObject("type");
            String checkRepeat = bomType.getString("checkrepeat");
            String verifyDimension = bomType.getString("verifydimension");
            if ("A".equals(checkRepeat) || "A".equals(checkRepeat)) continue;
            String infoMsg = BatchBOMUtils.repeatAddEcoEntrys((DynamicObjectCollection)ecoBomEntryDoc, (DynamicObjectCollection)bomEntryDOC, (String)checkRepeat, (String)verifyDimension, (String)changeType);
            if (StringUtils.isNotEmpty((CharSequence)infoMsg) && "B".equals(checkRepeat)) {
                this.addWarningMessage(obj, infoMsg);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)infoMsg) || !"C".equals(checkRepeat)) continue;
            this.addErrorMessage(obj, infoMsg);
        }
    }

    private void validateInitialBom(ExtendedDataEntity obj, String changeType, DynamicObject pentry, Map<Long, DynamicObject> ecoBomDataMap) {
        Long ecobomid = pentry.getLong("ecobomid");
        if (PlatformUtils.isNullLong((Long)ecobomid)) {
            return;
        }
        DynamicObject pEntryBOMDO = ecoBomDataMap.get(ecobomid);
        DynamicObjectCollection entrys = pEntryBOMDO.getDynamicObjectCollection("entry");
        if (PlatformUtils.isNullCollection((DynamicObjectCollection)entrys)) {
            return;
        }
        HashMap repeatEntryDataMap = new HashMap(16);
        DynamicObject bomType = pentry.getDynamicObject("bomtype");
        if (!bomType.containsProperty("checkrepeat")) {
            bomType = BusinessDataServiceHelper.loadSingleFromCache((Object)bomType.getPkValue(), (String)bomType.getDynamicObjectType().getName(), (String)"checkrepeat,verifydimension");
        }
        String checkRepeat = bomType.getString("checkrepeat");
        String verifyDimension = bomType.getString("verifydimension");
        for (int i = 0; i < entrys.size(); ++i) {
            String infoMsg;
            DynamicObject entry = (DynamicObject)entrys.get(i);
            if (!"A".equals(changeType) || "A".equals(checkRepeat)) continue;
            DynamicObject repeatRow = BatchBOMUtils.repeatEcoEntryValidate((String)verifyDimension, repeatEntryDataMap, (DynamicObject)entry);
            if (repeatRow != null && "B".equals(checkRepeat)) {
                infoMsg = BatchBOMUtils.buildErrorMessageInfo((String)verifyDimension, (DynamicObject)entry, (DynamicObject)repeatRow, (String)checkRepeat, (String)changeType);
                this.addWarningMessage(obj, infoMsg);
                continue;
            }
            if (repeatRow == null || !"C".equals(checkRepeat)) continue;
            infoMsg = BatchBOMUtils.buildErrorMessageInfo((String)verifyDimension, (DynamicObject)entry, (DynamicObject)repeatRow, (String)checkRepeat, (String)changeType);
            this.addErrorMessage(obj, infoMsg);
        }
    }

    private Map<Long, DynamicObject> getBomDatas(ExtendedDataEntity[] obj) {
        Set<Long> bomIdSet = this.getBomIdSet(obj);
        if (PlatformUtils.isNullSet(bomIdSet)) {
            return new HashMap<Long, DynamicObject>(16);
        }
        String selectProperties = this.getEcoBomSelectProperties();
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"pdm_mftbom", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", bomIdSet)});
        if (datas == null || datas.length < 1) {
            return new HashMap<Long, DynamicObject>(16);
        }
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dy : datas) {
            map.put(dy.getLong("id"), dy);
        }
        return map;
    }

    public Set<Long> getBomIdSet(ExtendedDataEntity[] objs) {
        HashSet<Long> bomIdSet = new HashSet<Long>(16);
        for (ExtendedDataEntity obj : objs) {
            DynamicObjectCollection pentrys;
            DynamicObject dObject = obj.getDataEntity();
            if (!this.isBomChange(dObject) || (pentrys = dObject.getDynamicObjectCollection("pentry")).isEmpty()) continue;
            for (int i = 0; i < pentrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)pentrys.get(i);
                DynamicObject bom = entry.getDynamicObject("pentrybom");
                if (bom == null) continue;
                bomIdSet.add(bom.getLong("id"));
            }
        }
        return bomIdSet;
    }

    private String getEcoBomSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",number");
        sb.append(",type");
        sb.append(",materialid");
        sb.append(",entry");
        sb.append(",entry.id");
        sb.append(",entry.entrytype");
        sb.append(",entry.entrymaterial");
        sb.append(",entry.entrymaterialid");
        sb.append(",entry.entryversion");
        sb.append(",entry.entryauxproperty");
        sb.append(",entry.featuretype");
        sb.append(",entry.entryvaliddate");
        sb.append(",entry.entryinvaliddate");
        sb.append(",entry.entryreplacegroup");
        sb.append(",entry.entryreplaceplan");
        sb.append(",entry.entryisreplace");
        sb.append(",entry.seq");
        sb.append(",entry.entryoperationnumber");
        sb.append(",entry.entryconfiguredcode");
        return sb.toString();
    }

    private Map<Long, DynamicObject> getMftBomEntryData(DynamicObjectCollection entrys) {
        int entrySize = entrys.size();
        HashSet<Long> mftBomEntryIdSet = new HashSet<Long>(16);
        for (int i = 0; i < entrySize; ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            String entrymode = entry.getString("entrymode");
            if (!StringUtils.equals((CharSequence)"E", (CharSequence)entrymode)) continue;
            Long entrybomentryid = entry.getLong("entrybomentryid");
            mftBomEntryIdSet.add(entrybomentryid);
        }
        return EcoUtils.getMftBomEntryData(mftBomEntryIdSet);
    }

    private Map<Long, DynamicObject> getMftBomCopEntryData(DynamicObjectCollection copEntrys) {
        int entrySize = copEntrys.size();
        HashSet<Long> mftBomCopEntryIdSet = new HashSet<Long>(16);
        for (int i = 0; i < entrySize; ++i) {
            DynamicObject entry = (DynamicObject)copEntrys.get(i);
            String entrymode = entry.getString("copentrymode");
            if (!StringUtils.equals((CharSequence)"E", (CharSequence)entrymode)) continue;
            Long copEntryId = entry.getLong("oldcopentryid");
            mftBomCopEntryIdSet.add(copEntryId);
        }
        return EcoCopUtils.getMftBomCopEntryData(mftBomCopEntryIdSet);
    }
}

