/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.opplugin.ecn.ECNBaseOpPlugin;

public class ECNNewDeleteOp
extends ECNBaseOpPlugin {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("pentry.pentrybom");
        e.getFieldKeys().add("pentry.pentryroute");
        e.getFieldKeys().add("pentry.pentryroutename");
        e.getFieldKeys().add("pentry.pentryecn");
        e.getFieldKeys().add("pentry.bomtype");
        e.getFieldKeys().add("pentry.entryversioncontrol");
        e.getFieldKeys().add("pentry.pentrynewversion");
        e.getFieldKeys().add("pentry.pentryoldversion");
        e.getFieldKeys().add("pentry.pentrynewrtversion");
        e.getFieldKeys().add("pentry.pentryoldrtversion");
        e.getFieldKeys().add("pentry.ecobomid");
        e.getFieldKeys().add("pentry.ecobomdata");
        e.getFieldKeys().add("pentry.ecorouteid");
        e.getFieldKeys().add("pentry.ecoroutedata");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        for (DynamicObject data : e.getDataEntities()) {
            DynamicObjectCollection pentrys = data.getDynamicObjectCollection("pentry");
            ArrayList<Long> ecobomIdList = new ArrayList<Long>(16);
            ArrayList<Long> ecorouteIdList = new ArrayList<Long>(16);
            for (int k = 0; k < pentrys.size(); ++k) {
                Long ecorouteid;
                DynamicObject pentry = (DynamicObject)pentrys.get(k);
                Long ecobomid = pentry.getLong("ecobomid");
                if (!PlatformUtils.isNullLong((Long)ecobomid)) {
                    ecobomIdList.add(ecobomid);
                }
                if (PlatformUtils.isNullLong((Long)(ecorouteid = Long.valueOf(pentry.getLong("ecorouteid"))))) continue;
                ecorouteIdList.add(ecorouteid);
            }
            if (!PlatformUtils.isNullList(ecorouteIdList)) {
                DeleteServiceHelper.delete((String)"pdm_ecoroute", (QFilter[])new QFilter[]{new QFilter("id", "in", ecorouteIdList)});
            }
            if (PlatformUtils.isNullList(ecobomIdList)) continue;
            DeleteServiceHelper.delete((String)"pdm_ecobom", (QFilter[])new QFilter[]{new QFilter("id", "in", ecobomIdList)});
        }
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        for (DynamicObject data : e.getDataEntities()) {
            if (!this.isBomChange(data)) continue;
            DynamicObjectCollection pentrys = data.getDynamicObjectCollection("pentry");
            ArrayList<Object> pkList = new ArrayList<Object>(16);
            String ecoBillNo = data.getString("billno");
            for (int k = 0; k < pentrys.size(); ++k) {
                DynamicObject pentrynewrtversion;
                DynamicObject pentry = (DynamicObject)pentrys.get(k);
                String entryversioncontrol = pentry.getString("entryversioncontrol");
                if (!StringUtils.equals((CharSequence)entryversioncontrol, (CharSequence)"B")) continue;
                DynamicObject pentrynewversion = pentry.getDynamicObject("pentrynewversion");
                if (null != pentrynewversion) {
                    pkList.add(pentrynewversion.getPkValue());
                }
                if (null == (pentrynewrtversion = pentry.getDynamicObject("pentrynewrtversion"))) continue;
                pkList.add(pentrynewrtversion.getPkValue());
            }
            if (PlatformUtils.isNullList(pkList)) continue;
            QFilter qfilter = new QFilter("id", "in", pkList);
            qfilter.and(new QFilter("ecnbillno", "=", (Object)ecoBillNo));
            DeleteServiceHelper.delete((String)"bd_bomversion_new", (QFilter[])new QFilter[]{qfilter});
        }
    }
}

