/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pdm.business.ecoplatform.EcoCopUtils;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.common.util.ECNNewUtil;
import kd.mmc.pdm.opplugin.ecn.ECNBaseOpPlugin;
import kd.mmc.pdm.opplugin.ecn.ECNNewSubmitValidator;
import kd.mmc.pdm.opplugin.ecn.ECNResetEcoBomEntryDatePlugin;
import kd.mmc.pdm.opplugin.ecn.ECNSetVersionValueValidator;

public class ECNNewSubmitOp
extends ECNBaseOpPlugin {
    private static final Log logger = LogFactory.getLog(ECNNewSubmitOp.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("pentry.pentrybom");
        e.getFieldKeys().add("pentry.pentryecn");
        e.getFieldKeys().add("pentry.bomtype");
        e.getFieldKeys().add("pentry.bomtype.purpose");
        e.getFieldKeys().add("pentry.pentrynewversion");
        e.getFieldKeys().add("pentry.pentryoldversion");
        e.getFieldKeys().add("pentry.ecobomid");
        e.getFieldKeys().add("pentry.ecobomdata");
        e.getFieldKeys().add("pentry.ecotype.trandatetoday");
        e.getFieldKeys().add("pentry.bomtype.checkrepeat");
        e.getFieldKeys().add("pentry.bomtype.verifydimension");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ECNResetEcoBomEntryDatePlugin());
        e.addValidator((AbstractValidator)new ECNSetVersionValueValidator());
        e.addValidator((AbstractValidator)new ECNNewSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        for (DynamicObject data : e.getDataEntities()) {
            if (!this.isBomChange(data)) continue;
            data.set("changetype", (Object)"A");
            DynamicObjectCollection pentrys = data.getDynamicObjectCollection("pentry");
            for (int k = 0; k < pentrys.size(); ++k) {
                DynamicObject pentry = (DynamicObject)pentrys.get(k);
                pentry.set("ecobomdata", (Object)pentry.getLong("ecobomid"));
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntity = e.getDataEntities();
        String key = e.getOperationKey();
        if (!StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
            return;
        }
        Set<Long> ecoBomIdSet = this.getAllEcoObjIds(dataEntity, Boolean.FALSE);
        Map<Long, DynamicObject> ecmBomDataMap = this.getEcoBomDatas(ecoBomIdSet);
        ArrayList<DynamicObject> updateEcoBomList = new ArrayList<DynamicObject>(16);
        for (int j = 0; j < dataEntity.length; ++j) {
            DynamicObject dObject = dataEntity[j];
            if (!this.isBomChange(dObject)) continue;
            DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
            int pSize = pentrys.size();
            for (int i = 0; i < pSize; ++i) {
                DynamicObject entry = (DynamicObject)pentrys.get(i);
                DynamicObject ecoType = entry.getDynamicObject("ecotype");
                int tranDateToDay = 0;
                if (ecoType != null) {
                    tranDateToDay = ecoType.getInt("trandatetoday");
                }
                Long ecoBomId = entry.getLong("ecobomid");
                boolean isUpdateA = Boolean.FALSE;
                DynamicObject ecoBom = ecmBomDataMap.get(ecoBomId);
                if (tranDateToDay > 0) {
                    isUpdateA = ECNNewUtil.updateEcoBomTransDate((DynamicObject)ecoBom, (int)tranDateToDay, (boolean)Boolean.FALSE);
                }
                EcoUtils.updateEcoBomKey((DynamicObject)ecoType, (DynamicObject)ecoBom, (boolean)true, null, (String)"");
                boolean isUpdateB = EcoUtils.updateEcoBomValues((DynamicObject)ecoBom, (DynamicObject)dObject, (boolean)Boolean.FALSE);
                boolean isUpdateC = EcoCopUtils.updateEcoBomValues((DynamicObject)ecoBom, (DynamicObject)dObject, (boolean)Boolean.FALSE);
                if (!isUpdateA && !isUpdateB && !isUpdateC) continue;
                updateEcoBomList.add(ecoBom);
            }
        }
        if (!updateEcoBomList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateEcoBomList.toArray(new DynamicObject[updateEcoBomList.size()]));
        }
    }
}

