/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mmc.pdm.common.util.BOMVersionUtil;

public class ECNSetVersionValueValidator
extends AbstractValidator {
    public boolean isBomChange(DynamicObject obj) {
        String changeType = obj.getString("changetype");
        return StringUtils.isEmpty((CharSequence)changeType) || "A".equals(changeType);
    }

    public boolean isRouteChange(DynamicObject obj) {
        String changeType = obj.getString("changetype");
        return "B".equals(changeType);
    }

    public void initPentryVersion(DynamicObject data) {
        DynamicObjectCollection pentrys = data.getDynamicObjectCollection("pentry");
        int psize = pentrys.size();
        String newVersionField = this.isBomChange(data) ? "pentrynewversion" : "pentrynewrtversion";
        for (int k = 0; k < psize; ++k) {
            DynamicObject pentry = (DynamicObject)pentrys.get(k);
            String entryversioncontrol = pentry.getString("entryversioncontrol");
            if (!"B".equals(entryversioncontrol) && !"D".equals(entryversioncontrol) || pentry.get(newVersionField) == null || BOMVersionUtil.isExistsVersionId((Object)pentry.getDynamicObject(newVersionField).getPkValue())) continue;
            pentry.set(newVersionField, null);
        }
    }

    public DynamicObject getOrg(DynamicObject pentry, DynamicObject data) {
        return BOMVersionUtil.getOrg((DynamicObject)pentry, (DynamicObject)data);
    }

    public void validate() {
        String operate = this.getOperateKey();
        ExtendedDataEntity[] objs = this.getDataEntities();
        if (objs == null || objs.length <= 0) {
            return;
        }
        if ("submit".equalsIgnoreCase(operate)) {
            for (ExtendedDataEntity obj : objs) {
                DynamicObject data = obj.getDataEntity();
                boolean isBomChange = this.isBomChange(data);
                String ecnbillno = data.getString("billno");
                this.initPentryVersion(data);
                String newVersionField = isBomChange ? "pentrynewversion" : "pentrynewrtversion";
                DynamicObjectCollection pentrys = data.getDynamicObjectCollection("pentry");
                for (int k = 0; k < pentrys.size(); ++k) {
                    DynamicObject pentry = (DynamicObject)pentrys.get(k);
                    String entryversioncontrol = pentry.getString("entryversioncontrol");
                    DynamicObject org = this.getOrg(pentry, data);
                    DynamicObject ppmarterial = pentry.getDynamicObject("proentrymaterialid");
                    if (!StringUtils.equals((CharSequence)entryversioncontrol, (CharSequence)"D") && !StringUtils.equals((CharSequence)entryversioncontrol, (CharSequence)"B")) continue;
                    boolean isNeedVersion = BOMVersionUtil.isNeedVersion((boolean)isBomChange, (DynamicObject)data, (DynamicObject)pentry);
                    if (!isNeedVersion && StringUtils.equals((CharSequence)entryversioncontrol, (CharSequence)"B")) {
                        String errorMsg = String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u53f7\u201c%1$s\u201d\u5bf9\u5e94\u7684\u7b2c\u201c%2$s\u201d\u884c\u4ea7\u54c1\u4fe1\u606f\u5206\u5f55\u4e3a\u987a\u5ef6\u7248\u672c\uff0c\u4f46BOM\u7c7b\u578b\u548c\u7269\u6599\u5747\u672a\u542f\u7528\u7248\u672c\u7ba1\u7406\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u987a\u5ef6\u7248\u672c\u53d8\u66f4\u3002", (String)"ECNSetVersionValueValidator_02", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), ecnbillno, k + 1);
                        if (!isBomChange) {
                            errorMsg = String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u53f7\u201c%1$s\u201d\u5bf9\u5e94\u7684\u7b2c\u201c%2$s\u201d\u884c\u4ea7\u54c1\u4fe1\u606f\u5206\u5f55\u4e3a\u987a\u5ef6\u7248\u672c\uff0c\u4f46\u521b\u5efa\u7ec4\u7ec7\u4e0b\u5de5\u827a\u8def\u7ebf\u672a\u542f\u7528\u7248\u672c\u7ba1\u7406\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u987a\u5ef6\u7248\u672c\u53d8\u66f4\u3002", (String)"ECNSetVersionValueValidator_01", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), ecnbillno, k + 1);
                        }
                        this.addErrorMessage(obj, errorMsg);
                        continue;
                    }
                    if (pentry.get(newVersionField) != null || !isNeedVersion) continue;
                    DynamicObject bomTypeDefRule = BOMVersionUtil.getBomTypeDefVersionRule((DynamicObject)pentry.getDynamicObject("bomtype"));
                    DynamicObject version = BOMVersionUtil.getInitVersion((DynamicObject)org, (DynamicObject)ppmarterial, (String)(isBomChange ? "A" : "B"), (DynamicObject)bomTypeDefRule);
                    pentry.set(newVersionField, (Object)version);
                }
                String errorMsg = "";
                errorMsg = isBomChange ? BOMVersionUtil.createBomVersionByECN((DynamicObject)data, (DynamicObjectCollection)pentrys) : BOMVersionUtil.createRouteVersionByECN((DynamicObject)data, (DynamicObjectCollection)pentrys);
                if (errorMsg == null || "".equals(errorMsg)) continue;
                this.addErrorMessage(obj, errorMsg);
            }
        }
    }
}

